\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{MQthesis-2017}[2017/11/22]    % version 1.20
%%%
%%%  original version by ????
%%%
%%%  revised February 2007 by Ross Moore  <ross@maths.mq.edu.au>
%%%  mostly for compatibility with  hyperref  and  Bookmarks
%%%
%%%  revised February 2010 by Ross Moore  <ross@maths.mq.edu.au>
%%%  extended for Faculty of Science
%%%
%%%  further revised Jan–March 2012 by Ross Moore  <ross.moore@mq.edu.au>
%%%  to allow "twoside", longer titles and generally better suit theses
%%%  in Mathematics. Should work seamlessly with and w/out  hyperref.sty .
%%%
%%%  November 2012 --- automatically provide the abstract's title: `Summary'
%%%
%%%
%%%  November 2017 --- change logo to the latest: `Summary'
%%%
\typeout{}
\typeout{--------------------------------------------------------------}
\typeout{ +---+ MQ Thesis Style (MQthesis.cls) version 1.20, November 2017}
\typeout{ +---+ extensions of (thesis.cls) version 1.10, January 2003, and later}
\typeout{ +---+ for Macquarie University, Sydney, Australia Ph.D. theses/dissertations.}
\typeout{ * Conforms to the Macquarie University, Sydney, Australia }
\typeout{ * Division "SPECIFICATIONS for Preparation of PhD. Thesis}
\typeout{ * and Doctoral Dissertations" (rev. February 2007).}
\typeout{--------------------------------------------------------------}
{\catcode`\~12\relax
% \typeout{ URL: http://www.ics.mq.edu.au/~isvr}
 \typeout{ URL: http://www.maths.mq.edu.au/~ross/MQthesis/}
}
\typeout{}

% Certain options are not handled here but are passed on to report.cls
% by \PassOptionToClass.

\DeclareOption{fleqn}{ \PassOptionsToClass{fleqn}{report}}
\DeclareOption{leqno}{ \PassOptionsToClass{leqno}{report}}
\DeclareOption{openbib}{ \PassOptionsToClass{openbib}{report}}
\DeclareOption{draft}{ \PassOptionsToClass{draft}{report}}
\DeclareOption{final}{ \PassOptionsToClass{final}{report}}
\DeclareOption{openright}{ \PassOptionsToClass{openright}{report}}
\DeclareOption{openany}{ \PassOptionsToClass{openany}{report}}
\DeclareOption{10pt}{ \PassOptionsToClass{10pt}{report}}
\DeclareOption{11pt}{ \PassOptionsToClass{11pt}{report}}
\DeclareOption{12pt}{ \PassOptionsToClass{12pt}{report}}
\DeclareOption{twoside}{ \PassOptionsToClass{twoside}{report}}

% Invalid options - normally used in report.cls and others, but not here:

\DeclareOption{}
   {\ClassWarning{MQthesis}{Title page always generated. Option ignored.}}
\DeclareOption{notitlepage}
   {\ClassWarning{MQthesis}{Option 'notitlepage' not available for thesis.}}
%\DeclareOption{twoside}
%   {\ClassWarning{MQthesis}{Option 'twoside' not available for thesis.}}
\DeclareOption{twocolumn}
   {\ClassWarning{MQthesis}{Option 'twocolumn' not available for thesis.}}
\DeclareOption{landscape}
   {\ClassWarning{MQthesis}{Option 'landscape' not available for thesis.}}
\DeclareOption{legalpaper}
   {\ClassWarning{MQthesis}{Option 'legalpaper' not available for thesis.}}
\DeclareOption{letterpaper}
   {\ClassWarning{MQthesis}{Option 'letterpaper' not available for this class.}}
\DeclareOption{a5paper}
   {\ClassWarning{MQthesis}{Option 'a5paper' not available for this class.}}
\DeclareOption{executivepaper}
   {\ClassWarning{MQthesis}{Option 'executivepaper' not available.}}
\DeclareOption{b5paper}
   {\ClassWarning{MQthesis}{Option 'b5paper' not available for this class.}}
\DeclareOption{a4paper}
   {\ClassWarning{MQthesis}{Option 'a4paper' superfluous. Ignored.}}
\DeclareOption{onecolumn}
   {\ClassWarning{MQthesis}{Option 'onecolumn' superfluous.  Ignored.}}
\DeclareOption{oneside}
   {\ClassWarning{MQthesis}{Option 'oneside' superfluous.  Ignored.}}

%%%%%%%%%%% CUSTOM OPTIONS:
% Options for no decimal numbering, or decimal number nested over 3 deep:
\newif\if@AllHeadings
\newif\if@NumberStdHeadings
\newif\if@PerChptrNumbering
\newif\if@emphisbold
\newif\if@boldhead
\newif\if@fixedHeadSz
\newif\if@headSizeTwelvePt
\newif\if@ChapterDefault
\newif\if@SectionDefault
\newif\if@SubSectionDefault
\newif\if@OtherHeadingDefault
\newif\if@centerChapter
\newif\if@centerSection
\newif\if@inlineSubSubSection
\newif\if@numberSubSubSection
\newif\if@chapterCaps
\newif\if@allowUL
\@AllHeadingsfalse
\@NumberStdHeadingstrue
\@PerChptrNumberingtrue
\@emphisboldtrue
\@boldheadtrue
\@fixedHeadSzfalse
\@centerChaptertrue
\@centerSectionfalse
\@inlineSubSubSectionfalse
\@numberSubSubSectiontrue
\@chapterCapsfalse
\@headSizeTwelvePttrue
\@allowULtrue
\DeclareOption{consecutivenumbering}{\@PerChptrNumberingfalse }
\DeclareOption{inlineh4}{\@inlineSubSubSectiontrue }
\DeclareOption{nonumh4}{\@numberSubSubSectionfalse }
\DeclareOption{centerh1}{\@centerSectiontrue }
\DeclareOption{chapleft}{\@centerSectiontrue }
\DeclareOption{chapup}{\@chapterCapstrue }
\DeclareOption{emph2underline}{\@emphisboldfalse }
\DeclareOption{plainhead}{\@boldheadfalse }
\DeclareOption{fixedheadsize}{\@fixedHeadSztrue }
\DeclareOption{varheadsize}{\@headSizeTwelvePtfalse} %Hidden option.  Don't use.
\DeclareOption{numberchapteronly}{%
    \@PerChptrNumberingfalse\@NumberStdHeadingsfalse\@AllHeadingsfalse
    \@centerChaptertrue\@centerSectiontrue
    \@inlineSubSubSectiontrue\@numberSubSubSectionfalse }
\DeclareOption{allheadings}{%
    \@PerChptrNumberingtrue\@NumberStdHeadingstrue\@AllHeadingstrue
    \@centerChaptertrue\@centerSectionfalse
    \@inlineSubSubSectionfalse\@numberSubSubSectiontrue}
\DeclareOption{typewriterstyle}{\@emphisboldfalse
    \@PerChptrNumberingfalse\@NumberStdHeadingsfalse\@AllHeadingsfalse
    \@centerChaptertrue\@centerSectiontrue\@chapterCapstrue
    \@inlineSubSubSectiontrue\@numberSubSubSectionfalse
    \@boldheadfalse\@fixedHeadSztrue}
\DeclareOption{modernstyle}{\@emphisboldtrue
    \@PerChptrNumberingtrue\@NumberStdHeadingstrue\@AllHeadingsfalse
    \@centerChaptertrue\@centerSectionfalse\@chapterCapsfalse
    \@inlineSubSubSectiontrue\@numberSubSubSectionfalse
    \@boldheadtrue\@fixedHeadSzfalse}
\DeclareOption{defaultstyle}{\@emphisboldtrue
    \@PerChptrNumberingtrue\@NumberStdHeadingstrue\@AllHeadingsfalse
    \@centerChaptertrue\@centerSectionfalse\@chapterCapsfalse
    \@inlineSubSubSectionfalse\@numberSubSubSectiontrue
    \@boldheadtrue\@fixedHeadSzfalse}
%%%
%%%   2007 rules allow  1.5  spacing to be used
\DeclareOption{spaceandhalf}{\AtBeginDocument{\spaceandahalf}}

% Further options, specific to Macquarie University, Faculty of Science
\providecommand{\@department}{Department of}
\DeclareOption{BBE}{\AtBeginDocument{\do@dept{\@department}{Brain, Behaviour and Evolution}}}
\DeclareOption{BIOL}{\AtBeginDocument{\do@dept{\@department}{Biology}}}
\DeclareOption{BIOT}{\AtBeginDocument{\do@dept{\@department}{Biotechnology}}}
\DeclareOption{CBMS}{\AtBeginDocument{\do@dept{\@department}{Chemistry and Biomolecular Sciences}}}
\DeclareOption{CHEM}{\AtBeginDocument{\do@dept{\@department}{Chemistry}}}
\DeclareOption{CHIRO}{\AtBeginDocument{\do@dept{\@department}{Chiropractic}}}
\DeclareOption{COMP}{\AtBeginDocument{\do@dept{\@department}{Computing}}}
\DeclareOption{EDU}{\AtBeginDocument{\do@dept{\@department}{Education}}}
\DeclareOption{ELEC}{\AtBeginDocument{\do@dept{\@department}{Electronics}}}
\DeclareOption{ENG}{\AtBeginDocument{\do@dept{\@department}{Physics and Engineering}}}
\DeclareOption{ENVG}{\AtBeginDocument{\do@dept{\@department}{Environment and Geography}}}
\DeclareOption{ENVSCI}{\AtBeginDocument{\do@dept{\@department}{Environmental Sciences}}}
\DeclareOption{EPS}{\AtBeginDocument{\do@dept{\@department}{Earth and Planetary Sciences}}}
\DeclareOption{JRCASE}{\AtBeginDocument{\do@dept{Joint Research Centre}{Computing and Software Engineering}}}
\DeclareOption{MATH}{\AtBeginDocument{\do@dept{\@department}{Mathematics}}\@allowULfalse}
\DeclareOption{PHYS}{\AtBeginDocument{\do@dept{\@department}{Physics and Engineering}}}
\DeclareOption{PPDP}{\AtBeginDocument{\do@dept{}{Postgraduate Professional Development Program}}}
\DeclareOption{STAT}{\AtBeginDocument{\do@dept{\@department}{Statistics}}}
%%%
%%%  Degree Types
%%%
\DeclareRobustCommand{\Mast}{Master of }
\DeclareRobustCommand{\HonsDeg}{Honours Degree of }
\DeclareRobustCommand{\GDip}{Graduate Diploma in }
\DeclareRobustCommand{\GCert}{Graduate Certificate in }
\DeclareRobustCommand{\PGDip}{Postgraduate Diploma in }
\DeclareRobustCommand{\PGCert}{Postgraduate Certificate in }
\DeclareRobustCommand{\PhD}{Doctor of Philosophy}
\DeclareRobustCommand{\withdeg}{ with the degree of }
%%%
%%%  Degree Areas
%%%
\DeclareRobustCommand{\AgeHealth}{Ageing and Health}
\DeclareRobustCommand{\AppStat}{Applied Statistics}
\DeclareRobustCommand{\Biostat}{Biostatistics}
\DeclareRobustCommand{\Biotech}{Biotechnology}
\DeclareRobustCommand{\Chiro}{Chiropractic}
\DeclareRobustCommand{\EngMan}{Engineering Management}
\DeclareRobustCommand{\EnvEcon}{Environmental Economics}
\DeclareRobustCommand{\EnvEd}{Environmental Education}
\DeclareRobustCommand{\EnvMgt}{Environmental Management}
\DeclareRobustCommand{\EnvPlan}{Environmental Planning}
\DeclareRobustCommand{\EnvSci}{Environmental Science}
\DeclareRobustCommand{\EnvStud}{Environmental Studies}
\DeclareRobustCommand{\GeogEd}{Geographical Education}
\DeclareRobustCommand{\Geosci}{Geoscience}
\DeclareRobustCommand{\HumGeog}{Human Geography}
\DeclareRobustCommand{\InfoTech}{Information \Tech}
\DeclareRobustCommand{\InfSys}{Information Systems}
\DeclareRobustCommand{\ITech}{\InfTech}
\DeclareRobustCommand{\ITechComp}{\InfTech\ \& Computing}
\DeclareRobustCommand{\LabQAMgt}{Laboratory Quality Analysis and Management}
\DeclareRobustCommand{\MusStud}{Museum Studies}
\DeclareRobustCommand{\ResPrep}{Research Preparation (ELS)}
\DeclareRobustCommand{\SocIA}{Social Impact Assessment}
\DeclareRobustCommand{\SusDev}{Sustainable Development}
\DeclareRobustCommand{\Tech}{Technology}
\DeclareRobustCommand{\TelEng}{Telecommunications Engineering}
\DeclareRobustCommand{\WldCon}{Wildlife Conservation}
\DeclareRobustCommand{\WldMgt}{Wildlife Management}
%%%
%%%  Masters degrees
%%%
\DeclareRobustCommand{\MArts}{\Mast Arts}
\DeclareRobustCommand{\MAgeHealth}{\Mast\AgeHealth}
\DeclareRobustCommand{\MAppStats}{\Mast\AppStat}
\DeclareRobustCommand{\MBiol}{\Mast Biology}
\DeclareRobustCommand{\MBioComm}{\Mast\Biotech\withdeg\MComm}
\DeclareRobustCommand{\MBiostat}{\Mast\Biostat}
\DeclareRobustCommand{\MChiroprac}{\Mast Chiropractic}
\DeclareRobustCommand{\MComm}{\Mast Commerce}
\DeclareRobustCommand{\MCommIT}{\Mast Commerce \Mast\InfTech}
\DeclareRobustCommand{\MCons}{\Mast Consulting}
\DeclareRobustCommand{\MEnvEd}{\Mast\EnvEd}
\DeclareRobustCommand{\MEnvMgt}{\Mast\EnvMgt}
\DeclareRobustCommand{\MEnvPlan}{\Mast\EnvPlan}
\DeclareRobustCommand{\MEnvSci}{\Mast\EnvSci}
\DeclareRobustCommand{\MEnvStud}{\Mast\EnvStud}
\DeclareRobustCommand{\MGeogEd}{\Mast\GeogEd}
\DeclareRobustCommand{\MGeosci}{\Mast\Geosci}
\DeclareRobustCommand{\MHealth}{\Mast\AgeH}
\DeclareRobustCommand{\MInfoTech}{\Mast\InfoTech}
\DeclareRobustCommand{\MIT}{\Mast\InfTech}
\DeclareRobustCommand{\MLabQAMgt}{\Mast\LabQAMgt}
\DeclareRobustCommand{\MPhil}{\Mast Philosophy}
\DeclareRobustCommand{\MTech}{\Mast\Tech}
\DeclareRobustCommand{\MTelEng}{\Mast\TelEng}
\DeclareRobustCommand{\MMusStud}{\Mast\MusStud}
\DeclareRobustCommand{\MSc}{\Mast Science}
\DeclareRobustCommand{\MSusDev}{\Mast\SusDev}
\DeclareRobustCommand{\MWldMgt}{\Mast\WldMgt}
%%%
%%%  Certificates degrees
%%%
\DeclareRobustCommand{\PGCertResPrep}{\PGCert\ResPrep}
%%%
%%%  Generic degrees, in the Department's discipline
%%%
\def\inth@deptname{., \th@deptname}
\DeclareOption{PhD}{\AtBeginDocument{\do@degree{\PhD}{PhD\inth@deptname}}}
\DeclareOption{MSc}{\AtBeginDocument{\do@degree{\MSc}{MSc\inth@deptname}}}
\DeclareOption{MA}{\AtBeginDocument{\do@degree{\MArts}{MA\inth@deptname}}}
\DeclareOption{MScHons}{\AtBeginDocument{\do@degree{\HonsDeg\MSc}{MSc.(Hons), \th@deptname}}}
\DeclareOption{MPhil}{\AtBeginDocument{\do@degree{\MPhil}{MPhil\inth@deptname}}}
%%%
%%%  Specialist Masters degrees
%%%
\DeclareOption{MAgeHlth}{\AtBeginDocument{\do@degree{\MAgeHlth}{MAgeHlth.}}}%%% <----??-----
\DeclareOption{MAppStats}{\AtBeginDocument{\do@degree{\MAppStats}{MAppStats.}}}%%% <----??-----
\DeclareOption{MBiostat}{\AtBeginDocument{\do@degree{\MBiostat}{MBiostat.}}}%%% <----??-----
\DeclareOption{MBiotech}{\AtBeginDocument{\do@degree{\MBiotech}{MBiotech.}}}%%% <----??-----
\DeclareOption{MBiotech MCom}{\AtBeginDocument{\do@degree{\MBioComm}{MBiotech. MCom.}}}%%% <----??-----
\DeclareOption{MBiotechMCom}{\AtBeginDocument{\do@degree{\MBioComm}{MBiotech. MCom.}}}%%% <----??-----
\DeclareOption{MChiroprac}{\AtBeginDocument{\do@degree{\MChiroprac}{MChiroprac.}}}%%% <----??-----
\DeclareOption{MCom MIT}{\AtBeginDocument{\do@degree{\MCommIT}{MCom.\,MIT., \ITechComp}}}
\DeclareOption{MComMIT}{\AtBeginDocument{\do@degree{\MCommIT}{MCom.\,MIT, \ITechComp}}}
\DeclareOption{MComp}{\AtBeginDocument{\do@degree{\Mast Computing}{MComp., \ITechComp}}}
\DeclareOption{MCons}{\AtBeginDocument{\do@degree{\MCons}{MCons.}}}%%% <-----??----
\DeclareOption{MEnvEd}{\AtBeginDocument{\do@degree{\MEnvEd}{MEnvEd.}}}%%% <-----??----
\DeclareOption{MEnvMgt}{\AtBeginDocument{\do@degree{\MEnvMgt}{MEnvMgt.}}}%%% <----??-----
\DeclareOption{MEnvPlan}{\AtBeginDocument{\do@degree{\MEnvPlan}{MEnvPlan.}}}%%% <-----??----
\DeclareOption{MEnvSci}{\AtBeginDocument{\do@degree{\MEnvSci}{MEnvSci.}}}%%% <-----??----
\DeclareOption{MEnvStud}{\AtBeginDocument{\do@degree{\MEnvStud}{MEnvStud.}}}%%% <----??-----
\DeclareOption{MGeogEd}{\AtBeginDocument{\do@degree{\MGeogEd}{MGeogEd.}}}%%% <-----??----
\DeclareOption{MGeoscience}{\AtBeginDocument{\do@degree{\MGeosci}{MGeoscience.}}}%%% <-----??----
\DeclareOption{MIT}{\AtBeginDocument{\do@degree{\MInfoTech}{MInfoTech., \ITechComp}}}
\DeclareOption{MInfoTech}{\AtBeginDocument{\do@degree{\MInfoTech}{MInfoTech.}}}
\DeclareOption{MLabQAMgt}{\AtBeginDocument{\do@degree{\MLabQAMgt}{MLabQAMgt.}}}%%% <-----??----
\DeclareOption{MMusStud}{\AtBeginDocument{\do@degree{\MMusStud}{MMusStud.}}}%%% <-----??----
\DeclareOption{MSusDev}{\AtBeginDocument{\do@degree{\MSusDev}{MSusDev.}}}%%% <-----??----
\DeclareOption{MTech}{\AtBeginDocument{\do@degree{\MTech}{MTech., \InfSys}}}
\DeclareOption{MTelEng}{\AtBeginDocument{\do@degree{\MTelEng}{MTelEng.}}}%%% <-----??----
\DeclareOption{MWldMgt}{\AtBeginDocument{\do@degree{\MWldMgt}{MWldMgt.}}}%%% <-----??----
%%%
%%%  Postgraduate Diplomas/Certificates
%%%
\DeclareOption{PGCertAppStat}{\AtBeginDocument{\do@degree{\PGCert\AppStat}{PGCertAppStat.}}}%%% <----??-----
\DeclareOption{PGCertBiostat}{\AtBeginDocument{\do@degree{\PGCert\Biostat}{PGCertBiostat.}}}%%% <----??-----
\DeclareOption{PGCertEngMgt}{\AtBeginDocument{\do@degree{\PGCert\EngMgt}{PGCertEngMgt.}}}%%% <----??-----
\DeclareOption{PGCertEnvEcon}{\AtBeginDocument{\do@degree{\PGCert\EnvEcon}{PGCertEnvEcon.}}}%%% <----??-----
\DeclareOption{PGCertEnvEd}{\AtBeginDocument{\do@degree{\PGCert\EnvEd}{PGCertEnvEd.}}}%%% <----??-----
\DeclareOption{PGCertEnvMgt}{\AtBeginDocument{\do@degree{\PGCert\EnvMgt}{PGCertEnvMgt.}}}%%% <----??-----
\DeclareOption{PGCertGeogEd}{\AtBeginDocument{\do@degree{\PGCert\GeogEd}{PGCertGeogEd.}}}%%% <----??-----
\DeclareOption{PGCertHumGeog}{\AtBeginDocument{\do@degree{\PGCert\HumGeog}{PGCertHumGeog.}}}%%% <----??-----
%\DeclareOption{PGCertInfoTech}{\AtBeginDocument{\do@degree{\PGCert\InfoTech}{PGCertInfoTech., \ITechComp}}}
\DeclareOption{PGCertLabQAMgt}{\AtBeginDocument{\do@degree{\PGCert\LabQAMgt}{PGCertLabQAMgt.}}}%%% <----??-----
%\DeclareOption{PGCertMusStud}{\AtBeginDocument{\do@degree{\PGCert\MusStud}{PGCertMusStud.}}}%%% <----??-----
\DeclareOption{PGCertResPrep}{\AtBeginDocument{\do@degree{\PGCertResPrep}{PGCertResPrep(ELS)}}}
\DeclareOption{PGCertSIA}{\AtBeginDocument{\do@degree{\PGCert\SocIA}{PGCertSIA.}}}%%% <----??-----
\DeclareOption{PGCertSusDev}{\AtBeginDocument{\do@degree{\PGCert\SusDev}{PGCertSusDev.}}}%%% <----??-----
\DeclareOption{PGCertWildCons}{\AtBeginDocument{\do@degree{\PGCert\WildCons}{PGCertWildCons.}}}%%% <----??-----
\DeclareOption{PGCertWldMgt}{\AtBeginDocument{\do@degree{\PGCert\WldMgt}{PGCertWldMgt.}}}%%% <----??-----
%%%
\DeclareOption{PGDipAppStat}{\AtBeginDocument{\do@degree{\PGDip\AppStat}{PGDipAppStat.}}}%%% <----??-----
\DeclareOption{PGDipBiostat}{\AtBeginDocument{\do@degree{\PGDip\Biostat}{PGDipBiostat.}}}%%% <----??-----
\DeclareOption{PGDipEngMgt}{\AtBeginDocument{\do@degree{\PGDip\EngMgt}{PGDipEngMgt.}}}%%% <----??-----
%\DeclareOption{PGDipEnvEcon}{\AtBeginDocument{\do@degree{\PGDip\EnvEcon}{PGDipEnvEcon.}}}%%% <----??-----
\DeclareOption{PGDipEnvEd}{\AtBeginDocument{\do@degree{\PGDip\EnvEd}{PGDipEnvEd.}}}%%% <----??-----
%\DeclareOption{PGDipEnvMgt}{\AtBeginDocument{\do@degree{\PGDip\EnvMgt}{PGDipEnvMgt.}}}%%% <----??-----
\DeclareOption{PGDipGeogEd}{\AtBeginDocument{\do@degree{\PGDip\GeogEd}{PGDipGeogEd.}}}%%% <----??-----
\DeclareOption{PGDipHumGeog}{\AtBeginDocument{\do@degree{\PGDip\HumGeog}{PGDipHumGeog.}}}%%% <----??-----
\DeclareOption{PGDipIT}{\AtBeginDocument{\do@degree{\PGDip\InfoTech}{PGDipInfoTech., \ITechComp}}}
\DeclareOption{PGDipInfoTech}{\AtBeginDocument{\do@degree{\PGDip\InfoTech}{PGDipInfoTech., \ITechComp}}}
\DeclareOption{PGDipLabQAMgt}{\AtBeginDocument{\do@degree{\PGDip\LabQAMgt}{PGDipLabQAMgt.}}}%%% <----??-----
\DeclareOption{PGDipMusStud}{\AtBeginDocument{\do@degree{\PGDip\MusStud}{PGDipMusStud.}}}%%% <----??-----
\DeclareOption{PGDipSIA}{\AtBeginDocument{\do@degree{\PGDip\SocIA}{PGDipSIA.}}}%%% <----??-----
\DeclareOption{PGDipSusDev}{\AtBeginDocument{\do@degree{\PGDip\SusDev}{PGDipSusDev.}}}%%% <----??-----
\DeclareOption{PGDipWildCons}{\AtBeginDocument{\do@degree{\PGDip\WildCons}{PGDipWildCons.}}}%%% <----??-----
\DeclareOption{PGDipWldMgt}{\AtBeginDocument{\do@degree{\PGDip\WldMgt}{PGDipWldMgt.}}}%%% <----??-----
%%%
%%%  ... no longer available, 2010+  ...
%%%
\DeclareOption{PGCertAgeHealth}{\AtBeginDocument{\do@degree{\PGCert\AgeHealth}{PGCert\AgeHealth.}}}%%% <----??-----
\DeclareOption{PGDipAgeHealth}{\AtBeginDocument{\do@degree{\PGDip\AgeHealth}{PGDip\AgeHealth.}}}%%% <----??-----
%%%
%%%  ... no longer available, 2007+  ...
%%%
\DeclareOption{PGDipIS}{\AtBeginDocument{\do@degree{\PGDip\InfSys}{PGDipInfoSys.}}}
\DeclareOption{PGDipITM}{\AtBeginDocument{\do@degree{\PGDip\InfTech\ Management}{PGDipITMgt.}}}
\DeclareOption{PGCertIS}{\AtBeginDocument{\do@degree{\PGCert\InfSys}{PGCertInfoSys.}}}
\DeclareOption{PGCertComp}{\AtBeginDocument{\do@degree{\PGCert Computing}{PGCertComp.}}}
\DeclareOption{PGCertTech}{\AtBeginDocument{\do@degree{\PGCert Technology}{PGCertTech.}}}
\DeclareOption{ComSys}{\AtBeginDocument{\do@degree{\PGDip Technology
 (Communication Systems)}{PGDipTech[CSys]}}}
\DeclareOption{SEng}{\AtBeginDocument{\do@degree{\PGDip Technology
 (Software Engineering)}{PGDipTech[SEng]}}}
\DeclareOption{Opto}{\AtBeginDocument{\do@degree{\PGDip Technology
 (Optoelectronics)}{PGDipTech[Opt]}}}
\DeclareOption{TMgt}{\AtBeginDocument{\do@degree{\PGDip Technology Management}{PGDipTechMgt.}}}
%%%  Postgraduate Diplomas/Certificates
\DeclareOption{GDipIT}{\AtBeginDocument{\do@degree{\GDip\InfTech}{GradCertIT.}}}
\DeclareOption{GCertIT}{\AtBeginDocument{\do@degree{\GCert\InfTech}{GradCertIT.}}}
\DeclareOption{GCertIST}{\AtBeginDocument{\do@degree{\GCert\InfSys\ and Technology}{GradCertInfSysTech.}}}


%%  location of the Macquarie logo graphic file (no need to specify  .pdf  or  .jpg  or  .eps)
\providecommand{\MQlogofilename}{MQlogo2015-RGB}
%\providecommand{\MQlogofilename}{FoS}
%\providecommand{\MQlogofilename}{MQlogo}
%\providecommand{\MQlogofilename}{fig/MQlogo}

% Now we load the report class with certain options by default.  It
% will process any other options specified.  Then, we process the
% options for this class file.  Lastly, we load in the font option
% file for the given font size.

\ProcessOptions
\LoadClass[letterpaper,oneside,onecolumn]{report}[1996/10/31]

% Other required LaTeX2e packages: if your computer doesn't already
% have these, you can copy them to your own directory (URL above):

\RequirePackage{indentfirst}        % indentfirst.sty, 1995/11/23
\RequirePackage{ifthen}         % ifthen.sty, 1996/08/02
\RequirePackage{ifpdf}          % ifpdf.sty, 2005/07/22 v1.3
\AtEndOfPackage{%
 \if@allowUL
  \RequirePackage[ULforem,normalbf]{ulem}%
 \else
  \let\EmphReset\relax
  \let\ULforem\relax
 \fi
}

%%%%%% SPECIAL INTERNAL COMMANDS.  Needed by later routines.

% Create a command to be used for default arguments.
\newcommand*{\th@DefArg}{aWfdRvV11f66GL00K5}

% Now create a command to check for the default argument, and call the
% command [in the first arg] appropriately.  Used for section heading
% commands.

\newcommand{\th@ExecChkOptArg}[3]{%
\ifthenelse{\equal{\th@DefArg}{#2}}{%
    #1{#3}%
    }{%
    #1[#2]{#3}}%
}

% Controls the heading styles.  You can change the size to suit your needs.

\if@fixedHeadSz
    \newcommand*{\th@ChSz}{\normalsize}
    \newcommand*{\th@ScSz}{\normalsize}
\else\if@headSizeTwelvePt
    \newcommand*{\th@ChSz}{\normalsize\fontsize{12}{12}\selectfont}
    \newcommand*{\th@ScSz}{\normalsize\fontsize{12}{12}\selectfont}
\else
    \newcommand*{\th@ChSz}{\normalsize\Large}
    \newcommand*{\th@ScSz}{\normalsize\large}
\fi\fi

\if@boldhead
    \newcommand*{\th@HdFnt}{\normalfont\bfseries}
\else
    \newcommand*{\th@HdFnt}{\normalfont}
\fi

% The style commands proper.  Controlled by a flag.

\newif\if@thInHeading
\@thInHeadingfalse
\newcommand*{\th@ChapterStyle}{\if@thInHeading\th@HdFnt\th@ChSz\fi}
\newcommand*{\th@SectionStyle}{\if@thInHeading\th@HdFnt\th@ScSz\fi}
\newcommand*{\th@SubSectionStyle}{\if@thInHeading\normalsize\th@HdFnt\fi}
\newcommand*{\th@OtherSecHeadStyles}{\if@thInHeading\normalsize\th@HdFnt\fi}

% Re-define the emphasis commands to use either BOLDFACE or UNDERLINING,
% depending on the startup flags.

\newcommand*{\EmphReset}{%
    \if@emphisbold
        \let\em\bfseries
        \let\emph\textbf
    \else
        \ULforem
    \fi
}

% Makes the chapter heading label, putting it in the desired style.
% We need to define it here, since we need it before redefining the
% chapter commands.

\newcommand*{\th@DoChapCenter}{\if@centerChapter\centering\fi}
%\newcommand*{\th@ChapHead}[1]{
% this isn't the best to use \protect here
\DeclareRobustCommand*{\th@ChapHead}[1]{%
   \th@ChapterStyle
   \th@DoChapCenter #1}
%    \protect\th@ChapterStyle
%    \protect\th@DoChapCenter #1}

%%%
%%%  Disable most of the above commands when in Bookmark strings 
%%%  (RRM: 2007/02/18)
%%%
\ifpdf
  \def\prepare@PDFbookmarks{%
   \make@bookToCnames
   \let\th@MakeStarHeading\th@MakeBookHeading
   \pdfstringdefDisableCommands{%
    \let\th@ChSz\relax
    \let\th@ScSz\relax
    \let\th@HdFnt\relax
    \def\th@ChapterStyle{}%
    \def\th@SectionStyle{}%
    \def\th@SubSectionStyle{}%
    \let\th@OtherSecHeadStyles\relax
    \def\th@ChapHead{}%
    \let\th@DoChapCenter\relax
    \def\th@MakeHeading##1##2{##2}%
    \let\normalsize\relax
    \let\normalfont\relax
    \let\singlespace\relax
    \let\spaceandahalf\relax
    \let\doublespace\relax
    \let\headingstyle\relax
  }}
 %%% 
 %%%  here's the test, to see whether Bookmarks are needed
 %%%
  \AtBeginDocument{%
   \expandafter\ifx\csname pdfstringdefDisableCommands\endcsname\relax
   \else\expandafter \prepare@PDFbookmarks\fi
  }
\fi



%%%%%%% DEFINE DOUBLE-SPACING (THE DEFAULT) AND OTHER SPACING:
\def\doublespaceamountx{2.004}%   10pt
\def\doublespaceamountxi{1.771}%  11pt
\def\doublespaceamountxii{1.660}% 12pt
\def\setspace@size{\ifx\@currsize\normalsize\@normalsize\else\@currsize\fi}
\def\doublespacing{\ifcase \@ptsize \relax
      \edef \baselinestretch {\doublespaceamountx}%   10pt
  \or \edef \baselinestretch {\doublespaceamountxi}%  11pt
  \or \edef \baselinestretch {\doublespaceamountxii}% 12pt
  \fi \setspace@size}
\def\singlespacing{\def \baselinestretch{1}\setspace@size \vskip \baselineskip}
\def\setstretch#1{\renewcommand{\baselinestretch}{#1}}
\def\@setsize#1#2#3#4{\@nomath#1
  \let\@currsize#1 \baselineskip #2
  \baselineskip \baselinestretch\baselineskip
  \parskip \baselinestretch\parskip
  \setbox\strutbox \hbox{ \vrule height.7\baselineskip depth.3\baselineskip
  width\z@} \skip\footins \baselinestretch\skip\footins
  \normalbaselineskip\baselineskip#3#4}
 
 %%% also allow 1.5 spacing:  \spaceandahalf
\def\spaceandahalf{%
  \renewcommand{\doublespaceamountx}{1.5}%
  \renewcommand{\doublespaceamountxi}{1.5}%
  \renewcommand{\doublespaceamountxii}{1.5}%
  \doublespacing
}
\def\restoredoublespacing{%
  \renewcommand{\doublespaceamountx}{2.004}%
  \renewcommand{\doublespaceamountxi}{1.771}%
  \renewcommand{\doublespaceamountxii}{1.660}%
  \doublespacing
}
%%%%%%%%% floats & footnotes singlespaced %%%%%%%%%
\let\latexx@xfloat=\@xfloat
\def\@xfloat #1[#2]{\latexx@xfloat #1[#2]%
\def\baselinestretch{1}\@normalsize \normalsize}
\long\def\@footnotetext#1{%
  \insert\footins{%
    \def\baselinestretch {1}%
    \reset@font\footnotesize
    \interlinepenalty\interfootnotelinepenalty
    \splittopskip\footnotesep
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM
    \hsize\columnwidth \@parboxrestore
    \protected@edef\@currentlabel{%
      \csname p@footnote\endcsname\@thefnmark}%
    \color@begingroup \@makefntext{%
        \rule\z@\footnotesep\ignorespaces#1\@finalstrut\strutbox}%
    \color@endgroup}}
\long\def\@mpfootnotetext#1{%
  \global\setbox\@mpfootins\vbox{%
    \unvbox \@mpfootins
    \def\baselinestretch {1}%
    \reset@font\footnotesize
    \hsize\columnwidth \@parboxrestore
    \protected@edef\@currentlabel{%
      \csname p@mpfootnote\endcsname\@thefnmark}%
    \color@begingroup \@makefntext{%
       \rule\z@\footnotesep\ignorespaces#1\@finalstrut\strutbox}
   \color@endgroup}}
%%%%%%%% single / double spacing %%%%%%%%%
\def\singlespace{\vskip \baselineskip \def\baselinestretch {1}%
  \setspace@size \vskip -\baselineskip }
\def\endsinglespace{\par}
\def\spacing#1{\par \begingroup \def\baselinestretch {#1} \setspace@size }
\def\endspacing{\par \vskip \parskip \vskip \baselineskip
  \endgroup \vskip -\parskip \vskip -\baselineskip }
\def\doublespace{\ifcase \@ptsize \relax
      \spacing{\doublespaceamountx}%    10pt
  \or \spacing{\doublespaceamountxi}%   11pt
  \or \spacing{\doublespaceamountxii}%  12pt
  \fi }
\let\enddoublespace=\endspacing



%%%%% SET THE OVERALL DOCUMENT PROPERTIES, such as page numbering,
% margins... Initialize several global document properties, but do so
% *before* the beginning of the document to forces these changes.
\AtBeginDocument{%
    \setlength{\topmargin}{-0.30in}%
    \setlength{\headheight}{0.20in}%
    \setlength{\headsep}{0.0in}%
    \setlength{\topskip}{0.40in}% first line, down from page number
    \setlength{\textheight}{9.10in}%    % 9"-(topmargin+headsep+headheight)
    \setlength{\footskip}{0pt}%
    \setlength{\oddsidemargin}{0.75in}%
    \setlength{\evensidemargin}{0.75in}%
    \addtolength{\evensidemargin}{-1.00in}%
    \setlength{\parindent}{30pt}%   % somewhere between 0.3" and 0.5"
    \setlength{\textwidth}{5.75in}%
    \setlength{\leftmargini}{3.5em}%
    \setlength{\leftmarginii}{2.2em}%
    \setlength{\leftmarginiii}{2.2em}%
    \setlength{\leftmarginiv}{2.2em}%
    \setlength{\leftmarginv}{2.2em}%
    \setlength{\leftmarginvi}{2.2em}%
    \setlength{\leftmargin}{\leftmargini}%
    \setlength{\labelsep}{.5em}%
    \setlength{\labelwidth}{ 1.5em}%
    \pagenumbering{arabic}%
    \pagestyle{myheadings}%
    \markright{}%
    \onecolumn
    \raggedbottom
    \normalsize
    \normalfont
    \EmphReset  % bold or underlined?
    \doublespacing  % footnotes and floats still singlespaced
    \setcounter{tocdepth}{2}%
    \setcounter{secnumdepth}{\value{th@SecNum}}%
% Redefine the bibliography command here, just in case someone
% uses a custom *.sty file that redefines bibliography command
    \let\th@OldBib\thebibliography
    \let\endth@OldBib\endthebibliography
    \renewenvironment*{thebibliography}[1]{%
        \begin{th@OldBib}{#1}%
        \ULforem%  set \em to underline
        \ifhyperisloaded
         \addtocontents{toc}{\protect\contentsline {chapter}%
           {\protect\bibnameToC}{\number\c@page}{\th@bibnameToClabel}}%
        \else
         \addtocontents{toc}{\protect\contentsline {chapter}%{part}%
           {\protect\bibnameToC}{\number\c@page}{}}%{\th@bibnameToClabel}}%
        \fi
        \begin{singlespace}%
    }{
        \end{singlespace}%
        \EmphReset% set \em back to the user-specified default.
        \end{th@OldBib}%
    }
}

%%%%%%%%%%% ADDITIONAL STUFF:
\setcounter{tocdepth}{2}
\newcommand*{\@normalsize}{\normalsize}
\doublespacing

%  Figures and Tables
\setcounter{topnumber}{1}
\renewcommand*{\topfraction}{.4}
\setcounter{totalnumber}{2}
\renewcommand*{\textfraction}{.5}
\renewcommand*{\floatpagefraction}{.3}
\setcounter{dbltopnumber}{1}
\renewcommand*{\dbltopfraction}{.4}
\renewcommand*{\dblfloatpagefraction}{.3}
\setlength{\abovecaptionskip}{10pt}
\setlength{\belowcaptionskip}{10pt}

% Re-define some formatting commands to produce lists, labels,
% and numberings that are more to the Grad School's liking.

% Set up some titles on the table of contents page.
\renewcommand*{\figurename}{Figure}
\renewcommand*{\tablename}{Table}
\newcommand*{\figurenameToC}{\normalsize\th@HdFnt\figurename\normalfont}
\newcommand*{\tablenameToC}{\normalsize\th@HdFnt\tablename\normalfont}

\if@chapterCaps
    \renewcommand*{\contentsname}{\th@ChapHead{CONTENTS}}
    \renewcommand*{\listfigurename}{\th@ChapHead{FIGURES}}
    \renewcommand*{\listtablename}{\th@ChapHead{TABLES}}
    \renewcommand*{\appendixname}{\th@ChapHead{APPENDIX}}
    \renewcommand*{\bibname}{\th@ChapHead{BIBLIOGRAPHY}}
    \renewcommand*{\chaptername}{\th@ChapHead{CHAPTER}}
    \newcommand*{\chapternameToC}{%
        \protect\normalsize \protect\th@HdFnt CHAPTER \protect\normalfont}
    \newcommand*{\bibnameToC}{%
        \protect\normalsize \protect\th@HdFnt  BIBLIOGRAPHY \protect\normalfont}
    \newcommand*{\appendixnameToC}{
        \protect\normalsize \protect\th@HdFnt  APPENDIX \protect\normalfont}
\else
    \renewcommand*{\contentsname}{\th@ChapHead{Contents}}
    \renewcommand*{\listfigurename}{\th@ChapHead{Figures}}
    \renewcommand*{\listtablename}{\th@ChapHead{Tables}}
    \renewcommand*{\appendixname}{\th@ChapHead{Appendix}}
    \renewcommand*{\bibname}{\th@ChapHead{Bibliography}}
    \renewcommand*{\chaptername}{\th@ChapHead{Chapter}}
    \newcommand*{\chapternameToC}{%
        \protect\normalsize \protect\th@HdFnt Chapter \protect\normalfont}
    \newcommand*{\bibnameToC}{%
        \protect\normalsize \protect\th@HdFnt  Bibliography \protect\normalfont}
    \newcommand*{\appendixnameToC}{%
        \protect\normalsize \protect\th@HdFnt  Appendix \protect\normalfont}
\fi

%%% Allow for Bookmarks, using Hyperref
%%% ... but do not commit to these, until a check has been made.
%%%  (added by RRM, Feb. 2007)
\def\make@bookToCnames{{%
  \def\th@ChapHead##1{##1}%
  \xdef\th@figureToClabel{\listfigurename}%
  \xdef\th@tableToClabel{\listtablename}%
  \xdef\th@contentsToClabel{\contentsname}%
  \xdef\th@bibnameToClabel{\bibname}%
  \xdef\th@appendixToClabel{\appendixname}%
  \global\let\th@titlepageTarget\th@makeTitlepageTarget
  \global\let\th@approvalTarget\th@makeApprovalTarget
  \global\let\th@abstractTarget\th@makeAbstractTarget
  \gdef\th@appendixTarget{\hypertarget{\th@appendixToClabel}{}}%
}}
\def\th@figureToClabel{}
\def\th@tableToClabel{}
\def\th@contentsToClabel{}
\def\th@bibnameToClabel{}
\def\th@appendixToClabel{}
\def\th@appendixTarget{}
\let\th@titlepageTarget\relax
\let\th@approvalTarget\relax
\let\th@abstractTarget\relax

\newif\ifhyperisloaded
\def\check@forhyperref{\expandafter
  \ifx\csname hypertarget\endcsname\relax
  \else\hyperisloadedtrue\fi}

\newcommand*{\th@makeTitlepageTarget}{%
  \ifhyperisloaded
   \hypertarget{titlepage}{}%
   \Hy@writebookmark{}{Title: \th@title}{titlepage}{0}{toc}%
  \fi
}
\newcommand*{\th@makeApprovalTarget}{%
  \ifhyperisloaded
   \hypertarget{approvalpage}{}%
   \Hy@writebookmark{}{Approval: \th@degree}{approvalpage}{1}{toc}%
  \fi
}
\newcommand*{\th@makeAbstractTarget}{%
  \ifhyperisloaded
   \hypertarget{abstractpage}{}%
   \Hy@writebookmark{}{\th@Abstractname}{abstractpage}{1}{toc}%
  \fi
}

\AtBeginDocument{%
 \check@forhyperref \make@bookToCnames
 \if@makenoLoF\else
%   \addtocontents{toc}{\protect\contentsline {part}%
%    {\protect\figurenameToC}{\protect\relax}{\th@figureToClabel}}%
 \fi
 \if@makenoLoT\else
%   \addtocontents{toc}{\protect\contentsline {part}%
%    {\protect\tablenameToC}{\protect\relax}{\th@tableToClabel}}%
 \fi
% \addtocontents{toc}{\protect\contentsline {part}%
%    {\protect\chapternameToC}{\protect\relax}{\th@contentsToClabel}}%
}

% NUMBERING STYLES, DEFAULT VALUES

% Using macros of the form \th@Def* avoids conflicts with
% LaTeX internals which use \theDef* forms...

\newcounter{th@SecNum}
\setcounter{th@SecNum}{3}
\if@NumberStdHeadings
    \@centerSectionfalse% Force this.
    \newcommand*{\th@DefTheChapter}{\arabic{chapter}}
    \newcommand*{\th@DefTheSection}{\th@DefTheChapter.\arabic{section}}
    \newcommand*{\th@DefTheSubsection}{\th@DefTheSection.\arabic{subsection}}
\else
    \@AllHeadingsfalse% Just to be safe...
    \newcommand*{\th@DefTheChapter}{\Roman{chapter}}
    \newcommand*{\th@DefTheSection}{\relax}
    \newcommand*{\th@DefTheSubsection}{\relax}
\fi

\if@AllHeadings
    \@inlineSubSubSectionfalse% Force this...
    \@numberSubSubSectiontrue% ...and this.
    \newcommand*{\th@DefTheSubsubsection}
        {\th@DefTheSubsection.\arabic{subsubsection}}
    \newcommand*{\th@DefTheParagraph}
        {\th@DefTheSubsubsection.\arabic{paragraph}}
    \newcommand*{\th@DefTheSubparagraph}
        {\th@DefTheParagraph.\arabic{subparagraph}}
\else
    \newcommand*{\th@DefTheParagraph}{\relax}
    \newcommand*{\th@DefTheSubparagraph}{\relax}
    \if@numberSubSubSection
        \newcommand*{\th@DefTheSubsubsection}
            {\th@DefTheSubsection.\arabic{subsubsection}}
    \else
        \newcommand*{\th@DefTheSubsubsection}{\relax}
    \fi
\fi
\renewcommand*{\thechapter}{\th@DefTheChapter}
\renewcommand*{\thesection}{\th@DefTheSection}
\renewcommand*{\thesubsection}{\th@DefTheSubsection}
\renewcommand*{\thesubsubsection}{\th@DefTheSubsubsection}
\renewcommand*{\theparagraph}{\th@DefTheParagraph}
\renewcommand*{\thesubparagraph}{\th@DefTheSubparagraph}

% Figure, Table, and Equation numbering.
\if@PerChptrNumbering\else
    \newcounter{th@SaveFigure}
    \newcounter{th@SaveTable}
    \newcounter{th@SaveEquation}
    \renewcommand*{\thefigure}{\arabic{figure}}
    \renewcommand*{\thetable}{\arabic{table}}
    \renewcommand*{\theequation}{\arabic{equation}}
\fi

% Enumerated List labels
\renewcommand*{\theenumi}{\arabic{enumi}}
\renewcommand*{\theenumii}{\alph{enumii}}
\renewcommand*{\theenumiii}{\roman{enumiii}}
\renewcommand*{\theenumiv}{\alph{enumiv}}
\renewcommand*{\labelenumi}{(\theenumi)}
\renewcommand*{\labelenumii}{(\theenumii)}
\renewcommand*{\labelenumiii}{(\theenumiii)}
\renewcommand*{\labelenumiv}{(\theenumiii.\theenumiv)}

% Itemized list labels.
\renewcommand*{\labelitemi}{\textbullet}
\renewcommand*{\labelitemii}{\textasteriskcentered}
\renewcommand*{\labelitemiii}{\normalfont \bfseries \textendash}
\renewcommand*{\labelitemiv}{\textperiodcentered}

% Margins for lists
\setlength{\leftmargini}{3.5em}
\setlength{\leftmarginiii}{2.2em}
\setlength{\leftmarginiv}{2.2em}
\setlength{\leftmarginv}{2.2em}
\setlength{\leftmarginvi}{2.2em}
\setlength{\leftmargin}{\leftmargini}
\setlength{\labelwidth}{1.5em}

% Redefine certain commands and environments from report.cls.
% This is where things get messy.  We rename each command we modify,
% then redefine the command using the old version as subset.

% VERSE, QUOTATION, and QUOTE must be single-spaced.
% These rename the internal commands for the \begin{...} and
% \end{...} environment commands.
\let\th@OldVerse\verse
\let\th@OldQuotation\quotation
\let\th@OldQuote\quote
\let\endth@OldVerse\endverse
\let\endth@OldQuotation\endquotation
\let\endth@OldQuote\endquote

% Note - the ``\begin{singlespace}'' and ``\end{singlespace}''
% are defined in setspace.sty.

\renewenvironment*{verse}{\begin{th@OldVerse}\begin{singlespace}}
    {\end{singlespace}\end{th@OldVerse}}

\renewenvironment*{quotation}{\begin{th@OldQuotation} \begin{singlespace}}
    {\end{singlespace}\end{th@OldQuotation}}

\renewenvironment*{quote}{\begin{th@OldQuote} \begin{singlespace}}
    {\end{singlespace} \end{th@OldQuote}}

% Theorems and Axioms:  They must NOT be italicized.  To do this
% robustly, I've needed to use some in-depth TeXnology.  Check out a
% good LaTeX book for info on the \@namedef and \@nameuse commands.

\let\th@OldNewtheorem\newtheorem
% Check for the calling format: \newtheorem{}[]{}
\def\newtheorem#1{ \@ifnextchar[{\th@nuthrmOM{#1}}{\th@newtheoremTwo{#1}}%]
}
% Calling format: \newtheorem{}{}[]; checks for the optional arg at the end.
\def\th@newtheoremTwo#1#2{%
    \@ifnextchar[{\th@nuthrmO{#1}{#2}}{\th@nuthrm{#1}{#2}}%]
}
% Standard call.  No optional args.
\def\th@nuthrm#1#2{%
    \th@OldNewtheorem{th@#1}{#2}%
    \th@correctTheorem{end#1}{#1}{endth@#1}{th@#1}%
}
% Optional arg at end.
\def\th@nuthrmO#1#2[#3]{%
    \th@OldNewtheorem{th@#1}{#2}[#3]%
    \th@correctTheorem{end#1}{#1}{endth@#1}{th@#1}%
    }
% Optional arg in the middle.
\def\th@nuthrmOM#1[#2]#3{%
    \th@OldNewtheorem{th@#1}[th@#2]{#3}%
    \th@correctTheorem{end#1}{#1}{endth@#1}{th@#1}%
    }
\def\th@execThrmOpt#1[#2]{%
    \@nameuse{#1}[#2] \normalsize\normalfont
}
\newcommand*{\th@correctTheorem}[4]{%
    \@namedef{#1}{\@nameuse{#3}}%
    \@namedef{#2}{\@ifnextchar[{\th@execThrmOpt{#4}}{ %%}
            \@nameuse{#4} \normalsize\normalfont}%
    }%
}

% APPENDIX command
\newcounter{th@SectionSave}
\let\th@OldAppCmd\appendix
\let\realclearpage\clearpage
\renewcommand{\appendix}{\clearpage%
    \setcounter{th@SectionSave}{\value{section}}%
    \th@OldAppCmd
    \if@NumberStdHeadings\else
        \setcounter{section}{\value{th@SectionSave}}%
    \fi
    \ifhyperisloaded
     \addtocontents{toc}{\protect\contentsline {part}%
        {\protect\appendixnameToC}{\protect\relax}{\th@appendixToClabel}}%
      %%% establish anchor-point at next  \clearpage  command  (RRM, Feb. 2007)
      \def\clearpage{\th@appendixTarget\let\clearpage\realclearpage}%
    \else
     \addtocontents{toc}{\protect\contentsline {part}%
        {\protect\appendixnameToC}{\protect\relax}}%
    \fi
    \renewcommand*{\th@DefTheChapter}{\Alph{chapter}}%
    }

%%%%%%%%%%%%%%% BIBLIOGRAPHY: Used to be redefined here.
% Moved to permit use of different bibliography .sty and .bst files.
% It's now in the '\AtBeginDocument' command.

%%%%%%%%%%%%%%% SECTION HEADINGS (including several new options):
% New if-s
\newif\if@AlwaysFalse
\@AlwaysFalsefalse
\newif\if@CenterHeading
\@CenterHeadingfalse
\newif\if@UseStarCmd
\@UseStarCmdfalse

%%%%%%%%%%%%%%% GENERAL AND SETUP COMMANDS.
% Makes a heading.
% The optional argument (#1) is a centering flag. The heading gets
% centered if it's present and set to true.
% The second arg is the style command.
% The third arg is the heading proper.
\newcommand*{\th@MakeHeading}[2]{%
    \protect #1%
    \if@CenterHeading\begin{center}\typeout{centered}\fi
    #2%
    \if@CenterHeading\end{center}\fi
    }

%%%  Allow inclusion of Bookmarks for *-chapters
%%%  (RRM, Feb. 2007)
\newcommand*{\th@MakeBookHeading}[2]{%
  {\def\th@ChapHead##1{##1}%
    \let\itshape\relax \let\textit\relax \let\texttt\relax
    \def\text@command##1{##1}%
   \hypertarget{#2}{}%
   \Hy@writebookmark{}{#2}{#2}{0}{toc}%
%   \Hy@star@pdfbookmark{#2}{#2}%
  }\th@MakeHeading{#1}{#2}%
}
\let\th@MakeStarHeading\th@MakeHeading

% Makes a heading.
% The entire thing is something of a mess.  We want all ToC entries to
% be in normal text.  We also want references in normal text.  But, we
% want the heading numbers to appear in the correct size and font.  To
% get this to happen is a chore.

% The args are, in order:
%    The command to execute (#1),
%    The heading style command (#2),
%    The optional arg passed to the heading command proper (#3).
%    E.g. if you execute a \section[foo]{bigfoo}, #3=="foo".
%    The heading text itself (#4).
%    The name of the current command (#5). E.g. "chapter".
%    The internal command that generates the number label (#6).

% There are also two important flags used by this command.  The first
% is \@UseStarCmd.  Set this to "true" if this is the starred version
% of the command.  The second flag is \@thInHeading.  This gets set
% 'true' inside the section heading commands and turned off at the end
% of the command.

\DeclareRobustCommand{\headingstyle}{\normalsize\normalfont}

\newcommand*{\th@Heading}[6]{%
    \@thInHeadingtrue
    % Alter the '\the...' command.
    \@namedef{the#5}{\protect#2#6}%% RRM, 21/02/12: removed spurious space
    \if@UseStarCmd
        #1*{\th@MakeStarHeading{\protect#2}{#4}}%
    \else
        \ifthenelse{\equal{\th@DefArg}{#3}}{%
            #1[\headingstyle#4]{%
                \th@MakeHeading{\protect#2}{#4}}%
        }{%
            #1[\headingstyle#3]{%
                \th@MakeHeading{\protect#2}{#4}}%
        }%
    \fi
% Reset the '\the...' command, but don't enforce
% '\normalsize\normalfont' anywhere, as this messes up
% cross-references in footnotes.
    \@namedef{the#5}{#6}%
    \@thInHeadingfalse
    \@CenterHeadingfalse
%   \normalsize\normalfont
}

%%%%%%%%%%% CHAPTER HEADING:
% The chapter command definitely needs some re-defining.  The primary
% purpose is to control numbering in figures, tables, and equations.

\AtBeginDocument{\let\th@OldChapter\chapter
% The \@ifstar{}{} is a LaTeX tool to check the character following
% the command and see if it's a '*'.
\renewcommand*{\chapter}{\@ifstar{\th@ChapterS}{\th@Chapter}}}

% Special if-s; used internally for chapters.
\newif\if@THshortChapter
\@THshortChapterfalse

% We define a special command for stepping the chapter counter,
% zeroing the figure, table, and equation counters only if necessary.

\newcommand*{\th@PreChCmd}{%
    \if@PerChptrNumbering
        \relax
    \else
        \setcounter{th@SaveTable}{\value{table}}%
        \setcounter{th@SaveFigure}{\value{figure}}%
        \setcounter{th@SaveEquation}{\value{equation}}%
    \fi
}

\newcommand*{\th@PostChCmd}{%
    \if@THshortChapter
        \typeout{Short Chapter (page numbered)}%
        \@THshortChapterfalse
        \thispagestyle{myheadings}%
    \else
        \thispagestyle{empty}%
    \fi
    \if@PerChptrNumbering
        \relax
    \else
        \setcounter{table}{\value{th@SaveTable}}%
        \setcounter{figure}{\value{th@SaveFigure}}%
        \setcounter{equation}{\value{th@SaveEquation}}%
    \fi
    \@UseStarCmdfalse
    \doublespacing\normalsize\normalfont 
}
\if@chapterCaps
    \newcommand*{\th@Chapter}[2][\th@DefArg]{%
        \th@PreChCmd
        \@UseStarCmdfalse
        \if@centerChapter\@CenterHeadingtrue\else\@CenterHeadingfalse\fi
        \th@Heading{\th@OldChapter}{\th@ChapterStyle}{#1}%
            {\uppercase\expandafter{#2}}{chapter}{\th@DefTheChapter}%
        \th@PostChCmd
        \noindent\ignorespaces
    }
    \newcommand*{\th@ChapterS}[1]{%
        \th@PreChCmd
        \@UseStarCmdtrue
        \if@centerChapter\@CenterHeadingtrue\else\@CenterHeadingfalse\fi
        \th@Heading{\th@OldChapter}{\th@ChapterStyle}{\th@DefArg}%
            {\uppercase\expandafter{#1}}{chapter}{\th@DefTheChapter}%
        \th@PostChCmd
    }
\else
    \newcommand*{\th@Chapter}[2][\th@DefArg]{%
        \th@PreChCmd
        \@UseStarCmdfalse
        \if@centerChapter\@CenterHeadingtrue\else\@CenterHeadingfalse\fi
        \th@Heading{\th@OldChapter}{\th@ChapterStyle}{#1}%
            {#2}{chapter}{\th@DefTheChapter}%
        \th@PostChCmd
        \noindent\ignorespaces
    }
    \newcommand*{\th@ChapterS}[1]{%
        \th@PreChCmd
        \@UseStarCmdtrue
        \if@centerChapter\@CenterHeadingtrue\else\@CenterHeadingfalse\fi
        \th@Heading{\th@OldChapter}{\th@ChapterStyle}{\th@DefArg}%
            {#1}{chapter}{\th@DefTheChapter}%
        \th@PostChCmd
    }
\fi

%%%%%%%%% SECTION HEADING COMMANDS.  We need to use the starred version
% and add the numbering and toc-entry ourselves.  We need to do this
% for all of the subsequent heading commands.  If we don't we'll get
% weird-looking ToC entries and references.

\let\th@OldSection\section
\renewcommand*{\section}{\@ifstar{\th@SectionS}{\th@Section}}

\newcommand*{\th@Section}[2][\th@DefArg]{%
    \@UseStarCmdfalse
    \if@centerSection\@CenterHeadingtrue\else\@CenterHeadingfalse\fi
    \th@Heading{\th@OldSection}{\th@SectionStyle}{#1}{#2}%
        {section}{\th@DefTheSection}%
%    \setcounter{equation}{0}%  leave control with the author for this.
    \doublespacing\normalsize\normalfont
    \noindent \ignorespaces
}
\newcommand*{\th@SectionS}[1]{%
    \@UseStarCmdtrue
    \if@centerSection\@CenterHeadingtrue\else\@CenterHeadingfalse\fi
    \th@Heading{\th@OldSection}{\th@SectionStyle}{\th@DefArg}%
        {#1}{section}{\th@DefTheSection}%
    \@UseStarCmdfalse
    \doublespacing\normalsize\normalfont 
    \noindent \ignorespaces
}

%%%%%%%%%% SUBSECTION HEADING COMMANDS.

\let\th@OldSubSection\subsection
\renewcommand*{\subsection}{%
    \@ifstar{\th@SubSectionS}{\th@SubSection}
}
\newcommand*{\th@SubSection}[2][\th@DefArg]{%
    \@UseStarCmdfalse
    \@CenterHeadingfalse
    \th@Heading{\th@OldSubSection}{\th@SubSectionStyle}%
        {#1}{#2}{subsection}{\th@DefTheSubsection}%
    \doublespacing\normalsize\normalfont
    \noindent \ignorespaces

}
\newcommand*{\th@SubSectionS}[1]{%
    \@UseStarCmdtrue
    \@CenterHeadingfalse
    \th@Heading{\th@OldSubSection}{\th@SubSectionStyle}%
        {\th@DefArg}{#1}{subsection}{\th@DefTheSubsection}%
    \@UseStarCmdfalse
    \doublespacing\normalsize\normalfont
    \noindent \ignorespaces
}

%%%%%%%%%% SUBSUBSECTION HEADING COMMANDS.  No starred version permitted.
% No ToC entry.  We also need to check and see if we should number
% it or not and if we should inline it or not.

\let\th@OldSubSubSection\subsubsection
\newlength{\th@SubSubSecSpc}
\if@numberSubSubSection
    \renewcommand*{\thesubsubsection}{\th@DefTheSubsubsection}%
    \newcommand*{\th@PreSubsubsecCmd}{\@UseStarCmdfalse}%
    \setcounter{th@SecNum}{4}%
    \setlength{\th@SubSubSecSpc}{0.5em}%
\else
    \renewcommand*{\thesubsubsection}{\relax}%
    \newcommand*{\th@PreSubsubsecCmd}{\@UseStarCmdtrue}%
    \setlength{\th@SubSubSecSpc}{0em}%
\fi

\newif\if@shutoffSSSect
\@shutoffSSSectfalse

\if@inlineSubSubSection
\renewcommand*{\subsubsection}[2][\th@DefArg]{%
    \refstepcounter{subsubsection}%
    \vspace{4\parsep}%
    \underline{%
    \@thInHeadingtrue\th@OtherSecHeadStyles
    \thesubsubsection\hspace{\th@SubSubSecSpc}#2}\hspace{2mm}%
    \doublespacing\normalsize\normalfont
    \noindent \ignorespaces
    }%
\else
\renewcommand*{\subsubsection}[2][\th@DefArg]{%
    \th@PreSubsubsecCmd
    \@CenterHeadingfalse
    \th@Heading{\th@OldSubSubSection}{\th@OtherSecHeadStyles}%
        {\th@DefArg}{#2}{subsubsection}{\th@DefTheSubsubsection}%
    \@UseStarCmdfalse 
    \doublespacing\normalsize\normalfont
    \noindent \ignorespaces
    }%
\fi

% We don't need to do much for paragraph and subparagraph.  We won't
% even define a *-version or permit entries in the ToC.
\if@AllHeadings
    \let\th@OldParagraph\paragraph
    \renewcommand*{\paragraph}[2][\th@DefArg]{%
        \@UseStarCmdfalse
        \@CenterHeadingfalse
        \th@Heading{\th@OldParagraph}%
            {\@thInHeadingtrue\th@OtherSecHeadStyles}%
            {\th@DefArg}{\underline{#2}}{paragraph}%
            {\hspace*{\parindent}\th@DefTheParagraph}%
        \@UseStarCmdfalse
        \@namedef{theparagraph}{\th@DefTheParagraph
            \protect\normalsize\protect\normalfont}%
        \normalsize\normalfont
    }%
    \let\th@OldSubParagraph\subparagraph
    \renewcommand*{\subparagraph}[2][\th@DefArg]{%
        \@UseStarCmdfalse
        \@CenterHeadingfalse
        \th@Heading{\th@OldSubParagraph}%
            {\@thInHeadingtrue\th@OtherSecHeadStyles}%
            {\th@DefArg}{\underline{#2}}{subparagraph}%
            {\th@DefTheSubparagraph}%
        \@UseStarCmdfalse
        \@namedef{thesubparagraph}{\th@DefTheSubparagraph
            \protect\normalsize\protect\normalfont}%
        \normalsize\normalfont
    }
    \setcounter{th@SecNum}{5}%
\else
    \renewcommand*{\paragraph}[2][\th@DefArg]{%
        {\normalfont\normalsize\bfseries #2}\hspace*{0.89em}}
    \renewcommand*{\subparagraph}[2][\th@DefArg]{%
        {\normalfont\normalsize\bfseries #2}\hspace*{0.89em}}
\fi


%%%%%%%%%% COMMANDS CHANGED FOR THIS CLASS
%%%%%% Unavailable commands
\renewcommand*{\theindex}{\ClassWarning{MQthesis}%
    {Indexing not available in this class.}}
\renewcommand*{\twocolumn}{\ClassWarning{MQthesis}%
    {Twocolumn not available in this class.}}
\renewcommand*{\thepart}{\ClassWarning{MQthesis}%
    {``thepart'' not available in this class.}}
\renewcommand*{\part}{\ClassWarning{MQthesis}%
    {``thepart'' not available in this class.}}
%%%%%% New commands
% This forces a page number on the first page of a chapter, etc.
\newcommand*{\forcepageno}{\thispagestyle{myheadings}}
\newcommand*{\OnePageChapter}{\forcepageno\noindent\ignorespaces}


%%%%%%%%%%% THESIS PROLOGUE PAGES:
% Stores the second arg in the command specified by the first arg.
\newcommand{\th@StoreIn}[2]{\gdef#1{#2}}
% Default values of storage variables.  Emits an error message.
% This part of the class is long...
\newcommand*{\th@title}{%
    \ClassError{MQthesis}{%
        You must specify a title!}%
    {Use the \protect\title{} command in the preamble.}
}
\newcommand*{\th@fwdname}{%
    \ClassError{MQthesis}{%
        You must specify your name!}%
    {Use the \protect\author{}{} command in the \MessageBreak
        preamble. The first arg is your first name and \MessageBreak
        middle initial.  The second arg is your last name.}
}
\newcommand*{\th@revname}{%
    \ClassError{MQthesis}{%
        You must specify your name!}%
    {Use the \protect\author{}{} command in the \MessageBreak
        preamble. The first arg is your first name and \MessageBreak
        middle initial.  The second arg is your last name.}
}
\newcommand*{\th@deptname}{%
    \ClassError{MQthesis}{%
        You must specify the name of the department \MessageBreak
        granting your degree and what type of \MessageBreak
        organization it is within the University.}%
    {Use the \protect\dept{}{} command in the \MessageBreak
        preamble.  The second arg is the name of the \MessageBreak
        department.  The first arg is the department's \MessageBreak
        official designation, e.g. 'Faculty of ...', \MessageBreak
        'Department of ...', 'School of ...', etc.}
}
\newcommand*{\th@deptorg}{%
    \ClassError{MQthesis}{%
        You must specify the name of the department \MessageBreak
        granting your degree and what type of \MessageBreak
        organization it is within the University.}%
    {Use the \protect\dept{}{} command in the \MessageBreak
        preamble.  The second arg is the name of the \MessageBreak
        department.  The first arg is the department's \MessageBreak
        official designation, e.g. 'Faculty of ...', \MessageBreak
        'Department of ...', 'School of ...', etc.}
}
\newcommand*{\th@advisor}{%
    \ClassError{MQthesis}{%
        You must specify your research advisor's name \MessageBreak
        and full title.}%
    {Use the \protect\advisor{}{} command in the \MessageBreak
        preamble.  The first arg is your advisor's \MessageBreak
        full title.  The second arg is your advisor's \MessageBreak
        name.}
}
\newcommand*{\th@advisortitle}{%
    \ClassError{MQthesis}{%
        You must specify your research advisor's name \MessageBreak
        and full title.}%
    {Use the \protect\advisor{}{} command in the \MessageBreak
        preamble.  The first arg is your advisor's \MessageBreak
        full title.  The second arg is your advisor's \MessageBreak
        name.}
}
\newcommand*{\th@reader}{%
    \ClassError{MQthesis}{%
        You must specify the name of the other \MessageBreak
        committee member who will be signing your \MessageBreak
        thesis.}%
    {Use the \protect\reader{}{} command in the preamble.}
}
\newcommand*{\th@readerThree}{none} % optional
\newcommand*{\th@readerFour}{none}  % optional
\newcommand*{\th@readerFive}{none}  % optional

\newcommand*{\th@fulldegree}{%
    \ClassError{MQthesis}{%
        You must specify the type of degree you are \MessageBreak
        receiving.}%
    {Use the \protect\degree{}{} command in the \MessageBreak
        preamble.  The first arg is the unabbreviated \MessageBreak
        name of the degree itself, e.g. \MessageBreak
        'Doctor of Philosophy'.  The second arg is the \MessageBreak
        degree abbreviation followed by the subject, e.g.\MessageBreak
        'PhD., Biology'. Specialist degrees don't need the subject.}
}
\newcommand*{\th@degree}{%
    \ClassError{MQthesis}{%
        You must specify the type of degree you are \MessageBreak
        receiving.}%
    {Use the \protect\degree{}{} command in the \MessageBreak
        preamble.  The first arg is the unabbreviated \MessageBreak
        name of the degree itself, e.g. \MessageBreak
        'Doctor of Philosophy'.  The second arg is the \MessageBreak
        degree abbreviation followed by the subject, \MessageBreak
        e.g. 'PhD., Biology'. Specialist degrees don't need the subject.}
}
\newcommand{\th@otherdegrees}{%
    \ClassError{MQthesis}{%
        You must specify other degrees you hold!}%
    {Use the \protect\otherdegrees{} command in the \MessageBreak
        preamble.  Break each line using the \protect\\ \MessageBreak
        command.}
}
\newcommand{\th@abstractStash}{%
    \ClassError{MQthesis}{%
        You must specify an abstract!}%
    {Use the \protect\abstractpage[]{} command in the \MessageBreak
        preamble.  If your abstract runs over a page, \MessageBreak
        use the optional argument with the word 'long'.}
}
\newcommand*{\th@degreeyear}{\number\the\year}
\newcommand*{\th@signature}[1]{\begin{center}%
        \normalsize
        \vspace*{16mm}% works well?
        \vrule width 80mm height 0.2mm\\
        #1 \end{center}%
}
\newcommand*{\th@dateline}{%
    \vspace*{9mm}%
    \begin{flushright}%
        Date~{\vrule width 35mm height 0.2mm}%
    \end{flushright}%
}
\newcommand{\th@AbstractPageStyle}{\relax}
\newcommand{\th@dedicationStash}{\relax}
\newcommand{\th@dedicationTitleStash}{\relax}
\newcommand{\th@acknowledgementsStash}{\relax}
\newif\if@shortLoF
\newif\if@shortLoT
\newif\if@shortToC
\newif\if@makenoLoF
\newif\if@makenoLoT
\newif\if@makeDedication
\newif\if@makeAcknowledgements
\newif\if@makePrologue
\@shortLoFfalse
\@shortLoTfalse
\@shortToCfalse
\@makenoLoFfalse
\@makenoLoTfalse
\@makeDedicationfalse
\@makeAcknowledgementsfalse
\@makeProloguetrue

% The base commands that make all of the prologue pages.
\newcommand*{\th@Titlepage}{%
    \thispagestyle{empty}%
    \@thInHeadingtrue
    \null \th@titlepageTarget
    \vfill
    \begin{list}{}{\setlength{\leftmargin}{0.8in}%
                \setlength{\rightmargin}{0.8in}\sloppy
                \renewcommand{\baselinestretch}{1.1}}%
        \centering\item[]
        {\th@ChapterStyle
            \if@chapterCaps
                \uppercase\expandafter{\th@title}%
            \else
                \th@title
            \fi}\par
            \vfill
        \vspace{1.35cm}%    
        by\par        
        \vfill      
        {\th@OtherSecHeadStyles
            \if@chapterCaps
                \uppercase\expandafter{\th@fwdname}%
            \else
                \th@fwdname
            \fi}\par
           %\vfill 
       \vspace{.25cm}    
       \th@otherdegrees
       \vfill
    \end{list}
    \vspace{2.15cm}%
    \begin{center}%
    %\centering 
        \includegraphics[width=0.25 \columnwidth]{\MQlogofilename}\\
        \vspace{0.75cm}%
        \spaceandahalf
        This thesis is presented for the degree of \\
         \th@fulldegree\\
         \th@deptorg\ \th@deptname\\
%        Faculty of Science \\
        \th@degreeyear \par       
        \vspace{-1.5cm}
    \end{center}    
    \@thInHeadingfalse
    \vfill
}

\newcommand*{\th@Approvalpage}{%
    \singlespacing
    \clearpage
    \thispagestyle{empty}
    \th@approvalTarget
    \vspace*{\fill}
    \begin{center}
        This thesis entitled:\\[6pt]
        \textbf{\th@title}\\[6pt]
        written by\
        \textbf{\th@fwdname}\\[6pt]
        has been approved for the\
        \th@deptorg\
        \th@deptname
    \end{center}
    \vspace*{2mm}
    \th@signature{\th@advisortitle\ \th@advisor}%
    \th@signature{\th@readertitle\ \th@reader}%       % REQUIRED.
    \ifthenelse{\equal{\th@readerThree}{none}}{\relax}%
                {\th@signature{\th@readerThree}} % optional
    \ifthenelse{\equal{\th@readerFour}{none}}{\relax}%
                {\th@signature{\th@readerFour}} % optional
    \ifthenelse{\equal{\th@readerFive}{none}}{\relax}%
                {\th@signature{\th@readerFive}} % optional
    \th@dateline
    \vspace*{\fill}
    \begin{center}
        The final copy of this thesis has been examined by
        the signatories, and we find that both the content
        and the form meet acceptable presentation standards
        of scholarly work in the above mentioned discipline.
    \end{center}
    \vspace*{\fill}
}
\newcommand{\th@Abstractname}{Summary}
\newcommand{\th@Abstractpage}{%
    \clearpage
    {\let\WriteBookmarks\relax 
    \providecommand{\@currentHref}{}%
    \renewcommand{\@currentHref}{abstractpage}%
    \addcontentsline{toc}{section}{\th@Abstractname}}%
    \th@AbstractPageStyle
    %% RRM:  happens automatically with  \section*  below
    %\th@abstractTarget
    \doublespacing  % 1998 revision of Grad School Specs
    \begin{list}{}{\setlength{\leftmargin}{2em}%
            \setlength{\itemindent}{-2em}%
            \setlength{\topsep}{0pt}%
            \setlength{\itemsep}{0pt}}
        %\item \th@revname\ %(\th@degree)
        %\item {\singlespace\textbf{\th@title}\par}%
        \item Thesis directed by \th@advisortitle\ \th@advisor %\show\th@reader
         \ifx\th@reader\empty.\par\bigskip
         \else\ and\ \th@readertitle\ \th@reader.\fi
        %\th@readerThree.     
    \end{list}
    \par
    \vspace*{4\parsep}
    \thispagestyle{plain}%
    % RRM:  added Nov. 2012
    \section*{\th@Abstractname}%
    \th@abstractStash\par   % finally, the actual abstract
}
\newcommand{\th@Dedicationpage}{%
    \if@makeDedication
        \clearpage
%        \thispagestyle{empty}
        \ifthenelse{\equal{\th@DefArg}{\th@dedicationTitleStash}%
            }{\vfill}{%
             \chapter*{\th@dedicationTitleStash}%
           {\let\WriteBookmarks\relax % avoid doubling-up Bookmark
            \addcontentsline{toc}{section}{\th@dedicationTitleStash}}%
            }%
        \thispagestyle{plain}%
        \th@dedicationStash\par
        \ifthenelse{\equal{\th@DefArg}{\th@dedicationTitleStash}%
            }{\vfill}{\relax}%
    \fi
}
\newcommand{\th@Acknowledgementname}{Acknowledgements}
\newcommand{\th@Acknowledgementpage}{%
    \if@makeAcknowledgements
        \clearpage
        \chapter*{Acknowledgements}%
        {\let\WriteBookmarks\relax % avoid doubling-up Bookmark
        \addcontentsline{toc}{section}{\th@Acknowledgementname}}%
        \thispagestyle{plain}%
        {%\doublespacing    %  why ???   %% this isn't technical material
        \th@acknowledgementsStash\par}%
    \fi
}

\newcommand{\th@ToCpage}{%
    \@THshortChapterfalse
    \if@shortToC
        \@THshortChaptertrue
        \typeout{Making Short ToC...}%
    \fi
    \@thInHeadingfalse
    {\singlespacing%\doublespacing   %%% ??? why ???  this is derived material
    \tableofcontents}%
}

\newcommand{\th@LoTpage}{%
    \@THshortChapterfalse
    \if@makenoLoT
        \typeout{Skipping LoT...}%
    \else
    \if@shortLoT
        \@THshortChaptertrue
        \typeout{Making Short LoT...}%
    \fi
    {\singlespacing%\doublespacing   %%% ??? why ???  this is derived material
    \listoftables}%
    \fi
}

\newcommand{\th@LoFpage}{%
    \@THshortChapterfalse
    \if@makenoLoF
        \typeout{Skipping LoF...}
    \else
    \if@shortLoF
        \@THshortChaptertrue
        \typeout{Making Short LoF...}%
    \fi
    {\singlespacing%\doublespacing   %%% ??? why ???  this is derived material
     \listoffigures}%
    \fi
}


% This performs the actual generation of the prologue
\newcounter{th@storepage}
\newcommand{\th@MakeThesisPrologue}{
    \if@makePrologue
        \pagenumbering{roman}
        \typeout{Making Title Page}%
        \th@Titlepage
        \typeout{Making Approval Page}%
        \th@Approvalpage
%        \typeout{Making ToC Page}%
%        \th@ToCpage
        \typeout{Making Abstract Page}%
        \th@Abstractpage
        \typeout{Making Dedication Page}%
        \th@Dedicationpage
        \typeout{Making Acknowledgement Page}%
        \th@Acknowledgementpage
        \setcounter{th@storepage}{\value{page}}%
        \typeout{Making ToC Page}%
        \th@ToCpage
        \if@makenoLoT\else
          \check@noTables
          \typeout{Making LoT Page}%
          \th@LoTpage
        \fi
        \if@makenoLoF\else
          \check@noFigures
          \typeout{Making LoF Page}%
          \th@LoFpage
        \fi
    \fi
    \cleardoublepage
    \doublespacing
}


% Make the generator-command the very first command of the document.
\let\th@OldBeginDocument\document
\renewcommand*{\document}{
    \th@OldBeginDocument
    \th@MakeThesisPrologue
    \typeout{}
    \typeout{}
    \typeout{-------------------Beginning Body----------------------}
    \typeout{}
    \typeout{}
    \doublespacing
    \clearpage
    \pagenumbering{arabic}%
    \@THshortChapterfalse
    \ignorespaces
}

%%%%%%%%% USER COMMANDS FOR CONTROLLING THE PROLOGUE:
\newcommand*{\do@title}[1]{\th@StoreIn{\th@title}{#1}}
\let\title\do@title
\newcommand*{\do@reader}[2]{%
  \th@StoreIn{\th@reader}{#2}%
  \th@StoreIn{\th@readertitle}{#1}%
  }
\let\reader\do@reader
\newcommand*{\readerThree}[1]{\th@StoreIn{\th@readerThree}{#1}}
\newcommand*{\readerFour}[1]{\th@StoreIn{\th@readerFour}{#1}}
\newcommand*{\readerFive}[1]{\th@StoreIn{\th@readerFive}{#1}}
\newcommand*{\degreeyear}[1]{\th@StoreIn{\th@degreeyear}{#1}}
\newcommand{\otherdegrees}[1]{\th@StoreIn{\th@otherdegrees}{#1}}
\newcommand{\acknowledgements}[1]{%
    \@makeAcknowledgementstrue
    \th@StoreIn{\th@acknowledgementsStash}{#1}%
}
\newcommand{\dedication}[2][\th@DefArg]{%
    \@makeDedicationtrue
    \th@StoreIn{\th@dedicationTitleStash}{#1}%
    \th@StoreIn{\th@dedicationStash}{#2}%
}
\newcommand*{\do@author}[2]{%
    \th@StoreIn{\th@fwdname}{#1 #2}%
    \th@StoreIn{\th@revname}{#2, #1}%
}
\let\author\do@author
\newcommand*{\do@degree}[2]{%
    \th@StoreIn{\th@fulldegree}{#1}%
    \th@StoreIn{\th@degree}{#2}%
}
\let\degree\do@degree
\newcommand*{\do@advisor}[2]{%
    \th@StoreIn{\th@advisor}{#2}%
    \th@StoreIn{\th@advisortitle}{#1}%
}
\let\advisor\do@advisor
\newcommand*{\do@dept}[2]{%
    \th@StoreIn{\th@deptorg}{#1}%
    \th@StoreIn{\th@deptname}{#2}%
}
\let\dept\do@dept
\newcommand{\do@abstract}[2][long]{%
    \ifthenelse{\equal{#1}{short}}{\relax}{%
        \th@StoreIn{\th@AbstractPageStyle}{\thispagestyle{empty}}%
    }%
    \th@StoreIn{\th@abstractStash}{#2}%
}
\let\abstract\do@abstract
\let\abstractpage\do@abstract

\newcommand*{\SuspendPrologue}{%
    \@makeProloguefalse
    \typeout{No prologue pages printed.}%
}
\newcommand*{\emptyLoF}{%
    \@makenoLoFtrue
    \typeout{No LoF printed}%
}
\newcommand*{\emptyLoFwarning}{%
 Put the command {\string\texttt{\string\string\string\emptyLoF}} in the {\string\LaTeX} preamble
 to suppress an empty List of Figures.
}
\newcommand*{\write@LoFwarning}{{%
 \def\emptyLoF{\string\emptyLoF}%
 \immediate\openout\@writeauxcheck \jobname.lof \relax
 \immediate\write\@writeauxcheck{\noexpand\contentsline {figure}{\noexpand\numberline {0}{\ignorespaces\emptyLoFwarning}}{0}}
 \immediate\closeout\@writeauxcheck\relax}%
}

\newcommand*{\emptyLoT}{%
    \@makenoLoTtrue
    \typeout{No LoT printed}%
}
\newcommand*{\emptyLoTwarning}{%
 Put the command {\string\texttt{\string\string\string\emptyLoT}} in the {\string\LaTeX} preamble
 to suppress an empty List of Tables.
}
\newcommand*{\write@LoTwarning}{{%
 \def\emptyLoT{\string\emptyLoT}%
 \immediate\openout\@writeauxcheck \jobname.lot \relax
 \immediate\write\@writeauxcheck{\noexpand\contentsline {table}{\noexpand\numberline {0}{\ignorespaces\emptyLoTwarning}}{0}}
 \immediate\closeout\@writeauxcheck\relax}%
}

\newcommand*{\ToCisShort}{%
    \@shortToCtrue
    \typeout{Putting page number on short ToC}%
}
\newcommand*{\LoFisShort}{%
    \@shortLoFtrue
    \typeout{Putting page number on short LoF}%
}
\newcommand*{\LoTisShort}{%
    \@shortLoTtrue
    \typeout{Putting page number on short LoT}%
}

\newwrite\@writeauxcheck
\def\read@auxcheck{}
\def\read@auxcompare{\par}
\def\check@noTables{\IfFileExists{\jobname.lot}%
 {\immediate\openin\@inputcheck=\jobname.lot \relax
  \immediate\read\@inputcheck to \read@auxcheck
  \ifeof\@inputcheck\relax\@makenoLoTtrue
  \else
   \ifx\read@auxcheck\read@auxcompare\relax
    \immediate\read\@inputcheck to \read@auxcheck
    \ifeof\@inputcheck\relax\@makenoLoTtrue\fi
  \fi\fi
  \immediate\closein\@inputcheck
  \if@makenoLoT\write@LoTwarning\@makenoLoTfalse\fi
 }{}}

\def\check@noFigures{\IfFileExists{\jobname.lof}%
 {\immediate\openin\@inputcheck=\jobname.lof \relax
  \immediate\read\@inputcheck to \read@auxcheck
  \ifeof\@inputcheck\relax\@makenoLoFtrue
  \else
   \ifx\read@auxcheck\read@auxcompare\relax
    \immediate\read\@inputcheck to \read@auxcheck
    \ifeof\@inputcheck\relax\@makenoLoFtrue\fi
  \fi\fi
  \immediate\closein\@inputcheck
  \if@makenoLoF\write@LoFwarning\@makenoLoFfalse\fi
 }{}}

\endinput
%%%%%%%%%%%%%%%% End of file ``MQthesis.cls''
