package persistence;

import java.sql.*;
import java.util.*;


import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;



/**
 *
 * Description: provides access to database for use case viewpoint datas
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CViewpointUc {

static boolean all = true;         //DEBUG ALL

  private CViewpointUc() {}

  // ====================================================================
  // ======= get
  // ====================================================================

   /** reads all use case viewpoints of shared use case from database
    *  @return vector of use case viewpoints of shared use case
    *
    */
   public static Vector getAllViewpointUcOfUsecase(business.CUsecase AUsecase) {
    //System.out.println("fix me:getAllViewpointUcOfUsecase(business.CUsecase AUsecase) {");
    Vector allViewpointUcV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(

          "SELECT viewpoint.id, viewpoint.viewpointAgentId, viewpoint.name, viewpoint.style, viewpointuc.trigger " +
          "FROM viewpointAgent INNER JOIN (viewpoint INNER JOIN viewpointuc ON viewpoint.id = viewpointuc.id) ON viewpointAgent.id = viewpoint.viewpointAgentId "+
          "WHERE viewpointAgent.usecaseId= "+AUsecase.getId()+
          " ORDER BY viewpoint.name ASC");

        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getAllViewpointUcOfUsecase: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);

        while (resDB.next()) {
          long id = resDB.getLong("id");
          business.CViewpointAgent vpAgent = persistence.CViewpointAgent.getAgent( resDB.getLong("viewpointAgentId"));
          int style = resDB.getInt("style");
          String name = resDB.getString("name");
          String trigger = resDB.getString("trigger");

          business.CViewpointUc viewpointUc =
             new business.CViewpointUc(id,vpAgent,name,style, AUsecase, trigger, null);
          allViewpointUcV.addElement(viewpointUc);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read all use case viewpoints of use case \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return allViewpointUcV;
  }

  /** reads all preconditions of use case viewpoint from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of preconditions of type business.CCondition
   *  of use case viewpoint
   */
  public static Vector getPrecond(business.CViewpointUc AViewpointUc) {

    Vector precondV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, nr, condition, extrans " +
            "FROM vpUcPrecondition " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY nr ASC");
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getPrecond: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CCondition precond =
            new business.CCondition(
            resDB.getLong("id"),
            resDB.getInt("nr"),
            resDB.getString("condition"),
            resDB.getString("extrans"));

          precondV.addElement(precond);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read preconditions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return precondV;
  }


  /** reads all endconditions valid after successful run of use case viewpoint from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of valid after successful run of type business.CCondition
   *  of use case viewpoint
   */
  public static Vector getSuccessEndcond(business.CViewpointUc AViewpointUc) {

    Vector successEndcondV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, nr, condition, extrans " +
            "FROM vpUcSuccessEndcondition " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY nr ASC");
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getSuccessEndcond: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CCondition successEndcond =
            new business.CCondition(
            resDB.getLong("id"),
            resDB.getInt("nr"),
            resDB.getString("condition"),
            resDB.getString("extrans"));
          successEndcondV.addElement(successEndcond);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("001 error message: can't read successEndconditions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return successEndcondV;
  }


  /** reads all endconditions valid after failed run of use case viewpoint from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of end conditions valid after failed run of type business.CCondition
   *  of use case viewpoint
   */
  public static Vector getFailedEndcond(business.CViewpointUc AViewpointUc) {

    Vector failedEndcondV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, nr, condition, extrans " +
            "FROM vpUcFailedEndcondition " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY nr ASC");
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getFailedEndcond: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CCondition failedEndcond =
            new business.CCondition(
            resDB.getLong("id"),
            resDB.getInt("nr"),
            resDB.getString("condition"),
            resDB.getString("extrans"));
          failedEndcondV.addElement(failedEndcond);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read failedEndconditions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return failedEndcondV;
  }


  /** reads all steps of type business.CStepStrT1 of success scenario of use case viewpoint
   *  from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of steps of type business.CStepStrT1 of success scenario
   *  of use case viewpoint
   */
  public static Vector getSuccessScenarioT1(business.CViewpointUc AViewpointUc) {

    Vector successScenarioT1V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, action, extrans " +
            "FROM strT1VpUcSuccessScenario " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY position1 ASC");
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getSuccessScenarioT1: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CStepStrT1 stepStrT1 =
            new business.CStepStrT1(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            resDB.getString("extrans"));
          successScenarioT1V.addElement(stepStrT1);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read success scenario \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return successScenarioT1V;
  }

  /** reads all steps of type business.CStepStrT2 of success scenario
   *  of use case viewpoint
   *  from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of steps of type business.CStepStrT2 of success scenario
   *  of use case viewpoint
   */
  public static Vector getSuccessScenarioT2(business.CViewpointUc AViewpointUc) {

    Vector successScenarioT2V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, actorId, action, systemStep, extrans " +
            "FROM strT2VpUcSuccessScenario " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY position1 ASC");
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getSuccessScenarioT2: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          long actorId = resDB.getLong("actorId");

          business.CActor actor = null;
          if (actorId != -1) {
            actor = persistence.CActor.getActorOfVpUc(actorId);
          }

          business.CStepStrT2 stepStrT2 =
            new business.CStepStrT2(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            actor,
            null,
            resDB.getBoolean("systemStep"),
            resDB.getString("extrans"));
          successScenarioT2V.addElement(stepStrT2);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read success scenario \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return successScenarioT2V;
  }

  /** reads all extension steps of type business.CStepStrT1
   *  of success scenario of use case viewpoint
   *  from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of extension steps of type business.CStepStrT1
   *  of success scenario of use case viewpoint
   */
  public static Vector getExtensionT1(business.CViewpointUc AViewpointUc) {

    Vector extensionT1V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, action, extrans " +
            "FROM strT1VpUcExtension " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY position1 ASC");
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getExtensionT1: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CStepStrT1 stepStrT1 =
            new business.CStepStrT1(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            resDB.getString("extrans"));
          extensionT1V.addElement(stepStrT1);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read extensions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return extensionT1V;
  }

  /** reads all extension steps of type business.CStepStrT2
   *  of success scenario of use case viewpoint
   *  from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of extension steps of type business.CStepStrT2
   *  of success scenario of use case viewpoint
   */
  public static Vector getExtensionT2(business.CViewpointUc AViewpointUc) {

    Vector extensionT2V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, actorId, action, systemStep, extrans " +
            "FROM strT2VpUcExtension " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY position1 ASC");
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getExtensionT2: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          long actorId = resDB.getLong("actorId");

          business.CActor actor = null;
          if (actorId != -1) {
            actor = persistence.CActor.getActorOfVpUc(actorId);
          }

          business.CStepStrT2 stepStrT2 =
            new business.CStepStrT2(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            actor,
            null,
            resDB.getBoolean("systemStep"),
            resDB.getString("extrans"));
          extensionT2V.addElement(stepStrT2);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read extensions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return extensionT2V;
  }

  /** reads all variation steps of type business.CStepStrT1
   *  of success scenario of use case viewpoint
   *  from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of variation steps of type business.CStepStrT1
   *  of success scenario of use case viewpoint
   */
  public static Vector getSubvariationT1(business.CViewpointUc AViewpointUc) {

    Vector subvariationT1V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, action ,extrans " +
            "FROM strT1VpUcVariation " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY position1 ASC");

        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getSubvariationT1: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CStepStrT1 stepStrT1 =
            new business.CStepStrT1(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            resDB.getString("extrans"));
          subvariationT1V.addElement(stepStrT1);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read variation \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return subvariationT1V;
  }

  /** reads all variation steps of type business.CStepStrT2
   *  of success scenario of use case viewpoint
   *  from database
   *  @param AViewpointUc use case viewpoint
   *  @return vector of variation steps of type business.CStepStrT2
   *  of success scenario of use case viewpoint
   */
  public static Vector getSubvariationT2(business.CViewpointUc AViewpointUc) {

    Vector subvariationT2V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, actorId, action, systemStep, extrans " +
            "FROM strT2VpUcVariation " +
            "WHERE viewpointUsecaseId=" + AViewpointUc.getId() +
            " ORDER BY position1 ASC");
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getSubvariationT2: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          long actorId = resDB.getLong("actorId");

          business.CActor actor = null;
          if (actorId != -1) {
            actor = persistence.CActor.getActorOfVpUc(actorId);
          }

          business.CStepStrT2 stepStrT2 =
            new business.CStepStrT2(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            actor,
            null,
            resDB.getBoolean("systemStep"),
            resDB.getString("extrans"));

          subvariationT2V.addElement(stepStrT2);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read variation \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return subvariationT2V;
  }
  // ====================================================================
  // ======= insert
  // ====================================================================

   /** inserts use case viewpoint into database
    *  @param AViewpointUc use case viewpoint
    */
   public static boolean insertViewpointUc(business.CViewpointUc AViewpointUc) {

    Connection conDB = CDatabase.getConnectionDb();
    try {
      if ( conDB != null) {
	//conDB.setAutoCommit(false); //errors inserting actors if false Oscar Aguilera
        conDB.setAutoCommit(true);

        Statement statDB = conDB.createStatement();
        long id = findNewId(statDB);

        String name = AViewpointUc.getName();
        if (name == null) name = new String("");

        String trigger = AViewpointUc.getTrigger();
        if (trigger == null) trigger = new String("");

        String sql =
          "INSERT INTO viewpoint " +
          "(id, viewpointAgentId, name, style) " +
          "VALUES (" +
          new Long(id).toString() + ", " + AViewpointUc.getViewpointAgent().getId() +
          ", '" +  name + "', " + AViewpointUc.getStyle() + ")";
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertViewpointUc: " + sql);
        statDB.executeUpdate(sql);

        // old: statDB = conDB.createStatement();
        sql =
          "INSERT INTO viewpointuc " +
          "(id, trigger) " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          //new Long(AViewpointUc.getUsecase().getId()).toString() + ","+
          "'" +  trigger + "')";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.insertViewpointUc: " + sql);

        statDB.executeUpdate(sql);
        AViewpointUc.setId(id);

//        if (AViewpointUc.getActors() != null)
//          persistence.CActor.insertActorOfViewpointUc(statDB, AViewpointUc);
//
//        for (int i=0;
//             AViewpointUc.getPrecond() != null &&
//             i<AViewpointUc.getPrecond().size(); i++) {
//          persistence.CViewpointUc.insertPrecond(statDB,
//            (business.CCondition) AViewpointUc.getPrecond().elementAt(i), AViewpointUc.getId()
//          );
//        }
//
//        for (int i=0;
//             AViewpointUc.getSuccessEndcond() != null &&
//             i<AViewpointUc.getSuccessEndcond().size(); i++) {
//          persistence.CViewpointUc.insertSuccessEndcond(statDB,
//            (business.CCondition) AViewpointUc.getSuccessEndcond().elementAt(i), AViewpointUc.getId()
//          );
//        }
//
//        for (int i=0;
//             AViewpointUc.getFailedEndcond() != null &&
//             i<AViewpointUc.getFailedEndcond().size(); i++) {
//          persistence.CViewpointUc.insertFailedEndcond(statDB,
//            (business.CCondition) AViewpointUc.getFailedEndcond().elementAt(i), AViewpointUc.getId()
//          );
//        }
//
//        for (int i=0;
//             AViewpointUc.getSuccessScenarioT1() != null &&
//             i<AViewpointUc.getSuccessScenarioT1().size(); i++) {
//          persistence.CViewpointUc.insertSuccessScenarioT1(statDB,
//            (business.CStepStrT1) AViewpointUc.getSuccessScenarioT1().elementAt(i), AViewpointUc.getId()
//          );
//        }
//
//        for (int i=0;
//             AViewpointUc.getSuccessScenarioT2() != null &&
//             i<AViewpointUc.getSuccessScenarioT2().size(); i++) {
//          persistence.CViewpointUc.insertSuccessScenarioT2(statDB,
//            (business.CStepStrT2) AViewpointUc.getSuccessScenarioT2().elementAt(i), AViewpointUc.getId()
//          );
//        }
//
//        for (int i=0;
//             AViewpointUc.getExtensionT1() != null &&
//             i<AViewpointUc.getExtensionT1().size(); i++) {
//          persistence.CViewpointUc.insertExtensionT1(statDB,
//            (business.CStepStrT1) AViewpointUc.getExtensionT1().elementAt(i), AViewpointUc.getId()
//          );
//        }
//
//        for (int i=0;
//             AViewpointUc.getExtensionT2() != null &&
//             i<AViewpointUc.getExtensionT2().size(); i++) {
//          persistence.CViewpointUc.insertExtensionT2(statDB,
//            (business.CStepStrT2) AViewpointUc.getExtensionT2().elementAt(i), AViewpointUc.getId()
//          );
//        }
//
//        for (int i=0;
//             AViewpointUc.getSubvariationT1() != null &&
//             i<AViewpointUc.getSubvariationT1().size(); i++) {
//          persistence.CViewpointUc.insertSubvariationT1(statDB,
//            (business.CStepStrT1) AViewpointUc.getSubvariationT1().elementAt(i), AViewpointUc.getId()
//          );
//        }
//
//        for (int i=0;
//             AViewpointUc.getSubvariationT2() != null &&
//             i<AViewpointUc.getSubvariationT2().size(); i++) {
//          persistence.CViewpointUc.insertSubvariationT2(statDB,
//            (business.CStepStrT2) AViewpointUc.getSubvariationT2().elementAt(i), AViewpointUc.getId()
//          );
//        }

	//conDB.commit();
        //conDB.setAutoCommit(true);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
        return false;
      }
    }
    catch (SQLException ex){
      String error = new String("error message: can't insert use case viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

      try {
        conDB.rollback();
        conDB.setAutoCommit(true);
      } catch (SQLException ex2) {
        error = new String("error message: can't do rollback \n");
        error = contr.CError.createSQLErrorMessage(error, ex2);
        contr.CError.showErrorMessage(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }

      return false;
    }

    return true;
  }

  /** inserts preconditions of use case viewpoint into database
    *  @param AViewpointUc use case viewpoint
    */
  public static void insertPrecond(
  Statement AStatDB,
  business.CCondition APrecond, long AViewpointUcId)
  throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewPrecondId(statDB);

        String text = APrecond.getText();
        if (text == null) text = new String("");

        String extrans = APrecond.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO vpUcPrecondition " +
          "(id, viewpointUsecaseId, nr, condition, extrans) " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AViewpointUcId).toString() + ", " +
          new Integer(APrecond.getNumber()).toString() +
          ", '" + text + "'"+
          ", '" + extrans + "')";
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertPrecond: " + sql);

        statDB.executeUpdate(sql);
        APrecond.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts endconditions valid after successful run of use case viewpoint into database
    *  @param AViewpointUc use case viewpoint
    */
  public static void insertSuccessEndcond(
  Statement AStatDB,
  business.CCondition ASuccessEndcond,
  long AViewpointUcId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewSuccessEndcondId(statDB);

        String text = ASuccessEndcond.getText();
        if (text == null) text = new String("");

        String extrans = ASuccessEndcond.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO vpUcSuccessEndcondition " +
          "(id, viewpointUsecaseId, nr, condition, extrans) " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AViewpointUcId).toString() + ", " +
          new Integer(ASuccessEndcond.getNumber()).toString() +
          ", '" + text + "'"+
          ", '" + extrans + "')";
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertSuccessEndcond: " + sql);

        statDB.executeUpdate(sql);
        ASuccessEndcond.setId(id);

    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts endconditions valid after failes run of use case viewpoint into database
    *  @param AViewpointUc use case viewpoint
    */
  public static void insertFailedEndcond(
  Statement AStatDB,
  business.CCondition AFailedEndcond,
  long AViewpointUcId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewFailedEndcondId(statDB);

        String text = AFailedEndcond.getText();
        if (text == null) text = new String("");

        String extrans = AFailedEndcond.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO vpUcFailedEndcondition " +
          "(id, viewpointUsecaseId, nr, condition, extrans) " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AViewpointUcId).toString() + ", " +
          new Integer(AFailedEndcond.getNumber()).toString() +
          ", '" + text + "'"+
          ", '" + extrans + "')";
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertFailedEndcond: " + sql);
        statDB.executeUpdate(sql);
        AFailedEndcond.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts steps of success scenario of type business.CStepStrT1
   *  of use case viewpoint into database
   *  @param AViewpointUc use case viewpoint
   */
  public static void insertSuccessScenarioT1(
  Statement AStatDB,
  business.CStepStrT1 AStepStrT1,
  long AViewpointUcId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewSuccessScenarioT1Id(statDB);

        String step = AStepStrT1.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT1.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT1.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO strT1VpUcSuccessScenario " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AViewpointUcId).toString() + ", " +
          new Integer(AStepStrT1.getPosition()).toString() +
          ", '" + step + "' " +
          ", '" + action + "'"+
          ", '" + extrans + "')";
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertSuccessScenarioT1: " + sql);
        statDB.executeUpdate(sql);
        AStepStrT1.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts steps of success scenario of type business.CStepStrT2 of use case viewpoint into database
    *  @param AViewpointUc use case viewpoint
    */
  public static void insertSuccessScenarioT2(
  Statement AStatDB,
  business.CStepStrT2 AStepStrT2,
  business.CViewpointUc AViewpointUc) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewSuccessScenarioT2Id(statDB);

        String step = AStepStrT2.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT2.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT2.getPhrases();
        if (extrans == null) extrans = new String("");

        long actorOfVpUcId = -1;
        if (AStepStrT2.getActor() != null) {
          actorOfVpUcId = persistence.CActor.getActorIdForUc(AStepStrT2.getActor(), AViewpointUc);
        }

        String sql =
          "INSERT INTO strT2VpUcSuccessScenario " +
          "VALUES (" +
          id+ ", " +
          AViewpointUc.getId()+ ", " +
          AStepStrT2.getPosition()+
          ", '" + step + "' " +
          ", " + actorOfVpUcId +
          ", '" + action + "'" +
          ", " + AStepStrT2.isSystemStep() +
          ",'" + extrans + "')";


        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertSuccessScenarioT2: " + sql);
        statDB.executeUpdate(sql);
        AStepStrT2.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts extension steps of success scenario of type business.CStepStrT1
   *  of use case viewpoint into database
   *  @param AViewpointUc use case viewpoint
   */
  public static void insertExtensionT1(
  Statement AStatDB,
  business.CStepStrT1 AStepStrT1,
  long AViewpointUcId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewExtensionT1Id(statDB);

        String step = AStepStrT1.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT1.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT1.getPhrases();
        if (extrans == null) extrans = new String("");


        String sql =
          "INSERT INTO strT1VpUcExtension " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AViewpointUcId).toString() + ", " +
          new Integer(AStepStrT1.getPosition()).toString() +
          ", '" + step + "' " +
          ", '" + action + "'"+
          ", '" + extrans + "')";
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertExtensionT1: " + sql);
        statDB.executeUpdate(sql);
        AStepStrT1.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }


  /** inserts extension steps of success scenario of type business.CStepStrT2
   *  of use case viewpoint into database
   *  @param AViewpointUc use case viewpoint
   */
  public static void insertExtensionT2(
  Statement AStatDB,
  business.CStepStrT2 AStepStrT2,
  business.CViewpointUc AViewpointUc) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewExtensionT2Id(statDB);

        String step = AStepStrT2.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT2.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT2.getPhrases();
        if (extrans == null) extrans = new String("");

        long actorOfVpUcId = -1;
        if (AStepStrT2.getActor() != null) {
            actorOfVpUcId = persistence.CActor.getActorIdForUc(AStepStrT2.getActor(), AViewpointUc);
//          actorOfVpUcId =   persistence.CActor.getActorOfVpUcId(AStepStrT2.getActor(), AViewpointUcId);
        }

        String sql =
          "INSERT INTO strT2VpUcExtension " +
          "VALUES (" +
          id + ", " +
          AViewpointUc.getId()+ ", " +
          AStepStrT2.getPosition() +
          ", '" + step + "' " +
          ", " + actorOfVpUcId +
          ", '" + action + "'" +
          ", " + AStepStrT2.isSystemStep() +
          ",'" + extrans + "')";
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertExtensionT2: " + sql);


        statDB.executeUpdate(sql);
        AStepStrT2.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts variation steps of success scenario of type business.CStepStrT1
   *  of use case viewpoint into database
   *  @param AViewpointUc use case viewpoint
   */
  public static void insertSubvariationT1(
  Statement AStatDB,
  business.CStepStrT1 AStepStrT1,
  long AViewpointUcId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewSubvariationT1Id(statDB);

        String step = AStepStrT1.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT1.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT1.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO strT1VpUcVariation " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AViewpointUcId).toString() + ", " +
          new Integer(AStepStrT1.getPosition()).toString() +
          ", '" + step + "' " +
          ", '" + action + "'"+
          ", '" + extrans + "')" ;
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertSubvariationT1: " + sql);
        statDB.executeUpdate(sql);
        AStepStrT1.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts variation steps of success scenario of type business.CStepStrT2
   *  of use case viewpoint into database
   *  @param AViewpointUc use case viewpoint
   */
  public static void insertSubvariationT2(
  Statement AStatDB,
  business.CStepStrT2 AStepStrT2,
  business.CViewpointUc AViewpointUc) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewSubvariationT2Id(statDB);

        String step = AStepStrT2.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT2.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT2.getPhrases();
        if (extrans == null) extrans = new String("");

        long actorOfVpUcId = -1;
        if (AStepStrT2.getActor() != null) {
          actorOfVpUcId = persistence.CActor.getActorIdForUc(AStepStrT2.getActor(), AViewpointUc);

        }

        String sql =
          "INSERT INTO strT2VpUcVariation " +
          "VALUES (" +
          id + ", " +
          AViewpointUc.getId()+ ", " +
          AStepStrT2.getPosition() +
          ", '" + step + "' " +
          ", " + actorOfVpUcId +
          ", '" + action + "'" +
          ", " + AStepStrT2.isSystemStep() +
          ",'" + extrans + "')";
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.insertSubvariationT2: " + sql);
        statDB.executeUpdate(sql);
        AStepStrT2.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  // ====================================================================
  // ======= update
  // ====================================================================

  /**
   * updates use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  public static void updateViewpointUc(business.CViewpointUc AViewpointUc) {
    Connection conDB = CDatabase.getConnectionDb();
    try {
      if (conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();
        String sql = new String("UPDATE viewpoint " +
           "SET name='" + AViewpointUc.getViewpointAgent().getName() + "' ," + //Vpuc name = agent name
           "viewpointAgentId=" + AViewpointUc.getViewpointAgent().getId() + ", " +
           "style= " + AViewpointUc.getStyle() + " " +
           "WHERE id=" + AViewpointUc.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateViewpointUc: " + sql);
        statDB.executeUpdate (sql);

        sql = new String("UPDATE viewpointuc " +
           "SET trigger='" + AViewpointUc.getTrigger() + "' " +
           "WHERE id=" + AViewpointUc.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateViewpointUc: " + sql);

        statDB.executeUpdate (sql);

        //persistence.CActor.insertActorOfViewpointUc(statDB, AViewpointUc);
        persistence.CViewpointUc.updatePrecond(statDB, AViewpointUc);
        persistence.CViewpointUc.updateSuccessEndcond(statDB, AViewpointUc);
        persistence.CViewpointUc.updateFailedEndcond(statDB, AViewpointUc);
        persistence.CViewpointUc.updateSuccessScenarioT1(statDB, AViewpointUc);
        persistence.CViewpointUc.updateExtensionT1(statDB, AViewpointUc);
        persistence.CViewpointUc.updateSubvariationT1(statDB, AViewpointUc);
        persistence.CViewpointUc.updateSuccessScenarioT2(statDB, AViewpointUc);
        persistence.CViewpointUc.updateExtensionT2(statDB, AViewpointUc);
        persistence.CViewpointUc.updateSubvariationT2(statDB, AViewpointUc);

        conDB.commit();
        conDB.setAutoCommit(true);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't update usecase viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

      try {
        conDB.rollback();
        conDB.setAutoCommit(true);
      } catch (SQLException ex2) {
        error = new String("error message: can't do rollback \n");
        error = contr.CError.createSQLErrorMessage(error, ex2);
        contr.CError.showErrorMessage(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    }
  }

  /**
   * updates preconditions of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updatePrecond(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM vpUcPrecondition " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updatePrecond: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AViewpointUc.getPrecond().size(); i++) {
          persistence.CViewpointUc.insertPrecond(statDB,
            (business.CCondition) AViewpointUc.getPrecond().elementAt(i), AViewpointUc.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates success endconditions of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updateSuccessEndcond(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM vpUcSuccessEndcondition " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateSuccessEndcond: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AViewpointUc.getSuccessEndcond().size(); i++) {
          persistence.CViewpointUc.insertSuccessEndcond(statDB,
            (business.CCondition) AViewpointUc.getSuccessEndcond().elementAt(i), AViewpointUc.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates failed endconditions of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updateFailedEndcond(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM vpUcFailedEndcondition " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateFailedEndcond: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AViewpointUc.getFailedEndcond().size(); i++) {
          persistence.CViewpointUc.insertFailedEndcond(statDB,
            (business.CCondition) AViewpointUc.getFailedEndcond().elementAt(i), AViewpointUc.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates success scenario type 1 of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updateSuccessScenarioT1(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT1VpUcSuccessScenario " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateSuccessScenarioT1: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AViewpointUc.getSuccessScenarioT1().size(); i++) {
          persistence.CViewpointUc.insertSuccessScenarioT1(statDB,
            (business.CStepStrT1) AViewpointUc.getSuccessScenarioT1().elementAt(i), AViewpointUc.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates success scenario type 2 of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updateSuccessScenarioT2(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT2VpUcSuccessScenario " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateSuccessScenarioT2: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AViewpointUc.getSuccessScenarioT2().size(); i++) {
          persistence.CViewpointUc.insertSuccessScenarioT2(statDB,
            (business.CStepStrT2) AViewpointUc.getSuccessScenarioT2().elementAt(i), AViewpointUc
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates extension type 1 of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updateExtensionT1(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT1VpUcExtension " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateExtensionT1: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0;
             AViewpointUc.getExtensionT1() != null &&
             i<AViewpointUc.getExtensionT1().size();
             i++) {
          persistence.CViewpointUc.insertExtensionT1(statDB,
            (business.CStepStrT1) AViewpointUc.getExtensionT1().elementAt(i), AViewpointUc.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates extension type 2 of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updateExtensionT2(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT2VpUcExtension " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateExtensionT2: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0;
             AViewpointUc.getExtensionT2() != null &&
             i<AViewpointUc.getExtensionT2().size();
             i++) {
          persistence.CViewpointUc.insertExtensionT2(statDB,
            (business.CStepStrT2) AViewpointUc.getExtensionT2().elementAt(i), AViewpointUc
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates variation type 1 of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updateSubvariationT1(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT1VpUcVariation " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateSubvariationT1: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0;
             AViewpointUc.getSubvariationT1() != null &&
             i<AViewpointUc.getSubvariationT1().size();
             i++) {
          persistence.CViewpointUc.insertSubvariationT1(statDB,
            (business.CStepStrT1) AViewpointUc.getSubvariationT1().elementAt(i), AViewpointUc.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates variation type 1 of use case viewpoint
   *
   * @param AViewpointUc use case viewpoint
   * @return void
   */
  private static void updateSubvariationT2(
  Statement AStatDB,
  business.CViewpointUc AViewpointUc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT2VpUcVariation " +
                     "WHERE viewpointUsecaseId=" + AViewpointUc.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointUc.updateSubvariationT2: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0;
             AViewpointUc.getSubvariationT2() != null &&
             i<AViewpointUc.getSubvariationT2().size();
             i++) {
          persistence.CViewpointUc.insertSubvariationT2(statDB,  (business.CStepStrT2) AViewpointUc.getSubvariationT2().elementAt(i), AViewpointUc );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  // ====================================================================
  // ======= delete
  // ====================================================================

  /** deletes use case viewpoint
   *  @param AViewpointUc use case viewpoint
   */
  public static boolean deleteViewpointUc(business.CViewpointUc AViewpointUc) {
  Vector Groups = new Vector();
  Vector Usecases = new Vector();
    if(persistence.CGroupVP.getGroupsOfVP( AViewpointUc.getId() , Groups,Usecases)){
      String msg = "";
      for(int i = 0 ;i<Groups.size();i++){
        msg = msg + (String) Usecases.elementAt(i) +":"+Groups.elementAt(i)+"\n";
      }
      JOptionPane.showMessageDialog(null,"Can not delete Viewpoint\n\n"+
      "This viewpoint belong to one or more Group Viewpoints\n\n"+
      "Usecase:Group\n"+
      msg);
      return false;
    }else{

      String sql = null;
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        try {
          conDB.setAutoCommit(true);
          Statement statDB = conDB.createStatement();
          //if (AViewpointUc.getActors() != null)
          //System.out.println("------------------------------------");
          //persistence.CActor.deleteAllActorOfViewpointUc(statDB, AViewpointUc);
          sql =
            new String("DELETE FROM vpUcPrecondition " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM vpUcSuccessEndcondition " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
          if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM vpUcFailedEndcondition " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM strT1VpUcSuccessScenario " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM strT1VpUcExtension " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM strT1VpUcVariation " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM strT2VpUcSuccessScenario " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM strT2VpUcExtension " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM strT2VpUcVariation " +
                       "WHERE viewpointUsecaseId=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM viewpointUc " +
                       "WHERE id=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          sql =
            new String("DELETE FROM viewpoint " +
                       "WHERE id=" + AViewpointUc.getId());
           if (business.Global.DEBUG && all)
            System.out.println("----> persistence.CViewpointUc.deleteViewpointUc: " + sql);
          statDB.executeUpdate (sql);

          conDB.commit();
          conDB.setAutoCommit(true);
          statDB.close();
          AViewpointUc = null;
        } catch (SQLException ex) {
          String error = new String("error message: can't delete usecase viewpoint \n");
          error = contr.CError.createSQLErrorMessage(error, ex);
          contr.CError.showNotDelete(business.Global.recocase, error);
          if (business.Global.DEBUG) System.out.println(error);

          try {
            conDB.rollback();
            conDB.setAutoCommit(true);
          } catch (SQLException ex2) {
            error = new String("error message: can't do rollback \n");
            error = contr.CError.createSQLErrorMessage(error, ex2);
            contr.CError.showErrorMessage(business.Global.recocase, error);
            if (business.Global.DEBUG) System.out.println(error);
          }
        }
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
      return true;
    }//ok to delete
  }

  /** deletes all use case viewpoints of a shared use case
   *  @param shared use case
   */
//  public static void deleteAllViewpointUcOfUsecaseOLD(business.CUsecase AUsecase) {
//      System.out.println("DO NOT USE :deleteAllViewpointUcOfUsecase(business.CUsecase AUsecase)");
//    Connection conDB = CDatabase.getConnectionDb();
//    if (conDB != null) {
//      Vector viewpointUcV = persistence.CViewpointUc.getAllViewpointUcOfUsecase(AUsecase);
//      if (viewpointUcV != null && viewpointUcV.size()>0) {
//        for (int i=0; i<viewpointUcV.size(); i++)
//          persistence.CViewpointUc.deleteViewpointUc((business.CViewpointUc) viewpointUcV.elementAt(i));
//      }
//    } else {
//      contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//    }
//  }

  // ====================================================================
  // ======= find
  // ====================================================================
  /**
   * finds new id for use case viewpoint
   *
   * @return id for use case viewpoint
   */
   private static long findNewId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM viewpoint");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for precondition
   *
   * @return id for precondition
   */
  private static long findNewPrecondId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM vpUcPrecondition");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for success endcondition
   *
   * @return id for success endcondition
   */
  private static long findNewSuccessEndcondId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM vpUcSuccessEndcondition");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for failed endcondition
   *
   * @return id for failed endcondition
   */
  private static long findNewFailedEndcondId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM vpUcFailedEndcondition");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of success scenario type 1
   *
   * @return id for step of success scenario type 1
   */
  private static long findNewSuccessScenarioT1Id(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT1VpUcSuccessScenario");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of success scenario type 2
   *
   * @return id for step of success scenario type 2
   */
  private static long findNewSuccessScenarioT2Id(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT2VpUcSuccessScenario");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of extension type 1
   *
   * @return id for step of extension type 1
   */
  private static long findNewExtensionT1Id(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT1VpUcExtension");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of extension type 2
   *
   * @return id for step of extension type 2
   */
  private static long findNewExtensionT2Id(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT2VpUcExtension");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of variation type 1
   *
   * @return id for step of variation type 1
   */
  private static long findNewSubvariationT1Id(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT1VpUcVariation");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of variation type 2
   *
   * @return id for step of variation type 2
   */
  private static long findNewSubvariationT2Id(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT2VpUcVariation");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }




  public static business.CViewpointUc getViewpoint(business.CUsecase AUsecase, long id ){
    business.CViewpointUc viewpoint = null;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
          "SELECT viewpoint.id, viewpoint.viewpointAgentId, viewpoint.name, viewpoint.style, viewpointuc.trigger " +
          "FROM viewpointAgent INNER JOIN (viewpoint INNER JOIN viewpointuc ON viewpoint.id = viewpointuc.id) ON viewpointAgent.id = viewpoint.viewpointAgentId "+
          "WHERE viewpointAgent.usecaseId= "+AUsecase.getId()+ "AND viewpointAgent.id= "+id+
          " ORDER BY viewpoint.name ASC");

        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointUc.getViewpointUc: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);

        if (resDB.next()) {
          business.CViewpointAgent vpAgent = persistence.CViewpointAgent.getAgent( resDB.getLong("viewpointAgentId"));
          String name = resDB.getString("name");
          int style = resDB.getInt("style");
          String trigger = resDB.getString("trigger");
          viewpoint = new business.CViewpointUc(id,vpAgent,name,style, AUsecase, trigger, null);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read all use case viewpoints of use case \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return viewpoint;
  }



}
