package persistence;

import java.sql.*;
import java.util.*;



/**
 *
 * Description: provides access to database for scenario viewpoint datas
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpointSc {


static boolean all = false; //Debug



  private CViewpointSc() {}

  // ====================================================================
  // ======= get
  // ====================================================================

  /** reads all scenario viewpoints of shared scenario from database
   *  @return vector of scenario viewpoints
   */
  public static Vector getAllViewpointScOf(business.CViewpointUc aViewpointUC) {
    Vector allViewpointScV = new Vector();
    //viewpointUC

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(

"SELECT viewpoint.id, viewpoint.viewpointAgentId, viewpoint.name, viewpoint.style "+
"FROM viewpoint INNER JOIN viewpointsc ON viewpoint.id = viewpointsc.id "+
"WHERE viewpointsc.viewpointUcID= "+aViewpointUC.getId()+" "+
"ORDER BY viewpoint.name");

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.getAllViewpointScOf: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);

        while (resDB.next()) {
          long id = resDB.getLong("id");
          long VPAgentID =  resDB.getLong("viewpointAgentId");
          String name = resDB.getString("name");
          int style = resDB.getInt("style");
          business.CViewpointAgent VPAgent =  persistence.CViewpointAgent.getAgent(VPAgentID);

          business.CViewpointSc viewpointSc =
            new business.CViewpointSc(
            id,
            VPAgent,
            name,
            style,
            aViewpointUC,
            null,
            null);
          allViewpointScV.addElement(viewpointSc);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read all scenario viewpoints of scenario \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return allViewpointScV;
   }


  /** reads the unstructured text of a scenario viewpoint from the database
   *  @return unstructured text of a scenario viewpoint
   */
  public static String getUnstructText(business.CViewpointSc AViewpointSc) {

    String actions = null;

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT actions " +
            "FROM unstrTVpScenario " +
            "WHERE viewpointScenarioId=" + AViewpointSc.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.getUnstructText: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
          actions =  resDB.getString("actions");
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read unstructured text \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return actions;
  }

  /** reads steps of scenario of scenario viewpoint from database
   *  (type business.CStepStrT1)
   *  @param AViewpointSc scenario viewpoint
   *  @return vector of steps of scenario of scenario viewpoint
   */
  public static Vector getStepStrT1(business.CViewpointSc AViewpointSc) {

    Vector stepV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, action ,extrans " +
            "FROM strT1VpScenario " +
            "WHERE viewpointScenarioId=" + AViewpointSc.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.getStepStrT1: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CStepStrT1 stepStrT1 =
            new business.CStepStrT1(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            resDB.getString("extrans"));

          stepV.add(stepStrT1);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read scenario steps 01 \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return stepV;
  }

  /** reads steps of scenario of scenario viewpoint from database
   *  (type business.CStepStrT2)
   *  @param AViewpointSc scenario viewpoint
   *  @return vector of steps of scenario of scenario viewpoint
   */
  public static Vector getStepStrT2(business.CViewpointSc AViewpointSc) {

    Vector stepV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, agentId, action, systemStep, extrans " +
            "FROM strT2VpScenario " +
            "WHERE viewpointScenarioId=" + AViewpointSc.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.getStepStrT2: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CAgent agent =
            persistence.CActor.getAgentOfVpSc(resDB.getLong("agentId"));

          business.CStepStrT2 stepStrT2 =
            new business.CStepStrT2(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            null,
            agent,
            resDB.getBoolean("systemStep"),
            resDB.getString("extrans"));

          stepV.add(stepStrT2);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read scenario steps 02 \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return stepV;
  }
  // ====================================================================
  // ======= insert
  // ====================================================================

   /** inserts scenario viewpoint into database
    *  @param AViewpointSc scenario viewpoint
    *  @return true, if no error occured, else false
    */
   public static boolean insertViewpointSc(business.CViewpointSc AViewpointSc) {

    Connection conDB = CDatabase.getConnectionDb();
    try {
      if ( conDB != null) {
	conDB.setAutoCommit(true);

        Statement statDB = conDB.createStatement();
        long id = findNewId(statDB);
        String name = AViewpointSc.getName();
        String sql =
          "INSERT INTO viewpoint " +
          "(id, viewpointAgentId, name, style) " +
          "VALUES (" +
          id + ", " + AViewpointSc.getViewpointAgent().getId() +
          ", '" +  name + "', " + AViewpointSc.getStyle() + ")";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.insertViewpointSc: " + sql);
        statDB.executeUpdate(sql);


        sql =
          "INSERT INTO viewpointsc " +
          "(id, viewpointUcID) " +
          "VALUES (" +
          id+ ", " +
          AViewpointSc.getViewpointUc().getId() +")";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.insertViewpointSc: " + sql);
        statDB.executeUpdate(sql);
        AViewpointSc.setId(id);

        //need to do this before inserting into str t2vpscenario
        if (AViewpointSc.getAgents() != null)
          persistence.CActor.insertAgentOfViewpointSc(statDB, AViewpointSc);
        if (AViewpointSc.getUnstructText() != null)
          persistence.CViewpointSc.insertUnstructText(statDB, AViewpointSc);
        if (AViewpointSc.getStepStrT1() != null)
          persistence.CViewpointSc.insertStepStrT1(statDB, AViewpointSc);
        if (AViewpointSc.getStepStrT2() != null)
          persistence.CViewpointSc.insertStepStrT2(statDB, AViewpointSc);
	conDB.commit();
        statDB.close();
	conDB.setAutoCommit(true);
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
        return false;
      }
    }
    catch (SQLException ex){
      String error = new String("error message: can't insert scenario viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

      try {
        conDB.rollback();
        conDB.setAutoCommit(true);
      } catch (SQLException ex2) {
        error = new String("error message: can't do rollback \n");
        error = contr.CError.createSQLErrorMessage(error, ex2);
        contr.CError.showErrorMessage(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }

      return false;
    }

    return true;
  }

  /** inserts unstructured text of scenario of scenario viewpoint into database
   *  @param AViewpointSc scenario viewpoint
   */
  private static void insertUnstructText(
  Statement AStatDB,
  business.CViewpointSc AViewpointSc)
  throws SQLException {

    Statement statDB = AStatDB;
    try {
        String sql =
          "DELETE * FROM unstrTVpScenario " +
          "WHERE viewpointScenarioId=" +
          AViewpointSc.getId();
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.insertUnstructText: " + sql);
        statDB.executeUpdate(sql);

        long id = findNewUnstructTextId(statDB);

        String actions = AViewpointSc.getUnstructText();
        if (actions == null || actions.equals(new String("")))
          actions = new String(" ");

        sql =
          "INSERT INTO unstrTVpScenario " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AViewpointSc.getId()).toString() + ", " +
          "'" +  actions + "')";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.insertUnstructText: " + sql);
        statDB.executeUpdate(sql);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts steps of scenario of scenario viewpoint into database
   *  (type business.CStepStrT1)
   *  @param AViewpointSc scenario viewpoint
   */
  private static void insertStepStrT1(
  Statement AStatDB,
  business.CViewpointSc AViewpointSc)
  throws SQLException {

    Statement statDB = AStatDB;
    try {
        String sql =
          "DELETE * FROM strT1VpScenario " +
          "WHERE viewpointScenarioId=" +
          AViewpointSc.getId();
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.insertStepStrT1: " + sql);
        statDB.executeUpdate(sql);

        if (AViewpointSc.getStepStrT1() != null) {
          for(int i=0; i<AViewpointSc.getStepStrT1().size(); i++) {
            business.CStepStrT1 step =
              (business.CStepStrT1) AViewpointSc.getStepStrT1().elementAt(i);
            long id = findNewStructText1Id(statDB);
            String action = step.getAction();
            if (action == null) action = new String("");

            String stepS = step.getStep();
            if (stepS == null) stepS = new String("");

            String extrans = step.getPhrases();
            if (extrans == null) extrans = new String("");



            sql =
               "INSERT INTO strT1VpScenario " +
               "VALUES (" +
               new Long(id).toString() + ", " +
               new Long(AViewpointSc.getId()).toString() + ", " +
               new Integer(step.getPosition()).toString() + ", " +
               "'" + stepS + "' " +
               ",'" + action + "'" +
               ",'" + extrans + "')";
             if (business.Global.DEBUG)
               System.out.println("----> persistence.CViewpointSc.insertStepStrT1: " + sql);
             statDB.executeUpdate(sql);
          }
        }
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /** inserts steps of scenario of scenario viewpoint into database
   *  (type business.CStepStrT1)
   *  @param AViewpointSc scenario viewpoint
   */
  private static void insertStepStrT2(
  Statement AStatDB,
  business.CViewpointSc AViewpointSc)
  throws SQLException {

    Statement statDB = AStatDB;
    try {
        String sql =
          "DELETE * FROM strT2VpScenario " +
          "WHERE viewpointScenarioId=" +
          AViewpointSc.getId();
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.insertStepStrT2: " + sql);
        statDB.executeUpdate(sql);

        if (AViewpointSc.getStepStrT2() != null) {
          for(int i=0; i<AViewpointSc.getStepStrT2().size(); i++) {
            business.CStepStrT2 step =
              (business.CStepStrT2) AViewpointSc.getStepStrT2().elementAt(i);

            long id = findNewStructText2Id(statDB);

            String action = step.getAction();
            if (action == null) action = new String(" ");

            String stepS = step.getStep();
            if (stepS == null) stepS = new String(" ");

            String extrans = step.getPhrases();
            if (extrans == null) extrans = new String("");

            long agentId = -1;
            if (step.getAgent() != null) {
              agentId = persistence.CActor.getAgentIdOfVpSc(
              AViewpointSc,
              step.getAgent());
            }

            sql =
               "INSERT INTO strT2VpScenario " +
               "VALUES (" +
               new Long(id).toString() + ", " +
               new Long(AViewpointSc.getId()).toString() + ", " +
               new Integer(step.getPosition()).toString() + ", " +
               "'" + stepS + "', " +
               agentId +
               ", '" + action + "'" +
               ", " + step.isSystemStep() +
               ",'" + extrans + "')";

             if (business.Global.DEBUG)
               System.out.println("----> persistence.CViewpointSc.insertStepStrT2: " + sql);
             statDB.executeUpdate(sql);
          }
        }
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  // ====================================================================
  // ======= update
  // ====================================================================

   /** update data of scenario viewpoint
    *  @param AViewpointSc scenario viewpoint
    */
   public static void updateViewpointSc(business.CViewpointSc AViewpointSc) {
        System.out.println();
        System.out.println("UPDATE");

    Connection conDB = CDatabase.getConnectionDb();
    try {
      if (conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();

        String sql = new String("UPDATE viewpoint " +
           "SET name='" + AViewpointSc.getName() + "' ," +
           "viewpointAgentId=" + AViewpointSc.getViewpointAgent().getId() + ", " +
           "style=" + AViewpointSc.getStyle() + " " +
           "WHERE id=" + AViewpointSc.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.updateViewpointSc: " + sql);
        statDB.executeUpdate (sql);

        sql = new String("UPDATE viewpointsc " +
           "SET viewpointUcID =" + AViewpointSc.getViewpointUc().getId() +
           " WHERE id=" + AViewpointSc.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointSc.updateViewpointSc: " + sql);
        statDB.executeUpdate (sql);

        if (AViewpointSc.getAgents() != null)
          persistence.CActor.insertAgentOfViewpointSc(statDB, AViewpointSc);

        if (AViewpointSc.getUnstructText() != null)
          persistence.CViewpointSc.insertUnstructText(statDB, AViewpointSc);

        if (AViewpointSc.getStepStrT1() != null)
          persistence.CViewpointSc.insertStepStrT1(statDB, AViewpointSc);

        if (AViewpointSc.getStepStrT2() != null)
          persistence.CViewpointSc.insertStepStrT2(statDB, AViewpointSc);

        conDB.commit();
        conDB.setAutoCommit(true);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't update scenario viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

      try {
        conDB.rollback();
        conDB.setAutoCommit(true);
      } catch (SQLException ex2) {
        error = new String("error message: can't do rollback \n");
        error = contr.CError.createSQLErrorMessage(error, ex2);
        contr.CError.showErrorMessage(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    }
  }

  // ====================================================================
  // ======= delete
  // ====================================================================

  /** deletes scenario viewpoint
   *  @param AViewpointSc scenario viewpoint
   */
  public static void deleteViewpointSc(business.CViewpointSc AViewpointSc) {

    if (business.Global.DEBUG && !all)
       System.out.println("----> persistence.CViewpointSc.deleteViewpointSc:     STEPS ");

    Connection conDB = CDatabase.getConnectionDb();
    if (conDB != null) {
      try {
	conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();

        //if (AViewpointSc.getAgents() != null)

          persistence.CActor.deleteAllAgentOfViewpointSc(statDB, AViewpointSc);

        String sql =
          new String("DELETE FROM unstrTVpScenario " +
                     "WHERE viewpointScenarioId=" + AViewpointSc.getId());
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointSc.deleteViewpointSc: " + sql);
        statDB.executeUpdate (sql);

        sql =
          new String("DELETE FROM strT1VpScenario " +
                     "WHERE viewpointScenarioId=" + AViewpointSc.getId());
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointSc.deleteViewpointSc: " + sql);
        statDB.executeUpdate (sql);

        sql =
          new String("DELETE FROM strT2VpScenario " +
                     "WHERE viewpointScenarioId=" + AViewpointSc.getId());
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointSc.deleteViewpointSc: " + sql);
        statDB.executeUpdate (sql);

        sql =
          new String("DELETE FROM viewpointSc " +
                     "WHERE id=" + AViewpointSc.getId());
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointSc.deleteViewpointSc: " + sql);
        statDB.executeUpdate (sql);

        sql =
          new String("DELETE FROM viewpoint " +
                     "WHERE id=" + AViewpointSc.getId());
        if (business.Global.DEBUG && all)
          System.out.println("----> persistence.CViewpointSc.deleteViewpointSc: " + sql);
        statDB.executeUpdate (sql);

        AViewpointSc = null;

	conDB.commit();
        statDB.close();
	conDB.setAutoCommit(true);

        if (business.Global.DEBUG && !all)
          System.out.println("----> persistence.CViewpointSc.deleteViewpointSc: " + sql);


      } catch (SQLException ex) {

        String error = new String("error message: can't delete scenario viewpoint \n");
        error = contr.CError.createSQLErrorMessage(error, ex);
        contr.CError.showNotDelete(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);

        try {
          conDB.rollback();
          conDB.setAutoCommit(true);
        } catch (SQLException ex2) {
          error = new String("error message: can't do rollback \n");
          error = contr.CError.createSQLErrorMessage(error, ex2);
          contr.CError.showErrorMessage(business.Global.recocase, error);
          if (business.Global.DEBUG) System.out.println(error);
        }
      }
    } else {
      contr.CError.showNoConnectionToDatabase(business.Global.recocase);
    }
  }

  /** deletes all scenario viewpoints of shared scenario
   *  @param AScenario scenario
   */
//  public static void deleteAllViewpointScOfScenario(business.CScenario AScenario) {
//
//    Connection conDB = CDatabase.getConnectionDb();
//    if (conDB != null) {
//      Vector viewpointScV = persistence.CViewpointSc.getAllViewpointScOfScenario(AScenario);
//      if (viewpointScV != null && viewpointScV.size()>0) {
//        for (int i=0; i<viewpointScV.size(); i++)
//          persistence.CViewpointSc.deleteViewpointSc((business.CViewpointSc) viewpointScV.elementAt(i));
//      }
//    } else {
//      contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//    }
//  }

  // ====================================================================
  // ======= find
  // ====================================================================

   /** finds new id for scenario viewpoint
    *  @return new id for scenario viewpoint
    */
   private static long findNewId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM viewpoint");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

   /** finds new id for unstructured text of scenario viewpoint
    *  @return new id for sunstructured text of cenario viewpoint
    */
  private static long findNewUnstructTextId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM unstrTVpScenario");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

   /** finds new id for step (type business.CStepStrT1) of scenario viewpoint
    *  @return new id for step (type business.CStepStrT1) of scenario viewpoint
    */
   private static long findNewStructText1Id(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT1VpScenario");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

   /** finds new id for step (type business.CStepStrT2) of scenario viewpoint
    *  @return new id for step (type business.CStepStrT2) of scenario viewpoint
    */
   private static long findNewStructText2Id(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT2VpScenario");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }
}
