package persistence;

import java.sql.*;
import java.util.*;


import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;


/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class CViewpointAgent {

  public CViewpointAgent() {
  }

  public static business.CViewpointAgent getAgent(long id){
    business.CViewpointAgent agent = null;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String("SELECT userId, name, usecaseId FROM viewpointAgent WHERE id = " +id );
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CviewpointAgent.getAgent: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
          agent =
            new    business.CViewpointAgent(
            id,
            persistence.CUser.getUser(resDB.getLong("userId")),
            resDB.getString("name"),
            resDB.getLong("usecaseId"));
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of the user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return agent;
  }




  public static void addAgent( business.CViewpointAgent agent){
  try {
      Connection conDB = CDatabase.getConnectionDb();
      conDB.setAutoCommit(false);
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        long id = findNewId(statDB);
        agent.setId(id);
        String name = agent.getName() ;
        long userId = agent.getUser().getId();
        long usecaseId = agent.getUsecaseId();
        String sql =
          " INSERT INTO viewpointAgent " +
          " VALUES("+id+","+userId+",'"+name+"',"+usecaseId+")";
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUser.addUser: " + sql);
       statDB.executeUpdate(sql);

        conDB.commit();
        conDB.setAutoCommit(true);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of the user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }

   public static void deleteAgent(long AId) {
    try {
      Connection conDB = CDatabase.getConnectionDb();
      conDB.setAutoCommit(false);
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql = "DELETE FROM viewpointAgent  WHERE id=" + AId;
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUser.dleteUser: " + sql);
        statDB.executeUpdate(sql);

        conDB.commit();
        conDB.setAutoCommit(true);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }

    }
    catch (SQLException ex) {
      String error = new String("error message: can't delete user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }


   public static void UpdateAgent(business.CViewpointAgent agent){
    try {
      Connection conDB = CDatabase.getConnectionDb();
      conDB.setAutoCommit(false);
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql = "UPDATE viewpointAgent"+
                     " SET name = '"+ agent.getName() + "'" +
                     " , userId = "+ agent.getUser().getId() +
                     " WHERE id = "+ agent.getId();

       if (business.Global.DEBUG)
          System.out.println("----> persistence.CViewpointAgent.updateAgent: " + sql);
        statDB.executeUpdate(sql);

        conDB.commit();
        conDB.setAutoCommit(true);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }

    }
    catch (SQLException ex) {
      String error = new String("error message: can't delete user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }


 private static long findNewId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM viewpointAgent");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  public static Vector getAllAgentsOfUsecase(long UCID){
    Vector agents = new Vector();
    business.CViewpointAgent agent = null;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String("SELECT id, userId, name, usecaseId FROM viewpointAgent WHERE usecaseId = " +UCID );
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CviewpointAgent.getAgent: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          agent =
            new    business.CViewpointAgent(
            resDB.getLong("id"),
            persistence.CUser.getUser(resDB.getLong("userId")),
            resDB.getString("name"),
            resDB.getLong("usecaseId")
            );
          agents.add(agent);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read data of the user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return agents;
  }



}