package persistence;

import java.sql.*;
import java.util.*;

/**
 *
 * Description: access to database for user datas
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CUser {

  private CUser() {}

   /** returns the user with correspondent login and password
    *  @return the user with correspondent login and password
    */
   public static business.CUser getUser(String ALogin, String APassword) {

    business.CUser user = null;

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String("SELECT id, name, admin, analyst, valid FROM users WHERE login='" +
                     ALogin + "' and password='" + APassword + "'");
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUser.getUser: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
          user =
            new business.CUser(
            resDB.getLong("id"),
            resDB.getString("name"),
            ALogin,
            APassword,
            resDB.getBoolean("admin"),
            resDB.getBoolean("analyst"),
            resDB.getBoolean("valid"));
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of the user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return user;
  }

   /** returns the user with correspondent id
    *  @return the user with correspondent id
    */

   public static business.CUser getUser(long AId) {
    business.CUser user = null;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String("SELECT name, login, password, admin, valid, analyst FROM users WHERE id=" + AId);
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUser.getUser2: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
          user =
            new business.CUser(
            AId,
            resDB.getString("name"),
            resDB.getString("login"),
            resDB.getString("password"),
            resDB.getBoolean("admin"),
            resDB.getBoolean("analyst"),
            resDB.getBoolean("valid"));
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of the user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return user;
  }


  // ====================================================================
  // ======= public static void deleteUser
  // ====================================================================
  /**
   *  @param  id of user
   */

   public static void deleteUser(long AId) {
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql = "DELETE FROM users WHERE id=" + AId;
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUser.dleteUser: " + sql);
        statDB.executeUpdate(sql);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't delete user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }


  }











   public static void addUser(String name,String user,String password,boolean Aadmin,boolean Aanalyst,boolean Avalid) {
    String admin = "NO";
    String analyst = "NO";
    String valid = "NO";

    if(Aadmin){
      admin = "YES";
    }
    if( Aanalyst){
      analyst = "YES";
    }
    if( Avalid){
      valid = "YES";
    }

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        long id = findNewUserId(statDB);
        String sql =
          " INSERT INTO users " +
          " VALUES("+id+",'"+name+"','"+user+"','"+password+"',"+admin+","+analyst+","+valid+")";
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUser.addUser: " + sql);
       statDB.executeUpdate(sql);

        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of the user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }




   public static Vector getUsers() {
    Vector users = new Vector();
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String("SELECT id, name, login, password, admin, valid, analyst FROM users ORDER BY name ");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUser.getUser s : " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CUser user =
            new business.CUser(
            resDB.getLong("id"),
            resDB.getString("name"),
            resDB.getString("login"),
            resDB.getString("password"),
            resDB.getBoolean("admin"),
            resDB.getBoolean("analyst"),
            resDB.getBoolean("valid"));
          users.addElement(user);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of the user \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return users;
  }




  public static void updateUser(business.CUser user){

    String admin = "NO";
    String analyst = "NO";
    String valid = "NO";

    if(user.isAdmin()){
      admin = "YES";
    }
    if(user.isAnalyst()){
      analyst = "YES";
    }
    if(user.isValid()){
      valid = "YES";
    }


    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();
        String sql = new String(
                  "UPDATE users "+
                  "SET "+
                  "users.name = '"      + user.getName()    +"', "+
                  "users.login = '"     + user.getLogin()   +"', "+
                  "users.[password] = '"+ user.getPassword()+"', "+
                  "users.admin = "      + admin             +", "+
                  "users.analyst = "    + analyst           +", "+
                  "users.valid = "      + valid             +
                  " WHERE (((users.id)="+ user.getId()+"))");

        if (business.Global.DEBUG)
          System.out.println("----> persistence.Cuser.update : " + sql);
        statDB.executeUpdate (sql);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: update CUser  \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }



















//    try {
//      Connection conDB = CDatabase.getConnectionDb();
//      if (conDB != null) {
//        Statement statDB = conDB.createStatement();
//        String sql =
//               "UPDATE users " +
//               "SET "+
//               "name='" + user.getName() + "', " +
//               "login='" + user.getLogin() + "', " +
//               "password='" + user.getPassword() + "', " +
//               "admin=" + admin + ", " +
//               "analyst=" +analyst  + ", " +
//               "valid=" + valid + ", " +
//               "WHERE id=" + user.getId();
//
//        //if (business.Global.DEBUG)
//            System.out.println("----> persistence.Cuser.updateUser: " + sql);
//        statDB.executeUpdate(sql);
//        statDB.close();
//      } else {
//        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//      }
//    }
//    catch (SQLException ex) {
//      String error = new String("error message: can't update user \n");
//      error = contr.CError.createSQLErrorMessage(error, ex);
//      contr.CError.showNotRead(business.Global.recocase, error);
//      if (business.Global.DEBUG) System.out.println(error);
//    }
//  }
//




 private static long findNewUserId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM users");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }



}


