package persistence;

import java.sql.*;
import java.util.*;

/**
 *
 * Description: provides access to database for use case datas (shared use case)
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CUsecase {

  private CUsecase() {}

  // ====================================================================
  // ======= get
  // ====================================================================

  /**
   * reads all use cases of project
   *
   * @param AProject project
   * @return vector of use case
   */
   public static Vector getAllUsecasesOfProject(business.CProject AProject) {

    Vector allUsecasesV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, functRequirement, name, trigger, style " +
            "FROM usecase " +
            "WHERE projectId=" + AProject.getId() +
            " ORDER BY usecase.name ASC");
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.getAllUsecasesOfProject: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          long id = resDB.getLong("id");
          Vector actorV = persistence.CActor.getAllActorOfUsecase(id);
          business.CUsecase usecase =
            new business.CUsecase(id, AProject,
            resDB.getString("functRequirement"),
            resDB.getString("name"),
            resDB.getString("trigger"),
            resDB.getInt("style"),
            actorV);//null);
          allUsecasesV.addElement(usecase);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read all uscases of project \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return allUsecasesV;
  }

  /**
   * reads preconditions of use case
   *
   * @param AUsecase use case
   * @return vector of preconditions
   */
  public static Vector getPrecond(business.CUsecase AUsecase) {

    Vector precondV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, nr, condition ,extrans " +
            "FROM ucPrecondition " +
            "WHERE usecaseId=" + AUsecase.getId() +
            " ORDER BY nr ASC");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.getPrecond: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CCondition precond =
            new business.CCondition(
            resDB.getLong("id"),
            resDB.getInt("nr"),
            resDB.getString("condition"),
            resDB.getString("extrans"));
          precondV.addElement(precond);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read preconditions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return precondV;
  }


  /**
   * reads success endconditions of use case
   *
   * @param AUsecase use case
   * @return vector of success endconditions
   */
  public static Vector getSuccessEndcond(business.CUsecase AUsecase) {

    Vector successEndcondV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, nr, condition, extrans " +
            "FROM ucSuccessEndcondition " +
            "WHERE usecaseId=" + AUsecase.getId() +
            " ORDER BY nr ASC");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.getSuccessEndcond: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CCondition successEndcond =
            new business.CCondition(
            resDB.getLong("id"),
            resDB.getInt("nr"),
            resDB.getString("condition"),
            resDB.getString("extrans"));
          successEndcondV.addElement(successEndcond);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't read successEndconditions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return successEndcondV;
  }


  /**
   * reads failed endconditions of use case
   *
   * @param AUsecase use case
   * @return vector of failed endconditions
   */
  public static Vector getFailedEndcond(business.CUsecase AUsecase) {

    Vector failedEndcondV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, nr, condition, extrans " +
            "FROM ucFailedEndcondition " +
            "WHERE usecaseId=" + AUsecase.getId() +
            " ORDER BY nr ASC");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.getFailedEndcond: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CCondition failedEndcond =
            new business.CCondition(
            resDB.getLong("id"),
            resDB.getInt("nr"),
            resDB.getString("condition"),
            resDB.getString("extrans"));
          failedEndcondV.addElement(failedEndcond);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read failedEndconditions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return failedEndcondV;
  }


  /**
   * reads success scenario of use case
   *
   * @param AUsecase use case
   * @return vector of steps of success scenario
   */
  public static Vector getSuccessScenarioT1(business.CUsecase AUsecase) {

    Vector successScenarioT1V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, action, extrans " +
            "FROM strT1UcSuccessScenario " +
            "WHERE usecaseId=" + AUsecase.getId() +
            " ORDER BY position1 ASC");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.getSuccessScenarioT1: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CStepStrT1 stepStrT1 =
            new business.CStepStrT1(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            resDB.getString("extrans"));
          successScenarioT1V.addElement(stepStrT1);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read success scenario \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return successScenarioT1V;
  }

  /**
   * reads steps of extension of success scenario of use case
   *
   * @param AUsecase use case
   * @return vector of steps of extension of success scenario
   */
  public static Vector getExtensionT1(business.CUsecase AUsecase) {

    Vector extensionT1V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, action, extrans " +
            "FROM strT1UcExtension " +
            "WHERE usecaseId=" + AUsecase.getId() +
            " ORDER BY position1 ASC");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.getExtensionT1: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CStepStrT1 stepStrT1 =
            new business.CStepStrT1(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            resDB.getString("extrans"));
          extensionT1V.addElement(stepStrT1);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read extensions \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return extensionT1V;
  }

  /**
   * reads steps of variation of use case
   *
   * @param AUsecase use case
   * @return vector of steps of variation
   */
  public static Vector getSubvariationT1(business.CUsecase AUsecase) {

    Vector subvariationT1V = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT id, position1, step, action, extrans " +
            "FROM strT1UcVariation " +
            "WHERE usecaseId=" + AUsecase.getId() +
            " ORDER BY position1 ASC");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.getSubvariationT1: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CStepStrT1 stepStrT1 =
            new business.CStepStrT1(
            resDB.getLong("id"),
            resDB.getInt("position1"),
            resDB.getString("step"),
            resDB.getString("action"),
            resDB.getString("extrans"));
          subvariationT1V.addElement(stepStrT1);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read variation \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return subvariationT1V;
  }

  // ====================================================================
  // ======= insert
  // ====================================================================

  /**
   * inserts datas of use case
   *
   * @param AUsecase use case
   * @return void
   */
   public static boolean insertUsecase(business.CUsecase AUsecase) {

    boolean result = true;

    Connection conDB = CDatabase.getConnectionDb();
    try {
      if ( conDB != null) {
	conDB.setAutoCommit(false);
        Statement statDB = conDB.createStatement();

        long id = findNewId();

        String functRequirement = AUsecase.getFunctReq();
        if (functRequirement == null) functRequirement = new String("");

        String name = AUsecase.getName();
        if (name == null) name = new String("");

        String trigger = AUsecase.getTrigger();
        if (trigger == null) trigger = new String("");

        String sql =
          "INSERT INTO usecase " +
          "(id, projectId, functRequirement, name, trigger, style) " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AUsecase.getProject().getId()).toString() +
          ", '" +  functRequirement + "', '" +
          name + "', '" +
          trigger + "', " +
          AUsecase.getStyle() + ")";


        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.insertUsecase: " + sql);

        statDB.executeUpdate(sql);
        AUsecase.setId(id);

//        if (AUsecase.getActors() != null)
//          persistence.CActor.insertActorOfUsecase(statDB, AUsecase);
//
//        for (int i=0;
//             AUsecase.getPrecond() != null &&
//             i<AUsecase.getPrecond().size(); i++) {
//          persistence.CUsecase.insertPrecond(statDB,
//            (business.CCondition) AUsecase.getPrecond().elementAt(i),
//            AUsecase.getId()
//          );
//        }
//
//        for (int i=0;
//             AUsecase.getSuccessEndcond() != null &&
//             i<AUsecase.getSuccessEndcond().size(); i++) {
//          persistence.CUsecase.insertSuccessEndcond(statDB,
//            (business.CCondition) AUsecase.getSuccessEndcond().elementAt(i),
//            AUsecase.getId()
//          );
//        }
//
//        for (int i=0;
//             AUsecase.getFailedEndcond() != null &&
//             i<AUsecase.getFailedEndcond().size(); i++) {
//          persistence.CUsecase.insertFailedEndcond(statDB,
//            (business.CCondition) AUsecase.getFailedEndcond().elementAt(i),
//            AUsecase.getId()
//          );
//        }
//
//        for (int i=0;
//             AUsecase.getSuccessScenarioT1() != null &&
//             i<AUsecase.getSuccessScenarioT1().size(); i++) {
//          persistence.CUsecase.insertSuccessScenarioT1(statDB,
//            (business.CStepStrT1) AUsecase.getSuccessScenarioT1().elementAt(i),
//            AUsecase.getId()
//          );
//        }
//
//        for (int i=0;
//             AUsecase.getExtensionT1() != null &&
//             i<AUsecase.getExtensionT1().size(); i++) {
//          persistence.CUsecase.insertExtensionT1(statDB,
//            (business.CStepStrT1) AUsecase.getExtensionT1().elementAt(i),
//            AUsecase.getId()
//          );
//        }
//
//        for (int i=0;
//             AUsecase.getSubvariationT1() != null &&
//             i<AUsecase.getSubvariationT1().size(); i++) {
//          persistence.CUsecase.insertSubvariationT1(statDB,
//            (business.CStepStrT1) AUsecase.getSubvariationT1().elementAt(i),
//            AUsecase.getId()
//          );
//        }

	conDB.commit();
        statDB.close();
	conDB.setAutoCommit(true);

      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex){
      result = false;

      String error = new String("error message: can't insert usecase \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

      try {
        conDB.rollback();
        conDB.setAutoCommit(true);
      } catch (SQLException ex2) {
        error = new String("error message: can't do rollback \n");
        error = contr.CError.createSQLErrorMessage(error, ex2);
        contr.CError.showErrorMessage(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    }

    return result;
  }

  /**
   * inserts precondition of use case
   *
   * @param APrecond precondition
   * @param AUsecaseId id of use case
   * @return void
   */
  public static void insertPrecond(
  Statement AStatDB,
  business.CCondition APrecond,
  long AUsecaseId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewPrecondId(statDB);

        String text = APrecond.getText();
        if (text == null) text = new String("");

        String extrans = APrecond.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO ucPrecondition " +
          "(id, usecaseId, nr, condition, extrans) " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AUsecaseId).toString() + ", " +
          new Integer(APrecond.getNumber()).toString() +
          ", '" + text + "'"+
          ", '" + extrans + "')";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.insertPrecond: " + sql);

        statDB.executeUpdate(sql);
        APrecond.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /**
   * inserts success endcondition of use case
   *
   * @param ASuccessEndcond success endcondition
   * @param AUsecaseId id of use case
   * @return void
   */
  public static void insertSuccessEndcond(
  Statement AStatDB,
  business.CCondition ASuccessEndcond,
  long AUsecaseId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewSuccessEndcondId(statDB);

        String text = ASuccessEndcond.getText();
        if (text == null) text = new String("");

        String extrans = ASuccessEndcond.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO ucSuccessEndcondition " +
          "(id, usecaseId, nr, condition, extrans)" +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AUsecaseId).toString() + ", " +
          new Integer(ASuccessEndcond.getNumber()).toString() +
          ", '" + text + "'"+
          ", '" + extrans + "')";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.insertSuccessEndcond: " + sql);

        statDB.executeUpdate(sql);
        ASuccessEndcond.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /**
   * inserts failed endcondition of use case
   *
   * @param AFailedEndcond failed endcondition
   * @param AUsecaseId id of use case
   * @return void
   */
  public static void insertFailedEndcond(
  Statement AStatDB,
  business.CCondition AFailedEndcond,
  long AUsecaseId)  throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewFailedEndcondId(statDB);

        String text = AFailedEndcond.getText();
        if (text == null) text = new String("");

        String extrans = AFailedEndcond.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO ucFailedEndcondition " +
          "(id, usecaseId, nr, condition, extrans) " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AUsecaseId).toString() + ", " +
          new Integer(AFailedEndcond.getNumber()).toString() +
          ", '" + text + "'"+
          ", '" + extrans + "')";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.insertFailedEndcond: " + sql);

        statDB.executeUpdate(sql);
        AFailedEndcond.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /**
   * inserts step of success scenario of use case
   *
   * @param AStepStr1 step of success scenario
   * @param AUsecaseId id of use case
   * @return void
   */
  public static void insertSuccessScenarioT1(
  Statement AStatDB,
  business.CStepStrT1 AStepStrT1,
  long AUsecaseId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewSuccessScenarioT1Id(statDB);

        String step = AStepStrT1.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT1.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT1.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO strT1UcSuccessScenario " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AUsecaseId).toString() + ", " +
          new Integer(AStepStrT1.getPosition()).toString() +
          ", '" + step + "' " +
          ", '" + action + "'" +
          ", '" + extrans + "')";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.insertSuccessScenarioT1: " + sql);

        statDB.executeUpdate(sql);
        AStepStrT1.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  /**
   * inserts step of extension of success scenario of use case
   *
   * @param AStepStr1 step of extension of success scenario
   * @param AUsecaseId id of use case
   * @return void
   */
  public static void insertExtensionT1(
  Statement AStatDB,
  business.CStepStrT1 AStepStrT1,
  long AUsecaseId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewExtensionT1Id(statDB);

        String step = AStepStrT1.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT1.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT1.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO strT1UcExtension " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AUsecaseId).toString() + ", " +
          new Integer(AStepStrT1.getPosition()).toString() +
          ", '" + step + "' " +
          ", '" + action + "'" +
          ", '" + extrans + "')";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.insertExtensionT1: " + sql);

        statDB.executeUpdate(sql);
        AStepStrT1.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }


  /**
   * inserts step of variation of use case
   *
   * @param AStepStr1 step of variation
   * @param AUsecaseId id of use case
   * @return void
   */
  public static void insertSubvariationT1(
  Statement AStatDB,
  business.CStepStrT1 AStepStrT1,
  long AUsecaseId) throws SQLException {

    Statement statDB = AStatDB;
    try {
        long id = findNewSubvariationT1Id(statDB);

        String step = AStepStrT1.getStep();
        if (step == null) step = new String("");

        String action = AStepStrT1.getAction();
        if (action == null) action = new String("");

        String extrans = AStepStrT1.getPhrases();
        if (extrans == null) extrans = new String("");

        String sql =
          "INSERT INTO strT1UcVariation " +
          "VALUES (" +
          new Long(id).toString() + ", " +
          new Long(AUsecaseId).toString() + ", " +
          new Integer(AStepStrT1.getPosition()).toString() +
          ", '" + step + "' " +
          ", '" + action + "'" +
          ", '" + extrans + "')" ;
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.insertSubvariationT1: " + sql);

        statDB.executeUpdate(sql);
        AStepStrT1.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }
  }

  // ====================================================================
  // ======= update
  // ====================================================================

  /**
   * updates use case
   *
   * @param AUsecase use case
   * @return void
   */
   public static void updateUsecase(business.CUsecase AUsecase) {
    Connection conDB = CDatabase.getConnectionDb();
    try {
      if (conDB != null) {
        conDB.setAutoCommit(false);

        Statement statDB = conDB.createStatement();
        String sql = new String("UPDATE usecase " +
           "SET name='" + AUsecase.getName() + "' ," +
           "functRequirement='" + AUsecase.getFunctReq() + "' , " +
           "trigger='" + AUsecase.getTrigger() + "' " +
           "WHERE id=" + AUsecase.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.updateUsecase: " + sql);

         statDB.executeUpdate (sql);

         persistence.CActor.insertActorOfUsecase(statDB, AUsecase);
         persistence.CUsecase.updatePrecond(statDB, AUsecase);
         persistence.CUsecase.updateSuccessEndcond(statDB, AUsecase);
         persistence.CUsecase.updateFailedEndcond(statDB, AUsecase);
         persistence.CUsecase.updateSuccessScenarioT1(statDB, AUsecase);
         persistence.CUsecase.updateExtensionT1(statDB, AUsecase);
         persistence.CUsecase.updateSubvariationT1(statDB, AUsecase);

         conDB.commit();
         statDB.close();
         conDB.setAutoCommit(true);
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't update usecase \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

      try {
        conDB.rollback();
        conDB.setAutoCommit(true);
      } catch (SQLException ex2) {
        error = new String("error message: can't do rollback \n");
        error = contr.CError.createSQLErrorMessage(error, ex2);
        contr.CError.showErrorMessage(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    }
  }

  /**
   * updates preconditions of use case
   *
   * @param AUsecase use case
   * @return void
   */
  public static void updatePrecond(Statement AStatDB, business.CUsecase AUsecase)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM ucPrecondition " +
                     "WHERE usecaseId=" + AUsecase.getId()
                    );
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.updatePrecond: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AUsecase.getPrecond().size(); i++) {
          persistence.CUsecase.insertPrecond(statDB,
            (business.CCondition) AUsecase.getPrecond().elementAt(i), AUsecase.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates success endconditions of use case
   *
   * @param AUsecase use case
   * @return void
   */
  public static void updateSuccessEndcond(Statement AStatDB, business.CUsecase AUsecase)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM ucSuccessEndcondition " +
                     "WHERE usecaseId=" + AUsecase.getId()
                    );
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.updateSuccessEndcond: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AUsecase.getSuccessEndcond().size(); i++) {
          persistence.CUsecase.insertSuccessEndcond(statDB,
            (business.CCondition) AUsecase.getSuccessEndcond().elementAt(i),
            AUsecase.getId()
          );
        }

      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates failed endconditions of use case
   *
   * @param AUsecase use case
   * @return void
   */
  public static void updateFailedEndcond(Statement AStatDB, business.CUsecase AUsecase)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM ucFailedEndcondition " +
                     "WHERE usecaseId=" + AUsecase.getId()
                    );
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.updateFailedEndcond: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AUsecase.getFailedEndcond().size(); i++) {
          persistence.CUsecase.insertFailedEndcond(statDB,
            (business.CCondition) AUsecase.getFailedEndcond().elementAt(i),
            AUsecase.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates success scenario of use case
   *
   * @param AUsecase use case
   * @return void
   */
  public static void updateSuccessScenarioT1(Statement AStatDB, business.CUsecase AUsecase)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT1UcSuccessScenario " +
                     "WHERE usecaseId=" + AUsecase.getId()
                    );
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.updateSuccessScenarioT1: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0; i<AUsecase.getSuccessScenarioT1().size(); i++) {
          persistence.CUsecase.insertSuccessScenarioT1(statDB,
            (business.CStepStrT1) AUsecase.getSuccessScenarioT1().elementAt(i),
            AUsecase.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates extension of use case
   *
   * @param AUsecase use case
   * @return void
   */
  public static void updateExtensionT1(Statement AStatDB, business.CUsecase AUsecase)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT1UcExtension " +
                     "WHERE usecaseId=" + AUsecase.getId()
                    );
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.updateExtensionT1: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0;
             AUsecase.getExtensionT1() != null &&
             i<AUsecase.getExtensionT1().size();
             i++) {
          persistence.CUsecase.insertExtensionT1(statDB,
            (business.CStepStrT1) AUsecase.getExtensionT1().elementAt(i),
            AUsecase.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /**
   * updates variation of use case
   *
   * @param AUsecase use case
   * @return void
   */
  public static void updateSubvariationT1(Statement AStatDB, business.CUsecase AUsecase)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM strT1UcVariation " +
                     "WHERE usecaseId=" + AUsecase.getId()
                    );
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.updateSubvariationT1: " + sql);
        statDB.executeUpdate (sql);

        for (int i=0;
             AUsecase.getSubvariationT1() != null &&
             i<AUsecase.getSubvariationT1().size();
             i++) {
          persistence.CUsecase.insertSubvariationT1(statDB,
            (business.CStepStrT1) AUsecase.getSubvariationT1().elementAt(i),
            AUsecase.getId()
          );
        }
      } catch (SQLException ex) {
        throw ex;
      }
  }

  // ====================================================================
  // ======= delete
  // ====================================================================

  /**
   * deletes use case
   *
   * @param AUsecase use case
   * @return void
   */
  public static void deleteUsecase(business.CUsecase AUsecase) {

    Statement statDB = null;
    String sql = null;
    Connection conDB = CDatabase.getConnectionDb();
    if (conDB != null) {
      try {

      conDB.setAutoCommit(false);
      //persistence.CGroupVP.deleteAllGroupViewpointsOfUsecase(AUsecase);
      //persistence.CViewpointUc.deleteAllViewpointUcOfUsecase(AUsecase); //this includes scenarios vp
      //persistence.CScenario.deleteAllScenariosOfUsecase(AUsecase);
      //CDatabase.refresh();

      statDB = conDB.createStatement();
      //if (AUsecase.getActors() != null)
          persistence.CActor.deleteAllActorOfUsecase(AUsecase,statDB);

//        sql =
//          new String("DELETE FROM ucPrecondition " +
//                     "WHERE usecaseId=" + AUsecase.getId()
//                    );
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CUsecase.deleteUsecase: " + sql);
//        statDB.executeUpdate (sql);
//
//        sql =
//          new String("DELETE FROM ucSuccessEndcondition " +
//                     "WHERE usecaseId=" + AUsecase.getId()
//                    );
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CUsecase.deleteUsecase: " + sql);
//        statDB.executeUpdate (sql);
//
//        sql =
//          new String("DELETE FROM ucFailedEndcondition " +
//                     "WHERE usecaseId=" + AUsecase.getId()
//                    );
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CUsecase.deleteUsecase: " + sql);
//        statDB.executeUpdate (sql);
//
//        sql =
//          new String("DELETE FROM strT1UcSuccessScenario " +
//                     "WHERE usecaseId=" + AUsecase.getId()
//                    );
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CUsecase.deleteUsecase: " + sql);
//        statDB.executeUpdate (sql);
//
//        sql =
//          new String("DELETE FROM strT1UcExtension " +
//                     "WHERE usecaseId=" + AUsecase.getId()
//                    );
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CUsecase.deleteUsecase: " + sql);
//        statDB.executeUpdate (sql);
//
//        sql =
//          new String("DELETE FROM strT1UcVariation " +
//                     "WHERE usecaseId=" + AUsecase.getId()
//                    );
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CUsecase.deleteUsecase: " + sql);
//        statDB.executeUpdate (sql);

        sql =
          new String("DELETE FROM usecase " +
                     "WHERE id=" + AUsecase.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.deleteUsecase: " + sql);
        statDB.executeUpdate (sql);


        conDB.commit();
        conDB.setAutoCommit(true);
        statDB.close();


        AUsecase = null;
      } catch (SQLException ex) {
        String error = new String("error message: can't delete usecase \n");
        error = contr.CError.createSQLErrorMessage(error, ex);
        contr.CError.showNotDelete(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    } else {
      contr.CError.showNoConnectionToDatabase(business.Global.recocase);
    }
  }

  /**
   * deletes all use cases of project
   *
   * @param AProject project
   * @return void
   */
  public static void deleteAllUsecasesOfProject(business.CProject AProject) {

    Connection conDB = CDatabase.getConnectionDb();
    if (conDB != null) {
      Vector usecaseV = persistence.CUsecase.getAllUsecasesOfProject(AProject);
      if (usecaseV != null && usecaseV.size()>0) {
        for (int i=0; i<usecaseV.size(); i++)
          persistence.CUsecase.deleteUsecase((business.CUsecase) usecaseV.elementAt(i));
      }
    } else {
      contr.CError.showNoConnectionToDatabase(business.Global.recocase);
    }
  }

  // ====================================================================
  // ======= find
  // ====================================================================

  /**
   * finds out new use case id
   *
   * @return use case id
   */
   private static long findNewId() throws SQLException {

    long newId = -1;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM Usecase");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds out new id for precondition
   *
   * @return id for precondition
   */
  private static long findNewPrecondId(Statement AStatDB) throws SQLException {

    Statement statDB = AStatDB;
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM ucPrecondition");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds out new id for success endcondition
   *
   * @return id for success endcondition
   */
  private static long findNewSuccessEndcondId(Statement AStatDB)
  throws SQLException {

    Statement statDB = AStatDB;
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM ucSuccessEndcondition");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds out new id for failed endcondition
   *
   * @return id for failed endcondition
   */
  private static long findNewFailedEndcondId(Statement AStatDB)
  throws SQLException {

    Statement statDB = AStatDB;
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM ucFailedEndcondition");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of success scenario
   *
   * @return id for step of success scenario
   */
  private static long findNewSuccessScenarioT1Id(Statement AStatDB)
  throws SQLException {

    Statement statDB = AStatDB;
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT1UcSuccessScenario");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of extension
   *
   * @return id for step of extension
   */
  private static long findNewExtensionT1Id(Statement AStatDB)
  throws SQLException {

    Statement statDB = AStatDB;
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT1UcExtension");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**
   * finds new id for step of variation
   *
   * @return id for step of variation
   */
  private static long findNewSubvariationT1Id(Statement AStatDB)
  throws SQLException {

    Statement statDB = AStatDB;
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM strT1UcVariation");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }
}
