package persistence;

import java.sql.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class CSynonymTable{

  public CSynonymTable() {
  }


  public static business.CSynonymTable getSynonymTable() {
    return getSynonymTable( business.Global.usecase.getId() + "" );
  }

  public static business.CSynonymTable getSynonymTable(String projectId ) {
    business.CSynonymTable synonymTable = new    business.CSynonymTable();
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();


        String sql =
          new String(
          "SELECT phrase "+
          "FROM synonyms "+
          "WHERE projectId ="+ projectId +
          " ORDER BY phrase");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CSynonymTable: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          String phrase = resDB.getString("phrase");
          synonymTable.addPhrase( phrase);
        }


        sql =
          new String(
          "SELECT synonyms.phrase as phrase  , replacement.phrase as replacement "+
          "FROM synonyms INNER JOIN synonyms AS replacement ON synonyms.replacementId = replacement.phraseId "+
          "WHERE (((synonyms.projectId)= "+ projectId+" ) AND ((replacement.projectId)="+ projectId+"))" );

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CSynonymTable: " + sql);
        resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          String phrase = resDB.getString("phrase");
          String replacement = resDB.getString("replacement");
          synonymTable.addSynonym( phrase, replacement);
        }

//
//        String sql =
//          new String(
//          "SELECT phrase,replacementId "+
//          "FROM synonyms "+
//          "WHERE projectId ="+ projectId +
//          " ORDER BY phraseid ");
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CSynonymTable: " + sql);
//        ResultSet resDB = statDB.executeQuery(sql);
//
//        while (resDB.next()) {
//          String phrase = resDB.getString("phrase");
//          long id = resDB.getLong("replacementId");
//          int  replacementID = new Long(id).intValue();
//          //System.out.println("phrase: "+phrase+" replacementId: "+replacementID);
//          synonymTable.addSynonym( phrase, replacementID);
//
//        }
//









        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message:get synonymTable \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return synonymTable;
  }





  /**
   * Create Resolution
   */
  public static void createTable(business.CSynonymTable ASynonymTable,String ProjectId) {

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();
        String sql = "";

        for(int i = 0; i < ASynonymTable.getSize() ; i++){
              String id="";
              id = findNewId(statDB)+"";
              sql =
              "INSERT INTO synonyms " +
              // (id , projectId , phraseId , phrase , replacementid)
              "VALUES (" +
                  id + ", " +
                  ProjectId + "," +
                  i + ", " +
                  "'"+ASynonymTable.getPhrase(i)  +"', " +
                  "'"+ASynonymTable.getSynonymId(i)  +"')";

              if (business.Global.DEBUG)
                System.out.println("----> persistence.CSynonym: " + sql);
              statDB.executeUpdate(sql);

        }

        statDB.close();

      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message:can't create synonym table  \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }







 public static void deleteTable(String projectId){
    String sql;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();
            sql =
            new String("DELETE FROM synonyms " +
                       "WHERE projectId ="+ projectId );
            if (business.Global.DEBUG)
               System.out.println("----> persistence.CResolution: " + sql);
            statDB.executeUpdate (sql);

        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message:delete synonymTable  \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }



  /**
   *
   */

  public static void SaveCSynonymTable(business.CSynonymTable ACSynonymTable ,String projectId) {
    deleteTable(projectId);
    createTable(ACSynonymTable , projectId);
  }


/**
 *  find KEY id for the table
 */



  private static long findNewId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM synonyms");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }


}

