package persistence;

import java.sql.*;
import java.util.*;

/**
 *
 * Description: provides access to database for project datas
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CProject {

  private CProject() {}

  // ====================================================================
  // ======= get
  // ====================================================================

   /** returns vector of projects
    *  @return vector of projects
    */
   public static Vector getAllProject() {

    Vector allProjectV = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String("SELECT id, name, system, description FROM project ORDER BY name");
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CProject.getAllProject: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          long id = resDB.getLong("id");
          Vector actorV = persistence.CActor.getAllActorOfProject(id);

          business.CProject project =
            new business.CProject(
            id,
            resDB.getString("name"),
            resDB.getString("description"),
            actorV);
          project.setSystem(resDB.getString("system"));
          allProjectV.addElement(project);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read all projects \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return allProjectV;
  }

  /** returns vector of all viewpoints of a project
   *  @return vector of all viewpoints of a project
   */
  public static Vector getAllViewpointUCOfProject(business.CProject AProject) {

    Vector allViewpointV = new Vector();

    Vector allUsecaseV = persistence.CUsecase.getAllUsecasesOfProject(AProject);
    if (allUsecaseV != null) {
      for (int i=0; i<allUsecaseV.size(); i++) {

        business.CUsecase usecase = (business.CUsecase) allUsecaseV.elementAt(i);
        Vector allViewpointUcV = persistence.CViewpointUc.getAllViewpointUcOfUsecase(usecase);
        if (allViewpointUcV != null) {
          for (int j=0; j<allViewpointUcV.size(); j++) {
            allViewpointV.add((business.CViewpointUc) allViewpointUcV.elementAt(j));
          }
        }

//        Vector allScenarioV = persistence.CScenario.getAllScenariosOfUsecase(usecase);
//        if (allScenarioV != null) {
//          for (int j=0; j<allScenarioV.size(); j++) {
//            business.CScenario scenario = (business.CScenario) allScenarioV.elementAt(j);
//
//            Vector allViewpointScV = persistence.CViewpointSc.getAllViewpointScOfScenario(scenario);
//            for (int k=0; k<allViewpointScV.size(); k++) {
//               allViewpointV.add((business.CViewpointSc) allViewpointScV.elementAt(k));
//            }
//          }
//        }

      }
    }

    return allViewpointV;
  }

  // ====================================================================
  // ======= insert
  // ====================================================================

   /** inserts project into the database
    *  @param AProject project
    */
   public static boolean insertProject(business.CProject AProject) {

    boolean result = true;

    Connection conDB = CDatabase.getConnectionDb();
    try {
      if ( conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();
        long id = findNewId();

        String description = AProject.getDescription();
        if (description == null) description = new String("");

        String sql = "INSERT INTO project (id, name, system, description) VALUES (" +
                     new Long(id).toString() +
                      ", '" +  AProject.getName() + "'" +
                      ", '" +  AProject.getSystem() + "', '" +
	   	      description + "')";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CProject.insertProject: " + sql);
        statDB.executeUpdate(sql);
        AProject.setId(id);


        for (int i = 0; i < AProject.getActors().size(); i++) {
          long actorId = persistence.CActor.insertActor(statDB,
            (business.CActor) AProject.getActors().elementAt(i));
          if (actorId != -1)
            persistence.CActor.insertActorOfProject(statDB, actorId, AProject.getId());
        }

        //conDB.commit();
        statDB.close();
        //conDB.setAutoCommit(true);
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex){

      result = false;
      String error = new String("error message: can't insert project \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

      try {
        conDB.rollback();
        conDB.setAutoCommit(true);
      } catch (SQLException ex2) {
        error = new String("error message: can't do rollback \n");
        error = contr.CError.createSQLErrorMessage(error, ex2);
        contr.CError.showErrorMessage(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    }

    return result;
  }

  // ====================================================================
  // ======= update
  // ====================================================================

   /** updates data of project
    *  @param AProject project
    */
   public static void updateProject(business.CProject AProject) {
    Connection conDB = CDatabase.getConnectionDb();
    try {
      if (conDB != null) {

        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();

        // ====== update actors
        persistence.CActor.updateAllActorOfProject(statDB, AProject);

        // ====== update project data
        String sql = new String("UPDATE project " +
           "SET name='" + AProject.getName() + "'," +
           "system='" + AProject.getSystem() + "', " +
           "description='" + AProject.getDescription() + "' " +
           "WHERE id=" + AProject.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CProject.updateProject: " + sql);
         statDB.executeUpdate (sql);

        //conDB.commit();
        statDB.close();
        //conDB.setAutoCommit(true);
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't update project \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotSaved(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

      try {
        conDB.rollback();
        conDB.setAutoCommit(true);
      } catch (SQLException ex2) {
        error = new String("error message: can't do rollback \n");
        error = contr.CError.createSQLErrorMessage(error, ex2);
        contr.CError.showErrorMessage(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    }
  }

  // ====================================================================
  // ======= delete
  // ====================================================================

  /** deletes project
   *  @param AProject project
   */
  public static void deleteProject(business.CProject AProject) {

    Connection conDB = CDatabase.getConnectionDb();
    if (conDB != null) {
      try {
        Statement statDB = conDB.createStatement();

        //persistence.CUsecase.deleteAllUsecasesOfProject(AProject);
        //CDatabase.refresh();


        //if (AProject.getActors() != null)
          //persistence.CActor.deleteAllActorOfProject(statDB, AProject);

        String sql =
          new String("DELETE FROM project " +
                     "WHERE id=" + AProject.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CProject.deleteProject: " + sql);
        statDB.executeUpdate (sql);
        statDB.close();

        AProject = null;
      } catch (SQLException ex) {

        String error = new String("error message: can't delete project \n");
        error = contr.CError.createSQLErrorMessage(error, ex);
        contr.CError.showNotDelete(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    } else {
      contr.CError.showNoConnectionToDatabase(business.Global.recocase);
    }
  }

  // ====================================================================
  // ======= find
  // ====================================================================

   /** finds new id for project
    *  @return new if of project
    */
   private static long findNewId() throws SQLException {

    long newId = -1;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM Project");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }
}