
package persistence;

import java.sql.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author Oscar Aguilera
 * @version 1.0
 */



public class CGroupVP {

  public CGroupVP() {
  }


/**
 *  GET GROUPS VIEWPOINTS
 */


  public static Vector getGroupVPIDs(long aGroupId) {
    String Groupid = aGroupId +"";
    //System.out.println("GROUP ID=" + Groupid);
    //public static Vector getAllViewpointUcOfUsecase(business.CUsecase AUsecase) {

    Vector GroupsVP = new Vector();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
          "SELECT viewpointid "+
          "FROM groupMembers "+
          "WHERE groupMembers.groupid ="+Groupid);

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          Long id = new Long( resDB.getLong("viewpointid"));
          //System.out.println("ID:"+id);
          GroupsVP.addElement(id);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message:GROUPVP \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return GroupsVP;
  }


   /**
    *  GET GROUPS
    *
    *  groups contains (string)description
    *  Ids    contains (string)groupid
    */
   public static void getGroups(long usecaseid,Vector Groups,Vector Ids ) {

   if (Groups == null)Groups = new Vector();
   if (Ids == null)Ids = new Vector();

   Groups.clear();
   Ids.clear();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT groupid , description , info " +
            "FROM groupVP " +
            "WHERE usecaseid=" + usecaseid );

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);

        ResultSet resDB = statDB.executeQuery(sql);


        while (resDB.next()) {
//          System.out.println( "UC:"+
//            resDB.getLong("groupid") + "  DESC:" +
//            resDB.getString("description")+"  INFO:"+
//            resDB.getString("info") );

            Groups.addElement(resDB.getString("description")  );
            Ids.addElement(resDB.getLong("groupid")+"");
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: test 000 \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
//    return Groups; //and ids
  }




/**
 *  UPDATE GROUPS VIEWPOINTS
 */

  public static void updateGroupVP(long GroupId, Vector VPIds ) {
    String groupId = GroupId+"";
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();


        String sql =
        new String("DELETE FROM groupMembers " +
                   "WHERE groupid=" + groupId );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);
        statDB.executeUpdate (sql);
        conDB.commit();
        conDB.setAutoCommit(true);



        for(int i = 0; i<VPIds.size() ; i++){
          long id = findNewGroupMemId(statDB);
          sql =
            "INSERT INTO groupMembers " +
            "(id, groupid, viewpointid) " +
            "VALUES (" +
            new Long(id).toString() + ", " +
            new Long(groupId).toString() + ", "+
            (String) VPIds.elementAt(i) +")";
          if (business.Global.DEBUG)
             System.out.println("----> persistence.CGroupVP : " + sql);
          statDB.executeUpdate(sql);

        }

        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: update  \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }

/**
 *
 *  findNewGroupMemId(Statement statDB) throws SQLException {
 */

  private static long findNewGroupMemId(Statement statDB) throws SQLException {
//  private static long findNewId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM groupMembers");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }


/**
 *  UPDATE GROUPS
 */

  public static void  updateGroup(long aGroupId,String GroupName,String GroupInfo,String UsecaseId,boolean includeUC ) {
    String groupId = aGroupId +"";

    String UC = "NO";
    if(includeUC) UC = "YES";

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();

        String sql = new String(
           "UPDATE groupVP " +
           "SET "+
           "description = '"  + GroupName + "', " +
           "usecaseid = "     + UsecaseId + ", "  +
           "UC = "            + UC        + ", "  +
           "info = '" + GroupInfo + "' " +
           "WHERE groupid = " + groupId );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);
        statDB.executeUpdate (sql);
//        System.out.println("-------------");

        statDB.close();

      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: update Group  \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }


   /**
    *  GET GROUP info
    *
    */
   public static business.CGroupViewpoint getGroup(long groupId ) {
    business.CGroupViewpoint GVP = null;
    System.out.println("GID:"+groupId);
    String description = "";
    String info = "";
    boolean uc = true;

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
            "SELECT groupid , description , info , UC " +
            "FROM groupVP " +
            "WHERE groupid=" + groupId );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
          description = resDB.getString("description");
          long ucid = business.Global.usecase.getId();
          info = resDB.getString("info");
          uc = resDB.getBoolean("UC");
          GVP = new business.CGroupViewpoint(groupId,description,ucid,info,uc);
        }else{
          System.out.println("GID:NOT FOUND");
          return null;
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: get group \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return GVP;
  }

/**
 *  CREATE GROUP
 */

  public static String CreateGroupVP(String Name ,boolean includeUC) {
    String UC = "NO";
    if(includeUC) UC = "YES";

    String id="";
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();
        id = findNewGroupId(statDB)+"";
        String sql =
        "INSERT INTO groupVP " +
        "(groupid,description,usecaseid,info,UC) " +
        "VALUES (" +
            id + ", " +
            "'"+Name+"'" + ", "+
            business.Global.usecase.getId() + ", " +
            "'info'" + ", " +
            UC + " )";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);
        statDB.executeUpdate(sql);
        statDB.close();

      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: create group  \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
        return id;
  }


/**
 *  private static long findNewGroupId(Statement statDB) throws SQLException {
 */
    private static long findNewGroupId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(groupid) as MaxId FROM groupVP");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }



  /**
   * Delte Group
   */
  public static void deleteAllGroupViewpointsOfUsecase(business.CUsecase AUsecase) {
      Vector Groups = new Vector();
      Vector Ids = new Vector();

      persistence.CGroupVP.getGroups(AUsecase.getId(),Groups,Ids);
      for(int i = 0; i<Ids.size();i++){
        DeleteGroup((String) Ids.elementAt(i) );
      }

      persistence.CGroupVP.getGroups(AUsecase.getId(),Groups,Ids );
      for(int i = 0; i<Ids.size();i++){
        DeleteGroup((String) Ids.elementAt(i) );
      }
  }


  /**
   * Delte Group
   */
//  public static void deleteAllGroupViewpointsOfScenario(business.CScenario AScenario) {
//persistence.CResolution.DeleteAllResolutionofGroup(groupId);
//    try {
//      Connection conDB = CDatabase.getConnectionDb();
//      if ( conDB != null) {
//        conDB.setAutoCommit(true);
//        Statement statDB = conDB.createStatement();
//
//        Vector AllSc =   persistence.CViewpointSc.getAllViewpointScOfScenario(AScenario);
//        for(int i = 0; i < AllSc.size() ; i++){
//          String sql =
//          new String("DELETE FROM groupMembers " +
//                     "WHERE viewpointid=" + ((business.CViewpointSc) AllSc.elementAt(i)).getId() );
//          if (business.Global.DEBUG)
//            System.out.println("----> persistence.CGroupVP : " + sql);
//          statDB.executeUpdate (sql);
//        }
//        statDB.close();
//      } else {
//        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//      }
//    }
//    catch (SQLException ex) {
//      String error = new String("error message: update  \n");
//      error = contr.CError.createSQLErrorMessage(error, ex);
//      contr.CError.showNotRead(business.Global.recocase, error);
//      if (business.Global.DEBUG) System.out.println(error);
//    }
//  }

  /**
   * Delte Group
   */
  public static void DeleteGroup(long aGroupId) {
     DeleteGroup(aGroupId+"");
  }
  public static void DeleteGroup(String groupId) {
    CDatabase.refresh();
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        conDB.setAutoCommit(true);
        Statement statDB = conDB.createStatement();

        String sql =
        new String("DELETE FROM groupMembers " +
                   "WHERE groupid=" + groupId );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);
        statDB.executeUpdate (sql);

        sql =
        new String("DELETE FROM groupVP " +
                   "WHERE groupid=" + groupId );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);
        statDB.executeUpdate (sql);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: update  \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }

   /**
    *  GET GROUPS
    *
    * retuens true if the viewpoint belongs to a groupviewpoint
    *
    */
   public static boolean getGroupsOfVP(long Viewpointid,Vector Groups,Vector Usecases ) {

   boolean flag = false;

   if (Groups == null)Groups = new Vector();
   if (Usecases == null)Usecases = new Vector();

   Groups.clear();
   Usecases.clear();

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
          "SELECT groupVP.description, usecase.name "+
          "FROM groupMembers, groupVP, usecase "+
          "WHERE (((groupMembers.viewpointid)="+ Viewpointid +") AND "+
          "((groupMembers.groupid)=groupVP.groupid) AND "+
          "((groupVP.groupid)=groupMembers.groupid) AND "+
          "((groupVP.usecaseid)=usecase.id) AND "+
          "((usecase.id)=groupVP.usecaseid))");

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CGroupVP : " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          flag = true;
            Groups.addElement(resDB.getString("description"));
            Usecases.addElement(resDB.getString("name"));
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("finding groupvp for viewpoinit \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return flag;
  }

}

