package persistence;

import java.sql.*;
import java.util.*;

import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.*;
import javax.swing.text.*;
import javax.swing.*;
import java.util.Vector;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;


/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */


public class CDiagram {
  public CDiagram() {
  }


//  static public boolean save( business.fca.ContextTable table,diagram.DGraph graph){
//    return false;
//  }


  static public boolean save( business.fca.ContextTable table, diagram.DGraph graph){
    long diagramId = (long) -1 ;
    String name = "";
    if(graph.getId() != -1){
      deleteDiagram(graph.getId());
      name = graph.getName();
      diagramId = graph.getId();
    }else{
      name = JOptionPane.showInputDialog(null,"Name?");
      if(name != null && name.length() < 1)name = "no name";
      graph.setName(name);
    }
    business.fca.FCAObject FCAObj = null;
    if (name != null && name!= ""){
      try {
        Connection conDB = CDatabase.getConnectionDb();
        if ( conDB != null) {
          Statement statDB = conDB.createStatement();

          if( diagramId == (long)-1 )diagramId = findNewDiagramId(statDB);
          graph.setId(diagramId);
          String sql =
            " INSERT INTO diagram " +
            " VALUES("+diagramId+","+ business.Global.usecase.getId() +",'"+name+"')";
           if (business.Global.DEBUG)
              System.out.println("----> persistence.CDiagram.addDiagram1: " + sql);
          statDB.executeUpdate(sql);
          //obj
          Vector Objects = new Vector();
          for(int i=0;i<table.get_no_obj();i++){
            FCAObj = table.get_obj(i+1);
            Objects.addElement(FCAObj);
            sql=" INSERT INTO objects " +
                " VALUES("+findNewObjectId(statDB)+
                         ","+i+
                         ","+diagramId+
                         ",'"+FCAObj.getVPName()+
                         "','"+FCAObj.getAction()+
                         "','"+FCAObj.getOwner()+
                         "','"+FCAObj.getStep()+"')";
            if (business.Global.DEBUG)
              System.out.println("----> persistence.CDiagram.addDiagram2: " + sql);
            statDB.executeUpdate(sql);

          }
          for(int i=0;i<table.get_no_attr();i++){
            sql=" INSERT INTO attributes " +
                " VALUES("+findNewAttributeId(statDB)+
                         ","+diagramId+
                         ","+i+
                         ",'"+table.get_attr_name(i+1)+"')";
             if (business.Global.DEBUG)
              System.out.println("----> persistence.CDiagram.addDiagram3: " + sql);
            statDB.executeUpdate(sql);
          }

          for(int i=0;i<table.get_no_obj();i++){
            for(int y=0;y<table.get_no_attr();y++){
              if(table.get_box(i+1,y+1)){
                sql=" INSERT INTO crossTable " +
                    " VALUES("+findNewCrossTableId(statDB)+
                             ","+i+
                             ","+diagramId+
                             ","+y+")";
                if (business.Global.DEBUG)
                  System.out.println("----> persistence.CDiagram.addDiagram4: " + sql);
                statDB.executeUpdate(sql);
               }
            }
          }

          // nodes  (not hidden)
          Vector nodeIterator = graph.nodes;
          //while (nodeIterator.hasNext()){
          for(int i = 0; i < nodeIterator.size() ; i++){
            diagram.DNode node  = (diagram.DNode) nodeIterator.elementAt(i);
            String hidden = "NOT HIDDEN";
            if (node.isHidden()) hidden = "HIDDEN";
            String conector = "NOT CONECTOR";
            int Cson = 0;
            int Cparent = 0;
            if (node.isConector()){
               conector = "CONECTOR";
               Cson = node.getChild(0).getId();
               Cparent = node.getParent(0).getId();
            }

            long nodeId = findNewNodeId(statDB);
            sql=" INSERT INTO node " +
                " VALUES("+nodeId+
                         ","+node.getId()+
                         ","+diagramId+
                         ","+node.x+
                         ","+node.y+
                         ",'"+hidden+
                         "','"+conector+ "')";
            //  "','"+node.getResolutionFlag()+"')";
            if (business.Global.DEBUG)
              System.out.println("----> persistence.CDiagram.addDiagram5: " + sql);
            statDB.executeUpdate(sql);
          }//for


          for(int i=0;i<graph.edges.size();i++){
            diagram.Dedge edge = (diagram.Dedge) graph.edges.elementAt(i);
            if(edge.isVisible()){
              sql=" INSERT INTO edge " +
                  " VALUES("+findNewEdgeId(statDB)+
                           ","+diagramId+
                           ","+edge.getParent().getId()+
                           ","+edge.getChild().getId()+")";
               if (business.Global.DEBUG)
                System.out.println("----> persistence.CDiagram.addDiagram3: " + sql);
              statDB.executeUpdate(sql);
            }
          }

          statDB.close();
        } else {
          contr.CError.showNoConnectionToDatabase(business.Global.recocase);
        }
      }

      catch (SQLException ex) {
        String error = new String("error message: can't create diagram \n");
        error = contr.CError.createSQLErrorMessage(error, ex);
        contr.CError.showNotRead(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    }else{
      return false;
    }
    graph.needsSaving(false);
    return true;
  }




//  static public boolean getDiagrams(Vector names,Vector ids){
//    return false;
//  }

  static public boolean getDiagrams(Vector names,Vector ids){
    if( names == null)  names = new Vector();
    if( ids == null)  ids = new Vector();

    long id = (long)-1;
    String name = "";
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          "SELECT diagram.id , diagram.name "+
          "FROM diagram "+
          "WHERE (((diagram.[usecase id])="+business.Global.usecase.getId()+")) "+
          "ORDER BY diagram.id";
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
            id = resDB.getLong("id");
            name  = resDB.getString("name");
            //System.out.println(id+"  "+name);
            names.addElement( name );
            ids.addElement( new Long(id) );
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of CDiagram \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    if(names.size()>0){
      return true;
    }else{
      return false;
    }
  }


/**============================================================
 *
 *               G E T     D I A G R A M
 *              -------------------------
 *
 * ============================================================
 */

//  static public void getDiagram(Long ADiagramId, diagram.DDiagram parent){
//  }

  static public void getDiagram(Long ADiagramId, diagram.DDiagram parent){

    long id = ADiagramId.longValue();
    long anId = (long)-1;

    //String name = "";
    //graph.setName(name);

    ResultSet resDB = null;
    String sql = "";
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        //diagram
        diagram.DDiagram diagram;
        if(parent == null){
            diagram = new diagram.DDiagram();//true
        }else{
            diagram = parent;
        }
        business.fca.ContextTable contextTable  = getTable(ADiagramId);
        diagram.createFCA(contextTable);
        diagram.DGraph graph = diagram.getGraph();
        graph.setId(id);


        //remove conectors **********************************
        Vector nodes = graph.nodes;
        Vector toBeDestroyed = new Vector();
        for(int i = 0;i<nodes.size();i++){
          diagram.DNode node = ((diagram.DNode) nodes.elementAt(i));
          if (node.isConector())toBeDestroyed.add(node);
        }
        while(toBeDestroyed.size() > 0){
          diagram.DNode node = ((diagram.DNode) toBeDestroyed.elementAt(0));
          node.destroy();
          toBeDestroyed.remove(node);
        }

        Vector edges = graph.edges;
        //remove edges **********************************
        while(edges.size()>0){
          diagram.Dedge edge = (diagram.Dedge) edges.firstElement();
          edge.destroy();
        }




        //NORMAL NODES
        sql =
          "SELECT node.nodeId, node.Left, node.Top, node.hidden, node.conector "+
          "FROM node "+
          "WHERE (((node.diagramId)="+id+")) "+
          "ORDER BY node.nodeId ";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

            long nodeId = resDB.getLong("nodeId");
            long left = resDB.getLong("Left");
            long top = resDB.getLong("Top");
            String hidden  = resDB.getString("hidden");
            String conector  = resDB.getString("conector");
            int Id =  (new Long(nodeId)).intValue();

            Vector nodeIterator = graph.nodes;
            for(int i = 0; i<nodeIterator.size() ; i++){
              diagram.DNode node  = (diagram.DNode) nodeIterator.elementAt(i);
              if(node.getId()== Id){
                  node.tempId = nodeId;
                  node.moveTo((new Long(left)).intValue(),(new Long(top)).intValue());
                  //node.setResolutionFlag(flag);
                  if(hidden.equals("HIDDEN")){
                     node.isVisible(false);
                  }
              }
            }
        }
        resDB.close();



        //graph.connectNodes();

        //add CONECTOR NODES
        sql =
          "SELECT node.nodeId, node.Left, node.Top, node.hidden, node.conector "+
          "FROM node "+
          "WHERE (((node.conector)='CONECTOR') AND ((node.diagramId)="+id+")) "+
          "ORDER BY node.nodeId ";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram2: " + sql);
        resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
          long nodeId = resDB.getLong("nodeId");
          long left = resDB.getLong("Left");
          long top = resDB.getLong("Top");
          String hidden  = resDB.getString("hidden");
          String conector  = resDB.getString("conector");
          int Id =  (new Long(nodeId)).intValue();

          diagram.DNode newNode = diagram.getGraph().addNode();
          newNode.isConector(true);
          newNode.tempId = nodeId;
          newNode.moveTo((new Long(left)).intValue(),(new Long(top)).intValue());
        }
        resDB.close();


        //set edges

        sql =
          "SELECT edge.parent, edge.son "+
          "FROM edge "+
          "WHERE (((edge.diagramId)="+id+"))";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram3: " + sql);
        resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
            long fatherId= resDB.getLong("parent");
            long sonId= resDB.getLong("son");
            diagram.DNode son = null;
            diagram.DNode father = null;
            //System.out.println("--");
            for(int i = 0;i<graph.nodes.size();i++){
              diagram.DNode node = (diagram.DNode) graph.nodes.elementAt(i);
              if(node.tempId == fatherId) father = node;
              if(node.tempId == sonId) son = node;
              //System.out.print(","+node.tempId);
            }
            if(father!= null && son != null){
              new diagram.Dedge(father,son);
            }else{
              System.out.println("ERROR: father:"+fatherId+"   son: "+sonId);
            }
        }
        resDB.close();

        //fix up conectors
        for(int i = 0;i<nodes.size();i++){
          diagram.DNode node = (diagram.DNode) nodes.elementAt(i);
          if(node.isConector()){
            node.setLevel( ((diagram.DNode) node.getChild(0)).getLevel()+1 );
          }
        }


        diagram.fitInWindow();
        graph.needsSaving(false);

        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of CDiagram \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }


/**============================================================
 *
 * ============================================================
 */

//  public static void deleteDiagram(long AId) {
//  }

  public static void deleteDiagram(long AId) {
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql = "DELETE FROM diagram WHERE id=" + AId;
       if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.deleteDiagram: " + sql);
        statDB.executeUpdate(sql);
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't delete CDiagram \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }

/**============================================================
 *
 * ============================================================
 */
  private static long findNewDiagramId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM diagram");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /**============================================================
 *
 * ============================================================
 */
  private static long findNewObjectId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM objects");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }
/**============================================================
 *
 * ============================================================
 */

  private static long findNewAttributeId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM Attributes");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }
/**============================================================
 *
 * ============================================================
 */

  private static long findNewCrossTableId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM crossTable");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }




/**============================================================
 *
 * ============================================================
 */

  private static long findNewNodeId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM node");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

/**============================================================
 *
 * ============================================================
 */


  private static long findNewNodeObjId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM nodeObj");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }




/**============================================================
 *       TABLE
 * ============================================================
 */

  static public business.fca.ContextTable  getTable(Long ADiagramId){

    long id = ADiagramId.longValue();
    long anId = (long)-1;
    business.fca.ContextTable contextTable = null;
    String name = "";

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          "SELECT diagram.id , diagram.name "+
          "FROM diagram "+
          "WHERE (((diagram.[usecase id])="+business.Global.usecase.getId()+")) "+
          "ORDER BY diagram.id";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next() && name.equals("")) {
            anId = resDB.getLong("id");
            if(anId == id){
              name  = resDB.getString("name");
            }
            //System.out.println(id+" "+Pid+" "+name);
        }
        resDB.close();
        //user shoses a diagram


        long OBJcount = (long)-1;
        sql =
          "SELECT Count(*) AS [count] "+
          "FROM objects "+
          "WHERE (((objects.diagramId)="+id+")) ";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
            OBJcount = resDB.getLong("count");
            //System.out.println("obj"+OBJcount);
        }
        resDB.close();

        long ATTRcount = (long)-1;

        sql =
          "SELECT Count(*) AS [count] "+
          "FROM attributes "+
          "WHERE (((attributes.diagramId)="+id+")) ";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
            ATTRcount = resDB.getLong("count");
            //System.out.println("obj"+ATTRcount);
        }
        resDB.close();


        contextTable = new business.fca.ContextTable((new Long(OBJcount)).intValue(),(new Long(ATTRcount)).intValue());


        sql =
          "SELECT objects.objNumber, objects.viewpointName, objects.action, objects.owner, objects.step "+
          "FROM objects "+
          "WHERE (((objects.diagramId)="+id+")) "+
          "ORDER BY objects.objNumber ";
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        resDB = statDB.executeQuery(sql);
        //Vector objs = new Vector();
        while (resDB.next()) {
            long num = resDB.getLong("objNumber");
            String vp  = resDB.getString("viewpointName");
            String action  = resDB.getString("action");
            String owner  = resDB.getString("owner");
            String step  = resDB.getString("step");
            int objNum = (new Long(num)).intValue()+1;
             business.fca.FCAObject obj =  new  business.fca.FCAObject(action,owner,step,vp);
             obj.setId(objNum);
            contextTable.set_obj(objNum,obj ) ;
            //System.out.println(" "+objNum+" "+action);
        }
        resDB.close();


        sql =
          "SELECT attributes.attributeNumber, attributes.attribute "+
          "FROM attributes "+
          "WHERE (((attributes.diagramId)="+id+")) "+
          "ORDER BY attributes.attributeNumber";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        resDB = statDB.executeQuery(sql);
        //Vector objs = new Vector();
        while (resDB.next()) {
            long num = resDB.getLong("attributeNumber");
            String attribute  = resDB.getString("attribute");
            int attrNum = (new Long(num)).intValue()+1;
            contextTable.set_attr_name(attrNum,attribute);
            //System.out.println(" "+attribute);
        }
        resDB.close();


        sql =
          "SELECT crossTable.object, crossTable.attribute "+
          "FROM crossTable "+
          "WHERE (((crossTable.diagramId)="+id+"))";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        resDB = statDB.executeQuery(sql);
        //Vector objs = new Vector();
        while (resDB.next()) {
            long objNum = resDB.getLong("object");
            long attrNum = resDB.getLong("attribute");
            contextTable.set_box((new Long(objNum)).intValue()+1,(new Long(attrNum)).intValue()+1);
            //System.out.println(" "+objNum+" "+attrNum);
        }
        resDB.close();
        statDB.close(); //fix 03

    } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data of CDiagram \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    contextTable.setName(name);
    return contextTable ;
  }

/**============================================================
 *
 * ============================================================
 */

  public static void insertSentenceFlag(String sentence,String flag ) {
    //update existing or inserts a new entry
      Connection conDB = CDatabase.getConnectionDb();
      try {
        if ( conDB != null) {
          //conDB.setAutoCommit(false);
          Statement statDB = conDB.createStatement();
          long id = findNewStepId(statDB);
          String sql =
            "INSERT INTO resolved " +
            "VALUES ( " +
            id +", "+
            business.Global.usecase.getId()+", "+
            "'"+sentence+"' , "+
            "'"+flag+"' )";

          if (business.Global.DEBUG)
            System.out.println("----> persistence.CDiagram.insertSentence: " + sql);

          statDB.executeUpdate(sql);
        //  statDB.close();

	//conDB.commit();
        statDB.close();
	//conDB.setAutoCommit(true);

        } else {
          contr.CError.showNoConnectionToDatabase(business.Global.recocase);
        }
      }
      catch (SQLException ex){

        String error = new String("error message: can't INSERT data (sentence flag) \n");
        error = contr.CError.createSQLErrorMessage(error, ex);
        contr.CError.showNotRead(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }


  }
/**============================================================
 *
 * ============================================================
 */

      //
      //  public static String getSentencesFlag(String sentence ) {
      //    Vector sentences = new Vector();
      //    Vector flags = new Vector();
      //    getSentencesFlags(sentences, flags );
      //    return (String) flags.elementAt( sentences.indexOf(sentence));
      //  }

/**============================================================
 *
 * ============================================================
 */

  public static void getSentencesFlags(Vector sentences,Vector flags ) {
    sentences.clear();
    flags.clear();
    ResultSet resDB = null;
    String sql = "";

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        sql =
          "SELECT sentence, flag "+
          "FROM resolved "+
          "WHERE usecaseId="+business.Global.usecase.getId();

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CDiagram.getDiagram: " + sql);
        resDB = statDB.executeQuery(sql);
        while (resDB.next()) {
            //resDB.getLong("id");
            sentences.add( resDB.getString("sentence"));
            flags.add( resDB.getString("flag"));
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read data (sentence flag) \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }

/**============================================================
 *
 * ============================================================
 */


  public static void updateSentenceFlag(String sentence , String flag ) {
    Connection conDB = CDatabase.getConnectionDb();
    try {
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
           "UPDATE resolved " +
           "SET flag='" + flag + "' " +
           "WHERE sentence= '" + sentence + "' AND usecaseId =" + business.Global.usecase.getId() ;

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CUsecase.updateUsecase: " + sql);

         statDB.executeUpdate (sql);
         statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      String error = new String("error message: can't UPDATE data (sentence flag) \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }



/**============================================================
 *
 * ============================================================
 */


  private static long findNewStepId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM resolved");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

/**============================================================
 *
 * ============================================================
 */


  private static long findNewEdgeId(Statement statDB) throws SQLException {
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM edge");
        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }


}