package persistence;

import java.sql.*;

/**
 *
 * Description: maintains connection to database
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CDatabase {

  /** connection to database */
  private static Connection conDB = null;
  private static Statement statDB = null;


  private CDatabase() {}

  /**
   * creates connection to database if it not exist yet and
   * returns connection to database
   *
   * @return connection to database
   */
  public static Connection getConnectionDb() {
    if (conDB == null) openDatabase();
    return conDB;
  }

  public static void refresh() {

//    try {
//      conDB = getConnectionDb();
//      conDB.setAutoCommit(false);
//      conDB.commit();
//      conDB.setAutoCommit(true);
//
//    } catch (SQLException ex) {
//        String error = new String("error message: getStatementDb()  \n");
//        error = contr.CError.createSQLErrorMessage(error, ex);
//        contr.CError.showNotDelete(business.Global.recocase, error);
//        if (business.Global.DEBUG) System.out.println(error);
//    }
    //the above dosent work try sleeping
    //-------------------------------------
    if (business.Global.DEBUG)
      System.out.println("* DATABASE UPDATE *  sleep for:" + business.Global.sleepTime);

        try{
          java.lang.Thread.currentThread().sleep((long)business.Global.sleepTime);
        }catch (InterruptedException a){
        }
    //-------------------------------------
    //other option is to let the table cascade deleted records

  }



  /**
   * creates connection to database
   *
   * @return void
   */
  private static void openDatabase() {
    try {


      //System.out.println("DATABASE ...");

      //Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");

      //System.out.println("DATABASE ...");
      //String url="137.111.240.165:5000:c:\\kathrin\\masterThesis\\database\\recocase.mdb";
      //String url="jdbc:microsoft:sqlserver:\\137.111.240.165:5000:c:\\kathrin\\masterThesis\\database\\recocase.mdb";
      //String url="jdbc:microsoft:sqlserver:137.111.240.165:5000:c:\\kathrin\\masterThesis\\database\\recocase.mdb";
      //String url="jdbc:microsoft\\137.111.240.165:5000:c:\\kathrin\\masterThesis\\database\\recocase.mdb";

      // the following lines must be changed if database driver is changed -------

      String url = "";
      if(business.Global.systemUnix){
        Class.forName("acs.jdbc.Driver");
        url="jdbc:atinav:137.111.240.165:5000:c:\\projects\\recocase\\recocase.mdb";//anywhere
      }else{
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        url = "jdbc:odbc:recocase";//local
      }


      //original backup -------------
      //Class.forName("acs.jdbc.Driver");
      //String url="jdbc:atinav:137.111.240.165:5000:c:\\projects\\recocase\\recocase.mdb";
      //------------------

      String username="Admin";
      String password="";


      conDB = DriverManager.getConnection (url,username,password);
      //System.out.println("DATABASE ...");

      // ODBC-JDBC
      // Class.forName ("sun.jdbc.odbc.JdbcOdbcDriver");
      // conDB = DriverManager.getConnection ("jdbc:odbc:recocase","","");

    } catch(SQLException ex) {
      String error = new String("error message: can't open connection to database \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showErrorMessage(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);

    } catch(Exception ex) {
      String error = new String("error message: can't open connection to database \n");
      error = contr.CError.createErrorMessage(error, ex);
      contr.CError.showErrorMessage(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }

  /**
   * closes connection to database
   *
   * @return void
   */
  public static void closeDatabase() {
    try {
     conDB.close();
    } catch (SQLException ex) {
      String error = new String("error message: can't close database \n");
      error = contr.CError.createErrorMessage(error, ex);
      contr.CError.showErrorMessage(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }
}
