package persistence;

import java.sql.*;
import java.util.*;

import javax.swing.*;

/**
 *
 * Description: provides access to database for actor datas
 *
 * @author Kathrin Boettger modified by Oscar Aguilera
 *
 * if there are more than 1 users in the system there could be errors when inserting
 * actors to the data base due to a race condition with the unique id's
 *
 * @version 1.0
 */
public class CActor {

  private CActor() {}

  // ====================================================================
  // ======= get
  // ====================================================================
  /** returns vector of actors of a project
   *  @param AProjectId id of the project for which the actors have to be
   *  found
   *  @return vector of actors of a project
   */
  public static Vector getAllActorOfProject(long AProjectId) {

    Vector actorV = new Vector();
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql = new String(
          "SELECT actor.id, type, description " +
          "FROM actorOfProject, actor " +
          "WHERE actorOfProject.actorId=actor.id and " +
          "actorOfProject.projectId=" + new Long(AProjectId).toString());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getAllActorOfProject: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
         while (resDB.next()) {

           business.CActor actor =
           new business.CActor(
           resDB.getLong("id"),
           resDB.getString("type"),
           resDB.getString("description"));

          actorV.addElement(actor);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read all actor of project \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return actorV;
  }

  /** returns vector of actors of shared use case
   *  @param AUsecaseId id of shared use case for which actors have to be found
   *  @return vector of actors of shared use case
   */
  public static Vector getAllActorOfUsecase(long AUsecaseId) {

    Vector actorV = new Vector();
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          ("SELECT actor.id, type, description " +
           "FROM actorOfUsecase, actorOfProject, actor " +
           "WHERE actorOfUsecase.usecaseId = " + new Long(AUsecaseId).toString() +
           " and actorOfUsecase.actorOfProjectId = actorOfProject.id and " +
           "actorOfProject.actorId = actor.id ");

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getAllActorOfUsecase: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CActor actor =
          new business.CActor(
          resDB.getLong("id"),
          resDB.getString("type"),
          resDB.getString("description"));

          actorV.addElement(actor);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read all actors of use case \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return actorV;
  }

  /** returns vector of actors of use case viewpoint
   *  @param AViewpointUcId id of the use case viewpoint for which actors
   *  have to be found
   *  @return vector of actors of use case viewpoint
   */
  public static long getActorIdForUc( business.CActor actor ,business.CViewpointUc AViewpointUc){
    long Id = -1;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();

        String sql = (
          "SELECT actorOfUsecase.id "+
          "FROM (actor INNER JOIN actorOfProject ON actor.id = actorOfProject.actorId) INNER JOIN actorOfUsecase ON actorOfProject.id = actorOfUsecase.actorOfProjectId "+
          "WHERE (((actor.id)="+actor.getId()+") AND ((actorOfUsecase.usecaseId)="+AViewpointUc.getUsecase().getId()+"))");


        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getActorIdForUc: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
          Id = resDB.getLong("id");
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read all actors of use case viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return Id;
  }

  /** returns actor of use case viewpoint
   *  @param AActorOfVpUcId id of the relation between shared use case actor and
   *  use case viewpoint
   *  @return actor of use case viewpoint
   */
  public static business.CActor getActorOfVpUc(long AActorOfVpUcId) {

    business.CActor actor = null;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          ("SELECT actor.id, type, description " +
           "FROM actorOfUsecase, actorOfProject, actor " +
           "WHERE actorOfUsecase.id = " + new Long(AActorOfVpUcId).toString() +
           " and actorOfUsecase.actorOfProjectId=actorOfProject.id" +
           " and actorOfProject.actorId=actor.id");

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getActorOfVpUc: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {

          actor =
          new business.CActor(
          resDB.getLong("id"),
          resDB.getString("type"),
          resDB.getString("description"));

        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read actor of use case viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return actor;
  }

  /** returns id of the relation between actor and use case viewpoint
   *  @param AActor actor
   *  @param id of the use case viewpoint
   *  @return id of the relation between actor and use case viewpoint
   */
//  public static long getActorOfVpUcId (business.CActor AActor, long AViewpointUcId) {
//
//    long actorOfVpUcId = -1;
//    try {
//      Connection conDB = CDatabase.getConnectionDb();
//      if (conDB != null) {
//        Statement statDB = conDB.createStatement();
//        String sql =
//          ("SELECT actorVpUc.id " +
//           "FROM actorVpUc, actorOfUsecase, actorOfProject " +
//           "WHERE " +
//           " actorVpUc.viewpointUcId=" + AViewpointUcId +
//           " and actorOfUsecase.id=actorVpUc.actorUcId" +
//           " and actorOfUsecase.actorOfProjectId=actorOfProject.id" +
//           " and actorOfProject.actorId=" + AActor.getId());
//
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CActor.getActorOfVpUcId: " + sql);
//        ResultSet resDB = statDB.executeQuery(sql);
//        if (resDB.next()) {
//          actorOfVpUcId = resDB.getLong("id");
//        }
//        resDB.close();
//        statDB.close();
//      } else {
//        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//      }
//    }
//    catch (SQLException ex) {
//
//      String error = new String("error message: can't read if of actor of use case viewpoint \n");
//      error = contr.CError.createSQLErrorMessage(error, ex);
//      contr.CError.showNotRead(business.Global.recocase, error);
//      if (business.Global.DEBUG) System.out.println(error);
//    }
//
//    return actorOfVpUcId;
//  }

  /** returns all agents of shared scenario
   *  @param AScenarioId id of a shared scenario
   *  @return vector of agents of shared scenario
   */
//  public static Vector getAllAgentOfScenario(long AScenarioId) {
//
//    Vector agentV = new Vector();
//    try {
//      Connection conDB = CDatabase.getConnectionDb();
//      if (conDB != null) {
//        Statement statDB = conDB.createStatement();
//        String sql =
//          ("SELECT actor.id, type, description, name " +
//           "FROM agentOfScenario, actorOfUsecase, actorOfProject, actor " +
//           "WHERE " +
//           " scenarioId=" + new Long(AScenarioId).toString() +
//           " and actorOfUsecaseId=actorOfUsecase.id " +
//           " and actorOfProjectId=actorOfProject.id and " +
//           " actorId=actor.id ");
//
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CActor.getAllAgentOfScenario: " + sql);
//        ResultSet resDB = statDB.executeQuery(sql);
//        while (resDB.next()) {
//
//          business.CAgent agent =
//          new business.CAgent(
//            new business.CActor(
//            resDB.getLong("id"),
//            resDB.getString("type"),
//            resDB.getString("description")),
//            resDB.getString("name"));
//
//          agentV.addElement(agent);
//        }
//        resDB.close();
//        statDB.close();
//      } else {
//        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//      }
//    }
//    catch (SQLException ex) {
//
//      String error = new String("error message: can't read all agents of scenario \n");
//      error = contr.CError.createSQLErrorMessage(error, ex);
//      contr.CError.showNotRead(business.Global.recocase, error);
//      if (business.Global.DEBUG) System.out.println(error);
//    }
//    return agentV;
//  }

  /** returns all agents of shared scenario
   *  @param AScenarioId id of a scenario viewpoint
   *  @return vector of agents of scenario viewpoint
   */
  public static Vector getAllAgentOfViewpointScenario(long AViewpointScenarioId) {

    Vector agentV = new Vector();
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          ("SELECT actor.id, type, description, name " +
           "FROM agentVpSc, actorOfUsecase, actorOfProject, actor " +
           "WHERE " +
           " viewpointScId=" + new Long(AViewpointScenarioId).toString() +
           " and actorOfUcId=actorOfUsecase.id " +
           " and actorOfProjectId=actorOfProject.id and " +
           " actorId=actor.id ");

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getAllAgentOfViewpointScenario: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while (resDB.next()) {

          business.CAgent agent =
          new business.CAgent(
            new business.CActor(
            resDB.getLong("id"),
            resDB.getString("type"),
            resDB.getString("description")),
            resDB.getString("name"));

          agentV.addElement(agent);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read all agents of scenario viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return agentV;
  }

  /** returns agent of scenario viewpoint
   *  @param AActorOfVpScId id of the relation between shared use case actor and
   *  scenario viewpoint
   *  @return agent of scenario viewpoint
   */
  public static business.CAgent getAgentOfVpSc(long AAgentOfVpScId) {

    business.CAgent agent = null;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          ("SELECT actor.id, type, description, name " +
           "FROM agentVpSc, actorOfUsecase, actorOfProject, actor " +
           "WHERE " +
           " agentVpSc.id=" + new Long(AAgentOfVpScId).toString() +
           " and actorOfUcId=actorOfUsecase.id " +
           " and actorOfProjectId=actorOfProject.id and " +
           " actorId=actor.id ");

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getAgentOfVpSc: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {

          agent = new business.CAgent(
            new business.CActor(
            resDB.getLong("id"),
            resDB.getString("type"),
            resDB.getString("description")),
            resDB.getString("name"));
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read agent of scenario viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return agent;
  }

  /** returns id of the relation between shared use case actor and
   *  scenario viewpoint
   *  @param scenario viewpoint
   *  @param agent
   *  @return id of the relation between shared use case actor and
   *  scenario viewpoint
   */
  public static long getAgentIdOfVpSc(business.CViewpointSc AViewpointSc,
                                      business.CAgent AAgent) {

    long agentId = -1;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          ("SELECT agentVpSc.id " +
           "FROM agentVpSc, actorOfUsecase, actorOfProject " +
           "WHERE " +
           " agentVpSc.viewpointScId=" + AViewpointSc.getId() +
           " and name='" + AAgent.getName() +
           "' and actorOfUcId=actorOfUsecase.id " +
           " and actorOfProjectId=actorOfProject.id and " +
           " actorId=" + AAgent.getActor().getId());

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getAgentIdOfVpSc: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        if (resDB.next()) {
          agentId = resDB.getLong("id");
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read id of agent of scenario viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return agentId;
  }

  // ====================================================================
  // ======= insert
  // ====================================================================
  /** inserts actor into database
   *  @param AActor actor to be inserted
   */
  public static long insertActor(Statement AStatDB, business.CActor AActor)
  throws SQLException {

    Statement statDB = AStatDB;
    long id = -1;
    try {
        id = findNewActorId(statDB);

        String type = new String("");
        if (AActor.getType() != null) type = AActor.getType();

        String description = new String("");
        if (AActor.getDescription() != null) description = AActor.getDescription();

        String sql = "INSERT INTO actor (id, type, description) " +
                     "VALUES (" +
            	     new Long(id).toString() + ", '" +
                     type + "', '" +
                     description + "')";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.insertActor: " + sql);
        statDB.executeUpdate(sql);
        AActor.setId(id);
    }
    catch (SQLException ex){
      throw ex;
    }

    return id;
  }

  /** inserts the relation between an actor and a project
   *  @param AStatDB SQL-Statement
   *  @param AActorId id of an actor
   *  @param AProjectId id of a project
   *  @returns id of the relation between an actor and a project
   */
  public static long insertActorOfProject(Statement AStatDB, long AActorId, long AProjectId)
  throws SQLException {

    Statement statDB = AStatDB;
    long id = -1;
    try {
        id = findNewActorOfProjectId(statDB);
        String sql = "INSERT INTO actorOfProject (id, projectId, actorId) " +
                     "VALUES (" +
            	     new Long(id).toString() + ", " +
                     new Long(AProjectId).toString() + ", " +
                     new Long(AActorId).toString() + ")";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.insertActorOfProject: " + sql);
        statDB.executeUpdate(sql);
    }
    catch (SQLException ex){
      throw ex;
    }

    return id;
  }


  /** inserts actors of shared use case
   *  @param AUsecase shared use case
   */
  public static void insertActorOfUsecase(  Statement AStatDB, business.CUsecase AUsecase) throws SQLException {

    Statement statDB = AStatDB;
    if (AUsecase == null) return;
    if (AUsecase !=null && AUsecase.getActors() == null) return;

    long id = -1;
    try {
        Vector oldActorV = persistence.CActor.getAllActorOfUsecase(AUsecase.getId());

        if (oldActorV != null) {
          for (int i=0; i<oldActorV.size(); i++) {
            if (!AUsecase.containsActor(((business.CActor) oldActorV.elementAt(i)).getId())) { // delete

              String sql =
              new String("SELECT actorOfUsecase.id FROM actorOfUsecase, actorOfProject " +
                         "WHERE usecaseId=" + AUsecase.getId() + " and " +
                         "actorOfProjectId=actorOfProject.id and " +
                         "actorId=" + ((business.CActor) oldActorV.elementAt(i)).getId()
                        );

              if (business.Global.DEBUG)
                System.out.println("----> persistence.CActor.insertActorOfUsecase: " + sql);
              ResultSet resDB = statDB.executeQuery(sql);
              id = -1;
              if (resDB.next()) {
               id = resDB.getLong("id");
              }
              resDB.close();

              if (id != -1) {
                sql =
                  new String("DELETE FROM actorOfUsecase " +
                             "WHERE id=" + id
                             );
                if (business.Global.DEBUG)
                  System.out.println("----> persistence.CActor.insertActorOfUsecase: " + sql);
                statDB.executeUpdate (sql);
              }
            }
          }
        }

        for (int i=0; i<AUsecase.getActors().size(); i++) {
           boolean exist = false;
           if (oldActorV != null) {
             for (int j=0; exist == false && j<oldActorV.size(); j++) {
               if(((business.CActor) oldActorV.elementAt(j)).getId() ==
               ((business.CActor) AUsecase.getActors().elementAt(i)).getId())
                 exist = true;
             }
           }
           if (!exist) { // insert

             id = findNewActorOfUsecaseId(statDB);
             String sql =  new String("SELECT id FROM actorOfProject " +
                                      "WHERE projectId=" + AUsecase.getProject().getId() + " and " +
                                      "actorId=" + ((business.CActor) AUsecase.getActors().elementAt(i)).getId());

             if (business.Global.DEBUG)
               System.out.println("----> persistence.CActor.insertActorOfUsecase: " + sql);
             ResultSet resDB = statDB.executeQuery(sql);
             long actorOfProjectId = -1;
             if (resDB.next()) {
               actorOfProjectId = resDB.getLong("id");
             }
             resDB.close();

             sql = "INSERT INTO actorOfUsecase (id, usecaseId, actorOfProjectId) " +
                        "VALUES (" +
                        new Long(id).toString() + ", " +
                        new Long(AUsecase.getId()).toString() + ", " +
                        new Long(actorOfProjectId).toString() + ")";
             if (business.Global.DEBUG)
               System.out.println("----> persistence.CActor.insertActorOfUsecase: " + sql);
             statDB.executeUpdate(sql);
            }
         }
    } catch (SQLException ex){
      throw ex;
    }
  }


  /** inserts agents of shared scenario
   *  @param AScenario shared scenario
   */
//  public static void insertAgentOfScenario(
//  Statement AStatDB, business.CScenario AScenario)
//  throws SQLException {
//
//    if (AScenario == null) return;
//    if (AScenario != null && AScenario.getAgents() == null) return;
//
//    long id = -1;
//    try {
//     Connection conDB = CDatabase.getConnectionDb();
//     Statement statDB = AStatDB;
//      if (conDB != null) {
//
//        Vector oldAgentV = persistence.CActor.getAllAgentOfScenario(AScenario.getId());
//
//        if (oldAgentV != null) {
//          for (int i=0; i<oldAgentV.size(); i++) {
//            if (!AScenario.containsAgent(((business.CAgent) oldAgentV.elementAt(i)).getId())) { // delete
//
//              String sql =
//              new String("SELECT agentOfScenario.id FROM agentOfScenario, actorOfUsecase, actorOfProject " +
//                         "WHERE scenarioId=" + AScenario.getId() +
//                         " name='" + ((business.CAgent) oldAgentV.elementAt(i)).getName() + "'" +
//                         " and actorOfUsecaseId=actorOfUsecase.id" +
//                         " and actorOfProjectId=actorOfProject.id and " +
//                         "actorId=" + ((business.CAgent) oldAgentV.elementAt(i)).getActor().getId()
//                        );
//
//              if (business.Global.DEBUG)
//                System.out.println("----> persistence.CActor.insertAgentOfScenario: " + sql);
//              ResultSet resDB = statDB.executeQuery(sql);
//              id = -1;
//              if (resDB.next()) {
//               id = resDB.getLong("id");
//              }
//              resDB.close();
//
//              if (id != -1) {
//                statDB = conDB.createStatement();
//                sql =
//                  new String("DELETE FROM agentOfScenario " +
//                             "WHERE id=" + id
//                             );
//                if (business.Global.DEBUG)
//                  System.out.println("----> persistence.CActor.insertAgentOfScenario: " + sql);
//                statDB.executeUpdate (sql);
//              }
//            }
//          }
//        }
//
//        for (int i=0; i<AScenario.getAgents().size(); i++) {
//           boolean exist = false;
//           if (oldAgentV != null) {
//             for (int j=0; exist == false && j<oldAgentV.size(); j++) {
//               if(((business.CAgent) oldAgentV.elementAt(j)).getId() ==
//               ((business.CAgent) AScenario.getAgents().elementAt(i)).getId())
//                 exist = true;
//             }
//           }
//           if (!exist) { // insert
//
//             id = findNewAgentOfScenarioId(statDB);
//             String sql =  new String("SELECT actorOfUsecase.id FROM actorOfUsecase, actorOfProject " +
//                             "WHERE usecaseId=" + AScenario.getUsecase().getId() + " and " +
//                             "projectId=" + AScenario.getUsecase().getProject().getId() + " and " +
//                             "actorId=" + ((business.CAgent) AScenario.getAgents().elementAt(i)).getActor().getId());
//
//             if (business.Global.DEBUG)
//               System.out.println("----> persistence.CActor.insertAgentOfScenario: " + sql);
//             ResultSet resDB = statDB.executeQuery(sql);
//             long actorOfUsecaseId = -1;
//             if (resDB.next()) {
//               actorOfUsecaseId = resDB.getLong("id");
//             }
//             resDB.close();
//
//             sql = "INSERT INTO agentOfScenario (id, scenarioId, actorOfUsecaseId, name) " +
//                        "VALUES (" +
//                        new Long(id).toString() + ", " +
//                        new Long(AScenario.getId()).toString() + ", " +
//                        new Long(actorOfUsecaseId).toString() +
//                        ", '" + ((business.CAgent) AScenario.getAgents().elementAt(i)).getName() + "')";
//             if (business.Global.DEBUG)
//               System.out.println("----> persistence.CActor.insertAgentOfScenario: " + sql);
//             statDB.executeUpdate(sql);
//           }
//         }
//      } else {
//        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//      }
//    } catch (SQLException ex){
//      throw ex;
//    }
//  }

  /** inserts actors of use case viewpoint
   *  @param AViewpointUc use case viewpoint
   */
//  public static void insertActorOfViewpointUc( Statement AStatDB,business.CViewpointUc AViewpointUc)
//
//  throws SQLException {
//  //System.out.println("CALL ****************************** insertActorOfViewpointUc");
//    Statement statDB = AStatDB;
//
//    try {
//
//        //not the most eficient but the quickest
//        Vector Actors = AViewpointUc.getActors();
//        deleteAllActorOfViewpointUc(statDB, AViewpointUc);
//        AViewpointUc.setActors(Actors);
//        //
//
//        if(AViewpointUc.getActors() != null &&  AViewpointUc.getActors().size() > 0){
//        long id_actorVpUc = findNewActorVpUcId();               //k
//          for (int i=0; i<AViewpointUc.getActors().size(); i++) {
//             String sql =  new String(
//               "SELECT actorOfUsecase.id "+
//               "FROM actorOfProject, actorOfUsecase " +
//               "WHERE usecaseId=" + AViewpointUc.getUsecase().getId() + " "+
//               "and actorOfProjectId=actorOfProject.id and " +
//               "actorId=" + ((business.CActor) AViewpointUc.getActors().elementAt(i)).getId());
//                                                                           //actor of project id
//             if (business.Global.DEBUG)
//               System.out.println("----> persistence.CActor.insertActorOfViewpointUc: " + sql);
//
//             ResultSet resDB = statDB.executeQuery(sql);
//             long actorOfUsecaseId = -1;
//             if (resDB.next()) {
//               actorOfUsecaseId = resDB.getLong("id");
//             }
//             resDB.close();
//
//             sql = "INSERT INTO actorVpUc (id, viewpointUcId, actorUcId) " +
//                        "VALUES (" +
//                        new Long(id_actorVpUc).toString() + ", " +
//                        new Long(AViewpointUc.getId()).toString() + ", " +
//                        new Long(actorOfUsecaseId).toString() + ")";
//             if (business.Global.DEBUG)
//               System.out.println("----> persistence.CActor.insertActorOfViewpointUc: " + sql);
//
//             statDB.executeUpdate(sql);
//             id_actorVpUc++;
//
//
//          }//for
//        }//if actors
//
//    } catch (SQLException ex){
//      throw ex;
//    }
//  }


  // ====================================================================
  // ======= update
  // ====================================================================
  /** updates all actors of project
   *  @param project
   */
  public static void updateAllActorOfProject( Statement AStatDB,  business.CProject AProject)
  throws SQLException {

    Connection conDB = CDatabase.getConnectionDb();
    Statement statDB = AStatDB;

    try {
      if (conDB != null) {


    //find what actors must be deleted
    Vector oldActors = getAllActorOfProject(AProject.getId());
    Vector actorsInUse = actorsInUse(AProject);
    for(int x = 0; x < oldActors.size() ; x++){
      boolean inUse = false;
      for (int y = 0 ; y < actorsInUse.size(); y++){
        System.out.println(((business.CActor )oldActors.elementAt(x)).getId() +"=1="+ ((business.CActor )actorsInUse.elementAt(y)).getId());
        System.out.println(((business.CActor )oldActors.elementAt(x)).getType() +"=2="+ ((business.CActor )actorsInUse.elementAt(y)).getType());
        if(((business.CActor )oldActors.elementAt(x)).getId() == ((business.CActor )actorsInUse.elementAt(y)).getId())
        {
          inUse = true;
        }
      }
      if(!inUse){
        String sql = new String("DELETE FROM actorOfProject " +
               "WHERE actorId=" + ((business.CActor )oldActors.elementAt(x)).getId()+
               " AND projectId = "+ AProject.getId() );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.updateAllActorOfProject(delete OLD): " + sql);
          statDB.executeUpdate (sql);
      }
    }
    //insert new Actors

    Vector newActors = AProject.getActors();

    for (int x = 0; x < newActors.size(); x++) {
      boolean inDB = false;
      for (int y = 0 ; y < actorsInUse.size(); y++){
        if(((business.CActor )newActors.elementAt(x)).getId() == ((business.CActor )actorsInUse.elementAt(y)).getId())
        {
          inDB = true;
        }
      }
      if(!inDB){
        business.CActor actor= (business.CActor) newActors.elementAt(x);
        insertActorOfProject( AStatDB,  actor.getId(), AProject.getId());
      }
    }








//
//          business.CActor actor= (business.CActor) AProject.getActors().elementAt(i);
//          if (actor.getId() != -1) {
//            // update actor which already exists in db
//            String sql = new String("UPDATE actor " +
//               "SET type='" + actor.getType() + "'," +
//               "description='" + actor.getDescription() + "' " +
//               "WHERE id=" + actor.getId());
//            if (business.Global.DEBUG)
//              System.out.println("----> persistence.CActor.updateAllActorOfProject: " + sql);
//            statDB.executeUpdate (sql);
//
//          } else if (actor.getId() == -1) {
//            // insert 'new' actor of project
//            long actorId = persistence.CActor.insertActor(statDB, actor);
//            persistence.CActor.insertActorOfProject(statDB, actorId, AProject.getId());
//          }
//        }

//        // delete 'old' actors of project from db
//        for (int i = 0; i < allOldActor.size(); i++) {
//          // ... check if no relation to this actor
//          // ... if not then
//          boolean found = false;
//          for (int j = 0; found == false && j < AProject.getActors().size(); j++) {
//            if (((business.CActor) allOldActor.elementAt(i)).getId() ==
//                ((business.CActor) AProject.getActors().elementAt(j)).getId())
//              found = true;
//          }
//          if (found == false) {
//            persistence.CActor.deleteActorOfProject(
//              statDB,
//              ((business.CActor) allOldActor.elementAt(i)).getId(),
//              AProject.getId());
//            persistence.CActor.deleteActor(
//              statDB,
//              (business.CActor) allOldActor.elementAt(i));
//          }
//        }

      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      throw ex;
    }
  }

  // ====================================================================
  // ======= delete
  // ====================================================================
  /** deletes actor from database
   *  @param AActor actor
   */
  public static long deleteActor(Statement AStatDB, business.CActor AActor)
  throws SQLException {

    Statement statDB = AStatDB;

      try {
         String sql = new String("DELETE FROM Actor WHERE id=" + AActor.getId());
         if (business.Global.DEBUG)
           System.out.println("----> persistence.CActor.deleteActor: " + sql);
         statDB.executeUpdate (sql);
      } catch (SQLException ex) {
        throw ex;
      }

    return AActor.getId();
  }

  /** deletes all actor of project
   *  @param AProject project
   */
  public static void deleteAllActorOfProject(Statement AStatDB, business.CProject AProject)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM actorOfProject " +
                     "WHERE projectId=" + AProject.getId()
                    );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.deleteAllActorOfProject: " + sql);
        statDB.executeUpdate (sql);

        for (int i = AProject.getActors().size()-1; i >= 0; i--) {
          deleteActor(statDB, (business.CActor) AProject.getActors().elementAt(i));
        }
        AProject.setActors(null);
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /** deletes actor of project
   *  @param AActorId id of actor
   *  @param AProjectId id of project
   */
  public static void deleteActorOfProject(
  Statement AStatDB, long AActorId, long AProjectId)
  throws SQLException {

    Statement statDB = AStatDB;

      try {
        String sql =
          new String("DELETE FROM actorOfProject " +
                     "WHERE projectId=" + AProjectId + " and " +
                     "actorId=" + AActorId
                     );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.deleteActorOfProject: " + sql);
        statDB.executeUpdate (sql);
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /** deletes all agents of scenario viewpoint
   *  @param AViewpointSc scenario viewpoint
   */
  public static void deleteAllAgentOfViewpointSc(
  Statement AStatDB,
  business.CViewpointSc AViewpointSc)
  throws SQLException {

    Statement statDB = AStatDB;
      try {
        String sql =
          new String("DELETE FROM agentVpSc " +
                     "WHERE viewpointScId=" + AViewpointSc.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.deleteAllAgentOfViewpointSc: " + sql);
        statDB.executeUpdate (sql);
        AViewpointSc.setAgents(null);
      } catch (SQLException ex) {
        throw ex;
      }
  }

  /** deletes all actors of use case viewpoint
   *  @param AViewpointUc use case viewpoint
   */
//  public static void deleteAllActorOfViewpointUc(
//  Statement AStatDB,
//  business.CViewpointUc AViewpointUc)
//  throws SQLException {
//
//    Statement statDB = AStatDB;
//      try {
//        String sql =
//          new String("DELETE FROM actorVpUc " +
//                     "WHERE viewpointUcId=" + AViewpointUc.getId());
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CActor.deleteAllActorOfViewpointUc: " + sql);
//        statDB.executeUpdate (sql);
//        AViewpointUc.setActors(null);
//      } catch (SQLException ex) {
//        throw ex;
//      }
//  }

  /** deletes all actors of use case
   *  @param AUsecase use case
   */
  public static void deleteAllActorOfUsecase(business.CUsecase AUsecase,  Statement statDB) {

      try {

        String sql =
          new String("DELETE FROM actorOfUsecase " +
                     "WHERE usecaseId=" + AUsecase.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.deleteAllActorOfUsecase: " + sql);
        statDB.executeUpdate (sql);

        AUsecase.setActors(null);

      } catch (SQLException ex) {
        String error = new String("error message: can't delete all actors of usecase \n");
        error = contr.CError.createSQLErrorMessage(error, ex);
        contr.CError.showNotDelete(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
  }

  /** deletes all agents of scenario
   *  @param AScenario scenario
   */
//  public static void deleteAllAgentOfScenario(business.CScenario AScenario,Statement statDB) {
//      try {
//        //--
//        String sql =
//          new String("DELETE FROM agentOfScenario " +
//                     "WHERE scenarioId=" + AScenario.getId());
//        if (business.Global.DEBUG)
//          System.out.println("----> persistence.CActor.deleteAllAgentOfScenario: " + sql);
//        statDB.executeUpdate (sql);
//
//        //--
//
//        AScenario.setAgents(null);
//      } catch (SQLException ex) {
//        String error = new String("error message: can't delete all agents of scenario \n");
//        error = contr.CError.createSQLErrorMessage(error, ex);
//        contr.CError.showNotDelete(business.Global.recocase, error);
//        if (business.Global.DEBUG) System.out.println(error);
//      }
//  }

  // ====================================================================
  // ======= find
  // ====================================================================
  /** finds new id for relation between actor and project
   *  @return new id for relation between actor and project
   */
  private static long findNewActorOfProjectId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM actorOfProject");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }


  /** finds new id for actor
   *  @return new id for actor
   */
  private static long findNewActorId(Statement statDB) throws SQLException {

    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM actor");


        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        if (business.Global.DEBUG)
            System.out.println("----> persistence.CActor.findNewActorId: " + newId);
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /** finds new id for relation between actor and shared use case
   *  @return new id for relation between actor and shared use case
   */
  private static long findNewActorOfUsecaseId(Statement AStatDB) throws SQLException {

    Statement statDB = AStatDB;
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM actorOfUsecase");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /** finds new id for relation between actor and use case viewpoint
   *  @return new id for relation between actor and use case viewpoint
   */
//  private static long findNewActorVpUcId() throws SQLException {
//
//    long newId = -1;
//    try {
//      Connection conDB = CDatabase.getConnectionDb();
//      if ( conDB != null) {
//        Statement statDB = conDB.createStatement();
//        ResultSet resDB =
//        statDB.executeQuery ("SELECT max(id) as MaxId FROM actorVpUc");
//
//        if (resDB.next()) {
//          newId  =  resDB.getLong("MaxId") + 1;
//        }
//        if (business.Global.DEBUG)
//            System.out.println("----> persistence.CActor.findNewActorVpUcId: " + newId);
//        resDB.close();
//        statDB.close();
//      } else {
//        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//      }
//    }
//    catch (SQLException ex) {
//      throw ex;
//    }
//    return (newId);
//  }

  /** finds new id for relation between agent and scenario
   *  @return new id for relation between actor and scenario
   */
  private static long findNewAgentOfScenarioId(Statement AStatDB) throws SQLException {

    Statement statDB = AStatDB;
    long newId = -1;
    try {
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM agentOfScenario");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }

  /** finds new id for relation between agent and scenario viewpoint
   *  @return new id for relation between actor and scenario viewpoint
   */
  private static long findNewAgentOfVpScId() throws SQLException {

    long newId = -1;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if ( conDB != null) {
        Statement statDB = conDB.createStatement();
        ResultSet resDB =
        statDB.executeQuery ("SELECT max(id) as MaxId FROM agentVpSc");

        if (resDB.next()) {
          newId  =  resDB.getLong("MaxId") + 1;
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {
      throw ex;
    }
    return (newId);
  }
































 /** inserts agents of scenario viewpoint
   *  @param AViewpointSc scenario viewpoint
   */
//  public static void insertAgentOfViewpointSc___OLD(
//  Statement AStatDB,
//  business.CViewpointSc AViewpointSc)
//  throws SQLException {
//
//    long id = -1;
//    try {
//     Statement statDB = AStatDB;
//     Connection conDB = CDatabase.getConnectionDb();
//      if (conDB != null) {
//
//        Vector oldAgentV = persistence.CActor.getAllAgentOfViewpointScenario(AViewpointSc.getId());
//
//        if (oldAgentV != null) {
//          for (int i=0; i<oldAgentV.size(); i++) {
//            if (!AViewpointSc.containsAgent(((business.CAgent) oldAgentV.elementAt(i)).getId())) { // delete
//
//              String sql =
//              new String("SELECT agentVpSc.id FROM agentVpSc, actorOfUsecase, actorOfProject " +
//                         "WHERE viewpointScId=" + AViewpointSc.getId() +
//                         " name='" + ((business.CAgent) oldAgentV.elementAt(i)).getName() + "'" +
//                         " and actorOfUsecaseId=actorOfUsecase.id" +
//                         " and actorOfProjectId=actorOfProject.id and " +
//                         "actorId=" + ((business.CAgent) oldAgentV.elementAt(i)).getActor().getId()
//                        );
//              if (business.Global.DEBUG)
//                System.out.println("----> persistence.CActor.insertAgentOfViewpointSc: " + sql);
//              ResultSet resDB = statDB.executeQuery(sql);
//              id = -1;
//              if (resDB.next()) {
//               id = resDB.getLong("id");
//              }
//              resDB.close();
//
//              if (id != -1) {
//                sql =
//                  new String("DELETE FROM agentVpSc " +
//                             "WHERE id=" + id
//                             );
//                if (business.Global.DEBUG)
//                  System.out.println("----> persistence.CActor.insertAgentOfViewpointSc: " + sql);
//                statDB.executeUpdate (sql);
//              }
//            }
//          }
//        }
//
//        for (int i=0; i<AViewpointSc.getAgents().size(); i++) {
//           boolean exist = false;
//           if (oldAgentV != null) {
//             for (int j=0; exist == false && j<oldAgentV.size(); j++) {
//               if(((business.CAgent) oldAgentV.elementAt(j)).getId() ==
//               ((business.CAgent) AViewpointSc.getAgents().elementAt(i)).getId())
//                 exist = true;
//             }
//           }
//           if (!exist) { // insert
//
//             id = findNewAgentOfVpScId();
//             String sql =  new String("SELECT actorOfUsecase.id FROM actorOfUsecase, actorOfProject " +
//                             "WHERE usecaseId=" + AViewpointSc.getScenario().getUsecase().getId() + " and " +
//                             "projectId=" + AViewpointSc.getScenario().getUsecase().getProject().getId() + " and " +
//                             "actorId=" + ((business.CAgent) AViewpointSc.getAgents().elementAt(i)).getActor().getId());
//             if (business.Global.DEBUG)
//               System.out.println("----> persistence.CActor.insertAgentOfViewpointSc: " + sql);
//             ResultSet resDB = statDB.executeQuery(sql);
//             long actorOfUsecaseId = -1;
//             if (resDB.next()) {
//               actorOfUsecaseId = resDB.getLong("id");
//             }
//             resDB.close();
//
//             sql = "INSERT INTO agentVpSc (id, viewpointScId, actorOfUcId, name) " +
//                        "VALUES (" +
//                        new Long(id).toString() + ", " +
//                        new Long(AViewpointSc.getId()).toString() + ", " +
//                        new Long(actorOfUsecaseId).toString() +
//                        ", '" + ((business.CAgent) AViewpointSc.getAgents().elementAt(i)).getName() + "')";
//             if (business.Global.DEBUG)
//               System.out.println("----> persistence.CActor.insertAgentOfViewpointSc: " + sql);
//             statDB.executeUpdate(sql);
//           }
//         }
//      } else {
//        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
//      }
//    } catch (SQLException ex){
//
//      throw ex;
//    }
//  }





  /** inserts agents of scenario viewpoint
   *  @param AViewpointSc scenario viewpoint
   */
  public static void insertAgentOfViewpointSc(  Statement AStatDB,  business.CViewpointSc AViewpointSc) throws SQLException {
    long id = -1;
    try {
     Statement statDB = AStatDB;
     Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null)
      {
          String sql =
          new String("DELETE FROM agentVpSc " +
                    "WHERE viewpointScId=" + AViewpointSc.getId());
          if (business.Global.DEBUG)
            System.out.println("----> persistence.CActor.insertAgentOfViewpointSc: " + sql);
          statDB.executeUpdate (sql);
        id = findNewAgentOfVpScId();
        for (int i=0; i<AViewpointSc.getAgents().size(); i++) {
          sql =  new String(
              "SELECT actorOfUsecase.id "+
              "FROM actorOfProject INNER JOIN actorOfUsecase ON actorOfProject.id = actorOfUsecase.actorOfProjectId "+
              "WHERE actorOfUsecase.usecaseId="+ AViewpointSc.getViewpointUc().getUsecase().getId() +
              " AND actorOfProject.projectId="+AViewpointSc.getViewpointUc().getUsecase().getProject().getId()+
              " AND actorOfProject.actorId=" + ((business.CAgent) AViewpointSc.getAgents().elementAt(i)).getActor().getId() );
          if (business.Global.DEBUG)
            System.out.println("----> persistence.CActor.insertAgentOfViewpointSc: " + sql);
          ResultSet resDB = statDB.executeQuery(sql);
          long actorOfUsecaseId = -1;
          if (resDB.next()) {
            actorOfUsecaseId = resDB.getLong("id");
          }
          resDB.close();
          sql = "INSERT INTO agentVpSc " +
                        "VALUES (" +
                        id + ", " +
                        actorOfUsecaseId + ", " +
                        AViewpointSc.getId()+ ", '" +
                        ((business.CAgent) AViewpointSc.getAgents().elementAt(i)).getName()
                        + "')";
          if (business.Global.DEBUG)
               System.out.println("----> persistence.CActor.insertAgentOfViewpointSc: " + sql);
          statDB.executeUpdate(sql);
          id++;
        }
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    } catch (SQLException ex){
      throw ex;
    }
  }




  public static Vector actorsInUse(business.CUsecase usecase)
  {
    Vector inUse = new Vector();
    Connection conDB = CDatabase.getConnectionDb();
    if (conDB != null) {
      try {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
"SELECT DISTINCT actor.id, actor.type, actor.description "+
"FROM strT2VpUcExtension, strT2VpUcSuccessScenario, strT2VpUcVariation, (actor INNER JOIN actorOfProject ON actor.id = actorOfProject.actorId) INNER JOIN actorOfUsecase ON actorOfProject.id = actorOfUsecase.actorOfProjectId "+
"WHERE (((actorOfUsecase.usecaseId)=" +usecase.getId() + ") AND ((actorOfUsecase.id)=[strT2VpUcVariation].[actorId] Or (actorOfUsecase.id)=[strT2VpUcSuccessScenario].[actorId] Or (actorOfUsecase.id)=[strT2VpUcExtension].[actorId])) ");


        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.actorInUse: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while(resDB.next()) {
            inUse.add(new business.CActor(
                    resDB.getLong("id"),
                    resDB.getString("type"),
                    resDB.getString("description")));

            //JOptionPane.showMessageDialog(null ," actor in use:"+resDB.getString("type"));
        }

        statDB.close();
        //return inUse;
      } catch (SQLException ex) {

        String error = new String("error message: persistence.CActor.actorInUse \n");
        error = contr.CError.createSQLErrorMessage(error, ex);
        contr.CError.showNotDelete(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    } else {
      contr.CError.showNoConnectionToDatabase(business.Global.recocase);
    }
    return inUse;

  }

  /**
   * actors in use by senarion
   * @param Aproject
   * @returns actors in use
   */

  public static Vector actorsInUse(business.CProject project ){
    Vector inUse = new Vector();
    Connection conDB = CDatabase.getConnectionDb();
    if (conDB != null) {
      try {
        Statement statDB = conDB.createStatement();
        String sql =
          new String(
              "SELECT DISTINCT actor.id, actor.type, actor.description "+
              "FROM (actor INNER JOIN actorOfProject ON actor.id = actorOfProject.actorId) INNER JOIN actorOfUsecase ON actorOfProject.id = actorOfUsecase.actorOfProjectId "+
              "WHERE (((actorOfProject.projectId)="+project.getId()+"))" );

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.actorInUse: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);
        while(resDB.next()) {
            inUse.add(new business.CActor(
                    resDB.getLong("id"),
                    resDB.getString("type"),
                    resDB.getString("description")));

            //JOptionPane.showMessageDialog(null ," actor in use:"+resDB.getString("type"));
        }

        statDB.close();
        //return inUse;
      } catch (SQLException ex) {

        String error = new String("error message: persistence.CActor.actorInUse \n");
        error = contr.CError.createSQLErrorMessage(error, ex);
        contr.CError.showNotDelete(business.Global.recocase, error);
        if (business.Global.DEBUG) System.out.println(error);
      }
    } else {
      contr.CError.showNoConnectionToDatabase(business.Global.recocase);
    }
    return inUse;
  }

  /**
   * actors
   * @retun all Actors
   */
  public static Vector getAllActors() {

    Vector actorV = new Vector();
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql = new String(
          "SELECT actor.id, type, description " +
          "FROM actor ORDER BY actor.type" );
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getAllActor: " + sql);

        ResultSet resDB = statDB.executeQuery(sql);
         while (resDB.next()) {

           business.CActor actor =
           new business.CActor(
           resDB.getLong("id"),
           resDB.getString("type"),
           resDB.getString("description"));

          actorV.addElement(actor);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read all actor of project \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return actorV;
  }

  /** inserts agents of scenario viewpoint
   *  @param an actor
   */

  public static long insertActor(business.CActor AActor)
  {
    long id = -1;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();

        id = findNewActorId(statDB);
        AActor.setId(id);
        String type = new String(" new ");
        if (AActor.getType() != null) type = AActor.getType();

        String description = new String("");
        if (AActor.getDescription() != null) description = AActor.getDescription();

        String sql = "INSERT INTO actor (id, type, description) " +
                     "VALUES (" +
            	     id + ", '" +
                     type + "', '" +
                     description + "')";

        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.insertActor: " + sql);
        statDB.executeUpdate(sql);
        AActor.setId(id);
      }
    }
    catch (SQLException ex){
      String error = new String("error message: can't insert actor 002  insertActor(business.CActor AActor) \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }

    return id;
  }





  public static boolean deleteActor(business.CActor AActor){
    boolean result = true;
    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql =
          ("SELECT actor.id, project.name "+
          "FROM project INNER JOIN (actor INNER JOIN actorOfProject ON actor.id = actorOfProject.actorId) ON project.id = actorOfProject.projectId "+
          "WHERE actor.id= "+ AActor.getId());
        if (business.Global.DEBUG)
          System.out.println("----> persistence.CActor.getActorOfVpUc: " + sql);
        ResultSet resDB = statDB.executeQuery(sql);

        if (resDB.next()) {
          result = false;
        }else{
          sql = new String("DELETE FROM Actor WHERE id=" + AActor.getId());
          if (business.Global.DEBUG)
            System.out.println("----> persistence.CActor.insertActor: " + sql);
            statDB.executeUpdate(sql);
        }
        resDB.close();
        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't read actor of use case viewpoint \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
    return result;
  }



  public static void updateActor(business.CActor actor){

    try {
      Connection conDB = CDatabase.getConnectionDb();
      if (conDB != null) {
        Statement statDB = conDB.createStatement();
        String sql = new String("UPDATE actor " +
               "SET type='" + actor.getType() + "'," +
               "description='" + actor.getDescription() + "' " +
               "WHERE id=" + actor.getId());

        if (business.Global.DEBUG)
            System.out.println("----> persistence.CActor.insertActor: " + sql);
        statDB.executeUpdate(sql);

        statDB.close();
      } else {
        contr.CError.showNoConnectionToDatabase(business.Global.recocase);
      }
    }
    catch (SQLException ex) {

      String error = new String("error message: can't update actor 002 \n");
      error = contr.CError.createSQLErrorMessage(error, ex);
      contr.CError.showNotRead(business.Global.recocase, error);
      if (business.Global.DEBUG) System.out.println(error);
    }
  }

}
