package language;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import se.sics.jasper.*;
import java.io.*;
import java.util.*;



/**
 * Title:        recocase
 *
 * Description: business.LInterface is the interface to LinkGrammar
 *
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class LInterface {
  public static boolean started = false;
  /**
   * = native method to initialize LinkGrammar
   */
  public static native void initLinkGrammar();

  /**
   * = native method to finish LinkGrammar
   */
  public static native void endLinkGrammar();

  /**
   * = native method providing the sentence structure (S, NP, VP, ...)
   * @param ASentence sentence
   */
  public static native String getSentenceStructure(String ASentence);

  /**
   * analyses sentence structure (S, NP, VP, ...)
   */
  public static String checkSentenceStructure(String ASentence) {
    if(!started){
      initLinkGrammar();
      started = true;
    }
    if(business.Global.DEBUG) System.out.println(" ----> language.test.checkSentenceStructure:");
    String sentenceStructure = language.LInterface.getSentenceStructure(ASentence);
    if(business.Global.DEBUG) System.out.println("   sentence structure: " + sentenceStructure);
    return sentenceStructure;
  }


}