package gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import se.sics.jasper.*;
import java.io.*;

/**
 *
 * Title:        recocase
 * Description:  This class is the main frame of the tool.
 *               an existing project.
 * Copyright:    Copyright (c) 2000
 * Company:      Macquire uni
 * @author       Kathrin Boettger and Oscar Aguilera
 * @version 1.0
 *
 */

public class RECOCASE extends JFrame implements WindowListener {


  /** temp object to create action listeners*/
  private Object tmpObj = null;
  /** controller for the main frame */
  private contr.CRecocase contrRecocase = null;

  /** parts of the lowest part of the main frame */

  private JPanel iconP = null;
  private JScrollPane scrollPane = null;

  private JButton projectB = null;
  private JButton useCaseB = null;
  private JButton groupB = null;
  private JButton viewpointB = null;
  private JButton diagramB = null;
  private JButton resolutionB = null;


  /** menubar */
  private gui.CMenuBar menuBar = null;

  /** gap between parts of lowest part of the main frame */
  private String gap = new String("  ");

  /** constructor */
  public RECOCASE() {
    super("RECOCASE");
    System.out.println( System.getProperties().elements().nextElement() );
    this.addWindowListener(this);

    business.Global.recocase = this;
    contrRecocase = new contr.CRecocase();

    // create menubar
    menuBar = new gui.CMenuBar();
    this.setJMenuBar(menuBar);
    menuBar.reload();

    JPanel bottomP = new JPanel();
    bottomP.setLayout(new BorderLayout());

    // create message area
    JTextArea messageTA = new JTextArea("log in !");
    business.Global.setMessageArea(messageTA);
    messageTA.setRows(5);
    JScrollPane messageTASP = new JScrollPane(messageTA);
    messageTASP.setVerticalScrollBarPolicy(
    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);


    bottomP.add(messageTASP, BorderLayout.CENTER);
    bottomP.add(createInfoP(), BorderLayout.SOUTH);
    this.getContentPane().add(bottomP, BorderLayout.SOUTH);


    //ImageIcon imageIcon =  new ImageIcon(business.Global.getImagePath() + "recocase.jpg");
    JButton recocaseB = new JButton(business.Global.imageIconRecocase);

    recocaseB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
          test();
          }
        });


    this.getContentPane().add(recocaseB, BorderLayout.CENTER);

    //this.getContentPane().add(iconP, BorderLayout.NORTH);

  }

  /** creates the lowest part of the main frame
   *  return lowest part of the main frame
   */
  private JPanel infoP;
  private JScrollPane createInfoP() {

    // icon panel
    iconP= new JPanel();
    //iconP.setMinimumSize(new Dimension(20,20));
    iconP.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 2));


    // part: project

    projectB = new JButton(business.Global.imageIconProject);
    projectB.setToolTipText("click to see project datas");
    projectB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        //System.out.println(e.getActionCommand()); useless code
        contrRecocase.showProject();
      }
    });
    projectB.setText("project");
    iconP.add(projectB);
    projectB.setEnabled(false);

    // part: shared use case
//    imageIcon = new ImageIcon(business.Global.getImagePath() + "suc.jpg");
    useCaseB = new JButton(business.Global.imageIconSUC);
    useCaseB.setToolTipText("click to see use case datas");
    useCaseB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        //System.out.println(e.getActionCommand()); useless code
          contrRecocase.showUseCase();
          }
        });
    useCaseB.setText("use case");
    useCaseB.setEnabled(false);

    scrollPane = new JScrollPane(iconP);
    scrollPane.setHorizontalScrollBarPolicy(  JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
    reload();
    return scrollPane;
  }

  /** reload main frame */
  public void reload() {
    menuBar.reload();
    iconP.removeAll();


    ImageIcon imageIcon; // = new ImageIcon(business.Global.getImagePath() + "uc.jpg");//default

    if (business.Global.ProjectIsOpen) {
      projectB.setEnabled(true);
      projectB.setText("Project: " + business.Global.project.getName() + gap);
      iconP.add(projectB);

      if(business.Global.user.isAnalyst()){
//        imageIcon = new ImageIcon(business.Global.getImagePath() + "s.jpg");

        JButton synonymTableB = new JButton(business.Global.imageIconSinonym);
        synonymTableB.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            business.Global.project.getSynonymTableFrame().show();
          }
        });
        synonymTableB.setText("Synonyms");
        iconP.add(synonymTableB);
      }
    } else {
      projectB.setEnabled(false);
      projectB.setText("Project");
      iconP.add(projectB);
    }




    if (business.Global.user != null && business.Global.user.isAnalyst()) {
      if (business.Global.UseCaseIsOpen) {
        useCaseB.setEnabled(true);
        useCaseB.setText("Shared UC:" + business.Global.usecase.getName() );
        iconP.add(useCaseB);
      } else {
        useCaseB.setEnabled(false);
        useCaseB.setText("Shared UC");
        iconP.add(useCaseB);
      }
    }




    if (business.Global.ViewpointIsOpen) {
      for(int i=0; i<business.Global.viewpointV.size(); i++) {
        business.CViewpoint viewpoint = (business.CViewpoint) business.Global.viewpointV.elementAt(i);
        String Type = "";
        if(viewpoint.getClass().isInstance(new business.CViewpointUc())) {
          imageIcon = business.Global.imageIconUC ;
          Type = "VP Uc:";
        }else{
          imageIcon = business.Global.imageIconSC;
          Type = "VP Sc:";
        }
        viewpointB = new JButton(imageIcon);
        viewpointB.setActionCommand(new Integer(i).toString());
        viewpointB.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            //System.out.println(e.getActionCommand()); useless code
            contrRecocase.showViewpoint(
              new Integer(e.getActionCommand()).intValue());
          }
        });
        viewpointB.setText(Type + viewpoint.getName() + " [" + viewpoint.getUser().getName() + "]");
        iconP.add(viewpointB);
      }
    }


//    imageIcon = new ImageIcon(business.Global.getImagePath() + "g.jpg");
    if(business.Global.groupViewpointFV.size()>0) {
      for(int i=0; i<business.Global.groupViewpointFV.size(); i++) {
          groupB = new JButton(business.Global.imageIconGVP);
          groupB.setActionCommand(new Integer(i).toString());
          groupB.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
               ((gui.CGroupViewpoint) business.Global.groupViewpointFV.elementAt(new Integer(e.getActionCommand()).intValue())).show();
            }
          });
          gui.CGroupViewpoint gvp = (gui.CGroupViewpoint) business.Global.groupViewpointFV.elementAt(i);
          groupB.setText("Group: " +gvp.getName());
          iconP.add(groupB);
      }
    }



//    imageIcon = new ImageIcon(business.Global.getImagePath() + "t.jpg");
    for(int i=0; i<business.Global.resolutionTableFV.size(); i++) {
      diagram.DResolutionTable resolutionT =  (diagram.DResolutionTable) business.Global.resolutionTableFV.elementAt(i);
      resolutionB = new JButton(business.Global.imageIconXT);
      this.tmpObj= (Object) resolutionT;
      resolutionB.addActionListener(new ActionListener() {
        diagram.DResolutionTable aResolutionT = (diagram.DResolutionTable) tmpObj;
        public void actionPerformed(ActionEvent e) {
          aResolutionT.show();
        }
      });
      String name = resolutionT.getName();
      resolutionB.setText(name);
      iconP.add(resolutionB);
    }


//    imageIcon = new ImageIcon(business.Global.getImagePath() + "di.jpg");
    for(int i=0; i<business.Global.diagramFV.size(); i++) {
      diagram.DDiagram diagram =  (diagram.DDiagram) business.Global.diagramFV.elementAt(i);
      diagramB = new JButton(business.Global.imageIconDiagram);
      this.tmpObj= (Object) diagram;
      diagramB.addActionListener(new ActionListener() {
        diagram.DDiagram adiagram = (diagram.DDiagram) tmpObj;
        public void actionPerformed(ActionEvent e) {
          adiagram.show();
        }
      });
      String name = "no name";
      if(diagram.getGraph()!= null){
        if(diagram.getGraph().getName() != null && diagram.getGraph().getName() != "" ){
          name = diagram.getGraph().getName();
        }
      }
      diagramB.setText(name);
      iconP.add(diagramB);
    }







//-----------------------
//repaint to show changes
//-----------------------
     menuBar.paintAll(menuBar.getGraphics());
     //iconP.paintAll(iconP.getGraphics());
     scrollPane.paintAll(scrollPane.getGraphics());


    //this.isEnabled(); //dosent work
    //menuBar.paintAll(menuBar.getGraphics()); //takes to long
    //this.setSize(this.getSize());//dosent work
    //this.setState(this.NORMAL); //nope
    //this.paint(this.getGraphics());//dosent work
    //this.repaint();//dosent work
    //this.update(this.getGraphics());//dosent work
    //this.show(); //sends to front
    //this.setVisible(true); //sends to front
    //this.pack(); //resizes everything
    //this.repaint((long) 1); //dosent work
    //this.toBack(); //sends it all the way back
  }

  /** main */
  public static void main(String[] args) {

   // create main frame
   business.Global.recocase = new gui.RECOCASE();
   business.Global.recocase.addWindowListener(new WindowAdapter() {
     public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
   });

   business.Global.recocase.setSize(
       Toolkit.getDefaultToolkit().getScreenSize().width,
       (Toolkit.getDefaultToolkit().getScreenSize().height/4)*3); //  Toolkit.getDefaultToolkit().getScreenSize().height);

   business.Global.recocase.setVisible(true);

   // login
   if (business.Global.contrRecocase.showLogin() == null) {
     business.Global.recocase.dispose();
     System.exit(0);
   } else {
     business.Global.recocase.reload();
   }
  }

  static {
    // ==== load libraries
    if (business.Global.systemUnix == true) {  // unix
      System.loadLibrary("linkgrLIB");     //link G.
      System.loadLibrary("linkGrammarLIB"); // link G.
      System.loadLibrary("MorphLIB"); // link G.
      //System.loadLibrary("RecocaseLogicLIB"); //extrans recocase logic
    } else { // windows
      //System.loadLibrary("projectVC"); //copy projectVC.dll to win directory
      System.loadLibrary("makedll"); //copy makedll.dll to win directory
      System.loadLibrary("morph2"); //copy morph2.dll to win directory
      //System.load("E:\\projects\\RECOCASE\\lib\\projectVC.dll"); //dosent work???
    }
  }



  public void windowActivated(WindowEvent e)
  {
//    System.out.println("1");
  }
  public void windowClosed(WindowEvent e){
//    System.out.println("2");
  }
  public void windowClosing(WindowEvent e){
//    System.out.println("3");
  }
  public void windowDeactivated(WindowEvent e){
//    System.out.println("4");
  }
  public void windowDeiconified(WindowEvent e) {
//    System.out.println("5");
  }
  public void windowIconified(WindowEvent e){
//    System.out.println("6");
  }
  public void windowOpened(WindowEvent e){
//    System.out.println("7");
  }












  //=======================================
  //           T E S T
  //=======================================

  public void test(){
    System.out.println("test");
    System.out.println("-----------------------------------");

    language.LSentence s;
//    s = new language.LSentence("the big ATM card of the system notifies the customer that the video is not held by the store");
//    s = new language.LSentence("the running ATM card of the system notifies the customer that the video is not held by the store");
//ERROR    language.LSentence s = new language.LSentence("the System displays \"the user is ok\" ");


    s = new language.LSentence("the big ATM card of the system notifies the customer that the video is not held by the store");
    s.analyse();
    System.out.println("-----------------------------------");
    s = new language.LSentence("The customer checks out the ATM or the customer inserts card");
    s.analyse();
    s = new language.LSentence("The customer checks out the ATM or inserts card");
    s.analyse();
    System.out.println("-----------------------------------");
    s = new language.LSentence("If the card is valid then the ATM gives the money to the customer");
    s.analyse();
    System.out.println("-----------------------------------");
    s = new language.LSentence("If the card is valid then the ATM gives the money to the customer");
    s.analyse();
    System.out.println("-----------------------------------");
    s = new language.LSentence("the cat is an animal that runs");
    s.analyse();
    System.out.println("-----------------------------------");


    System.out.println("END test");
  }





}

