package gui;

import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/**
 * Title:        recocase
 * Description:  gui for scenario steps of type business.CStepStrT1
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

  public class GStyle2P extends JPanel implements ActionListener, business.IListener {

  ImageIcon imageIcon = null;

  //used for copy paste
  private static String temp = null;

  /** action steps of type business.CStepStr1 */
  private Vector stepStrT1V = null;

  /** which scenario data have to be displayed
   *  (business.Global.kindDataSuccessSc for success scenario,
   *   business.Global.kindDataExtension for extensions,
   *   business.Global.kindDataVariation for variations)
   */
  private String kindOfData = null;

  /** action steps for main success scenario of use case and scenario */
  private Vector mainStepV = null;
  /** action steps for extension of use case */
  private Vector extensionStepV = null;
  /** action steps for variation of use case */
  private Vector variationStepV = null;
  /** all action steps for use case and scenario (sorted) */
  private Vector allStepV = null;

  /** observer to inform about update */
  private business.IObserver observer = null;

  /** Tablemodel */
  private CTableModel tableModel = null;
  /** Table */
  private JTable scenarioT = null;
  /** column names for table */
  private final String[] columnNames = {"step", "action / state"};

  /** part of parent */
  private Object parent = null;

  /** actions */
  private final String actionCopyStep = new String("CopyStep");

  private final String actionMoveStepUp = new String("MoveStepUp");
  private final String actionMoveStepDown = new String("MoveStepDown");

  private final String actionPasteStep = new String("PasteStep");
  private final String actionNewStep = new String("NewStep");
  private final String actionDeleteStep = new String("DeleteString");
  private final String actionPhrasesStep = new String("Phrases");

  /** constructor
   *  @param AParent parent window
   *  @param AMainStepV vector of steps success scenario of type business.CStepStrT2
   *  @param AKindOfData which scenario data have to be displayed
   *  (business.Global.kindDataSuccessSc for success scenario,
   *   business.Global.kindDataExtension for extensions,
   *   business.Global.kindDataVariation for variations)
   *  @param AExtensionStepV vector of extension steps of success scenario
   *  of type business.CStepStrT2
   *  @param AVariationStepV vector of variation steps of success scenario
   *  of type business.CStepStrT2
   *  @param AObserver observer
   */
  public GStyle2P(Object AParent,
                  Vector AMainStepV,
                  String AKindOfData, // MainScenario, Extension, Variation
                  Vector AExtensionStepV,
                  Vector AVariationStepV,
                  business.IObserver AObserver) {

    parent = AParent;
    kindOfData = AKindOfData;
    extensionStepV = AExtensionStepV;
    variationStepV = AVariationStepV;
    mainStepV = AMainStepV;
    observer = AObserver;

    // set data to be displayed
    if (AKindOfData.equals(business.Global.kindDataSuccessSc)) {
      stepStrT1V = AMainStepV;
    } else if (AKindOfData.equals(business.Global.kindDataExtension)) {
      stepStrT1V = AExtensionStepV;
    } else {
      stepStrT1V = AVariationStepV;
    }
    if (stepStrT1V == null) stepStrT1V = new Vector();
    init();
  }

  /** initialize gui */
  private void init() {

    this.setLayout(new BorderLayout(5, 5));

    // scenario panel
    JPanel scenarioP = new JPanel();
    scenarioP.setLayout(new BorderLayout(5, 5));

    tableModel = new gui.CTableModel(columnNames, 0);
//tableModel.setEditableCol(0,false);
    for (int i=0; i<stepStrT1V.size(); i++) {
      Vector newRow = new Vector();
      newRow.add(((business.CStepStrT1) stepStrT1V.elementAt(i)).getStep());
      newRow.add(((business.CStepStrT1) stepStrT1V.elementAt(i)).getAction());
      tableModel.addRow(newRow);
    }
    scenarioT = new JTable(tableModel);
    scenarioT.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    TableColumn column = scenarioT.getColumnModel().getColumn(0);
    column.setPreferredWidth(80);
    column = scenarioT.getColumnModel().getColumn(1);
    column.setPreferredWidth(420);

    scenarioT.setPreferredScrollableViewportSize(new Dimension(500, 70));
    JScrollPane scenarioTSP = new JScrollPane(scenarioT);

    // button-panel
    JPanel scenarioBP = new JPanel();
    scenarioBP.setLayout(
      new BoxLayout(scenarioBP, BoxLayout.Y_AXIS));


    imageIcon = new ImageIcon(business.Global.getImagePath() + "insert.gif");
    JButton scenarioNewB = new JButton ("New",imageIcon);
    scenarioNewB.setActionCommand(this.actionNewStep);
    scenarioNewB.addActionListener(this);

    JButton scenarioPhrasesB = new JButton ("Phrases");
    scenarioPhrasesB.setActionCommand(this.actionPhrasesStep);
    scenarioPhrasesB.addActionListener(this);

    imageIcon = new ImageIcon(business.Global.getImagePath() + "copy.gif");
    JButton scenarioCopyB = new JButton ("Copy",imageIcon);
    scenarioCopyB.setActionCommand(this.actionCopyStep);
    scenarioCopyB.addActionListener(this);

    imageIcon = new ImageIcon(business.Global.getImagePath() + "paste.gif");
    JButton scenarioPasteB = new JButton ("Paste",imageIcon);
    scenarioPasteB.setActionCommand(this.actionPasteStep);
    scenarioPasteB.addActionListener(this);

    imageIcon = new ImageIcon(business.Global.getImagePath() + "up.gif");
    JButton scenarioMoveUpB = new JButton ("Up",imageIcon);
    scenarioMoveUpB.setActionCommand(this.actionMoveStepUp);
    scenarioMoveUpB.addActionListener(this);

    imageIcon = new ImageIcon(business.Global.getImagePath() + "down.gif");
    JButton scenarioMoveDownB = new JButton ("Down",imageIcon);
    scenarioMoveDownB.setActionCommand(this.actionMoveStepDown);
    scenarioMoveDownB.addActionListener(this);

//    JPanel scenarioMoveP = new JPanel();
//    scenarioMoveP.add(scenarioMoveUpB);
//    scenarioMoveP.add(scenarioMoveDownB);

    imageIcon = new ImageIcon(business.Global.getImagePath() + "delete.gif");
    JButton scenarioDeleteB = new JButton ("Delete",imageIcon);
    scenarioDeleteB.setActionCommand(this.actionDeleteStep);
    scenarioDeleteB.addActionListener(this);

    scenarioBP.add(scenarioNewB);
    scenarioBP.add(scenarioCopyB);
    scenarioBP.add(scenarioPasteB);
    scenarioBP.add(scenarioDeleteB);
//    scenarioBP.add(scenarioMoveP);


    scenarioBP.add(scenarioMoveUpB);
    scenarioBP.add(scenarioMoveDownB);

    scenarioBP.add(scenarioPhrasesB);

    add(scenarioTSP, BorderLayout.CENTER);
    add(scenarioBP, BorderLayout.EAST);
  }

  /** is called if user wants to add, copy, move or delete scenario step */
  public void actionPerformed(ActionEvent e) {
    editingStopped();
    getStepStrT1();

//  tableModel
    if (scenarioT.isEditing()){
      JOptionPane.showMessageDialog(null,"Please finish editing row:"+
        (scenarioT.getEditingRow()+1) + " in table:" + kindOfData);
    }else{




      //copy
      //------------------------------------------------------------
      if (e.getActionCommand().equals(this.actionCopyStep)) {
        //this.getStepStrT1()
        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        if (minIndex > -1) {
          System.out.println("copy");
          temp = ((business.CStepStrT1)this.stepStrT1V.elementAt(minIndex)).getAction();
        }


      //paste
      //------------------------------------------------------------
      }else if (e.getActionCommand().equals(this.actionPasteStep)) {
        if (temp != null) {
          System.out.println("paste");
          ListSelectionModel rowSM = scenarioT.getSelectionModel();
          int minIndex = rowSM.getMinSelectionIndex();
          business.CStep s = new business.CStepStrT1(-1, minIndex, "", temp,"");
          if (minIndex > -1) {
            insertStep(s,minIndex+1);
          } else{
            insertStep(s,this.stepStrT1V.size());
          }

        }


      // move step
      //------------------------------------------------------------
      } else if (e.getActionCommand().equals(this.actionMoveStepUp)) {

        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        if (minIndex > -1) {
          System.out.println("UP");
          //up the list = down in number
          this.downStep(minIndex);
        }
      } else if (e.getActionCommand().equals(this.actionMoveStepDown)) {
        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        if (minIndex > -1) {
          System.out.println("Down");
          //down the list must increase number
          this.upStep(minIndex);
        }

      // new step
      //------------------------------------------------------------
      } else if(e.getActionCommand().equals(this.actionNewStep)) {
        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        business.CStep s = new business.CStepStrT1(-1, minIndex, "","","");
        if (minIndex > -1) {
          //business.CStep s = new business.CStepStrT1(-1,this.stepStrT1V.size(), "","","");
          insertStep(s,minIndex+1);
        } else{
          insertStep(s,this.stepStrT1V.size());
        }
      //delete
      //------------------------------------------------------------
      }else if (e.getActionCommand().equals(this.actionDeleteStep)) {
        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        if (minIndex > -1) {
          removeStep(minIndex);
        }
      //------------------------------------------------------------
      }else if(e.getActionCommand().equals(this.actionPhrasesStep)) {
        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        if (minIndex < 0) {
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }
        business.CStep step = (business.CStep) stepStrT1V.elementAt(minIndex);
        new gui.GSentence(null,step);
        this.reload();
      }
      //observer.sendMessage(business.CObserver.Reload_Screen);
    }//is not editing table
  }//action performed


  /**
   * reads scenario steps of type
   * <code> business.CStepStrT1 </code>
   * from table
   *
   * @return Vector of scenario steps
   */
  public Vector getStepStrT1() {
    editingStopped();
    if (scenarioT.isEditing()){
      JOptionPane.showMessageDialog(null,"Please finish editing row:"+ (scenarioT.getEditingRow()+1) + " in table:" + kindOfData);
        business.Global.error = true;
    }
    //  JOptionPane.showMessageDialog(null,"ERROR  FIX ME");
    //  business.Global.error = true;

//    stepStrT1V.clear();
//    for(int i = 0; i<this.scenarioT.getRowCount() ;i++){
//      business.CStep s = new business.CStepStrT1(-1, i, (String)tableModel.getValueAt(i, 0), (String)tableModel.getValueAt(i, 1),"");
//      stepStrT1V.add(s);
//    }

    for (int i = 0; i < stepStrT1V.size(); i++) {
      ((business.CStepStrT1) stepStrT1V.elementAt(i)).setPosition(i);
      ((business.CStepStrT1) stepStrT1V.elementAt(i)).setStep(
        ((String)tableModel.getValueAt(i, 0)));
      ((business.CStepStrT1) stepStrT1V.elementAt(i)).setAction(
        ((String)tableModel.getValueAt(i, 1)));
    }

    return stepStrT1V;
  }

  /**
   * update table of scenario steps
   *
   * @param AStepStrT1V Vector of scenario steps of type
   * <code> business.CStepStrT1 </code>
   * @return void
   */
  public void reload() {
    reload(this.stepStrT1V);
  }

  public void reload(Vector AStepStrT1V) {

    stepStrT1V = AStepStrT1V;
    // if (stepStrT1V == null) stepStrT1V = new Vector();

    // === delete all rows of table
    for (int i=tableModel.getRowCount()-1; i>=0; i--)
      tableModel.removeRow(i);

    // === create for each step new row
    for (int i=0; i<stepStrT1V.size(); i++) {

      Vector newRow = new Vector();
      newRow.add(((business.CStep) stepStrT1V.elementAt(i)).getStep());

      if (((business.CStep) stepStrT1V.elementAt(i)).getAction() != null) {
        newRow.add(((business.CStep) stepStrT1V.elementAt(i)).getAction());
      } else {
        newRow.add(new String(""));
      }

      tableModel.addRow(newRow);
    }
  }

  /**
   * receives messages for updating table of scenario steps
   *
   * @param AMessage type of message
   * @return void
   */
  public void receiveMessage(int AMessage) {
    // === update screen
    if (AMessage == business.CObserver.Reload_Screen)
      this.reload(this.stepStrT1V);
    // === read content of table
    else   this.getStepStrT1();
  }

  public void editingStopped(){
    DefaultCellEditor editor  =(DefaultCellEditor)scenarioT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();
  }


  public void moveItem(int item,int to){
    JOptionPane.showMessageDialog(null,"ERROR: no code  FIX ME");
  //  selectItem(i);
  //  this.actionPerformed( new ActionEvent(this,ActionEvent.ACTION_PERFORMED,this.actionMoveStep));

  }

  public void selectItem(int i){
    this.scenarioT.removeRowSelectionInterval(0,this.scenarioT.getRowCount()-1);
    this.scenarioT.changeSelection(i,0,true,false);
  }


  //inserts a new step and makes sure the position numbering is correct
  //and they are in the right order in the vector
  public void insertStep(business.CStep newStep,int pos){
    if(pos == -1)pos = this.stepStrT1V.size();
    Vector newSteps = new Vector();
    business.CStep step = null;
    business.CStep testStep = null;
    for(int i = 0;i<this.stepStrT1V.size();i++){
      boolean found = false;
      for(int x = 0; x<this.stepStrT1V.size();x++){
        testStep = ((business.CStep) stepStrT1V.elementAt(x));
        if(testStep.getPosition()==i){
          step  = testStep;
          found = true;
        }
      }
      if(found == true){
        if(i < pos){
          step.setPosition(i);
          newSteps.add(step);
        }else if(i > pos){
          step.setPosition(i+1);
          newSteps.add(step);
        }else if(i == pos){
          newStep.setPosition(pos);
          newSteps.add(newStep);
          step.setPosition(i+1);
          newSteps.add(step);
        }
      }//if found
      else{
        JOptionPane.showMessageDialog(null,"ERROR IN DATABASE fix me:VP new 0009 ");
      }
    }//for i
    if(pos>=this.stepStrT1V.size()){
      newStep.setPosition(this.stepStrT1V.size());
      newSteps.add(newStep);
    }
    this.stepStrT1V = newSteps;
    this.reload();
    selectItem(pos);

  }

  //removes a new step and makes sure the position numbering is correct
  //and they are in the right order in the vector
  public void removeStep(int pos){
    Vector newSteps = new Vector();
    business.CStep step = null;
    business.CStep testStep = null;
    for(int i = 0;i<this.stepStrT1V.size();i++){
      boolean found = false;
      for(int x = 0; x<this.stepStrT1V.size();x++){
        testStep = ((business.CStep) stepStrT1V.elementAt(x));
        if(testStep.getPosition()==i){
          step  = testStep;
          found = true;
        }
      }
      if(found == true){
        if(i < pos){
          step.setPosition(i);
          newSteps.add(step);
        }else if(i > pos){
          step.setPosition(i-1);
          newSteps.add(step);
        }else if(i == pos){
          //do nothing
        }
      }//if found
      else{
        JOptionPane.showMessageDialog(null,"ERROR IN DATABASE fix me:VP del 0003 ");
      }
    }//for i
    this.stepStrT1V = newSteps;
    this.reload();
  }


  public void downStep(int pos){
    if(pos>0&&pos < stepStrT1V.size()){
      business.CStep theStep =  (business.CStep) stepStrT1V.elementAt(pos);
      this.removeStep(pos);
      this.insertStep(theStep,pos-1 );
    }
  }

  public void upStep(int pos){
    if(pos >= 0&&pos < stepStrT1V.size()-1){
      business.CStep theStep = (business.CStep) stepStrT1V.elementAt(pos);
      this.removeStep(pos);
      this.insertStep(theStep,pos+1 );
    }

  }



}
