package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class GSentence extends JDialog {
  /** this dialog */
  private static gui.GSentence dialogD = null;
  /** current user */
  private static business.CUser user = null;
  // gui
  private JTextField sentenceTF = null;
  private JTextField phrasesTF = null;

  private boolean showAdvanced = true;

  //errors
  private int errors = 0;

  /** constructor
   *
   */
  private business.Sentence mySentence = null;
  private boolean actionOnly = false;

  public GSentence(JFrame AParent, business.Sentence ASentence,boolean CloseIfNoError,boolean AShowAdvanced) {
    super(AParent, "Sentence", true); // not true
    this.showAdvanced = AShowAdvanced;
    this.mySentence = ASentence;
    if (mySentence.getClass().isInstance(new business.CStepStrT2())){
      actionOnly = true;
    }

    dialogD = this;
    init();//finds errors
    //this.setSize(500, 300);
    if(this.getErrors()==0 && CloseIfNoError ){
      this.dispose();
    }else{
      this.pack();
      dialogD.setLocationRelativeTo(null);
      dialogD.setVisible(true);
    }



  }
  public GSentence(JFrame AParent, business.Sentence AmySentence) {
    super(AParent, "Sentence", true); // not true
    mySentence = AmySentence;
    if (mySentence.getClass().isInstance(new business.CStepStrT2())){
      actionOnly = true;
    }

    dialogD = this;
    init();//finds errors
    //this.setSize(500, 300);
    this.pack();
    dialogD.setLocationRelativeTo(null);
    dialogD.setVisible(true);
  }

  /** initialize gui */
  private void init() {
    mySentence.analyse();
    //=============
    //sentece panel
    //=============
    JPanel sentenceP = new JPanel();
    sentenceP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(""),
        BorderFactory.createEmptyBorder(1,1,1,1)
      )
    );


    GridBagLayout sentencePGBL = new GridBagLayout();
    GridBagConstraints sentencePGBC = new GridBagConstraints();
    sentenceP.setLayout(sentencePGBL);

    JLabel sentenceL ;
    if(actionOnly){
      sentenceL = new JLabel("Action:");
    }else{
      sentenceL = new JLabel("Sentence:");
    }
    sentencePGBC.gridx = 0;
    sentencePGBC.gridy = 0;
    sentencePGBC.anchor = GridBagConstraints.NORTHWEST;
    sentencePGBL.setConstraints(sentenceL, sentencePGBC);
    sentenceP.add(sentenceL);

    sentenceTF = new JTextField(30);
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 0;
    sentencePGBL.setConstraints(sentenceTF, sentencePGBC);
    sentenceP.add(sentenceTF);
    if(actionOnly){
      sentenceTF.setText( ((business.CStepStrT2) mySentence).getAction());
    }else{
      sentenceTF.setText( mySentence.getSentence());
    }

    JLabel structureL ;
    if(mySentence.checkStructure()){
      structureL = new JLabel("Structure: ok");
    }else{
      structureL = new JLabel("Structure:*Error: Check your sentence structure and spelling, maybe try to reword your sentence.");
      errors++;
    }
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 1;
    sentencePGBL.setConstraints(structureL, sentencePGBC);
    sentenceP.add(structureL);



    JLabel unknownWordsL = new JLabel("unknown words:"+mySentence.getUnknownWordsS());
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 2;
    sentencePGBL.setConstraints(unknownWordsL, sentencePGBC);
    if(mySentence.getUnknownWordsV().size()>0) { sentenceP.add(unknownWordsL); errors++;}

    JLabel keyWordsL = new JLabel("Key words:"+mySentence.getKeyWordsS());
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 3;
    sentencePGBL.setConstraints(keyWordsL, sentencePGBC);
    if(mySentence.getKeyWordsV().size()>0){sentenceP.add(keyWordsL);errors++;}

    JLabel modalVerbsL = new JLabel("Modal Verbs:"+mySentence.getModalVerbsS());
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 4;
    sentencePGBL.setConstraints(modalVerbsL, sentencePGBC);
    if(mySentence.getModalVerbsV().size()>0){sentenceP.add(modalVerbsL);errors++;}

    JLabel possessivePronounsL = new JLabel("Possessive Pronouns:"+mySentence.getPossessivePronounsS());
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 5;
    sentencePGBL.setConstraints(possessivePronounsL, sentencePGBC);
    if(mySentence.getPossessivePronounsV().size()>0){sentenceP.add(possessivePronounsL);errors++;}

    JLabel pronounsL = new JLabel("Pronouns:"+mySentence.getPronounsS());
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 6;
    sentencePGBL.setConstraints(pronounsL, sentencePGBC);
    if(mySentence.getPronounsV().size()>0){sentenceP.add(pronounsL);errors++;}

    JLabel simbolsL = new JLabel("Simbols:"+mySentence.getSimbolsS());
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 7;
    sentencePGBL.setConstraints(simbolsL, sentencePGBC);
    if(mySentence.getSimbolsV().size()>0){sentenceP.add(simbolsL);errors++;}

    JLabel ifThenL = new JLabel("Do not use if [state] then [action]");
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 8;
    sentencePGBL.setConstraints(ifThenL, sentencePGBC);
    if(mySentence.getIfThen()){sentenceP.add(ifThenL);errors++;}

    JLabel negationL = new JLabel(mySentence.getNegation());
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 9;
    sentencePGBL.setConstraints(negationL, sentencePGBC);
    if(mySentence.getNegation()!=null){sentenceP.add(negationL);errors++;}

    JLabel orAndL = new JLabel(mySentence.getOrAnd());
    sentencePGBC.gridx = 1;
    sentencePGBC.gridy = 10;
    sentencePGBL.setConstraints(orAndL, sentencePGBC);
    if(mySentence.getOrAnd()!=null){sentenceP.add(orAndL);errors++;}

    //=============
    //phrases panel
    //=============
    JPanel phrasesP = new JPanel();

    phrasesP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder("Advanced"),
        BorderFactory.createEmptyBorder(1,1,1,1)
      )
    );


    GridBagLayout phrasesPGBL = new GridBagLayout();
    GridBagConstraints phrasesPGBC = new GridBagConstraints();
    phrasesP.setLayout(phrasesPGBL);


    phrasesPGBC.anchor = GridBagConstraints.NORTHWEST;
//    JLabel sentenceL ;
//    if(actionOnly){
//      sentenceL = new JLabel("Action:");
//    }else{
//      sentenceL = new JLabel("Sentence:");
//    }
//    phrasesPGBC.gridx = 0;
//    phrasesPGBC.gridy = 0;
//    phrasesPGBC.anchor = GridBagConstraints.NORTHWEST;
//    phrasesPGBL.setConstraints(sentenceL, phrasesPGBC);
//    phrasesP.add(sentenceL);
//
//    sentenceTF = new JTextField(30);
//    phrasesPGBC.gridx = 1;
//    phrasesPGBC.gridy = 0;
//    phrasesPGBL.setConstraints(sentenceTF, phrasesPGBC);
//    phrasesP.add(sentenceTF);
//    if(actionOnly){
//      sentenceTF.setText( mySentence.getAction());
//    }else{
//      sentenceTF.setText( mySentence.getSentence());
//    }



    JLabel phrasesL = new JLabel("Phrases:");
    phrasesPGBC.gridx = 0;
    phrasesPGBC.gridy = 0;
    phrasesPGBL.setConstraints( phrasesL, phrasesPGBC);
    phrasesP.add(    phrasesL);

    phrasesTF = new JTextField(30);
    phrasesPGBC.gridx = 1;
    phrasesPGBC.gridy = 0;
    phrasesPGBL.setConstraints(phrasesTF, phrasesPGBC);
    phrasesP.add(phrasesTF);
    phrasesTF.setText( mySentence.getPhrases());


    JLabel noteL = new JLabel("Note: if you modify the sentence in the use case");
    phrasesPGBC.gridx = 1;
    phrasesPGBC.gridy = 1;
    phrasesPGBL.setConstraints( noteL, phrasesPGBC);
    phrasesP.add(noteL);

    JLabel noteL2 = new JLabel("the phrases will be recalculated");
    phrasesPGBC.gridx = 1;
    phrasesPGBC.gridy = 2;
    phrasesPGBL.setConstraints( noteL2, phrasesPGBC);
    phrasesP.add(noteL2);

    JLabel noteL3 = new JLabel("Use Example:, p1, p2,  ...  , px,");
    phrasesPGBC.gridx = 1;
    phrasesPGBC.gridy = 3;
    phrasesPGBL.setConstraints( noteL3, phrasesPGBC);
    phrasesP.add(noteL3);




    // button panel
    final JButton doneB = new JButton("Done");
    doneB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if(actionOnly){
         ((business.CStepStrT2) mySentence).setAction(sentenceTF.getText());
        }else{
          mySentence.setSentence(sentenceTF.getText());
        }
        if(showAdvanced){
           mySentence.setPhrases(phrasesTF.getText());
        }
        dialogD.dispose();
      }
    });

    JButton cancelB = new JButton("cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dialogD.dispose();
      }
    });


    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));
    buttonP.add(doneB);
    buttonP.add(cancelB);

    JPanel centerP = new JPanel();
    centerP.setLayout(new BorderLayout());

    centerP.add(sentenceP, BorderLayout.CENTER);

    if(this.showAdvanced) centerP.add(phrasesP, BorderLayout.SOUTH);
    getContentPane().add(centerP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);



    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
    });
  }

  /**
   *
   */
  public int getErrors(){
    return this.errors;
  }


}
