package gui;

import javax.swing.JFrame;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.*;
import javax.swing.text.*;
import javax.swing.JCheckBox.*;
import javax.swing.*;
import java.util.Vector;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;


/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */



public class GReport extends JDialog implements ActionListener {

  private JButton okB=null;
  private JButton cancelB=null;
  private JTextArea report = null;

  public GReport() {

    super(business.Global.recocase,"Report" ,true);

    JPanel mainP = new JPanel();
    mainP.setLayout(new BorderLayout());
    TitledBorder mT = BorderFactory.createTitledBorder("REPORT");
    mainP.setBorder(mT);
    this.setContentPane(mainP);



    // ===================================================================
    // ===== report
    // ===================================================================



        // create message area
//    JTextArea messageTA = new JTextArea("log in !");
//    messageTA.setRows(5);
//    JScrollPane messageTASP = new JScrollPane(messageTA);
//    messageTASP.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);


    //JPanel reportP = new JPanel();
    report = new JTextArea();
    report.setRows(30);
    report.setColumns(80);
    JScrollPane reportSP = new JScrollPane(report);
    reportSP.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
//    reportSP.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
    //reportP.add(reportSP);
    mainP.add(reportSP);

    // ===================================================================
    // ===== comands
    // ===================================================================


    //comands
    JPanel CommandP = new JPanel();
    CommandP.setLayout(new FlowLayout());

    okB = new JButton("Ok");
    okB.setActionCommand("ok");
    okB.addActionListener(this);
    CommandP.add(okB);

    cancelB = new JButton("Cancel");
    cancelB.setActionCommand("cancel");
    cancelB.addActionListener(this);
    CommandP.add(cancelB);
    mainP.add(CommandP,BorderLayout.SOUTH);
    this.pack();
  }

  public void showDialog(){
    show();
  }

 /**-----------------------------------------------------
  *  ACTION
  * -----------------------------------------------------
  */

  public void actionPerformed(ActionEvent event) {
    String command = event.getActionCommand();
    if (command.equals("cancel")){
      this.dispose();
    }else if (command.equals("ok")) {
      this.dispose();
    }
  }

  public void setText(String txt){
    this.report.setText(txt);
  }

  public void addText(String txt){
    this.report.setText(this.report.getText()+txt);
  }



  public void VPReport(business.CViewpointUc VP){
        //report.setText("HERE \n yes ");
        Vector V= null;


        this.addText("\n\n" );
        this.addText("NAME:"+  VP.getName()+"\n\n" );
        this.addText("AGENT:"+VP.getViewpointAgent().getName()+"\n");
        this.addText("SYSTEM:"+VP.getUsecase().getProject().getSystem()+"\n");


        V = VP.getActors() ;
        this.addText("\nACTORS:\n");
        for(int i =0; i < V.size() ;i++){
          this.addText(  V.elementAt(i)+"\n" );
        }


        this.addText("\n\nTRIGER:\n"+VP.getTrigger());

        V = VP.getPrecond() ;
        this.addText("\n\nPRE CONDITIONS:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText((i+1)+":\t"+  V.elementAt(i)+"\n" );
        }

        V = VP.getSuccessEndcond() ;
        this.addText("\n\nSUCCESS END CONDITIONS:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText((i+1)+":\t"+  V.elementAt(i)+"\n" );
        }

        V = VP.getFailedEndcond() ;
        this.addText("\n\nFAILED END CONDITIONS:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText((i+1)+":\t"+  V.elementAt(i)+"\n" );
        }


        if(VP.getStyle()==business.Global.STYLE_STRUCT_WITHOUT_ACTOR){
          V = VP.getSuccessScenarioT1() ;
        }else{
          V = VP.getSuccessScenarioT2() ;
        }
        this.addText("\n\nSUCCESS SCENARIO:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText(  V.elementAt(i)+"\n" );
        }

        if(VP.getStyle()==business.Global.STYLE_STRUCT_WITHOUT_ACTOR){
        V = VP.getExtensionT1() ;
        }else{
        V = VP.getExtensionT2() ;
        }
        this.addText("\n\nEXTENSION:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText(  V.elementAt(i)+"\n" );
        }

//        if(VP.getStyle()==business.Global.STYLE_STRUCT_WITHOUT_ACTOR){
//        V = VP.getSubvariationT1() ;
//        }else{
//        V = VP.getSubvariationT2() ;
//        }
//        this.addText("\n\nSUBVARIATION:\n");
//        for(int i = 0; i < V.size() ;i++){
//          this.addText(  V.elementAt(i)+"\n" );
//        }

  }


  public void UCReport(business.CUsecase UC){
        Vector V= null;


        this.addText("\n\n" );
        this.addText("NAME:"+  UC.getName()+"\n\n" );
        this.addText("SYSTEM:"+UC.getProject().getSystem()+"\n");


        V = UC.getActors() ;
        this.addText("\nACTORS:\n");
        for(int i =0; i < V.size() ;i++){
          this.addText(  V.elementAt(i)+"\n" );
        }


        this.addText("\n\nTRIGER:\n"+UC.getTrigger());

        V = UC.getPrecond() ;
        this.addText("\n\nPRE CONDITIONS:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText((i+1)+":\t"+  V.elementAt(i)+"\n" );
        }

        V = UC.getSuccessEndcond() ;
        this.addText("\n\nSUCCESS END CONDITIONS:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText((i+1)+":\t"+  V.elementAt(i)+"\n" );
        }

        V = UC.getFailedEndcond() ;
        this.addText("\n\nFAILED END CONDITIONS:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText((i+1)+":\t"+  V.elementAt(i)+"\n" );
        }


        V = UC.getSuccessScenarioT1() ;
        this.addText("\n\nSUCCESS SCENARIO:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText(  V.elementAt(i)+"\n" );
        }

        V = UC.getExtensionT1() ;
        this.addText("\n\nEXTENSION:\n");
        for(int i = 0; i < V.size() ;i++){
          this.addText(  V.elementAt(i)+"\n" );
        }

//        V = UC.getSubvariationT1() ;
//        this.addText("\n\nSUBVARIATION:\n");
//        for(int i = 0; i < V.size() ;i++){
//          this.addText(  V.elementAt(i)+"\n" );
//        }


  }
}