package gui;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;


/**
 * Description: creates a panel to show 'conditions' in a table
 * and to be able to edit them
 *
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Kathrin and Oscar Aguilera
 * @version 1.0
 */

public class GConditionP extends JPanel implements ActionListener {



    /** vector of 'conditions */
    private Vector condV = null;

    /** table model */
    private gui.CTableModel tableModelConditions = null;
    /** table */
    private JTable conditionsT = null;
    /** columns */
    private final String[] columnNamesConditions = {
      "#", "Condition",
    };
    /** default data */
    final Object[][] dataConditions = {};

    private String type = "";
  /** constructor
   *  @param condV vector of 'conditions' of type business.CCondition
   *
   */

  public GConditionP(Vector AcondV,String tableName_type) {
    condV = AcondV;
    type = tableName_type;
    if (condV == null) condV = new Vector();
    init();
  }

  /** initialize gui */
  private void init() {

    this.setLayout(new BorderLayout(5, 5));

    // table
    tableModelConditions =
    new gui.CTableModel(
      dataConditions, columnNamesConditions);
    tableModelConditions.setEditableCol(0,false);

    for (int i=0; i<condV.size(); i++) {
      Vector newRow = new Vector();
      newRow.add(String.valueOf(((business.CCondition) condV.elementAt(i)).getNumber()));
      newRow.add(((business.CCondition) condV.elementAt(i)).getText());
      tableModelConditions.addRow(newRow);
    }
    conditionsT = new JTable(tableModelConditions);

    TableColumn column = conditionsT.getColumnModel().getColumn(0);
    column.setMaxWidth(30);
    column.setMinWidth(30);
    column = conditionsT.getColumnModel().getColumn(1);
    column.setMinWidth(170);
    column.setMaxWidth(170);

    conditionsT.setPreferredScrollableViewportSize( new Dimension(200, 60));
    JScrollPane conditionsTSP = new JScrollPane(conditionsT);

    // buttons
    JPanel conditionsBP = new JPanel();
    conditionsBP.setLayout(    new BoxLayout(conditionsBP, BoxLayout.Y_AXIS));
    JButton conditionsNewB = new JButton ("New");
    conditionsNewB.setActionCommand("New");
    conditionsNewB.addActionListener(this);
    JButton conditionsDeleteB = new JButton ("Delete");
    conditionsDeleteB.setActionCommand( "Delete");
    conditionsDeleteB.addActionListener(this);
    conditionsBP.add(conditionsNewB);
    conditionsBP.add(conditionsDeleteB);

    this.add(conditionsTSP, BorderLayout.CENTER);
    this.add(conditionsBP, BorderLayout.EAST);
  }

  /** is called if the user wants to add or delete a condition */
  public void actionPerformed(ActionEvent e) {
    editingStopped();
    if (e.getActionCommand().equals("Delete")) {

      ListSelectionModel rowSM = conditionsT.getSelectionModel();
      int minIndex = rowSM.getMinSelectionIndex();
      int maxIndex = rowSM.getMaxSelectionIndex();

      for(int i=minIndex; i!=-1 && i<=maxIndex; i++) {
        tableModelConditions.removeRow(minIndex);
        condV.removeElementAt(minIndex);
           // !!!minIndex, because previous row is already deleted
      }
    } else if(e.getActionCommand().equals("New")) {
      int nrNewRow = tableModelConditions.getRowCount() + 1;
      Vector newRow = new Vector();
      newRow.add(String.valueOf(nrNewRow));
      newRow.add(new String(""));
      tableModelConditions.addRow(newRow);

      business.CCondition cond = new business.CCondition(-1, -1, "", "");
      condV.add(cond);
    }
  }

  /** reads data from gui and returns vector of 'conditions' of type
   *  business.CCondition
   *  @return vector of 'conditions' of type business.CCondition
   */
  public Vector getConditions() {
    editingStopped();
    if (conditionsT.isEditing()){
      JOptionPane.showMessageDialog(null,"Please finish editing row:"+
        (conditionsT.getEditingRow()+1) + " in table:"+type);
        business.Global.error = true;
    }

    for (int i = 0; i < condV.size() ; i++) {
      ((business.CCondition) condV.elementAt(i)).setNumber(
         Integer.valueOf((String)tableModelConditions.getValueAt(i, 0)).intValue());
      ((business.CCondition) condV.elementAt(i)).setText(
        new String((String) tableModelConditions.getValueAt(i, 1)));
    }
    return condV;
  }

  public void editingStopped(){
    //dosent work as expected
    //System.out.println("WARNING editingStopped()");
    //this.conditionsT.editingStopped(new ChangeEvent(this));

    DefaultCellEditor editor  =(DefaultCellEditor)conditionsT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();

  }


  public void reload(){
      reload(this.condV);
  }

  public void reload(Vector AconditionsV){

    this.condV = AconditionsV;
    // === delete all rows of table
    for (int i=this.tableModelConditions.getRowCount()-1; i>=0; i--)
      this.tableModelConditions.removeRow(i);

    // === create for each condition
    for (int i=0; i<this.condV.size(); i++) {
      Vector newRow = new Vector();
      newRow.addElement(((business.CCondition) this.condV.elementAt(i)).getNumber()+"");
      if (((business.CCondition) condV.elementAt(i)).getSentence() != null) {
        newRow.add(((business.CCondition) this.condV.elementAt(i)).getSentence());
      } else {
        newRow.add(new String(""));
      }
      this.tableModelConditions.addRow(newRow);
    }
  }

}
