package gui;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: An object of this class is part of a frame to capture
 * data of a use case viewpoint.
 *
 * @author Kathrin Boettger and Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpointUseCaseP extends JPanel {

    /** parent frame */
    private JFrame frameF = null;

    /** data of this use case viewpoint are displayed */
    private business.CViewpointUc viewpointUc = null;
    /** vector of shared use cases */
    private Vector usecaseV = null;
    /** to show all shared use cases */
    //private JComboBox useCaseCB = null;
    /** index of choosed shared use case before changed and if ok then index
     *  of current shared use case*/
    private int lastUsecaseIndex = 0;

    /** textfield for name */
    //private JTextField nameTF = null;
    /** textarea for trigger */
    private JTextArea triggerTA = null;

    /** preconditions */
    private gui.GConditionP preconditionsP = null;
    /** conditions valid after successful run */
    private gui.GConditionP successEndconditionsP = null;
    /** conditions valid after failed run */
    private gui.GConditionP failedEndconditionsP = null;

    /** JTabbedPane for different kinds of description of scenario */
    private JTabbedPane mainSuccessScenarioTP = null;
    private gui.CStyle3P style3PMain = null;
    private gui.GStyle2P style2PMain = null;
    private JTabbedPane extensionsTP = null;
    private gui.GStyle2P style2PExt = null;
    private gui.CStyle3P style3PExt = null;
//    private JTabbedPane subvariationsTP = null;
//    private gui.GStyle2P style2PSub = null;
//    private gui.CStyle3P style3PSub = null;



  public CViewpointUseCaseP(JFrame AFrameF, business.CViewpointUc AViewpointUc,
                            Vector AUsecaseV) {

    viewpointUc = AViewpointUc;
    if (viewpointUc == null) viewpointUc = new business.CViewpointUc();
    usecaseV = AUsecaseV;
    frameF = AFrameF;

    business.CObserver observerStrT1 = new business.CObserver();
    business.CObserver observerStrT2 = new business.CObserver();


    JPanel viewpointUseCaseP = new JPanel();
    viewpointUseCaseP.setLayout(new BoxLayout(viewpointUseCaseP, BoxLayout.Y_AXIS));



    // ========================================================
    // ======= label: use case
    // ========================================================

    JLabel useCaseL = new JLabel("Usecase:" + viewpointUc.getUsecase().getName());
    viewpointUseCaseP.add(useCaseL);


    // ========================================================
    // ======= label: Agent
    // ========================================================

    JLabel AgentL = new JLabel("Agent:"+viewpointUc.getViewpointAgent().getName());
    viewpointUseCaseP.add(AgentL);

    // ========================================================
    // ======= label: system
    // ========================================================

    JLabel systemL = new JLabel("System: "+viewpointUc.getUsecase().getProject().getSystem());
    viewpointUseCaseP.add(systemL);

    // ========================================================
    // ===== panel conditions
    // ========================================================
    JPanel conditionsP = new JPanel();
    GridBagLayout conditionsPGBL = new GridBagLayout();
    GridBagConstraints conditionsPGBC = new GridBagConstraints();
    conditionsPGBC.anchor = GridBagConstraints.NORTHWEST;
    conditionsPGBC.insets = new Insets(1, 1, 1, 1);
    conditionsP.setLayout(conditionsPGBL);

    // ========================================================
    // ===== label usecase , Agent , system
    // ========================================================

    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 0;
    conditionsPGBL.setConstraints(viewpointUseCaseP, conditionsPGBC);
    conditionsP.add(viewpointUseCaseP);


    // ========================================================
    // ===== label actors
    // ========================================================
    JLabel actorsL = new JLabel("actors:");
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 1;
    conditionsPGBL.setConstraints(actorsL, conditionsPGBC);
    conditionsP.add(actorsL);

    // ========================================================
    // ===== table actors
    // ========================================================

    JPanel actorsP = new JPanel();
    actorsP.setLayout(new BorderLayout(1, 1));

    Vector title =  new Vector();
    title.add("Actor");
    Vector actors = new Vector();

    for(int i = 0; i < viewpointUc.getActors().size() ; i++){
        Vector actor = new Vector();
        actor.add(((business.CActor) viewpointUc.getActors().elementAt(i)).getType());
        actors.add(actor);
    }

    gui.CTableModel tm = new gui.CTableModel(actors,title);
    tm.setEditable(false);
    JTable actorsT = new JTable(tm);

    JScrollPane actorsTSP = new JScrollPane(actorsT);
    TableColumn column = actorsT.getColumnModel().getColumn(0);
    column.setMaxWidth(200);
    column.setMinWidth(200);
    actorsT.setPreferredScrollableViewportSize(new Dimension(200, 50));
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 2;
    actorsP.add(actorsTSP,BorderLayout.CENTER);
    //actorsT.disable();
    conditionsPGBL.setConstraints(actorsP, conditionsPGBC);
    conditionsP.add(actorsP);


    // ========================================================
    // ===== label trigger
    // ========================================================

    JLabel triggerL = new JLabel("trigger:");
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 3;
    conditionsPGBL.setConstraints(triggerL, conditionsPGBC);
    conditionsP.add(triggerL);

    // ========================================================
    // ===== textarea trigger
    // ========================================================

    triggerTA = new JTextArea(4, 25);
    if (viewpointUc.getTrigger() != null)
      triggerTA.setText(viewpointUc.getTrigger());
    JScrollPane triggerTASP = new JScrollPane(triggerTA);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 4;
    conditionsPGBL.setConstraints(triggerTASP, conditionsPGBC);
    conditionsP.add(triggerTASP);

    // ========================================================
    // ===== label preconditions
    // ========================================================
    JLabel preconditionsL = new JLabel("Preconditions:");
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 5;
    conditionsPGBL.setConstraints(preconditionsL, conditionsPGBC);
    conditionsP.add(preconditionsL);

    // ========================================================
    // ===== table preconditions
    // ========================================================

    preconditionsP = new gui.GConditionP(viewpointUc.getPrecond(),business.Global.kindDataPreCond);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 6;
    conditionsPGBL.setConstraints(preconditionsP, conditionsPGBC);
    conditionsP.add(preconditionsP);

    // ========================================================
    // ===== label Success Endconditions
    // ========================================================
    JPanel successEndconditionsLP = new JPanel();
    successEndconditionsLP.setLayout(
      new BoxLayout(successEndconditionsLP, BoxLayout.Y_AXIS));
    successEndconditionsLP.add(new JLabel("Success End Conditions:"));
//    successEndconditionsLP.add(new JLabel("endconditions:"));
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 7;
    conditionsPGBL.setConstraints(successEndconditionsLP, conditionsPGBC);
    conditionsP.add(successEndconditionsLP);

    // ========================================================
    // ===== table Success Endcondtions
    // ========================================================

    successEndconditionsP = new gui.GConditionP(viewpointUc.getSuccessEndcond(),business.Global.kindDataSuccessEndCond);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 8;
    conditionsPGBL.setConstraints(successEndconditionsP, conditionsPGBC);
    conditionsP.add(successEndconditionsP);

    // ========================================================
    // ===== label failed endconditions
    // ========================================================
    JPanel failedEndconditionsLP = new JPanel();
    failedEndconditionsLP.setLayout(
      new BoxLayout(failedEndconditionsLP, BoxLayout.Y_AXIS));
    failedEndconditionsLP.add(new JLabel("Failed End Conditions:"));
//    failedEndconditionsLP.add(new JLabel("endconditions:"));
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 9;
    conditionsPGBL.setConstraints(failedEndconditionsLP, conditionsPGBC);
    conditionsP.add(failedEndconditionsLP);

    // ========================================================
    // ===== table failed endcondtions
    // ========================================================

    failedEndconditionsP = new gui.GConditionP(viewpointUc.getFailedEndcond(),business.Global.kindDataFailedEndCond);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 10;
    conditionsPGBL.setConstraints(failedEndconditionsP, conditionsPGBC);
    conditionsP.add(failedEndconditionsP);

    // ========================================================
    // ===== panel actions
    // ========================================================
    JPanel actionsP = new JPanel();
    GridBagLayout actionsPGBL = new GridBagLayout();
    GridBagConstraints actionsPGBC = new GridBagConstraints();
    actionsPGBC.anchor = GridBagConstraints.NORTHWEST;
    actionsPGBC.insets = new Insets(1, 1, 1, 1);
    actionsP.setLayout(actionsPGBL);

    // ========================================================
    // ===== label main success scenario
    // ========================================================

    JPanel mainSuccessScenarioLP = new JPanel();
    mainSuccessScenarioLP.setLayout(
      new BoxLayout(mainSuccessScenarioLP, BoxLayout.Y_AXIS));
    mainSuccessScenarioLP.add(new JLabel("Success Main Flow:"));
    //    mainSuccessScenarioLP.add(new JLabel("Main Flow:"));
    actionsPGBC.gridx = 0;
    actionsPGBC.gridy = 1;
    actionsPGBL.setConstraints(mainSuccessScenarioLP, actionsPGBC);
    actionsP.add(mainSuccessScenarioLP);

    // ========================================================
    // ===== table main success scenario
    // ========================================================

    mainSuccessScenarioTP = new JTabbedPane();

    style2PMain = new GStyle2P(frameF, viewpointUc.getSuccessScenarioT1(),
          business.Global.kindDataSuccessSc, viewpointUc.getExtensionT1(),
          viewpointUc.getSubvariationT1(), observerStrT1);

    observerStrT1.addListener(style2PMain);
    mainSuccessScenarioTP.addTab("Style **", style2PMain);

    style3PMain = new CStyle3P(frameF, viewpointUc.getSuccessScenarioT2(),
      viewpointUc.getActors(), business.Global.TYPE_USECASE,
      business.Global.kindDataSuccessSc, viewpointUc.getExtensionT2(),
      viewpointUc.getSubvariationT2(),
      observerStrT2);
    observerStrT2.addListener(style3PMain);
    mainSuccessScenarioTP.addTab("Style ***", style3PMain);

    if (viewpointUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR)
      mainSuccessScenarioTP.setSelectedComponent(style2PMain);
    else
      mainSuccessScenarioTP.setSelectedComponent(style3PMain);
    mainSuccessScenarioTP.setPreferredSize(new Dimension(600, 310));
    mainSuccessScenarioTP.addChangeListener(new ChangeListener () {
      public void stateChanged(ChangeEvent e) {
        JTabbedPane source = (JTabbedPane)e.getSource();
        if (source.getSelectedIndex() == 0) {
          extensionsTP.setSelectedIndex(0);
          //subvariationsTP.setSelectedIndex(0);
        } else {
          extensionsTP.setSelectedIndex(1);
          //subvariationsTP.setSelectedIndex(1);
        }
      }
    });
    actionsPGBC.gridx = 0;
    actionsPGBC.gridy = 2;
    actionsPGBL.setConstraints(mainSuccessScenarioTP, actionsPGBC);
    actionsP.add(mainSuccessScenarioTP);

    // ========================================================
    // ===== label extensions
    // ========================================================

    JLabel extensionsL = new JLabel("Extensions:");
    actionsPGBC.gridx = 0;
    actionsPGBC.gridy = 3;
    actionsPGBL.setConstraints(extensionsL, actionsPGBC);
    actionsP.add(extensionsL);

    // ========================================================
    // ===== table extensions
    // ========================================================

    extensionsTP = new JTabbedPane();

    style2PExt = new GStyle2P(frameF, viewpointUc.getSuccessScenarioT1(),
      business.Global.kindDataExtension, viewpointUc.getExtensionT1(),
      viewpointUc.getSubvariationT1(), observerStrT1);
    observerStrT1.addListener(style2PExt);
    extensionsTP.addTab("Style **", style2PExt);

    style3PExt = new CStyle3P(frameF, viewpointUc.getSuccessScenarioT2(),
      viewpointUc.getActors(), business.Global.TYPE_USECASE,
      business.Global.kindDataExtension, viewpointUc.getExtensionT2(),
      viewpointUc.getSubvariationT2(),
      observerStrT2);
    observerStrT2.addListener(style3PExt);
    extensionsTP.addTab("Style ***", style3PExt);

    if (viewpointUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR)
      extensionsTP.setSelectedComponent(style2PExt);
    else
      extensionsTP.setSelectedComponent(style3PExt);
    extensionsTP.setPreferredSize(new Dimension(600, 250));
    extensionsTP.addChangeListener(new ChangeListener () {
      public void stateChanged(ChangeEvent e) {
        JTabbedPane source = (JTabbedPane)e.getSource();
        if (source.getSelectedIndex() == 0) {
          mainSuccessScenarioTP.setSelectedIndex(0);
          //subvariationsTP.setSelectedIndex(0);
        } else {
          mainSuccessScenarioTP.setSelectedIndex(1);
          //subvariationsTP.setSelectedIndex(1);
        }
      }
    });
    actionsPGBC.gridx = 0;
    actionsPGBC.gridy = 4;
    actionsPGBL.setConstraints(extensionsTP, actionsPGBC);
    actionsP.add(extensionsTP);

    // ========================================================
    // ===== label subvariations
    // ========================================================

//    JLabel subvariationsL = new JLabel("Subvariations:");
//    actionsPGBC.gridx = 0;
//    actionsPGBC.gridy = 5;
//    actionsPGBL.setConstraints(subvariationsL, actionsPGBC);
//    actionsP.add(subvariationsL);

    // ========================================================
    // ===== table subvariations
    // ========================================================

//    subvariationsTP = new JTabbedPane();
//    style2PSub = new GStyle2P(frameF, viewpointUc.getSuccessScenarioT1(),
//      business.Global.kindDataVariation,
//      viewpointUc.getExtensionT1(),
//      viewpointUc.getSubvariationT1(),
//      observerStrT1);
//    observerStrT1.addListener(style2PSub);
//    subvariationsTP.addTab("Style **", style2PSub);
//
//    style3PSub = new CStyle3P(frameF, viewpointUc.getSuccessScenarioT2(),
//      viewpointUc.getActors(), business.Global.TYPE_USECASE,
//      business.Global.kindDataVariation,
//      viewpointUc.getExtensionT2(),
//      viewpointUc.getSubvariationT2(),
//      observerStrT2);
//    observerStrT2.addListener(style3PSub);
//    subvariationsTP.addTab("Style ***", style3PSub);
//    if (viewpointUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR)
//      subvariationsTP.setSelectedComponent(style2PSub);
//    else
//      subvariationsTP.setSelectedComponent(style3PSub);
//    //subvariationsTP.setPreferredSize(new Dimension(600, 170));
//    subvariationsTP.addChangeListener(new ChangeListener () {
//      public void stateChanged(ChangeEvent e) {
//        JTabbedPane source = (JTabbedPane)e.getSource();
//        if (source.getSelectedIndex() == 0) {
//          extensionsTP.setSelectedIndex(0);
//          mainSuccessScenarioTP.setSelectedIndex(0);
//        } else {
//          extensionsTP.setSelectedIndex(1);
//          mainSuccessScenarioTP.setSelectedIndex(1);
//        }
//      }
//    });
//    actionsPGBC.gridx = 0;
//    actionsPGBC.gridy = 6;
//    actionsPGBL.setConstraints(subvariationsTP, actionsPGBC);
//    actionsP.add(subvariationsTP);

    // ========================================================

    this.setLayout(new BorderLayout(1, 1));

    conditionsP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(""),
        BorderFactory.createEmptyBorder(1,1,1,1)
      )
    );
    this.add(conditionsP, BorderLayout.CENTER);

    actionsP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(""),
        BorderFactory.createEmptyBorder(1,1,1,1)
      )
    );
    this.add(actionsP, BorderLayout.EAST);
  }


  /** reads data of use case viewpoint from gui
   *  @return use case viewpoint
   */
  public business.CViewpointUc getViewpointUc() {
    viewpointUc.setTrigger(triggerTA.getText());
    viewpointUc.setPrecond(preconditionsP.getConditions());
    viewpointUc.setSuccessEndcond(successEndconditionsP.getConditions());
    viewpointUc.setFailedEndcond(failedEndconditionsP.getConditions());
    viewpointUc.setStyle(mainSuccessScenarioTP.getSelectedIndex());
    viewpointUc.setSuccessScenarioT1(style2PMain.getStepStrT1());
    viewpointUc.setSuccessScenarioT2(style3PMain.getStepStrT2());
    viewpointUc.setExtensionT1(style2PExt.getStepStrT1());
    viewpointUc.setExtensionT2(style3PExt.getStepStrT2());
//    viewpointUc.setSubvariationT1(style2PSub.getStepStrT1());
//    viewpointUc.setSubvariationT2(style3PSub.getStepStrT2());
      //------
//    setActors();
    return viewpointUc;
  }

  /** checks if AIndex. actor of use case viewpoint is used in steps of type
   *  business.CStepStrT2 of scenario
   *  @return true, if used; else false
   */
  private boolean isActorInUse(int AIndex) {

    viewpointUc.setSuccessScenarioT2(style3PMain.getStepStrT2());
    viewpointUc.setExtensionT2(style3PExt.getStepStrT2());
    //viewpointUc.setSubvariationT2(style3PSub.getStepStrT2());

    boolean inUse = false;
    if (viewpointUc.getSuccessScenarioT2() != null) {
      for (int i=0; inUse == false && i<viewpointUc.getSuccessScenarioT2().size(); i++) {
        if (((business.CStepStrT2)
              viewpointUc.getSuccessScenarioT2().elementAt(i)).getActor() != null &&
            ((business.CStepStrT2)
              viewpointUc.getSuccessScenarioT2().elementAt(i)).getActor().getType().equals(
            ((business.CActor) viewpointUc.getActors().elementAt(AIndex)).getType()))
          inUse = true;
      }
    }

    if (viewpointUc.getExtensionT2() != null) {
      for (int i=0; inUse == false && i<viewpointUc.getExtensionT2().size(); i++) {
        if (((business.CStepStrT2)
              viewpointUc.getExtensionT2().elementAt(i)).getActor() != null &&
            ((business.CStepStrT2)
              viewpointUc.getExtensionT2().elementAt(i)).getActor().getType().equals(
            ((business.CActor) viewpointUc.getActors().elementAt(AIndex)).getType()))
          inUse = true;
      }
    }

//    if (viewpointUc.getSubvariationT2() != null) {
//      for (int i=0; inUse == false && i<viewpointUc.getSubvariationT2().size(); i++) {
//        if (((business.CStepStrT2)
//              viewpointUc.getSubvariationT2().elementAt(i)).getActor() != null &&
//            ((business.CStepStrT2)
//              viewpointUc.getSubvariationT2().elementAt(i)).getActor().getType().equals(
//            ((business.CActor) viewpointUc.getActors().elementAt(AIndex)).getType()))
//          inUse = true;
//      }
//    }

    return inUse;
  }

  /** reloads data of gui connected with actors */
  public void reload() {

    this.preconditionsP.reload();
    this.failedEndconditionsP.reload();
    this.successEndconditionsP.reload();

    style3PMain.reload();
    style3PExt.reload();
//    style3PSub.reload();

    style2PMain.reload();
    style2PExt.reload();
//    style2PSub.reload();

    //setActors();
  }
}
