package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: An object of this class is created if user wants to open
 * an existing use case viewpoint.
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpointUseCaseF extends JFrame implements ActionListener {

  ImageIcon imageIcon = null;

  /** this frame */
  private JFrame frameF = null;

  /** button to save the use case viewpoint */
  private JButton saveB = null;
  private JButton helpB = null;
  private JButton verifyB = null;
  private JButton closeB = null;
  private JButton minimizeB = null;
  private JButton documentB = null;
  private JButton senariosB = null;

  /** constructor */

  public CViewpointUseCaseF() {}

  /**
   * WARNING this CViewpointUc is not the updated viewpoint
   * but the original one passed as a parameter to this object
   */
  private business.CViewpointUc xCViewpointUc ;


  /** constructor
   *  @param AViewpointUc use case viewpoint to be displayed
   *  @param all shared use cases
   */



  public CViewpointUseCaseF(business.CViewpointUc AViewpointUc,
                            Vector AUsecaseV) {

    super("usecase viewpoint");
    xCViewpointUc = AViewpointUc;
    frameF = this;
    init(AViewpointUc, AUsecaseV);
    pack();
  }



  /** init gui
   *  @param AViewpointUc use case viewpoint to be displayed
   *  @param all shared use cases
   */
  public gui.CViewpointUseCaseP viewpointUseCaseP;
  private void init(business.CViewpointUc AViewpointUc,
                    Vector AUsecaseV) {

    // panel for data of use case viewpoint
      viewpointUseCaseP = new gui.CViewpointUseCaseP(this, AViewpointUc, AUsecaseV);

    // button to save use case viewpoint

    saveB = new JButton("Save",business.Global.imageIconSave);
    saveB.setActionCommand("Save");
    saveB.addActionListener(this);

    // button to check if user followed the guidelines
    verifyB = new JButton("Verify",business.Global.imageIconVerify);
    verifyB.setActionCommand("Verify");
    verifyB.addActionListener(this);

    // button to check if user followed the guidelines
    helpB = new JButton("Help",business.Global.imageIconHelp);
    helpB.setActionCommand("Help");
    helpB.addActionListener(this);

    // button to check if user followed the guidelines
    documentB = new JButton("Create Document",business.Global.imageIconDocument);
    documentB.setActionCommand("Document");
    documentB.addActionListener(this);


    // button to close
    closeB = new JButton("Close",business.Global.imageIconClose);
    closeB.setActionCommand("Close");
    closeB.addActionListener(this);
    // button to minimize
    minimizeB = new JButton("Minimize",business.Global.imageIconMinimize);
    minimizeB.setActionCommand("Minimize");
    minimizeB.addActionListener(this);



    // ===== senarios
    senariosB = new JButton("Senarios",business.Global.imageIconSC);
    senariosB.setActionCommand("Senarios");
    senariosB.addActionListener(this);


    JPanel buttonPR = new JPanel();
    buttonPR.setLayout(new FlowLayout(FlowLayout.RIGHT, 1, 1));

    JPanel buttonPL = new JPanel();
    buttonPL.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));


    buttonPL.add(saveB);
    buttonPL.add(verifyB);
    buttonPL.add(documentB);
    buttonPL.add(senariosB);
    buttonPL.add(helpB);


//    buttonP.add(deleteB);
    buttonPR.add(minimizeB);
    buttonPR.add(closeB);

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new BorderLayout());
    buttonP.add(buttonPL,BorderLayout.WEST);
    buttonP.add(buttonPR,BorderLayout.EAST);

    getContentPane().add(viewpointUseCaseP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.NORTH);
  }

  /** called if use case viewpoint shall be saved */
  public void doSave() {
    business.Global.contrViewpoint.setFrame(frameF);
    business.Global.error = false;
    business.CViewpointUc VPUC = viewpointUseCaseP.getViewpointUc();
    if(business.Global.error != true){
      business.Global.contrViewpoint.saveViewpoint( VPUC,false);//diferent to this.save()
    }else{
      JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
    }
  }

  public void save() {
    business.Global.contrViewpoint.setFrame(frameF);
    business.Global.error = false;
    business.CViewpointUc VPUC = viewpointUseCaseP.getViewpointUc();
    if(business.Global.error != true){
      business.Global.contrViewpoint.saveViewpoint( VPUC,true);//diferent to this.dosave()
    }else{
      JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
    }
  }

  public void reload(){
    this.viewpointUseCaseP.reload();
  }






  public void actionPerformed(ActionEvent e) {

    if(e.getActionCommand().equals("Save")) {
      save();
    }else if(e.getActionCommand().equals("Verify")) {
//      if (business.Global.systemUnix){
        business.Global.error = false;
        business.CViewpoint viewpoint = viewpointUseCaseP.getViewpointUc();
        if (!business.Global.error){
          business.Global.contrViewpoint.setFrame(frameF);
          business.Global.contrViewpoint.verifyViewpoint(viewpoint);
          JOptionPane.showMessageDialog(null,"Done!");
          reload();
        }else{
          JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
        }
//      }else{
//        JOptionPane.showMessageDialog(null,"This option is only available on Unix");
//      }
    }
    else if(e.getActionCommand().equals("Help")) {
      JOptionPane.showMessageDialog(frameF,"help goes here");
    }
    else if(e.getActionCommand().equals("Close")) {
      close();
    }
    else if(e.getActionCommand().equals("Minimize")) {
      frameF.dispose();
    }
    else if(e.getActionCommand().equals("Document")) {
      gui.GReport report = new gui.GReport();
      business.CViewpointUc VP = viewpointUseCaseP.getViewpointUc();
      report.VPReport(VP);
      report.showDialog();
    }
    else if(e.getActionCommand().equals("Document")) {
        new gui.CScenarioOpenD(frameF,xCViewpointUc);
    }
    else if(e.getActionCommand().equals("Senarios")) {
        new gui.CScenarioOpenD(frameF,xCViewpointUc);
    }

  }




  public void close(){
            int option;
            option = JOptionPane.showConfirmDialog(null,"Do you want to save this","Save",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
            if (option == JOptionPane.OK_OPTION){
                save();

                if(business.Global.error != true)
                business.Global.contrViewpoint.closeViewpoint( xCViewpointUc);
                //viewpointUseCaseP.getViewpointUc());
            }
            if (option == JOptionPane.NO_OPTION){
                business.Global.contrViewpoint.closeViewpoint( xCViewpointUc);
                //viewpointUseCaseP.getViewpointUc());
            }
            if (option == JOptionPane.CANCEL_OPTION){
            }
  }




}
