package gui;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * Description: An object of this class is part of a frame to capture
 * data of a scenario viewpoint.
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpointScenarioP extends JPanel {

  /** current scenario viewpoint */
  private business.CViewpointSc viewpointSc = null;
  /** shared scenario is attached to this shared use case */
  private business.CUsecase usecase = null;

  /** parent frame */
  private JFrame frameF = null;

  /** combobox for all shared use cases */
  //private JComboBox useCaseCB = null;
  /** combobox for all shared scenarios */
  //private JComboBox scenarioCB = null;
  /** combobox to define view / actors of current shared use case */
  //private JComboBox viewCB = null;
  /** textfield for name of scenario viewpoint */
  private JTextField nameTF = null;
  /** table of agents */
  private gui.CAgentTableP actorsP = null;
  /** JTabbedPane for different kinds of description of scenario steps */
  private gui.CScenarioTP scenarioTP = null;

  /** index of choosed shared use case before changed and if ok then index
    *  of current shared use case */
  private int lastUsecaseIndex = 0;

  /** constructor
   *  @param AFrameF frame of parent
   *  @param scenario viewpoint to be displayed
   *  @param all shared use cases
   *  @param all shared scenarios of current shared use case
   */
  public CViewpointScenarioP(JFrame AFrameF,
                             business.CViewpointSc AViewpointSc){
//                             Vector AUsecaseV,
//                             Vector AScenarioV) {

    frameF = AFrameF;
    viewpointSc = AViewpointSc;
    if (viewpointSc == null) viewpointSc = new business.CViewpointSc();

    JPanel viewpointScenarioP = new JPanel();

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    viewpointScenarioP.setLayout(gridbag);

    // ========================================================
    // ======= label: use case
    // ========================================================

    JLabel useCaseL = new JLabel("usecase:");
    c.gridx = 0;
    c.gridy = 0;
    c.insets = new Insets(1, 1, 1, 1);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(useCaseL, c);
    viewpointScenarioP.add(useCaseL);

    // ========================================================
    // ======= use case
    // ========================================================

    JLabel useCaseL2 = new JLabel(this.viewpointSc.getViewpointUc().getUsecase().getName());
    c.gridx = 1;
    c.gridy = 0;
    gridbag.setConstraints(useCaseL2, c);
    viewpointScenarioP.add(useCaseL2);

//    useCaseCB = new JComboBox();
//    if (AUsecaseV != null) {
//      for (int i=0; i<AUsecaseV.size(); i++) {
//        useCaseCB.addItem((business.CUsecase) AUsecaseV.elementAt(i));
//        if (viewpointSc.getScenario() != null) {
//          if (viewpointSc.getScenario().getUsecase().getId() ==
//             ((business.CUsecase) AUsecaseV.elementAt(i)).getId()) {
//            useCaseCB.setSelectedIndex(i);
//            usecase = viewpointSc.getScenario().getUsecase();
//            lastUsecaseIndex = i;
//          }
//        }
//      }
//    }




//    useCaseCB.addActionListener(new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//
//        viewpointSc.setAgents(actorsP.getAgents());
//        viewpointSc.setUnstructText(scenarioTP.getUnstructText());
//        viewpointSc.setStepStrT1(scenarioTP.getStepStrT1());
//        viewpointSc.setStepStrT2(scenarioTP.getStepStrT2());
//
//        // ====== usecase
//        business.CUsecase usecase =
//          (business.CUsecase) useCaseCB.getSelectedItem();
//
//        // check if possible to change to usecase
//        boolean found = true;
//
//        // is viewpointSc only using agent of actor types of new usecase
//        if (viewpointSc.getAgents() != null) {
//          for (int i=0; found == true && i<viewpointSc.getAgents().size(); i++) {
//            if (!usecase.containsActor(((business.CAgent)
//              viewpointSc.getAgents().elementAt(i)).getActor().getId()))
//              found = false;
//          }
//        }
//
//        if (viewpointSc.getStepStrT2() != null) {
//          for (int i=0; found == true && i<viewpointSc.getStepStrT2().size(); i++) {
//            if (!usecase.containsActor(
//                 ((business.CStepStrT2)
//                   viewpointSc.getStepStrT2().elementAt(i)).getAgent().getActor().getId()
//               )) {
//              found = false;
//            }
//          }
//        }
//
//        if (found == false) {
//          JOptionPane.showMessageDialog(frameF,
//            "can't be part of usecase " + usecase.getName());
//          useCaseCB.setSelectedIndex(lastUsecaseIndex);
//        } else {
//
//          lastUsecaseIndex = useCaseCB.getSelectedIndex();
//
//          // reload scenarios
//          Vector scenarioV = null;
//          if (usecase != null) {
//            scenarioV =
//            business.Global.contrViewpoint.getAllScenarioOfUsecase(usecase);
//          }
//
//          scenarioCB.removeAllItems();
//          scenario = null;
//          if (scenarioV != null) {
//            for (int i=0; i<scenarioV.size(); i++) {
//              scenarioCB.addItem((business.CScenario) scenarioV.elementAt(i));
//            }
//            if (scenarioV.size() > 0) {
//              scenarioCB.setSelectedIndex(0);
//              scenario = (business.CScenario) scenarioV.elementAt(0);
//            }
//          }
//
//          // reload views
//          viewCB.removeAllItems();
//          if (usecase != null && usecase.getActors() != null) {
//            for (int i=0; i<usecase.getActors().size(); i++) {
//              viewCB.addItem(
//                (business.CActor) usecase.getActors().elementAt(i)
//              );
//            }
//          }
//
//          // agents
//          actorsP.reload(usecase, viewpointSc.getAgents());
//
//          // actions
//          scenarioTP.reload(viewpointSc.getStepStrT2(), viewpointSc.getAgents());
//        }
//      }
//    });
//    c.gridx = 1;
//    c.gridy = 0;
//    gridbag.setConstraints(useCaseCB, c);
//    viewpointScenarioP.add(useCaseCB);

    // ========================================================
    // ======= label: scenario
    // ========================================================

    JLabel scenarioL = new JLabel("scenario of:");
    c.gridx = 0;
    c.gridy = 1;
    gridbag.setConstraints(scenarioL, c);
    viewpointScenarioP.add(scenarioL);

    // ========================================================
    // ======= scenario
    // ========================================================

    JLabel scenarioL2 = new JLabel( this.viewpointSc.getViewpointUc().getViewpointAgent().getUser().getName());
    c.gridx = 1;
    c.gridy = 1;
    gridbag.setConstraints(scenarioL2, c);
    viewpointScenarioP.add(scenarioL2);

//    scenarioCB = new JComboBox();
//    if (AScenarioV != null) {
//      for (int i=0; i<AScenarioV.size(); i++) {
//        scenarioCB.addItem((business.CScenario) AScenarioV.elementAt(i));
//        if (viewpointSc.getScenario() != null) {
//          if (viewpointSc.getScenario().getId() ==
//             ((business.CScenario) AScenarioV.elementAt(i)).getId())
//          scenarioCB.setSelectedIndex(i);
//          scenario = (business.CScenario) AScenarioV.elementAt(i);
//        }
//      }
//    }
//    if (viewpointSc.getScenario() == null) {
//      viewpointSc.setScenario((business.CScenario) scenarioCB.getSelectedItem());
//    }
//    c.gridx = 1;
//    c.gridy = 1;
//    gridbag.setConstraints(scenarioCB, c);
//    viewpointScenarioP.add(scenarioCB);

    // ========================================================
    // ======= label: view
    // ========================================================

    JLabel viewL = new JLabel("view:");
    c.gridx = 0;
    c.gridy = 2;
    gridbag.setConstraints(viewL, c);
    viewpointScenarioP.add(viewL);

    // ========================================================
    // ======= view
    // ========================================================

    JLabel viewL2 = new JLabel(this.viewpointSc.getViewpointUc().getViewpointAgent().getName());
    c.gridx = 1;
    c.gridy = 2;
    gridbag.setConstraints(viewL2, c);
    viewpointScenarioP.add(viewL2);

//    viewCB = new JComboBox();
//    if (viewpointSc.getScenario() != null) {
//      for (int i=0; i<viewpointSc.getScenario().getUsecase().getActors().size(); i++) {
//        viewCB.addItem(
//          (business.CActor) viewpointSc.getScenario().getUsecase().getActors().elementAt(i)
//        );
//      }
//    } else {
//      if (AUsecaseV != null) {
//        for (int i=0; i<((business.CUsecase) AUsecaseV.elementAt(0)).getActors().size(); i++) {
//          viewCB.addItem(
//            (business.CActor) ((business.CUsecase) AUsecaseV.elementAt(0)).getActors().elementAt(i)
//          );
//        }
//      }
//    }
//    c.gridx = 1;
//    c.gridy = 2;
//    gridbag.setConstraints(viewCB, c);
//    viewpointScenarioP.add(viewCB);

    // ========================================================
    // ======= label: name
    // ========================================================

    JLabel nameL = new JLabel("name:*");
    c.gridx = 0;
    c.gridy = 3;
    gridbag.setConstraints(nameL, c);
    viewpointScenarioP.add(nameL);

    // ========================================================
    // ======= textfield: name
    // ========================================================

    nameTF = new JTextField(50);
    if (viewpointSc.getName() != null) {
      nameTF.setText(viewpointSc.getName());
    }
    c.gridx = 1;
    c.gridy = 3;
    gridbag.setConstraints(nameTF, c);
    viewpointScenarioP.add(nameTF);

    // ========================================================
    // ======= label: system
    // ========================================================

    JLabel systemL = new JLabel("system:");
    c.gridx = 0;
    c.gridy = 4;
    gridbag.setConstraints(systemL, c);
    viewpointScenarioP.add(systemL);

    // ========================================================
    // ======= label: systemName
    // ========================================================

    JLabel systemNameL = new JLabel(viewpointSc.getUsecase().getProject().getSystem());
    c.gridx = 1;
    c.gridy = 4;
    gridbag.setConstraints(systemNameL, c);
    viewpointScenarioP.add(systemNameL);

    // ========================================================
    // ======= label: actors
    // ========================================================

    JLabel actorsL = new JLabel("agents:");
    c.gridx = 0;
    c.gridy = 5;
    gridbag.setConstraints(actorsL, c);
    viewpointScenarioP.add(actorsL);

    // ========================================================
    // ======= table: actors
    // ========================================================

    actorsP = new gui.CAgentTableP(
               frameF,
               this,
               this.viewpointSc.getViewpointUc().getUsecase(),
               viewpointSc.getAgents());
    c.gridx = 1;
    c.gridy = 5;
    gridbag.setConstraints(actorsP, c);
    viewpointScenarioP.add(actorsP);

    // ========================================================
    // ======= label: scenario
    // ========================================================

    scenarioL = new JLabel("scenario:");
    c.gridx = 0;
    c.gridy = 6;
    gridbag.setConstraints(scenarioL, c);
    viewpointScenarioP.add(scenarioL);

    // ========================================================
    // ======= scenario
    // ========================================================

    scenarioTP = new gui.CScenarioTP(frameF,
                                     viewpointSc.getUnstructText(),
                                     viewpointSc.getStepStrT1(),
                                     viewpointSc.getStepStrT2(),
                                     viewpointSc.getAgents());
    scenarioTP.setSelectedIndex(viewpointSc.getStyle());
    c.gridx = 1;
    c.gridy = 6;
    gridbag.setConstraints(scenarioTP, c);
    viewpointScenarioP.add(scenarioTP);

    // ========================================================

    viewpointScenarioP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(""),
        BorderFactory.createEmptyBorder(1,1,1,1)
      )
    );

    add(viewpointScenarioP);
  }

  /** is called if agent is changed in agent table;
   *  checks if entry is ok
   */
  public void changedAgents() {
    viewpointSc.setAgents(actorsP.getAgents());

    if (areAgentsCorrect()) {
      scenarioTP.reload(viewpointSc.getStepStrT2(), viewpointSc.getAgents());
    } else {
      JOptionPane.showMessageDialog(frameF, "agent names have to be clear and unambiguous");
    }
  }

  /** reads data of scenario viewpoint from gui
   *  @return scenario viewpoint
   */
  public business.CViewpointSc getViewpointSc() {

    if(nameTF.getText().equals("")||nameTF.getText()==null){business.Global.error = true;}

    //viewpointSc.setScenario((business.CScenario) scenarioCB.getSelectedItem());
    viewpointSc.setName(nameTF.getText());



    DefaultCellEditor editor  =(DefaultCellEditor)actorsP.actorsT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();


    if (actorsP.actorsT.isEditing()){
      JOptionPane.showMessageDialog(null,"ERROR: Please finish editing agents ... row:"+(actorsP.actorsT.getEditingRow()+1));
      business.Global.error = true;
    }else{
      viewpointSc.setAgents(actorsP.getAgents());
    }

    viewpointSc.setUnstructText(scenarioTP.getUnstructText());
    viewpointSc.setStepStrT1(scenarioTP.getStepStrT1());
    viewpointSc.setStepStrT2(scenarioTP.getStepStrT2());
    viewpointSc.setStyle(scenarioTP.getStyle());
    return viewpointSc;
  }

  /** checks if agent is not in use
   *  @return true, if actor is not in use
   */
  public boolean canDeleteAgent(int AIndex) {

    viewpointSc.setAgents(actorsP.getAgents());
    viewpointSc.setStepStrT2(scenarioTP.getStepStrT2());

    boolean delete = true;
    if (viewpointSc.getStepStrT2() != null) {
      for (int i=0; delete == true && i<viewpointSc.getStepStrT2().size(); i++) {
        if (((business.CStepStrT2)
              viewpointSc.getStepStrT2().elementAt(i)).getAgent() != null &&
            ((business.CStepStrT2)
              viewpointSc.getStepStrT2().elementAt(i)).getAgent().getName().equals(
            ((business.CAgent) viewpointSc.getAgents().elementAt(AIndex)).getName()))
          delete = false;
      }
    }

    return delete;
  }

  /** checks if agents do not have the same names
   *  @return true, if agent do not have the same names
   */
  public boolean areAgentsCorrect() {
    boolean correct = true;
    if (viewpointSc.getAgents() != null) {
      for (int i=0; correct == true && i<viewpointSc.getAgents().size(); i++) {
        for (int j=0; correct == true && j<viewpointSc.getAgents().size(); j++) {
          if (i!=j &&
             ((business.CAgent) viewpointSc.getAgents().elementAt(i)).getName().equals(
             ((business.CAgent) viewpointSc.getAgents().elementAt(j)).getName()))
             correct = false;
          }
        }
      }
    return correct;
  }

  public void reload(){
    this.scenarioTP.reload();
  }
}

