package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * Description: An object of this class is created if user wants to open
 * an existing scenario viewpoint.
 *
 * @author Kathrin Boettger modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpointScenarioF extends JFrame {

  private JFrame frameF = null;
  private gui.CViewpointScenarioP viewpointScenarioP = null;
  private JButton saveB = null;

  /** constructor
   *  @param AViewpointSc scenario viewpoint
   *  @param AUsecaseV all shared use cases
   *  @param AScenarioV all shared scenario of
   */
  public CViewpointScenarioF(business.CViewpointSc AViewpointSc)//,Vector AUsecaseV, Vector AScenarioV)
{
    super("scenario viewpoint");
    frameF = this;
    init(AViewpointSc);//, AUsecaseV, AScenarioV);
    pack();
  }

  /** init gui
   *  @param AViewpointSc scenario viewpoint
   *  @param AUsecaseV all shared use cases
   *  @param AScenarioV all shared scenario of
   */
  private void init(business.CViewpointSc AViewpointSc){//,Vector AUsecaseV,Vector AScenarioV) {

    // ======================================================
    // ===== viewpoint scenario panel
    // ======================================================

    viewpointScenarioP =
      new gui.CViewpointScenarioP(this, AViewpointSc);//, AUsecaseV, AScenarioV);

    // ======================================================
    // ===== button panel
    // ======================================================
    saveB = new JButton("Save",business.Global.imageIconSave);
    saveB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        business.Global.contrViewpoint.setFrame(frameF);
        business.Global.error = false;
        business.CViewpointSc vpsc = viewpointScenarioP.getViewpointSc();
        if(business.Global.error == false){
          business.Global.contrViewpoint.saveViewpoint(vpsc,true);
        }else{
          JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
        }
      }
    });

    final JButton verifyB = new JButton("Verify Rules",business.Global.imageIconVerify);
    verifyB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        business.Global.error = false;
        business.CViewpoint viewpoint = viewpointScenarioP.getViewpointSc();
        if (!business.Global.error){
          business.Global.contrViewpoint.setFrame(frameF);
          business.Global.contrViewpoint.verifyViewpoint(viewpoint);
          JOptionPane.showMessageDialog(null,"Done!");
          reload();
        }else{
          JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
        }
      }
    });

    final JButton deleteB = new JButton("Delete",business.Global.imageIconDelete);
    deleteB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int sure = JOptionPane.showConfirmDialog(
        frameF,
        "Are you sure ? ",
        "delete viewpoint",
        JOptionPane.YES_NO_OPTION);
        if (sure == JOptionPane.NO_OPTION) return;
        business.Global.contrViewpoint.deleteViewpoint(
          viewpointScenarioP.getViewpointSc());
      }
    });

    final JButton closeB = new JButton("close",business.Global.imageIconClose);
    closeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
            int option;
            option = JOptionPane.showConfirmDialog(null,"Do you want to save","Save",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
            if (option == JOptionPane.OK_OPTION){
                doSave();
                if(business.Global.error != true)
                business.Global.contrViewpoint.closeViewpoint(
                    viewpointScenarioP.getViewpointSc());
            }
            if (option == JOptionPane.NO_OPTION){
                business.Global.contrViewpoint.closeViewpoint(
                    viewpointScenarioP.getViewpointSc());
            }
            if (option == JOptionPane.CANCEL_OPTION){

            }
      }
    });

    JButton minimizeB = new JButton("Minimize",business.Global.imageIconMinimize);
    minimizeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        frameF.dispose();
      }
    });

//    JPanel buttonP = new JPanel();
//    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));



    JPanel buttonPR = new JPanel();
    buttonPR.setLayout(new FlowLayout(FlowLayout.RIGHT, 1, 1));

    JPanel buttonPL = new JPanel();
    buttonPL.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));




    buttonPL.add(saveB);
    buttonPL.add(verifyB);
    buttonPL.add(deleteB);

    buttonPR.add(minimizeB);
    buttonPR.add(closeB);

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new BorderLayout());
    buttonP.add(buttonPL,BorderLayout.WEST);
    buttonP.add(buttonPR,BorderLayout.EAST);




    // ======================================================
    getContentPane().add(viewpointScenarioP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.NORTH);
  }

  /** is called if scenario viewpoint shall be saved into database */
  public void doSave() {
        business.Global.contrViewpoint.setFrame(frameF);
        business.Global.error = false;
        business.CViewpointSc vpsc = viewpointScenarioP.getViewpointSc();
        if(business.Global.error == false){
          business.Global.contrViewpoint.saveViewpoint(vpsc,false);
        }else{
          JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
        }
  }

  public void reload(){
    viewpointScenarioP.reload();
  }
}
