package gui;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * Description: creates a dialog to choose a viewpoint from a tree to open
 * this viewpoint
 *
 * @author Kathrin Boettger modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpointOpenD extends JDialog {
  private boolean foundVPUC = false;
  /** this dialog */
  private CViewpointOpenD dialogD = null;
  /** current marked viewpoint */
  private business.CViewpoint viewpoint = null;

  /** constructor *
   * @param AParent parent frame of this dialog
   * @param AViewpoint vector of viewpoints
   */
  public CViewpointOpenD(JFrame AParent ) {

    super(AParent, "Open Viewpoint", true); // not true
    dialogD = this;
    business.Global.contrViewpoint.setDialog(this);
    Vector VPUC = persistence.CProject.getAllViewpointUCOfProject(business.Global.project);
    init(VPUC);
    pack();
  }

  /** initializes the dialog
   *  @param vector of viewpoints
   */
  private void init(Vector AViewpointV) {

    Vector viewpointV = AViewpointV;

    // create the tree
    JPanel viewpointTree = new JPanel();
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("All viewpoints");
    if (viewpointV != null) {
      long lastUsecaseId = -1;
      long lastScenarioId = -1;
      DefaultMutableTreeNode usecaseNode = null;
      DefaultMutableTreeNode scenarioNode = null;
      for (int i=0; i<viewpointV.size(); i++) {
        business.CViewpointUc viewpointUc =   (business.CViewpointUc) viewpointV.elementAt(i);
        if(business.Global.user.isAnalyst() || business.Global.user.getId() == viewpointUc.getViewpointAgent().getUser().getId() )
        {
          foundVPUC = true;
          if (viewpointUc.getUsecase().getId() != lastUsecaseId) {
            usecaseNode = new DefaultMutableTreeNode("usecase: " + viewpointUc.getUsecase().getName());
            top.add(usecaseNode);
            lastUsecaseId = viewpointUc.getUsecase().getId();
          }
          DefaultMutableTreeNode VPUCNode = new DefaultMutableTreeNode(viewpointUc);
          usecaseNode.add(VPUCNode);
          Vector ViewpointSCV = persistence.CViewpointSc.getAllViewpointScOf(viewpointUc);
          for(int y = 0;y<ViewpointSCV.size();y++){
            VPUCNode.add(new DefaultMutableTreeNode(ViewpointSCV.elementAt(y)) );
          }//for
        }//if
      }//for
    }//if

    final JTree tree = new JTree(top);
    tree.getSelectionModel().setSelectionMode(
      TreeSelectionModel.SINGLE_TREE_SELECTION);

    // set viewpoint if user marks viewpoint
    tree.addTreeSelectionListener(new TreeSelectionListener() {
      public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
          tree.getLastSelectedPathComponent();
        if (node == null) return;
        Object nodeInfo = node.getUserObject();
        if (nodeInfo.getClass().isInstance(new business.CViewpointUc())) {
          business.CViewpointUc viewpointUc = (business.CViewpointUc) nodeInfo;
          viewpoint = viewpointUc;
        } else if (nodeInfo.getClass().isInstance(new business.CViewpointSc())) {
          business.CViewpointSc viewpointSc = (business.CViewpointSc) nodeInfo;
          viewpoint = viewpointSc;
        } else {
          viewpoint = null;
          // no leaf
        }
      }
    });
    JScrollPane treeView = new JScrollPane(tree);
    treeView.setPreferredSize(new Dimension(400, 500));
    viewpointTree.add(treeView);

    // create button to open viewpoint
    final JButton openB = new JButton("open viewpoint");
    openB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (viewpoint != null){
          business.Global.contrViewpoint.openViewpoint(viewpoint);
          business.Global.contrViewpoint.showViewpoint(viewpoint);
        }else{
          JOptionPane.showMessageDialog(null , "Please choose a viewpoint first");
        }
      }
    });

    // close the dialog without doing anything
    JButton cancelB = new JButton("cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dialogD.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));
    buttonP.add(openB);
    buttonP.add(cancelB);

    getContentPane().add(viewpointTree, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       dialogD.dispose();
     }
    });


  }

  /** shows the dialog */
  public void showDialog() {
    if(foundVPUC){
      dialogD.setLocationRelativeTo(null);
      dialogD.setVisible(true);
    }else{
      dialogD.dispose();
      JOptionPane.showMessageDialog(null,"NO Viewpoints Found: Contact your group leader.");
    }
  }
}
