package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 *
 * @author:      Oscar Aguilera
 * @version 1.0
 */

public class CViewpointAgentNewD extends JDialog implements ActionListener {

  private JComboBox usersCB = null;
  private JTextField nameTF = null;
  private Vector users = new Vector();;

  /** this dialog */

  private CViewpointAgentNewD dialogD = null;
  /** user decision */
  private String returnString = null;

  /** constructor
   *  @param AParent parent of this dialog
   */
  private JFrame parent;
  private business.CUsecase usecase;

  public CViewpointAgentNewD(JFrame AParent, business.CUsecase aUsecase) {
    super(AParent, "New Viewpoint", true); // not true
    parent = AParent ;
    usecase = aUsecase;
    dialogD = this;
    init();
    pack();
    this.show();
  /** kind of viewpoint */
  }

  /** initializes the dialog */
  private void init() {
    usersCB = new JComboBox();
    users = persistence.CUser.getUsers();
    for(int i = 0; i < users.size() ; i++){
      usersCB.addItem(((business.CUser) users.elementAt(i) ).getName());
    }


    JPanel viewpointP = new JPanel();
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    viewpointP.setLayout(gridbag);
    c.insets = new Insets(5,5,5,5);




    JLabel nameL = new JLabel("Agent / Role:");
    c.gridy = 0;
    c.gridx = 0;
    gridbag.setConstraints(nameL, c);
    viewpointP.add(nameL);

    nameTF = new JTextField(30);
    c.gridy = 0;
    c.gridx = 1;
    gridbag.setConstraints(nameTF, c);
    viewpointP.add(nameTF);



    JLabel ownerL = new JLabel("Owner of Viewpoint:");
    c.gridy = 1;
    c.gridx = 0;
    gridbag.setConstraints(ownerL, c);
    viewpointP.add(ownerL);


    c.gridy = 1;
    c.gridx = 1;
    gridbag.setConstraints(usersCB, c);
    usersCB.setMinimumSize(new Dimension(2000,14) );
    viewpointP.add(usersCB);






    // button to open corresponing window
    final JButton okB = new JButton("Ok");
    okB.addActionListener(this);


    // button to cancel
    JButton cancelB = new JButton("Cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        returnString = null;
        dialogD.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 20));
    buttonP.add(okB);
    buttonP.add(cancelB);

    getContentPane().add(viewpointP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
    });
  }

  /** sets the user decision */
  public void actionPerformed(ActionEvent e) {
    if(this.nameTF.getText()!= null && this.nameTF.getText() != ""){
        //user
        int index = this.usersCB.getSelectedIndex();
        business.CUser user = ((business.CUser)  this.users.elementAt( index));

        //agent
        business.CViewpointAgent agent =  new business.CViewpointAgent(user, this.nameTF.getText(), usecase.getId());

        persistence.CViewpointAgent.addAgent(agent);

        business.CViewpointUc vp = new business.CViewpointUc();
        vp.setName(this.nameTF.getText());
        System.out.println(user.getName());
        vp.setViewpointAgent(agent);
        vp.setUsecase( usecase );
        System.out.println("Usecase");
        business.Global.contrViewpoint.createViewpointDB(vp,1);
        System.out.println("Usecase created");
     }
     dialogD.dispose();
     returnString = e.getActionCommand();
  }

  /** shows the dialog and returns the user decision
   *  @return user decision: business.Global.TYPE_VP_SCENARIO for scenario viewpoint,
   *  business.Global.TYPE_VP_USECASE for use case viewpoint and null for cancel
   */
  public String showDialog() {
    dialogD.setLocationRelativeTo(null);
    dialogD.setVisible(true);

    return returnString;
  }
}
