package gui;

import javax.swing.JFrame;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.*;
import javax.swing.text.*;
import javax.swing.JCheckBox.*;
import javax.swing.*;
import java.util.Vector;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class CUser extends JDialog implements ActionListener,ItemListener {

  private business.CUser user =null;
  private JCheckBox validCB = null;
  private JCheckBox adminCB = null;
  private JCheckBox analystCB = null;

  private JTextField loginTF=null;
  private JTextField nameTF=null;
  private JPasswordField passwordTF1=null;
  private JPasswordField passwordTF2=null;

  private Vector allUsers=null;

//  private JComboBox allUsersCB=null;
  private JButton newB=null;
  private JButton saveB=null;
  private JButton closeB=null;
  private JButton editB=null;
  private JButton cancelB=null;

  public CUser() {
    super(business.Global.recocase,"Users" ,true);
    JPanel mainP = new JPanel();
    mainP.setLayout(new BorderLayout());
    TitledBorder userT = BorderFactory.createTitledBorder("Administration tools");
    mainP.setBorder(userT);
    this.setContentPane(mainP);


    // ===================================================================
    // ===== Select User
    // ===================================================================

    JPanel UsersP = new JPanel();
    TitledBorder UsersT;
    UsersT = BorderFactory.createTitledBorder("");
    UsersP.setBorder(UsersT);
    UsersP.setLayout(  new FlowLayout());

    JLabel selectL = new JLabel("Select:");
    UsersP.add(selectL);

//    allUsers =  persistence.CUser.getUsers();
//    allUsersCB = new JComboBox(allUsers);
//    allUsersCB.addActionListener(this);
//    allUsersCB.setActionCommand("selectUser");
//    UsersP.add(allUsersCB);


    newB = new JButton("New User");
    newB.setActionCommand("newUser");
    newB.addActionListener(this);
    UsersP.add(newB);


    editB = new JButton("Edit User");
    editB.setActionCommand("editUser");
    editB.addActionListener(this);
    UsersP.add(editB);


    closeB = new JButton("Close");
    closeB.setActionCommand("close");
    closeB.addActionListener(this);
    UsersP.add(closeB);


    mainP.add(UsersP, BorderLayout.SOUTH);


    // ===================================================================
    // ===== Add User
    // ===================================================================

    JPanel addUserP = new JPanel();
    addUserP.setLayout(new BorderLayout());
    TitledBorder addUserT;
    addUserT = BorderFactory.createTitledBorder("Edit");
    addUserP.setBorder(addUserT);


    //details
    JPanel detailsP = new JPanel();
    detailsP.setLayout(new FlowLayout());
    addUserP.add(detailsP,BorderLayout.NORTH);

    JLabel loginL = new JLabel("RECOCASE Login Name:");
    detailsP.add(loginL);
    loginTF = new JTextField(10);
    detailsP.add(loginTF);

    JLabel nameL = new JLabel("Full Name:");
    detailsP.add(nameL);
    nameTF = new JTextField(10);
    detailsP.add(nameTF);


    JLabel PasswordL1 = new JLabel("password:");
    detailsP.add(PasswordL1);
    passwordTF1 = new JPasswordField(10);
    detailsP.add(passwordTF1);

    JLabel PasswordL2 = new JLabel("re-enter password:");
    detailsP.add(PasswordL2);
    passwordTF2 = new JPasswordField(10);
    detailsP.add(passwordTF2);

    //options
    JPanel optionsP = new JPanel();
    optionsP.setLayout(new FlowLayout());
    addUserP.add(optionsP,BorderLayout.CENTER);

    JLabel adminL = new JLabel("Admin:");
    optionsP.add(adminL);

    adminCB = new JCheckBox();
    adminCB.addItemListener(this);
    optionsP.add(adminCB);

    JLabel analystL = new JLabel("Analyst:");
    optionsP.add(analystL);

    analystCB = new JCheckBox();
    analystCB.addItemListener(this);
    optionsP.add(analystCB);

    JLabel validL = new JLabel("Valid:");
    optionsP.add(validL);

    validCB = new JCheckBox();
    validCB.addItemListener(this);
    optionsP.add(validCB);


    analystCB.setSelected(false);
    validCB.setSelected(false);
    adminCB.setSelected(false);

    //comands
    JPanel addUserCommandP = new JPanel();
    addUserCommandP.setLayout(new FlowLayout());
    addUserP.add(addUserCommandP,BorderLayout.SOUTH);


    saveB = new JButton("Save");
    saveB.setActionCommand("Save");
    saveB.addActionListener(this);
    addUserCommandP.add(saveB);

    cancelB = new JButton("Cancel");
    cancelB.setActionCommand("cancel");
    cancelB.addActionListener(this);
    addUserCommandP.add(cancelB);




    mainP.add(addUserP, BorderLayout.NORTH);

    //this.setSize(800, 300);
    this.setLock(true);
//            nameTF.setEditable(false);
//            loginTF.setEditable(false);
//            passwordTF1.setEditable(false);
//            passwordTF2.setEditable(false);
//            passwordTF1.setEnabled(false);
//            passwordTF2.setEnabled(false);
//
//            adminCB.setEnabled(false);
//            analystCB.setEnabled(false);
//            validCB.setEnabled(false);
//
//            this.saveB.setEnabled(false);
//            this.allUsersCB.setEnabled(true);
//            this.newB.setEnabled(true);
//            this.editB.setEnabled(true);

    this.pack();
    this.show();
  }

 /**-----------------------------------------------------
  *  ITEM STATE CHANGED
  * -----------------------------------------------------
  */

  public void itemStateChanged(ItemEvent e){
    Object source = e.getItemSelectable();
      if (source == adminCB) {
        if( adminCB.isSelected()){
          validCB.setSelected(true);
          analystCB.setSelected(true);
        }
      }
      if (source == analystCB) {
        if( analystCB.isSelected()){
          validCB.setSelected(true);
        }
        else{
          adminCB.setSelected(false);
        }
      }
      if (source == validCB) {
        if(!validCB.isSelected()){
          analystCB.setSelected(false);
          adminCB.setSelected(false);
        }
      }




  }


 /**-----------------------------------------------------
  *  ACTION
  * -----------------------------------------------------
  */

  public void actionPerformed(ActionEvent event) {
    String command = event.getActionCommand();

    if (command.equals("close")){
      this.dispose();
    }else if (command.equals("editUser")){
      user = new gui.GSelectUser().showDialog();
      if(user!=null){
        loginTF.setText(user.getLogin());
        nameTF.setText(user.getName());
        passwordTF1.setText(user.getPassword());
        passwordTF2.setText(user.getPassword());
        adminCB.setSelected(user.isAdmin());
        analystCB.setSelected(user.isAnalyst());
        validCB.setSelected(user.isValid());
        this.setLock(false);
      }
    }else if (command.equals("cancel")){
      user = null;
      loginTF.setText("");
      nameTF.setText("");
      passwordTF1.setText("");
      passwordTF2.setText("");
      adminCB.setSelected(false);
      analystCB.setSelected(false);
      validCB.setSelected(false);

      this.setLock(true);
    }else if (command.equals("newUser")){
      user = null;
      loginTF.setText("");
      nameTF.setText("");
      passwordTF1.setText("");
      passwordTF2.setText("");
      adminCB.setSelected(false);
      analystCB.setSelected(false);
      validCB.setSelected(true);
      //--
      this.setLock(false);
//    }else if (command.equals("selectUser")){
//      this.user = ((business.CUser) allUsers.elementAt(allUsersCB.getSelectedIndex()));
//      loginTF.setText(user.getLogin());
//      nameTF.setText(user.getName());
//      passwordTF1.setText(user.getPassword());
//      passwordTF2.setText(user.getPassword());
//      adminCB.setSelected(user.isAdmin());
//      analystCB.setSelected(user.isAnalyst());
//      validCB.setSelected(user.isValid());

    }else if (command.equals("Save"))
    {
      String ps1 = "";
      String ps2 = "";
      ps1 = new String(passwordTF1.getPassword());
      ps2 = new String(passwordTF2.getPassword());

      boolean userOk = true;
      if(!ps1.equals(ps2)){
        JOptionPane.showMessageDialog(null,"Incorrect password");
        userOk = false;
      }
      else if(nameTF.getText().length()<4 || loginTF.getText().length() < 4){
        JOptionPane.showMessageDialog(null,"Name of user and Login Name must be at least 4 characters long");
        userOk = false;
      }
      else{
        Vector allUsers = persistence.CUser.getUsers();
        for(int i = 0 ; i < allUsers.size();i++){
          //System.out.println(((business.CUser) allUsers.elementAt(i)).getLogin()+ " ==  "+(loginTF.getText()));
          if(((business.CUser) allUsers.elementAt(i)).getLogin().toLowerCase().equals(loginTF.getText().toLowerCase())){
            if (user == null){
              userOk = false;
              JOptionPane.showMessageDialog(null,"Login name taken");
            }else{
              if(((business.CUser) allUsers.elementAt(i)).getId() != user.getId() ){
                userOk = false;
                JOptionPane.showMessageDialog(null,"Login name taken");
              }
            }
          }
        }


      }

      if(userOk){
          if (user == null){
           persistence.CUser.addUser(
             nameTF.getText(),
             loginTF.getText(),
             ps1,
             adminCB.isSelected(),
             analystCB.isSelected(),
             validCB.isSelected()
             );
          }else{
            //System.out.println("UPDATE USER ERROR: NOT IMPLEMENTED");
            user.setLogin(loginTF.getText());
            user.setName(nameTF.getText());
            user.setPassword(ps1);
            user.isAdmin(adminCB.isSelected());
            user.isAnalyst(analystCB.isSelected());
            user.isValid(validCB.isSelected());
            persistence.CUser.updateUser( user);
          }
          this.setLock(true);
      }
    }
  }

  public void setLock(boolean lock){

            lock = !lock;
            nameTF.setEditable(lock);
            loginTF.setEditable(lock);
            passwordTF1.setEditable(lock);
            passwordTF2.setEditable(lock);
            passwordTF1.setEnabled(lock);
            passwordTF2.setEnabled(lock);

            adminCB.setEnabled(lock);
            analystCB.setEnabled(lock);
            validCB.setEnabled(lock);


            //this.allUsersCB.setEnabled(!lock);
            this.editB.setEnabled(!lock);

            this.saveB.setEnabled(lock);
            this.cancelB.setEnabled(lock);
            this.newB.setEnabled(!lock);




  }





}