package gui;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.event.TableModelEvent;
import javax.swing.event.*;


/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */


 /**
  * IMPORTANT when modifing this class remeber that
  * each Agent must have a use case viewpoint
  */


public class CUseCaseProject extends JDialog implements ActionListener,TableModelListener {


  /** constructor
   *  @param usecase to be displayed as a project
   */
  private business.CUsecase usecase;
  private Vector agentV;
  private JTable agentT;

  private boolean delete = false;

  private gui.CTableModel    tableModelActors = null;
  private JComboBox actorCB = new JComboBox();
  private JTable actorsT = null;
  private Vector actorsV = new Vector();

  private Vector users;

  public CUseCaseProject(business.CUsecase UC) {
    super(business.Global.recocase,"",true);
    usecase = UC;
    init();
    this.pack();
    this.show();
  }

  public CUseCaseProject(boolean adelete,business.CUsecase UC) {
    super(business.Global.recocase,"",true);
    delete = adelete;
    usecase = UC;
    init();
    this.pack();
    this.show();

  }

  // gui
  private JTextField nameTF = null;
  private JTextField descriptionTF = null;
  private gui.CTableModel tableModel = null;


  /** initialize gui*/
  private void init() {

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    this.getContentPane().setLayout(gridbag);

    // ===================================================================
    // ===== label name
    // ===================================================================
    JLabel nameL = new JLabel("Name:*");
    c.gridx = 0;
    c.gridy = 0;
    c.insets = new Insets(10, 10, 10, 10);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(nameL, c);
    this.getContentPane().add(nameL);


    // ===================================================================
    // ===== textfield name
    // ===================================================================
    nameTF = new JTextField(30);
    if (usecase.getName() != null)
      nameTF.setText(this.usecase.getName());
    c.gridx = 1;
    c.gridy = 0;
    gridbag.setConstraints(nameTF, c);
    this.getContentPane().add(nameTF);
    if (this.delete)nameTF.disable();

    // ===================================================================
    // ===== label system
    // ===================================================================
    JLabel descriptionL = new JLabel("Description:");
    c.gridx = 0;
    c.gridy = 1;
//    c.insets = new Insets(10, 10, 10, 10);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(descriptionL, c);
    this.getContentPane().add(descriptionL);

    // ===================================================================
    // ===== textfield system
    // ===================================================================
    descriptionTF = new JTextField(30);
    if (this.usecase.getFunctReq() != null)
      descriptionTF.setText(this.usecase.getFunctReq());
    c.gridx = 1;
    c.gridy = 1;
    gridbag.setConstraints(descriptionTF, c);
    this.getContentPane().add(descriptionTF);
    if (this.delete)descriptionTF.disable();


    // ===================================================================
    // ===== label Actors
    // ===================================================================
    JLabel actorsL = new JLabel("Actors:");
    c.gridx = 0;
    c.gridy = 2;
//    c.insets = new Insets(10, 10, 10, 10);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(actorsL, c);
    this.getContentPane().add(actorsL);

    // ========================================================
    // ===== table actors
    // ========================================================


    Vector dataActors = new Vector();
    Vector columnNamesActors = new Vector();
    columnNamesActors.add("Actors");

    JPanel actorsP = new JPanel();
    actorsP.setLayout(new BorderLayout(5, 5));

    tableModelActors = new gui.CTableModel(dataActors, columnNamesActors);

    for (int i=0; this.usecase.getActors() != null &&   i< this.usecase.getActors().size(); i++) {
      Vector newRow = new Vector();
      newRow.add( usecase.getActors().elementAt(i));
      tableModelActors.addRow(newRow);
    }
    actorsT = new JTable(tableModelActors);
    tableModelActors.addTableModelListener(this);
    if(this.delete)this.actorsT.disable();

    TableColumn typeColumnActors = actorsT.getColumnModel().getColumn(0);

    for (int i=0; i<usecase.getProject().getActors().size(); i++) {
      actorCB.addItem( usecase.getProject().getActors().elementAt(i) );//add item
    }
    typeColumnActors.setCellEditor(new DefaultCellEditor(actorCB));

    TableCellRenderer headerRenderer = typeColumnActors.getHeaderRenderer();
    if (headerRenderer instanceof DefaultTableCellRenderer) {
       ((DefaultTableCellRenderer)headerRenderer).setToolTipText(
                     "Click to see the list of actor types");
    }

    actorsT.setPreferredScrollableViewportSize(new Dimension(200, 50));
    JScrollPane actorsTSP = new JScrollPane(actorsT);
//    conditionsPGBC.gridx = 0;
//    conditionsPGBC.gridy = 2;

    JPanel actorsBP = new JPanel();
    actorsBP.setLayout(new BoxLayout(actorsBP, BoxLayout.Y_AXIS));
    JButton actorsNewB = new JButton ("Add");
    actorsNewB.setActionCommand("NewActor");
    actorsNewB.addActionListener(this);
    JButton actorsDeleteB = new JButton ("Remove");
    actorsDeleteB.setActionCommand("DeleteActor");
    actorsDeleteB.addActionListener(this);
    if(!this.delete){
      actorsBP.add(actorsNewB);
      actorsBP.add(actorsDeleteB);
    }
    actorsP.add(actorsTSP, BorderLayout.CENTER);
    actorsP.add(actorsBP, BorderLayout.EAST);


    c.gridx = 1;
    c.gridy = 2;
//    c.insets = new Insets(10, 10, 10, 10);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(actorsP, c);
//    conditionsPGBL.setConstraints(actorsP, conditionsPGBC);
    this.getContentPane().add(actorsP);
//    conditionsP.add(actorsP);


    // ===================================================================
    // ===== agents / viewpoints
    // ===================================================================


    JLabel viewpointL = new JLabel("Agents:");
    c.gridx = 0;
    c.gridy = 3;
    gridbag.setConstraints(viewpointL, c);
    this.getContentPane().add(viewpointL);

    // ===================================================================
    // ===== agents / viewpoints
    // ===================================================================

    final String[] columnNamesVP = {"Agent name","Owner"};

    JPanel viewpointP = new JPanel();
    viewpointP.setLayout(new BorderLayout(5, 5));

    gui.CTableModel tableModelVP = new gui.CTableModel(columnNamesVP, 0);
    agentT = new JTable(tableModelVP);
    if (this.delete)agentT.disable();
    agentV = persistence.CViewpointAgent.getAllAgentsOfUsecase(this.usecase.getId());
    if (agentV != null && agentV.size()>0) {
      for (int i=0; i<agentV.size(); i++) {
        Vector vp  = new Vector();
        vp.add(((business.CViewpointAgent)agentV.elementAt(i)).getName()) ;
        vp.add(((business.CViewpointAgent)agentV.elementAt(i)).getUser().getName());
        tableModelVP.addRow(vp);
      }
    }





    JComboBox usersCB = new JComboBox();
    users = persistence.CUser.getUsers();
    for(int i = 0; i < users.size() ; i++){
      usersCB.addItem(((business.CUser) users.elementAt(i)) );
    }
    TableColumn typeColumnUsers = agentT.getColumnModel().getColumn(1);
    typeColumnUsers.setCellEditor(new DefaultCellEditor(usersCB));




    agentT.setPreferredScrollableViewportSize(new Dimension(350, 70));
    JScrollPane viewpointTSP = new JScrollPane(agentT);
    c.gridx = 1;
    c.gridy = 3;
    JPanel viewpointBP = new JPanel();
    viewpointBP.setLayout(new BoxLayout(viewpointBP, BoxLayout.Y_AXIS));
    JButton viewpointNewB = new JButton ("New Agent");
    viewpointNewB.setActionCommand("newAgent");
    viewpointNewB.addActionListener(this);
    JButton viewpointDeleteB = new JButton ("Delete Agent");
    viewpointDeleteB.setActionCommand("deleteAgent");
    viewpointDeleteB.addActionListener(this);
    JButton refreshB = new JButton ("Refresh");
    refreshB.setActionCommand("refresh");
    refreshB.addActionListener(this);

    if (!this.delete){
      viewpointBP.add(viewpointNewB);
      viewpointBP.add(viewpointDeleteB);
      viewpointBP.add(refreshB);
    }

    viewpointP.add(viewpointTSP, BorderLayout.CENTER);
    viewpointP.add(viewpointBP, BorderLayout.EAST);
    gridbag.setConstraints(viewpointP, c);
    this.getContentPane().add(viewpointP);



    // ===================================================================
    // ===== BUTTONS
    // ===================================================================

    JPanel ButtonsP = new JPanel();
    ButtonsP.setLayout(new BoxLayout(ButtonsP, BoxLayout.X_AXIS));

    JButton saveB = new JButton("Save",business.Global.imageIconSave);
    saveB.setActionCommand("save");
    saveB.addActionListener(this);
    if(!this.delete)  ButtonsP.add(saveB);




    JButton deleteB = new JButton("Delete usecase",business.Global.imageIconDelete);
    deleteB.setActionCommand("delete");
    deleteB.addActionListener(this);
    ButtonsP.add(deleteB);



    JButton closeB;
    if (this.delete)  {  closeB = new JButton("Cancel",business.Global.imageIconClose);}
    else  {  closeB = new JButton("Close",business.Global.imageIconClose);     }
    closeB.setActionCommand("close");
    closeB.addActionListener(this);
    ButtonsP.add(closeB);



    c.gridx = 1;
    c.gridy = 4;
    gridbag.setConstraints(ButtonsP, c);
    this.getContentPane().add(ButtonsP);

  }


    // ===================================================================
    // ===== action
    // ===================================================================

  /** is called if the user wants to add or delete a vp */

  public void actionPerformed(ActionEvent e) {
    editingStopped();
    if(business.Global.user.isAnalyst()){
      // new relation between shared use case and an actor
      if(e.getActionCommand().equals("NewActor")) {
        this.refresh();
        if( usecase.getProject().getActors().size()>0){
          boolean notDone = true;
          Vector newRow = new Vector();
          // newRow.add(new String(""));
          if (this.actorsV.size()==0 ){
            usecase.setActors(new Vector());
            newRow.add( usecase.getProject().getActors().elementAt(0) );
            notDone = false;
          }else{
            for(  int i = 0; notDone && i < usecase.getProject().getActors().size();i++){
              boolean found = true;
              for(int j = 0; j <this.actorsV.size();j++){
                //System.out.println(i+":"+usecase.getProject().getActors().size());
                if(((business.CActor) usecase.getProject().getActors().elementAt(i)).getId()==
                   ((business.CActor) this.actorsV.elementAt(j)).getId() )
                {
                  found =false;
                }
              }//for
              if(found){
                newRow.add( usecase.getProject().getActors().elementAt(i));
                notDone = false;
              }//if
            }//for
          }//if
          if(notDone){
            JOptionPane.showMessageDialog(null,"usecase contains already all actors of project");
          }else{
            //usecase.getActors().add(new business.CActor());
            tableModelActors.addRow(newRow);
          }
        }else{
         JOptionPane.showMessageDialog(null,"there are no actors in this project");
        }
        //this.fixActors(); no need

      } else if (e.getActionCommand().equals("DeleteActor")) {
        if(!actorsT.isEditing()){
          tableModelActors.removeRow(actorsT.getSelectedRow()); //will fix actors due to listener
        }else{
            JOptionPane.showMessageDialog(null ,"Please finish editing table");
        }
        //this.fixActors(); no need
      }


      //-----------------------
      else if(e.getActionCommand().equals("newAgent")) {
        saveAgents();
        gui.CViewpointAgentNewD dialog = new gui.CViewpointAgentNewD(null, this.usecase);
        this.refresh();
      } else if (e.getActionCommand().equals("deleteAgent")) {
        saveAgents();
        deleteAgent();
      } else if (e.getActionCommand().equals("save")) {
        save();
      }else if (e.getActionCommand().equals("refresh")) {
        this.refresh();
      }else if (e.getActionCommand().equals("delete")) {
        delete();
      } else if (e.getActionCommand().equals("close")) {
        if (this.delete){
          this.dispose();
        }else{

          //save();
          int option;
          option = JOptionPane.showConfirmDialog(null,"Do you want to save","Save",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
          if (option == JOptionPane.OK_OPTION){
            this.dispose();
            save();
          }
          if (option == JOptionPane.NO_OPTION){
            this.dispose();
          }
          if (option == JOptionPane.CANCEL_OPTION){
          }
        }
      }
    }else{
      contr.CError.showNoRights(business.Global.recocase);
    }
  }

  public void refresh(){
    refreshActors();
    refreshAgents();
  }

  public void refreshActors (){
    //==================
    //actors
    //==================
    actorsV.clear();
    Vector allActors = persistence.CActor.getAllActorOfProject(this.usecase.getProject().getId());
    for(int i = 0; i < this.actorsT.getRowCount() ; i++){
      for(int y = 0; y < allActors.size() ; y++){
        long actorInTable = ((business.CActor )this.actorsT.getModel().getValueAt(i,0)).getId();
        long actorInDB = ((business.CActor )allActors.elementAt(y)).getId() ;
        if(actorInTable == actorInDB){
          if (actorsV.contains(allActors.elementAt(y))){
            JOptionPane.showMessageDialog(null,(((business.CActor )allActors.elementAt(y)).getType()) +" is in the table more than once");
          }else{
            actorsV.add(allActors.elementAt(y));
          }
        }//if
      }//for
    }//for
  }

    //==================
    //agents
    //==================

  public void refreshAgents(){
    final String[] columnNamesVP = {"Agent name","Owner"};
    gui.CTableModel tableModelVP = new gui.CTableModel(columnNamesVP, 0);
    agentV = persistence.CViewpointAgent.getAllAgentsOfUsecase(this.usecase.getId());
    if (agentV != null && agentV.size()>0) {
      for (int i=0; i<agentV.size(); i++) {
        Vector vp  = new Vector();
        vp.add(((business.CViewpointAgent)agentV.elementAt(i)).getName()) ;
        vp.add(((business.CViewpointAgent)agentV.elementAt(i)).getUser().getName());
        tableModelVP.addRow(vp);
      }
    }
    agentT.setModel(tableModelVP);

    JComboBox usersCB = new JComboBox();
    users = persistence.CUser.getUsers();
    for(int i = 0; i < users.size() ; i++){
      usersCB.addItem(((business.CUser) users.elementAt(i)) );
    }
    TableColumn typeColumnUsers = agentT.getColumnModel().getColumn(1);
    typeColumnUsers.setCellEditor(new DefaultCellEditor(usersCB));

  }




  public void editingStopped(){
    DefaultCellEditor editor  =(DefaultCellEditor)this.agentT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();
    editor  =(DefaultCellEditor)this.actorsT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();

  }

  public void delete(){
    boolean error = false;
    String errorMSG = "Cant delete Use Case\n\n";
    if(business.Global.contrUsecase.isOpen(this.usecase)){
      error = true;
      errorMSG = errorMSG + "Use case is open \n\n";
    }
    Vector openVP = business.Global.contrViewpoint.getOpenViewpointsOfUc(this.usecase);
    if(openVP.size() > 0){
      error = true;
      errorMSG = errorMSG + "These viewpoints that belong to the usecase are open:\n\n";
      for(int i = 0;i<openVP.size();i++){
        errorMSG = errorMSG +"   "+((business.CViewpoint) openVP.elementAt(i)).getName()+"      Type: "+((business.CViewpoint) openVP.elementAt(i)).getType() +"\n";
      }
    }
    if(error){
      JOptionPane.showMessageDialog(null,errorMSG,"Error",JOptionPane.ERROR_MESSAGE);
      if( this.delete)this.dispose(); //dispose of frame
    }else{
      int sure = JOptionPane.showConfirmDialog(
          this,
          "THIS WILL DELETE ALL\n"+
          "(the use case, use case viewpoints and scenarios viewpoints)\n\n"+
          "Do you want to continue? ",
          "Delete",
          JOptionPane.YES_NO_OPTION);
      if (sure == JOptionPane.YES_OPTION){
        persistence.CUsecase.deleteUsecase(this.usecase);
        this.dispose();
      }
    }
  }


  private void fixActors(){
    Vector actorsInUse = persistence.CActor.actorsInUse(this.usecase);
    for (int i = 0; i < actorsInUse.size(); i++)
    {
      boolean found = false;
      //System.out.println(">t>"+((business.CActor)   actorsInUse.elementAt(i)).getType());

      for (int j=0; j< this.actorsT.getRowCount(); j++) {
        if  (   ((business.CActor)this.actorsT.getModel().getValueAt(j,0)).getId()   ==
              (   ((business.CActor) actorsInUse.elementAt(i)).getId()  )  )
        {
            found = true;
        }
      }//for
      if(!found){
          JOptionPane.showMessageDialog(null ,"This actor is in use by a viewpoint or Scenario: "+
              ((business.CActor) actorsInUse.elementAt(i)).getType()+
              "\n\n"+
              "This actor has beeen added to the usecase"
          );
          Vector newRow = new Vector();
          newRow.add( actorsInUse.elementAt(i));
          tableModelActors.addRow(newRow);
      }
    }//if found
    usecase.setActors(this.actorsV);
  }//for

  public void tableChanged(TableModelEvent e) {
    this.refresh();
  }

  public void save(){
    Vector VP = business.Global.contrViewpoint.getOpenViewpointsOfUc(this.usecase);
    if(VP.size()>0){
      String warning  = "W A R N I N G : This Changes will not take place \n"+
                        "until you reopen the viewpoints that belong to this use case:"+this.usecase.getName() +"\n\nViewpoints:\n";
      for(int i = 0 ; i<VP.size() ; i ++){
        warning = warning + ((business.CViewpoint) VP.elementAt(i)).getName()+"\n";
      }
      JOptionPane.showMessageDialog(null , warning,"Warning",JOptionPane.WARNING_MESSAGE );
    }
    if(nameTF.getText().equals("")){
          nameTF.setText("No name");
          JOptionPane.showMessageDialog(null,"No Name?");
    }
    this.fixActors();
    this.refreshActors();
    this.usecase.setName(nameTF.getText());
    this.usecase.setFunctReq(descriptionTF.getText());
    this.usecase.setActors(this.actorsV);
    persistence.CUsecase.updateUsecase(this.usecase);
    saveAgents();
      //((business.CViewpointAgent) agentV.elementAt(i)).setUser( this.agentT.getValueAt(0,0).getClass().toString());

  }

  public void saveAgents() {
   for(int i = 0; i<this.agentV.size();i++){
      business.CViewpointAgent agent = (business.CViewpointAgent) agentV.elementAt(i);
      agent.setName( this.agentT.getValueAt(i,0).toString());
      for(int x = 0; x<this.users.size();x++){
        //System.out.println("["+((business.CUser)users.elementAt(x)).getName() +"=="+ this.agentT.getValueAt(i,1)+"]");
        if(((business.CUser)users.elementAt(x)).getName().toString().equals(this.agentT.getValueAt(i,1).toString())){
          //System.out.println( ((business.CUser)users.elementAt(x)).getName() +"= is ="+ this.agentT.getValueAt(i,1));
          agent.setUser( (business.CUser)users.elementAt(x));
        }
      }
      persistence.CViewpointAgent.UpdateAgent(agent);
    }
  }

  public void deleteAgent(){
    int selected =  this.agentT.getSelectedRow();
    boolean error = false;
    String errorMSG ="Cant delete this Agent: You must first close the following Viewpoints:\n\n";
    if(selected >-1 && selected < this.agentV.size()){
    Vector VP = business.Global.contrViewpoint.getOpenViewpointsOfUc(this.usecase);
      if(VP.size()>0){
        business.CViewpointAgent VPAgent =((business.CViewpointAgent) agentV.elementAt(selected) );
        for(int i = 0 ; i<VP.size() ; i ++){
          business.CViewpoint aVP = ((business.CViewpoint)VP.elementAt(i));
          if(aVP.getViewpointAgent().getId() == VPAgent.getId()){
            errorMSG = errorMSG + aVP.getName()+"\n";
            error = true;
          }
        }
      }
      if(error){
        JOptionPane.showMessageDialog(null , errorMSG ,"",JOptionPane.WARNING_MESSAGE );
      } else {
        int sure = JOptionPane.showConfirmDialog(
        this,
        "Are you sure?  (This will delete the usecase viewpoint and all scenarios that belong to this agent)",
        "Delete",
        JOptionPane.YES_NO_OPTION,JOptionPane.WARNING_MESSAGE  );
        if (sure == JOptionPane.YES_OPTION){
          persistence.CViewpointAgent.deleteAgent(((business.CViewpointAgent) agentV.elementAt(selected)).getId() );
        }
      }
    }
    this.refresh();
  }
}