package gui;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: An object of this class is part of a frame to capture
 * data of a shared use case.
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CUseCaseP extends JPanel implements ActionListener {

    /** current use case */
    private business.CUsecase usecase = null;

    // gui
    private JTextField nameTF = null;
    private JTextArea functReqTA = null;
    private JTextArea triggerTA = null;
    private gui.GConditionP preconditionsP = null;
    private gui.GConditionP successEndconditionsP = null;
    private gui.GConditionP failedEndconditionsP = null;
    private JComboBox actorCB = new JComboBox();

    private JTabbedPane mainSuccessScenarioTP = null;
    private JTabbedPane extensionsTP = null;
    private JTabbedPane subvariationsTP = null;
    private gui.GStyle2P style2PMain = null;
    private gui.GStyle2P style2PExt = null;
    //private gui.GStyle2P style2PSub = null;

    private Object parent = null;

    // ====== actor
    private gui.CTableModel tableModelActors = null;
    private JTable actorsT = null;
    private final String[] columnNamesActors = {
      "actor",
    };
    private final Object[][] dataActors = {};

    /** observer to update success scenario, extensions, variations */
    private business.CObserver observerStrT1 = null;


  /** constructor
   *  @param AParent parent
   *  @param AUsecase shared use case
   */
  public CUseCaseP(Object AParent, business.CUsecase AUsecase) {

    parent = AParent;
    usecase = AUsecase;
    observerStrT1 = new business.CObserver();

    init();
  }

  /** initializes panel */
  private void init() {

    JPanel useCaseP = new JPanel();

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    useCaseP.setLayout(gridbag);





    // ========================================================
    // ===== label name
    // ========================================================

    JLabel nameL = new JLabel("name:*");
    c.gridx = 0;
    c.gridy = 0;
    gridbag.setConstraints(nameL, c);
    useCaseP.add(nameL);


    // ========================================================
    // ===== textfield name
    // ========================================================

    nameTF = new JTextField(70);
    if (usecase.getName() != null)
      nameTF.setText(usecase.getName());
    c.gridx = 1;
    c.gridy = 0;
    gridbag.setConstraints(nameTF, c);
    useCaseP.add(nameTF);

    // ========================================================
    // ===== label funct. requirement
    // ========================================================

    JLabel functReqL = new JLabel("goal:");
    c.gridx = 0;
    c.gridy = 1;
    c.insets = new Insets(1, 1, 1, 1);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(functReqL, c);
    useCaseP.add(functReqL);

    // ========================================================
    // ===== textarea funct. requirement
    // ========================================================

    functReqTA = new JTextArea(1, 70);
    if (usecase.getFunctReq() != null)
      functReqTA.setText(usecase.getFunctReq());
    JScrollPane functReqTASP = new JScrollPane(functReqTA);
    c.gridx = 1;
    c.gridy = 1;
    gridbag.setConstraints(functReqTASP, c);
    useCaseP.add(functReqTASP);

    // ========================================================
    // ===== panel conditions
    // ========================================================
    JPanel conditionsP = new JPanel();
    GridBagLayout conditionsPGBL = new GridBagLayout();
    GridBagConstraints conditionsPGBC = new GridBagConstraints();
    conditionsPGBC.anchor = GridBagConstraints.NORTHWEST;
    conditionsPGBC.insets = new Insets(1, 1, 1,1 );
    conditionsP.setLayout(conditionsPGBL);

    // ========================================================
    // ===== label system
    // ========================================================

    JLabel systemL = new JLabel("system: "+usecase.getProject().getSystem());
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 0;
    conditionsPGBL.setConstraints(systemL, conditionsPGBC);
    conditionsP.add(systemL);

    // ========================================================
    // ===== label systemName
    // ========================================================

//    JLabel systemNameL = new JLabel(usecase.getProject().getSystem());
//    conditionsPGBC.gridx = 1;
//    conditionsPGBC.gridy = 0;
//    conditionsPGBL.setConstraints(systemNameL, conditionsPGBC);
//    conditionsP.add(systemNameL);

    // ========================================================
    // ===== label actors
    // ========================================================
    JLabel actorsL = new JLabel("actors:");
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 1;
    conditionsPGBL.setConstraints(actorsL, conditionsPGBC);
    conditionsP.add(actorsL);

    // ========================================================
    // ===== table actors
    // ========================================================

    JPanel actorsP = new JPanel();
    actorsP.setLayout(new BorderLayout(5, 5));

    tableModelActors = new gui.CTableModel(dataActors, columnNamesActors);
    for (int i=0;
         usecase.getActors() != null &&
         i<usecase.getActors().size();
         i++) {
      Vector newRow = new Vector();
      newRow.add(((business.CActor) usecase.getActors().elementAt(i)).getType());
      tableModelActors.addRow(newRow);
    }
    actorsT = new JTable(tableModelActors);

    TableColumn typeColumnActors = actorsT.getColumnModel().getColumn(0);
    for (int i=0; i<usecase.getProject().getActors().size(); i++) {
      actorCB.addItem(
        ((business.CActor) usecase.getProject().getActors().elementAt(i)).getType()
      );
    }
    typeColumnActors.setCellEditor(new DefaultCellEditor(actorCB));

    TableCellRenderer headerRenderer = typeColumnActors.getHeaderRenderer();
    if (headerRenderer instanceof DefaultTableCellRenderer) {
       ((DefaultTableCellRenderer)headerRenderer).setToolTipText(
                     "Click to see the list of actor types");
    }

    actorsT.setPreferredScrollableViewportSize(new Dimension(200, 50));
    JScrollPane actorsTSP = new JScrollPane(actorsT);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 2;

    JPanel actorsBP = new JPanel();
    actorsBP.setLayout(new BoxLayout(actorsBP, BoxLayout.Y_AXIS));
    JButton actorsNewB = new JButton ("New");
    actorsNewB.setActionCommand("NewActor");
    actorsNewB.addActionListener(this);
    JButton actorsDeleteB = new JButton ("Delete");
    actorsDeleteB.setActionCommand("DeleteActor");
    actorsDeleteB.addActionListener(this);
    actorsBP.add(actorsNewB);
    actorsBP.add(actorsDeleteB);

    actorsP.add(actorsTSP, BorderLayout.CENTER);
    actorsP.add(actorsBP, BorderLayout.EAST);

    conditionsPGBL.setConstraints(actorsP, conditionsPGBC);
    conditionsP.add(actorsP);

    // ========================================================
    // ===== label trigger
    // ========================================================

    JLabel triggerL = new JLabel("trigger:");
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 3;
    conditionsPGBL.setConstraints(triggerL, conditionsPGBC);
    conditionsP.add(triggerL);

    // ========================================================
    // ===== textarea trigger
    // ========================================================

    triggerTA = new JTextArea(4, 25);
    if (usecase.getTrigger() != null)
      triggerTA.setText(usecase.getTrigger());
    JScrollPane triggerTASP = new JScrollPane(triggerTA);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 4;
    conditionsPGBL.setConstraints(triggerTASP, conditionsPGBC);
    conditionsP.add(triggerTASP);

    // ========================================================
    // ===== label preconditions
    // ========================================================
    JLabel preconditionsL = new JLabel("Preconditions:");
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 5;
    conditionsPGBL.setConstraints(preconditionsL, conditionsPGBC);
    conditionsP.add(preconditionsL);

    // ========================================================
    // ===== table preconditions
    // ========================================================

    preconditionsP = new gui.GConditionP(usecase.getPrecond(),business.Global.kindDataPreCond);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 6;
    conditionsPGBL.setConstraints(preconditionsP, conditionsPGBC);
    conditionsP.add(preconditionsP);

    // ========================================================
    // ===== label Success Endconditions
    // ========================================================
    JPanel successEndconditionsLP = new JPanel();
    successEndconditionsLP.setLayout(
      new BoxLayout(successEndconditionsLP, BoxLayout.Y_AXIS));
    successEndconditionsLP.add(new JLabel("Success End Conditions:"));
//    successEndconditionsLP.add(new JLabel("endconditions:"));
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 7;
    conditionsPGBL.setConstraints(successEndconditionsLP, conditionsPGBC);
    conditionsP.add(successEndconditionsLP);

    // ========================================================
    // ===== table Success Endcondtions
    // ========================================================

    successEndconditionsP = new gui.GConditionP(usecase.getSuccessEndcond(),business.Global.kindDataSuccessEndCond);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 8;
    conditionsPGBL.setConstraints(successEndconditionsP, conditionsPGBC);
    conditionsP.add(successEndconditionsP);

    // ========================================================
    // ===== label failed endconditions
    // ========================================================
    JPanel failedEndconditionsLP = new JPanel();
    failedEndconditionsLP.setLayout(
      new BoxLayout(failedEndconditionsLP, BoxLayout.Y_AXIS));
    failedEndconditionsLP.add(new JLabel("Failed End Conditions:"));
//    failedEndconditionsLP.add(new JLabel("endconditions:"));
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 9;
    conditionsPGBL.setConstraints(failedEndconditionsLP, conditionsPGBC);
    conditionsP.add(failedEndconditionsLP);

    // ========================================================
    // ===== table failed endcondtions
    // ========================================================

    failedEndconditionsP = new gui.GConditionP(usecase.getFailedEndcond(),business.Global.kindDataFailedEndCond);
    conditionsPGBC.gridx = 0;
    conditionsPGBC.gridy = 10;
    conditionsPGBL.setConstraints(failedEndconditionsP, conditionsPGBC);
    conditionsP.add(failedEndconditionsP);

    // ========================================================
    // ===== panel actions
    // ========================================================
    JPanel actionsP = new JPanel();
    GridBagLayout actionsPGBL = new GridBagLayout();
    GridBagConstraints actionsPGBC = new GridBagConstraints();
    actionsPGBC.anchor = GridBagConstraints.NORTHWEST;
    actionsPGBC.insets = new Insets(1, 1, 1, 1);
    actionsP.setLayout(actionsPGBL);

    // ========================================================
    // ===== label main success scenario
    // ========================================================

    JPanel mainSuccessScenarioLP = new JPanel();
    mainSuccessScenarioLP.setLayout(
      new BoxLayout(mainSuccessScenarioLP, BoxLayout.Y_AXIS));
    mainSuccessScenarioLP.add(new JLabel("Success Main Flow:"));
//    mainSuccessScenarioLP.add(new JLabel("Main Flow:"));
    actionsPGBC.gridx = 0;
    actionsPGBC.gridy = 0;
    actionsPGBL.setConstraints(mainSuccessScenarioLP, actionsPGBC);
    actionsP.add(mainSuccessScenarioLP);

    // ========================================================
    // ===== table main success scenario
    // ========================================================

    mainSuccessScenarioTP = new JTabbedPane();

    style2PMain = new GStyle2P(parent, usecase.getSuccessScenarioT1(),
      business.Global.kindDataSuccessSc, usecase.getExtensionT1(),
      usecase.getSubvariationT1(), observerStrT1);
    observerStrT1.addListener(style2PMain);
    mainSuccessScenarioTP.addTab("Style ***", style2PMain);
    mainSuccessScenarioTP.setPreferredSize(new Dimension(600, 310));
    mainSuccessScenarioTP.setSelectedComponent(style2PMain);

    actionsPGBC.gridx = 0;
    actionsPGBC.gridy = 1;
    actionsPGBL.setConstraints(mainSuccessScenarioTP, actionsPGBC);
    actionsP.add(mainSuccessScenarioTP);

    // ========================================================
    // ===== label extensions
    // ========================================================

    JLabel extensionsL = new JLabel("Extensions:");
    actionsPGBC.gridx = 0;
    actionsPGBC.gridy = 2;
    actionsPGBL.setConstraints(extensionsL, actionsPGBC);
    actionsP.add(extensionsL);

    // ========================================================
    // ===== table extensions
    // ========================================================

    extensionsTP = new JTabbedPane();

    style2PExt = new GStyle2P(parent, usecase.getSuccessScenarioT1(),
      business.Global.kindDataExtension, usecase.getExtensionT1(),
      usecase.getSubvariationT1(), observerStrT1);
    observerStrT1.addListener(style2PExt);
    extensionsTP.addTab("Style ***", style2PExt);
    extensionsTP.setPreferredSize(new Dimension(600, 250));
    extensionsTP.setSelectedComponent(style2PExt);
    actionsPGBC.gridx = 0;
    actionsPGBC.gridy = 3;
    actionsPGBL.setConstraints(extensionsTP, actionsPGBC);
    actionsP.add(extensionsTP);

    // ========================================================
    // ===== label subvariations
    // ========================================================

//    JLabel subvariationsL = new JLabel("Subvariations:");
//    actionsPGBC.gridx = 0;
//    actionsPGBC.gridy = 4;
//    actionsPGBL.setConstraints(subvariationsL, actionsPGBC);
//    actionsP.add(subvariationsL);

    // ========================================================
    // ===== table subvariations
    // ========================================================

//    subvariationsTP = new JTabbedPane();
//    style2PSub = new GStyle2P(parent, usecase.getSuccessScenarioT1(),
//      business.Global.kindDataVariation,
//      usecase.getExtensionT1(),
//      usecase.getSubvariationT1(),
//      observerStrT1);
//    observerStrT1.addListener(style2PSub);
//    subvariationsTP.addTab("Style ***", style2PSub);
//
//    subvariationsTP.setSelectedComponent(style2PSub);
//
//    actionsPGBC.gridx = 0;
//    actionsPGBC.gridy = 5;
//    actionsPGBL.setConstraints(subvariationsTP, actionsPGBC);
//    actionsP.add(subvariationsTP);

    // ========================================================
    this.setLayout(new BorderLayout(1, 1));

    useCaseP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(""),
        BorderFactory.createEmptyBorder(1,1,1,1)
      )
    );
    this.add(useCaseP, BorderLayout.NORTH);

    conditionsP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(""),
        BorderFactory.createEmptyBorder(1,1,1,1)
      )
    );
    this.add(conditionsP, BorderLayout.CENTER);

    actionsP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(""),
        BorderFactory.createEmptyBorder(1,1,1,1)
      )
    );
    this.add(actionsP, BorderLayout.EAST);
  }

  /** is called if the user wants to attach a new relation between shared use case and an actor
   *  or delete a relation between shared use case and an actor
   */
  public void actionPerformed(ActionEvent e) {
    editingStopped();




    // new relation between shared use case and an actor
    if(e.getActionCommand().equals("NewActor")) {
      this.fixActors();//in business.usecase
      if(usecase.getProject().getActors() != null && usecase.getProject().getActors().size()>0){
        boolean notDone = true;
        Vector newRow = new Vector();

        // newRow.add(new String(""));
        if (usecase.getActors() == null || usecase.getActors().size()==0 ){
          usecase.setActors(new Vector());
          newRow.add(((business.CActor) usecase.getProject().getActors().elementAt(0)).getType());
          notDone = false;
        }else{
          for(  int i = 0; notDone && i < usecase.getProject().getActors().size();i++){
            boolean found = true;
            for(int j = 0;         j < usecase.             getActors().size() ; j++){
              //System.out.println(i+":"+usecase.getProject().getActors().size());
              if(((business.CActor) usecase.getProject().getActors().elementAt(i)).getType().equals(
                 ((business.CActor) usecase.             getActors().elementAt(j)).getType() ))
              {
                found =false;
              }
            }//for
            if(found){
              newRow.add(((business.CActor) usecase.getProject().getActors().elementAt(i)).getType());
              notDone = false;
            }//if
          }//for
        }//if
        if(notDone){
          JOptionPane.showMessageDialog(null,"usecase contains already all actors of project");
        }else{
          usecase.getActors().add(new business.CActor());
          tableModelActors.addRow(newRow);
        }

      }else{
       JOptionPane.showMessageDialog(null,"there are no actors in this project");
      }
    // delete relation between shared use case and an actor
    } else if (e.getActionCommand().equals("DeleteActor")) {
      if(!actorsT.isEditing()){
        ListSelectionModel rowSM = actorsT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        int maxIndex = rowSM.getMaxSelectionIndex();

        for(int i=minIndex; i!=-1 && i<=maxIndex; i++) {
          tableModelActors.removeRow(minIndex);
          usecase.getActors().removeElementAt(minIndex);
             // !!!minIndex, because previous row is already deleted
        }
      }else{
          JOptionPane.showMessageDialog(null ,"Please finish editing table");
      }
    }
  }

  /** reads user input from gui and returns the shared use case object */
  public business.CUsecase getUsecase() {
    editingStopped();

    if(nameTF.getText().equals("") || nameTF.getText() == null)business.Global.error = true;
    fixActors();
    usecase.setName(nameTF.getText());
    usecase.setFunctReq(functReqTA.getText());
    usecase.setTrigger(triggerTA.getText());
    usecase.setPrecond(preconditionsP.getConditions());
    usecase.setSuccessEndcond(successEndconditionsP.getConditions());
    usecase.setFailedEndcond(failedEndconditionsP.getConditions());
    usecase.setStyle(mainSuccessScenarioTP.getSelectedIndex()+1);
    usecase.setSuccessScenarioT1(style2PMain.getStepStrT1());
    usecase.setExtensionT1(style2PExt.getStepStrT1());
    //usecase.setSubvariationT1(style2PSub.getStepStrT1());

    return usecase;
  }


  private boolean fixActors(){
        if (!fixActors2())fixActors2();
        return true;
  }

  //@returns false if the actors in table are incorrect and it will fix the table
  //@returns true if the actors in table are correct and it will fix the Usecase
  private boolean fixActors2(){
    boolean error = false;
    for (int i = 0;
         usecase.getActors() != null &&
         i < usecase.getActors().size();
         i++) {
      String actorS = (String) tableModelActors.getValueAt(i, 0);
      business.CActor actor = null;
      for (int j=0; j<usecase.getProject().getActors().size(); j++) {
        if (actorS.equals(
             ((business.CActor) usecase.getProject().getActors().elementAt(j)).getType())
           )
          actor = (business.CActor) usecase.getProject().getActors().elementAt(j);
      }
      usecase.getActors().setElementAt(actor, i);
    }


    Vector actorsInUse = persistence.CActor.actorsInUse(this.usecase);
    for (int i = 0; i < actorsInUse.size(); i++)
    {
      boolean found = false;
      for (int j=0; j<usecase.getActors().size(); j++) {
        if(usecase.getActors().elementAt(j)!= null){
          if (((business.CActor) usecase.getActors().elementAt(j)).getType().equals(
              ((business.CActor)         actorsInUse.elementAt(i)).getType()))
          {
            found = true;
          }
        }
      }
      if(!found){
          Vector newRow = new Vector();
          newRow.add(new String(((business.CActor) actorsInUse.elementAt(i)).getType()));
          tableModelActors.addRow(newRow);

          if (usecase.getActors() == null)
            usecase.setActors(new Vector());
          usecase.getActors().add(new business.CActor());
          error = true;

          JOptionPane.showMessageDialog(null ,"This actor is in use by a viewpoint or Scenario: "+
              ((business.CActor) actorsInUse.elementAt(i)).getType()+
              "\n\n"+
              "This actor has beeen added to the Usecase"
          );

      }
    }
    return (!error);
  }



  public void reload(){

    this.preconditionsP.reload();
    this.failedEndconditionsP.reload();
    this.successEndconditionsP.reload();

    style2PMain.receiveMessage( business.CObserver.Reload_Screen);
    style2PExt.receiveMessage( business.CObserver.Reload_Screen);
    //style2PSub.receiveMessage( business.CObserver.Reload_Screen);
  }

  public void editingStopped(){
    DefaultCellEditor editor  =(DefaultCellEditor)actorsT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();
  }

  public void moveItem(int i){
    //this.style2PMain.moveItem(i);
  }
  public void selectItem(int i){
    this.style2PMain.selectItem(i);
  }
  public void insertItemMain(String s, int i){
    this.style2PMain.insertStep(new business.CStepStrT1(-1,0,"",s,""), i);
  }
  public void insertItemExt(String s,int i){
    this.style2PExt.insertStep(new business.CStepStrT1(-1,0,"",s,""), i);
  }

//  public void insertItemSub(String s,int i){
//    this.style2PSub.insertStep(new business.CStepStrT1(-1,0,"",s,""), i);
//  }


}

