package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: creates a dialog to choose a shared use case from a combobox to
 * open this shared use case
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CUseCaseOpenD extends JDialog {

  /** this dialog */
  private CUseCaseOpenD dialogD = null;
  /** current chosen shared use case */
  private business.CUsecase useCase = null;
  /** vector of all shared use cases of the project which is opened at the moment */
  private Vector useCaseV = null;
  /** Combobox for shared use cases */
  private JComboBox nameCB = null;

  /** constructor
   *  @param parent of the dialog
   *  @param AUsecaseV vector of shared use cases
   */
  public CUseCaseOpenD(JFrame AParent, Vector AUseCaseV) {

    super(AParent, "Open Use Case", true); // not true
    useCaseV = AUseCaseV;
    dialogD = this;
    business.Global.contrUsecase.setDialog(this);
    init();
    pack();
  }

  /** initializes dialog */
  private void init() {

    JPanel useCaseP = new JPanel();
    useCaseP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));

    JLabel nameL = new JLabel("name:");
    useCaseP.add(nameL);

    nameCB = new JComboBox();
    for (int i=0; i<useCaseV.size(); i++) {
      nameCB.addItem(((business.CUsecase)useCaseV.elementAt(i)).getName());
    }
    useCaseP.add(nameCB);

    // button to open shared use case
    final JButton openB = new JButton("Open Use Case",business.Global.imageIconSUC);
    openB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (nameCB.getSelectedIndex() != -1) {
          business.Global.contrUsecase.openUsecase(
            (business.CUsecase) useCaseV.elementAt(nameCB.getSelectedIndex()));
          business.Global.contrRecocase.showUseCase();
        } else {
          business.Global.contrUsecase.openUsecase(null);
        }
      }
    });

    // button to open shared use case Minimised
    final JButton openMB = new JButton("Open (Minimised)",business.Global.imageIconMinimize);
    openMB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (nameCB.getSelectedIndex() != -1) {
          business.Global.contrUsecase.openUsecase(
            (business.CUsecase) useCaseV.elementAt(nameCB.getSelectedIndex()));
        } else {
          business.Global.contrUsecase.openUsecase(null);
        }
      }
    });



    // button to cancel
    JButton cancelB = new JButton("Cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dialogD.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));

    buttonP.add(openMB);
    buttonP.add(openB);
    buttonP.add(cancelB);

    getContentPane().add(useCaseP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        dialogD.dispose();
     }
    });
  }

  /** shows dialog */
  public void showDialog() {
    dialogD.setLocationRelativeTo(null);
    dialogD.setVisible(true);
  }
}
