package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: An object of this class is created if user wants to open
 * an existing shared use case.
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CUseCaseF extends JFrame implements ActionListener {


  ImageIcon imageIcon = null;

  /** this frame */
  JFrame frameF = null;
  /** button to save shared use case */
  private JButton saveB = null;
  private JButton helpB = null;
  private JButton verifyB = null;
  private JButton closeB = null;
  private JButton minimizeB = null;
  private JButton documentB = null;


  /** constructor
   *  @param AUsecase shared use case to be opened
   */
  public CUseCaseF(business.CUsecase AUsecase) {
    super("Use Case");
    frameF = this;
    business.Global.contrUsecase.setFrame(this);
    init(AUsecase);
    pack();
  }

  /** initializes frame */
  private gui.CUseCaseP usecaseP ;

  private void init(business.CUsecase AUsecase) {

    // panel for data of shared use case
    usecaseP = new gui.CUseCaseP(this, AUsecase);





    // button to save use case viewpoint

    saveB = new JButton("Save",business.Global.imageIconSave);
    saveB.setActionCommand("Save");
    saveB.addActionListener(this);

    // button to check if user followed the guidelines
    verifyB = new JButton("Verify",business.Global.imageIconVerify);
    verifyB.setActionCommand("Verify");
    verifyB.addActionListener(this);

    // button to check if user followed the guidelines
    helpB = new JButton("Help",business.Global.imageIconHelp);
    helpB.setActionCommand("Help");
    helpB.addActionListener(this);

    // button to check if user followed the guidelines
    documentB = new JButton("Create Document",business.Global.imageIconDocument);
    documentB.setActionCommand("Document");
    documentB.addActionListener(this);


    // button to close
    closeB = new JButton("Close",business.Global.imageIconClose);
    closeB.setActionCommand("Close");
    closeB.addActionListener(this);
    // button to minimize
    minimizeB = new JButton("Minimize",business.Global.imageIconMinimize);
    minimizeB.setActionCommand("Minimize");
    minimizeB.addActionListener(this);











//    // button to update data of shared use case
//    imageIcon = new ImageIcon(business.Global.getImagePath() + business.Global.imageIconSave);
//    saveB = new JButton("Save",imageIcon);
//    saveB.setActionCommand("Save");
//    saveB.addActionListener(this);
//
//    // button to check if user followed the guidelines
//    imageIcon = new ImageIcon(business.Global.getImagePath() + business.Global.imageIconHelp);
//    helpB = new JButton("Help",imageIcon);
//    helpB.setActionCommand("Help");
//    helpB.addActionListener(this);
//
//    // button to check if user followed the guidelines
//    imageIcon = new ImageIcon(business.Global.getImagePath() + business.Global.imageIconVerify);
//    verifyB = new JButton("Verify",imageIcon);
//    verifyB.setActionCommand("Verify");
//    verifyB.addActionListener(this);
//
//    //document
//    imageIcon = new ImageIcon(business.Global.getImagePath() + business.Global.imageIconDocument);
//    documentB = new JButton("Document",imageIcon);
//    documentB.setActionCommand("Document");
//    documentB.addActionListener(this);
//    // button to close shared use case
//    imageIcon = new ImageIcon(business.Global.getImagePath() + business.Global.imageIconClose);
//    closeB = new JButton("Close",imageIcon);
//    closeB.setActionCommand("Close");
//    closeB.addActionListener(this);
//    // button to cancel action
//    imageIcon = new ImageIcon(business.Global.getImagePath() + business.Global.imageIconMinimize);
//    minimizeB = new JButton("Minimize",imageIcon);
//    minimizeB.setActionCommand("Minimize");
//    minimizeB.addActionListener(this);


    JPanel buttonPR = new JPanel();
    buttonPR.setLayout(new FlowLayout(FlowLayout.RIGHT, 1, 1));

    JPanel buttonPL = new JPanel();
    buttonPL.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));


    buttonPL.add(saveB);
    buttonPL.add(verifyB);
    buttonPL.add(documentB);
    buttonPL.add(helpB);


//    buttonP.add(deleteB);
    buttonPR.add(minimizeB);
    buttonPR.add(closeB);

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new BorderLayout());
    buttonP.add(buttonPL,BorderLayout.WEST);
    buttonP.add(buttonPR,BorderLayout.EAST);

    getContentPane().add(usecaseP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.NORTH);
  }

  /** called if use case viewpoint shall be saved */
  public void doSave() {
    business.Global.error = false;
    business.CUsecase UC = usecaseP.getUsecase();
    if(business.Global.error != true){
      business.Global.contrUsecase.saveUsecase(UC);
    }else{
      JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
    }
  }

  public void reload(){
    usecaseP.reload();
    //reload style2PMain
    //reload style2PExt
    //reload style2PSub
  }

  public void insert(String s ,boolean move){
    int opt;
    if(move){
      opt = new gui.GnewStep().showDialog();
      business.Global.contrUsecase.showUseCase();
    }else{
      opt = 1;
    }

    if(opt == 1){
      this.usecaseP.insertItemMain(s,-1);
//    }else if(opt == 2){
//      this.usecaseP.insertItemSub(s,-1);
    }else if(opt == 2){
      this.usecaseP.insertItemExt(s,-1);
    }
    business.CUsecase UC = usecaseP.getUsecase();
    if(business.Global.error != true){
      business.Global.contrUsecase.saveUsecase(UC);
    }
  }



  public void OLDinsert(String sentence ,boolean move){
          business.CUsecase uc =  business.Global.usecase;
          Vector steps = uc.getSuccessScenarioT1();
          int position =0;
          String step = "1";
          business.CStep bigStep=null;
          if(steps.size()>0){
            bigStep = (business.CStep)steps.elementAt(steps.size()-1);
            position = bigStep.getPosition() + 1;
            step = (new Integer(bigStep.getLevel(0)).intValue()+1 ) + "";
          }
          business.CStepStrT1 newStep = new business.CStepStrT1( 0, position, step,sentence , "" );
          newStep.redoPhrases();
          if(bigStep == null){
            newStep.insertStep(steps);
          }else{
            newStep.insertAfterStep(steps,bigStep);
          }
          if(business.Global.usecaseF != null)business.Global.usecaseF.reload();
          if(move){
            business.Global.contrUsecase.showUseCase();
            this.usecaseP.moveItem(steps.size()-1);
          }else{
//            business.Global.contrUsecase.showUseCase();
//            this.usecaseP.selectItem(steps.size()-1);
          }
  }



  public boolean close(){
    if(business.Global.groupViewpointFV.size()>0){
      JOptionPane.showMessageDialog(frameF,"Cant close: Group Viewpoints belonging to this use case are still open");
      return false;
    }else if(business.Global.diagramFV.size()>0){
      JOptionPane.showMessageDialog(frameF,"Cant close: diagrams belonging to this use case are still open");
      return false;
    }else{
      int option;
      option = JOptionPane.showConfirmDialog(frameF,"Do you want to save","Save",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
      if (option == JOptionPane.OK_OPTION){
        business.Global.error = false;
        business.CUsecase UC = usecaseP.getUsecase();
        if(business.Global.error != true){
          business.Global.contrUsecase.saveUsecase(UC);
          business.Global.contrUsecase.closeUsecase();
          return true;
        }else{
          JOptionPane.showMessageDialog(frameF,"Please make sure all the required fields are filled");
          return false;
        }
      }else if (option == JOptionPane.NO_OPTION){
        business.Global.contrUsecase.closeUsecase();
        return true;
      }else{
      //if (option == JOptionPane.CANCEL_OPTION){
        return false;
      }
    }
  }

  public void actionPerformed(ActionEvent e) {

    if(e.getActionCommand().equals("Save")) {
      doSave();
    }else if(e.getActionCommand().equals("Verify")) {
//      if (business.Global.systemUnix){
        business.Global.error = false;
        business.CUsecase uc = usecaseP.getUsecase();
        if (!business.Global.error){
          business.Global.contrUsecase.verifyUsecase(uc);
          JOptionPane.showMessageDialog(null,"Done!");
          reload();
        }else{
          JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
        }
//      }else{
//        JOptionPane.showMessageDialog(null,"This option is only available on Unix");
//      }
    }
    else if(e.getActionCommand().equals("Help")) {
        JOptionPane.showMessageDialog(frameF,"help goes here");
    }
    else if(e.getActionCommand().equals("Close")) {
      close();
    }
    else if(e.getActionCommand().equals("Minimize")) {
        business.Global.contrUsecase.hideUsecase();
    }
    else if(e.getActionCommand().equals("Document")) {
        gui.GReport report = new gui.GReport();
        business.CUsecase UC = usecaseP.getUsecase();
        report.UCReport(UC);
        report.showDialog();

    }


  }









}
