package gui;

import javax.swing.*;
import javax.swing.table.*;
import java.util.Vector;

/**
 * Description: table model
 *
 * @author Kathrin Boettger and Oscar Aguilera
 *
 * @version 1.0
 */
class CTableModel extends DefaultTableModel {

  public CTableModel(Vector AData, Vector AColumnNames) {
    super(AData, AColumnNames);
  }

  public CTableModel(Object[][] AData, Object[] AColumnNames) {
    super(AData, AColumnNames);
  }

  public CTableModel(Object[] AColumnNames, int ACountObj) {
    super(AColumnNames, ACountObj);
  }

  public CTableModel(Vector AColumnNames, int ACountObj) {
    super(AColumnNames, ACountObj);
  }

   public Class getColumnClass(int c) {
     return getValueAt(0, c).getClass();
  }

  Vector restrictEdit = new Vector();
  public void setEditableCol(int col, boolean Editable)
  {
    if(col < this.getColumnCount()){
      if(Editable){
        restrictEdit.removeElement(new Integer(col));
      }else{
        restrictEdit.addElement(new Integer(col));
      }
    }
  }

  boolean editable= true;
  public void setEditable(boolean aEditable){
    editable = aEditable;
  }

  public boolean isEditable(){
    return editable;
  }

  public boolean isCellEditable(int row, int col) {
  //Note that the data/cell address is constant,
  //no matter where the cell appears onscreen.
    if(!editable)return false;
    if( restrictEdit.contains(new Integer(col))){
        return false;
    } else {
        return true;
    }

  }

}
