package gui;

import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.*;
import java.util.Vector;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */


public class CSynonymTable extends JFrame implements ActionListener , TableModelListener {

    private  JLabel nameL;

    private JCheckBox synonymsCB = null;

    private  JComboBox comboBox;
    private  JButton CreateLatticeB;
    private  JButton closeWindowB;
    private  JButton saveB;
    private  JButton deleteB;
    private  JButton addB;

    private  JButton attrFindB;
    private  JButton attrFindExactB;

    private  MenuItem menuFileSave;
    private  MenuItem menuFileOpen;
    private  MenuItem menuFileClose;
    private  MenuItem menuRenameTable;
    private  MenuItem menuCreateLattice;

    private JTable projectTable;
    private Vector cols;

    public JFrame frameF ;

    private business.CSynonymTable synonymTable;

    public CSynonymTable(business.CSynonymTable aSynonymTable) {
      super("Synonyms");
      synonymTable = aSynonymTable;
      //synonymTable.print();
      init();
    }
    /**
     * Init
     * create menus
     * create table
     * display
     */

    private void init() {
        frameF = this;
        frameF.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent e) {
          closeWindow();
          }
        });

        //business.Global.contrViewpoint.addResolutionTable(frameF);

        MenuBar	menuBar = new MenuBar();

        Menu menuFile=new Menu("[Synonym Table]");
        Menu menuOptions=new Menu("[Options]");

//        this.menuFileOpen = new MenuItem("Open");
//        this.menuFileOpen.setShortcut(new MenuShortcut('0'));
//        this.menuFileOpen.setActionCommand("Open");
//        this.menuFileOpen.addActionListener(this);

        this.menuFileSave = new MenuItem("Save");
        this.menuFileSave.setShortcut(new MenuShortcut('S'));
        this.menuFileSave.setActionCommand("Save");
        this.menuFileSave.addActionListener(this);


        this.menuFileClose = new MenuItem("Minimize");
        this.menuFileClose.setShortcut(new MenuShortcut('C'));
        this.menuFileClose.setActionCommand("Close");
        this.menuFileClose.addActionListener(this);


//        menuFile.add(this.menuFileOpen);
        menuFile.add(this.menuFileSave);
        menuFile.add(this.menuFileClose);

//        this.menuRenameTable = new MenuItem("Name this Table");
//        this.menuRenameTable.setShortcut(new MenuShortcut('R'));
//        this.menuRenameTable.setActionCommand("RenameTable");
//        this.menuRenameTable.addActionListener(this);
//
//        this.menuCreateLattice = new MenuItem("Create Lattice");
//        this.menuCreateLattice.setShortcut(new MenuShortcut('N'));
//        this.menuCreateLattice.setActionCommand("CreateLattice");
//        this.menuCreateLattice.addActionListener(this);
//
//
//        menuOptions.add(this.menuRenameTable);
//        menuOptions.add(this.menuCreateLattice);


        menuBar.add(menuFile);
//        menuBar.add(menuOptions);

        this.setMenuBar(menuBar);



        //---------------------------------------------------------------------------
        // TABLE
        //---------------------------------------------------------------------------


        this.cols = new Vector();
        cols.add("#");
        cols.add("Original Phrase");
        cols.add("->");
        cols.add("#");
        cols.add("Phrase");

        Vector rows = new Vector();
        for(int i = 0 ; i< this.synonymTable.size() ; i++){

            Vector data = new Vector();
            data.add(i+"");
            data.add(this.synonymTable.getPhrase(i)+"");
            data.add("->");
            int synonymId = this.synonymTable.getSynonymId(i);
            if (synonymId == -1){
              data.add( " ");
            }else{
              data.add( synonymId +"");
            }
            data.add(this.synonymTable.getSynonym(i) +"");
            rows.add(data);
        }
        MyTableModel mt = new MyTableModel(rows, cols);
        this.projectTable = new JTable( mt );
        mt.addTableModelListener(this);

//
//
//        if (rows.size() < 30){
//          this.projectTable.setPreferredScrollableViewportSize(new Dimension(700, 20+(16*rows.size()) ));
//        }else{
//          this.projectTable.setPreferredScrollableViewportSize(new Dimension(700, 30*16 ));
//        }
//
//        javax.swing.table.TableColumn column = null;
//        for (int i = 0; i < cols.size() ; i++) {
//            column = this.projectTable.getColumnModel().getColumn(i);
//            if (i == 0 || i == 2 || i == 3) {
//                column.setPreferredWidth(35); //this column is smaller
//            } else {
//                column.setPreferredWidth(300);
//            }
//        }

        this.updateTable();

        JPanel tableP = new JPanel();
        tableP.setLayout(new BorderLayout());


        JPanel toolsP = new JPanel();
        toolsP.setLayout(new FlowLayout());//(new BorderLayout());


        TitledBorder tableT;
        tableT = BorderFactory.createTitledBorder("Synonym Table For:" +business.Global.project.getName());
        tableP.setBorder(tableT);

        TitledBorder toolsT;
        toolsT = BorderFactory.createTitledBorder("Tools");
        toolsP.setBorder(toolsT);

        //Create the scroll pane and add the table to it.
        JScrollPane scrollPane = new JScrollPane(this.projectTable);
        tableP.add(scrollPane, BorderLayout.CENTER);

        //---------------------------------------------------------------------------
        //    TOOLS

        this.attrFindB = new JButton("Find");
        this.attrFindB.setActionCommand("AttrFind");
        attrFindB.addActionListener(this);

        this.attrFindExactB = new JButton("Find Exact");
        this.attrFindExactB.setActionCommand("AttrFindExact");
        attrFindExactB.addActionListener(this);

        this.addB = new JButton ("Add");
        this.addB.setActionCommand("Add");
        addB.addActionListener(this);

        this.deleteB = new JButton ("Remove");
        this.deleteB.setActionCommand("Delete");
        deleteB.addActionListener(this);


        toolsP.add(attrFindB);
        toolsP.add(attrFindExactB);
        toolsP.add(addB);
        toolsP.add(deleteB);

        tableP.add(toolsP, BorderLayout.NORTH);


        //---------------------------------------------------------------------------


        this.closeWindowB = new JButton("Minimize",business.Global.imageIconMinimize);
        this.closeWindowB.setActionCommand("Close");
        closeWindowB.addActionListener(this);


        this.saveB = new JButton   ("Save",business.Global.imageIconSave);
        this.saveB.setActionCommand("Save");
        saveB.addActionListener(this);


        JPanel buttonPR = new JPanel();
        buttonPR.setLayout(new FlowLayout(FlowLayout.RIGHT, 1, 1));
        JPanel buttonPL = new JPanel();
        buttonPL.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));

        buttonPL.add(saveB);
        buttonPR.add(closeWindowB);

        JPanel buttonP = new JPanel();
        buttonP.setLayout(new BorderLayout());
        buttonP.add(buttonPL,BorderLayout.WEST);
        buttonP.add(buttonPR,BorderLayout.EAST);


        //---------------------------------------------------------------------------
//        nameL = new JLabel("Project:"+business.Global.project.getName());
//        JPanel infoP = new JPanel();
//        infoP.setLayout(new BorderLayout());
//
//        TitledBorder infoT;
//        infoT = BorderFactory.createTitledBorder("Info");
//        infoP.setBorder(infoT);
//        infoP.add(nameL,BorderLayout.WEST);

        //---------------------------------------------------------------------------

//        getContentPane().add(infoP, BorderLayout.NORTH);
        getContentPane().add(tableP, BorderLayout.CENTER);
        getContentPane().add(buttonP, BorderLayout.NORTH);

        this.pack();
        this.setVisible(true);

    }


    /**
     * Close
     */
    public boolean closeWindow() {
      this.save();
      this.dispose();
      return true;

//            int option;
//            option = JOptionPane.showConfirmDialog(this,"Do you want to save?","Save",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
//            if (option == JOptionPane.OK_OPTION){
//                if(this.save()){
//                  business.Global.project.resetSynonymTable();
//                  this.dispose();
//                  return true;
//                }else{
//                  return false;
//                }
//            } else
//            if (option == JOptionPane.CANCEL_OPTION){
//                return false;
//            } else
//            if (option == JOptionPane.NO_OPTION){
//                business.Global.project.resetSynonymTable();
//                this.dispose();
//                return true; //change
//            }else{
//              return false;
//            }
    }

    /**
     * Save
     */
    public boolean save(){
      this.projectTable.editingStopped(new ChangeEvent(this));
      this.updateTable();
      persistence.CSynonymTable.SaveCSynonymTable(this.synonymTable,business.Global.project.getId()+"");
      return true;
    }

    /**
     * Open
     */

    private void open(){

    }


    /**
     * action performed
     */
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();

	if (command.equals("AttrFindExact"))
	{
          findExact();
        }
	if (command.equals("AttrFind"))
	{
          attrFind();
        }
	if (command.equals("Save"))
	{
            this.save();
	}

	if (command.equals("Add"))
	{
          String input = JOptionPane.showInputDialog(this,"Enter Phrase");
          if(input != null && input != ""){
            this.synonymTable.addPhrase(input);
            this.updateTable();
            //  this.AttTable.changeSelection(row,0,true,false);
            //  this.projectTable.editCellAt(this.synonymTable.size()-1,3);
            this.projectTable.setRowSelectionInterval(this.synonymTable.size()-1,this.synonymTable.size()-1);
            this.projectTable.scrollRectToVisible(projectTable.getCellRect(projectTable.getRowCount()-1,-1,true));
          }
	}

	if (command.equals("Delete"))
	{
          System.out.println( this.projectTable.getSelectedRow() );
          this.synonymTable.deletePhrase(this.projectTable.getSelectedRow());
          this.updateTable();
	}
	if (command.equals("Close"))
	{
            this.closeWindow();
	}
    }

    public void tableChanged(TableModelEvent e){
        boolean noerror = true;
//        if(!(e.getSource()==this)){
//          if (this.projectTable.isEditing()){
//              this.projectTable.editingStopped(new ChangeEvent(this));
//              noerror = false;
//          }
//        }
        if(e.getColumn()==3){
        int id = -1;
        Object obj = this.projectTable.getModel().getValueAt(e.getFirstRow(),3);
        String val = "";
        if(obj != null) val = obj.toString();
        if(!val.equals("")){
          try{
              id = Integer.parseInt( val );
              if(id < 0 || id > this.synonymTable.size() -1 ){
                JOptionPane.showMessageDialog(null,"Error in row : "+ e.getFirstRow());
              }
          }
          catch (Exception f)
          {
              id = -1;
              JOptionPane.showMessageDialog(null,"Error in row : "+ e.getFirstRow());
              noerror = false;
          }
        }
        this.synonymTable.setSynonym(e.getFirstRow(),id);
//        System.out.println("-------v-------"+ e.getFirstRow() );
//        System.out.println("table:(org,synonym):"+ this.synonymTable.getPhrase(e.getFirstRow()) +","+ this.synonymTable.getSynonym(e.getFirstRow()));
//        System.out.println("system:"+  this.synonymTable.getPhraseId("system" )+" error:"+this.synonymTable.getPhraseId("error") );
//        System.out.println("-------^-------");

        updateTable(false); //the table is in edit mode !!!?

      }
    }

/**
 * update Table
 */
    public boolean updateTable(){
      return  updateTable(true);
    }

    public boolean updateTable(boolean warnings){
        boolean noerror = true;
        if (this.projectTable.isEditing()){
            if(warnings) JOptionPane.showMessageDialog(null,"Please finish editing row:"+(this.projectTable.getEditingRow()+1));
            //this.projectTable.editingStopped(new ChangeEvent(this));
            noerror = false;
        }else{
          noerror = true;
        }
        {
          Vector rows = new Vector();
          for(int i = 0 ; i< this.synonymTable.size() ; i++){

              Vector data = new Vector();
              data.add(i+"");
              data.add(this.synonymTable.getPhrase(i)+"");
              data.add("->");
              int synonymId = this.synonymTable.getSynonymId(i);
              if (synonymId == -1){
                data.add( "");
              }else{
                data.add( synonymId +"");
              }
              if(this.synonymTable.getSynonymId(i)!= -1){
                data.add(this.synonymTable.getSynonym(i) +"");
              }else{
                data.add(" ");
              }
              rows.add(data);
          }
          MyTableModel mt = new MyTableModel(rows, cols);
          this.projectTable.setModel( mt );

          if (rows.size() < 8){
            this.projectTable.setPreferredScrollableViewportSize(new Dimension(700, 8*16));
          }else if (rows.size() < 30){
            this.projectTable.setPreferredScrollableViewportSize(new Dimension(700, (16*rows.size())+20 ));
          }else{
            this.projectTable.setPreferredScrollableViewportSize(new Dimension(700, 30*16 ));
          }

          javax.swing.table.TableColumn column = null;
          for (int i = 0; i < cols.size() ; i++) {
              column = this.projectTable.getColumnModel().getColumn(i);
              if (i == 0 || i == 2 || i == 3) {
                  column.setPreferredWidth(35); //this column is smaller
              } else {
                  column.setPreferredWidth(300);
              }
          }

          mt.addTableModelListener(this);
       }//else (table is not editing)
       return noerror;

  }//update



  public void attrFind(){
          String search = JOptionPane.showInputDialog(this,"Search for:");
          if (search != null){
            this.projectTable.removeRowSelectionInterval(0,this.projectTable.getRowCount()-1);

            Vector attrFound =  new Vector();
            for(int row = 0;row<this.projectTable.getRowCount();row++){
              String attr = ((String) this.projectTable.getModel().getValueAt(row,1));
              String test = " "+attr+" ";
              boolean found = false;
              for(int x = 0;x<(test.length()-search.length()+1)&&found==false;x++){
                if(test.regionMatches(true,0+x,search,0,search.length())){
                    found = true;
                    attrFound.addElement(attr);
                    this.projectTable.changeSelection(row,0,true,false);
                }
              }
            }


         }//not cancel search
}

  private void findExact(){
          String search = JOptionPane.showInputDialog(this,"Search for:");
          if (search != null){
            this.projectTable.removeRowSelectionInterval(0,this.projectTable.getRowCount()-1);
            Vector attrFound =  new Vector();
            for(int row = 0;row<this.projectTable.getRowCount();row++){
              String attr = ((String) this.projectTable.getModel().getValueAt(row,1));
                if(attr.equals(search)){
                    attrFound.addElement(attr);
                    this.projectTable.changeSelection(row,0,true,false);
                }
            }
         }
      }


class MyTableModel extends DefaultTableModel {
  public MyTableModel(Vector AData, Vector AColumnNames) {
    super(AData, AColumnNames);
  }

  public MyTableModel(Object[][] AData, Object[] AColumnNames) {
    super(AData, AColumnNames);
  }

  public MyTableModel(Object[] AColumnNames, int ACountObj) {
    super(AColumnNames, ACountObj);
  }

  public MyTableModel(Vector AColumnNames, int ACountObj) {
    super(AColumnNames, ACountObj);
  }

   public Class getColumnClass(int c) {

     if(getValueAt(0, c) == null){
       return "".getClass();
     }else{
        return getValueAt(0, c).getClass();
     }
   }

  public boolean isCellEditable(int row, int col) {
    if (col == 3) {
        return true;
    } else {
        return false;
    }
//    return true;
  }
}



}
