package gui;

import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/**
 * Description: gui for scenario steps of type business.CStepStrT2
 *
 * @author Kathrin Boettger modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CStyle3P extends JPanel implements ActionListener, business.IListener {


  /** kind of viewpoint (business.Global.TYPE_USECASE or business.Global.TYPE_SCENARIO) */
  private String type = null;
  /** scenario to be displayed */
  private Vector stepStrT2V = null;
  /** which scenario data have to be displayed
   *  (business.Global.kindDataSuccessSc for success scenario,
   *   business.Global.kindDataExtension for extensions,
   *   business.Global.kindDataVariation for variations)
   */
  private String kindOfData;
  /** vector of extension steps of success scenario of type business.CStepStrT2 */
  private Vector extensionStepV = null;
  /** vector of variation steps of success scenario of type business.CStepStrT2 */
  private Vector variationStepV = null;
  /** vector of steps success scenario of type business.CStepStrT2 */
  private Vector mainStepV = null;
  /** vector of agent or actor dependent on AType */
  private Vector actorV = null;

  /** all action steps for use case and scenario (sorted) */
  private Vector allStepV = null;
  /** observer */
  private business.IObserver observer = null;
  /** parent window */
  private Object parent = null;

  /** table model of scenario table */
  private CTableModel tableModel = null;
  /** table of scenario steps */
  private JTable scenarioT = null;
  /** column names for 'scenario viewpoints' */
  private final Vector columnNamesUc;
  /** column names for 'use case viewpoints' */
  private final Vector columnNamesSc;
  /** default data */
  private final Object[][] data = {};
  /** combobox for actors/agents dependent on type */
  private JComboBox actorCB = null;

  /** actions */
  private final String actionCopyStep = new String("CopyStep");
  private final String actionMoveStep = new String("MoveStep");
  private final String actionNewStep = new String("NewStep");
  private final String actionDeleteStep = new String("DeleteString");
  private final String actionPhrasesStep = new String("Phrases");

  /** constructor
   *  @param AParent parent window
   *  @param AMainStepV vector of steps success scenario of type business.CStepStrT2
   *  @param AActorV vector of agent or actor dependent on AType
   *  @param AType kind of 'viewpoint' (business.Global.TYPE_USECASE or
   *  business.Global.TYPE_SCENARIO)
   *  @param AKindOfData which scenario data have to be displayed
   *  (business.Global.kindDataSuccessSc for success scenario,
   *   business.Global.kindDataExtension for extensions,
   *   business.Global.kindDataVariation for variations)
   *  @param AExtensionStepV vector of extension steps of success scenario
   *  of type business.CStepStrT2
   *  @param AVariationStepV vector of variation steps of success scenario
   *  of type business.CStepStrT2
   *  @param AObserver observer
   */
  public CStyle3P(Object AParent,
                  Vector AMainStepV,
                  Vector AActorV,
                  String AType,
                  String AKindOfData,
                  Vector AExtensionStepV,
                  Vector AVariationStepV,
                  business.IObserver AObserver) {

    parent = AParent;
    observer = AObserver;
    actorV = AActorV;
    type = AType;
    kindOfData = AKindOfData;
    extensionStepV = AExtensionStepV;
    variationStepV = AVariationStepV;
    mainStepV = AMainStepV;

    // set data to be displayed
    if (kindOfData.equals(business.Global.kindDataSuccessSc)) {
      stepStrT2V = AMainStepV;
    } else if (kindOfData.equals(business.Global.kindDataExtension)) {
      stepStrT2V = AExtensionStepV;
    } else {
      stepStrT2V = AVariationStepV;
    }

    // define column names for 'use case viewpoints'
    columnNamesUc = new Vector();
    columnNamesUc.add(new String("step"));
    columnNamesUc.add(new String("agent of action"));
    columnNamesUc.add(new String("action"));

    // define column name for 'scenario viewpoints'
    columnNamesSc = new Vector();
    columnNamesSc.add(new String("step"));
    columnNamesSc.add(new String("agent of action"));
    columnNamesSc.add(new String("action"));

    init();
  }

  /** initialize gui */
  private void init() {

    this.setLayout(new BorderLayout(5, 5));

    // scenario-panel
    JPanel scenarioP = new JPanel();
    scenarioP.setLayout(new BorderLayout(5, 5));

    // define table model dependent on type of viewpoint
    if (type.equals(business.Global.TYPE_USECASE))
      tableModel = new gui.CTableModel(columnNamesUc, 0);
    else
      tableModel = new gui.CTableModel(columnNamesSc, 0);

    tableModel.setEditableCol(0,false);
    // init scenario table
    scenarioT = new JTable(tableModel);
    scenarioT.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    TableColumn typeColumn = scenarioT.getColumnModel().getColumn(1);
    actorCB = new JComboBox();

    // init combobox of actors or agents
    if (actorV != null) {
      for (int i=0; i<actorV.size(); i++) {
        if (type.equals(business.Global.TYPE_USECASE)) {
          actorCB.addItem(((business.CActor) actorV.elementAt(i)).getType());
        } else {
          actorCB.addItem(((business.CAgent) actorV.elementAt(i)).getName());
        }
      }
    }
    actorCB.addItem(new String("none"));
    actorCB.addItem(business.Global.project.getSystem());

    // init scenario table
    for (int i=0; i<stepStrT2V.size(); i++) {
      Vector newRow = new Vector();
      newRow.add(((business.CStepStrT2) stepStrT2V.elementAt(i)).getStep());

      if (actorV != null && actorV.size()>0) {
         if (type.equals(business.Global.TYPE_USECASE)) {
           if (((business.CStepStrT2) stepStrT2V.elementAt(i)).getActor() != null)
             newRow.add((((business.CStepStrT2) stepStrT2V.elementAt(i)).getActor()).getType());
           else if (((business.CStepStrT2) stepStrT2V.elementAt(i)).isSystemStep())
             newRow.add(business.Global.project.getSystem());
           else
             newRow.add(new String("none"));

         } else { // business.Global.TYPE_SCENARIO
           if (((business.CStepStrT2) stepStrT2V.elementAt(i)).getAgent() != null)
             newRow.add((((business.CStepStrT2) stepStrT2V.elementAt(i)).getAgent()).getName());
           else if (((business.CStepStrT2) stepStrT2V.elementAt(i)).isSystemStep())
             newRow.add(business.Global.project.getSystem());
           else
             newRow.add(new String("none"));
         }
      } else if (((business.CStepStrT2) stepStrT2V.elementAt(i)).isSystemStep()) {
        newRow.add(business.Global.project.getSystem());
      } else {
        newRow.add(new String("none"));
      }

      newRow.add(((business.CStepStrT2) stepStrT2V.elementAt(i)).getAction());
      tableModel.addRow(newRow);
    }

    scenarioT.setPreferredScrollableViewportSize(new Dimension(500, 70));

    typeColumn.setCellEditor(new DefaultCellEditor(actorCB));
    typeColumn = scenarioT.getColumnModel().getColumn(0);
    typeColumn.setPreferredWidth(30);
    typeColumn = scenarioT.getColumnModel().getColumn(1);
    typeColumn.setPreferredWidth(100);
    typeColumn = scenarioT.getColumnModel().getColumn(2);
    typeColumn.setPreferredWidth(370);

    JScrollPane scenarioTSP = new JScrollPane(scenarioT);

    // button panel
    JPanel scenarioBP = new JPanel();
    scenarioBP.setLayout(
      new BoxLayout(scenarioBP, BoxLayout.Y_AXIS));

    JButton scenarioNewB = new JButton ("New ...");
    scenarioNewB.setActionCommand(this.actionNewStep);
    scenarioNewB.addActionListener(this);

    JButton scenarioCopyB = new JButton ("Copy ...");
    scenarioCopyB.setActionCommand(this.actionCopyStep);
    scenarioCopyB.addActionListener(this);

    JButton scenarioMoveB = new JButton ("Move ...");
    scenarioMoveB.setActionCommand(this.actionMoveStep);
    scenarioMoveB.addActionListener(this);

    JButton scenarioDeleteB = new JButton ("Delete ...");
    scenarioDeleteB.setActionCommand(this.actionDeleteStep);
    scenarioDeleteB.addActionListener(this);

    JButton scenarioPhrasesB = new JButton ("Phrases ...");
    scenarioPhrasesB.setActionCommand(this.actionPhrasesStep);
    scenarioPhrasesB.addActionListener(this);

    scenarioBP.add(scenarioNewB);
    scenarioBP.add(scenarioCopyB);
    scenarioBP.add(scenarioMoveB);
    scenarioBP.add(scenarioDeleteB);
    scenarioBP.add(scenarioPhrasesB);

    add(scenarioTSP, BorderLayout.CENTER);
    add(scenarioBP, BorderLayout.EAST);
  }

  /** reads steps of scenario of type business.CStepStrT2 from gui
   * @return vector of
   */
  public Vector getStepStrT2() {
    editingStopped();
    if (scenarioT.isEditing()){
      JOptionPane.showMessageDialog(null,"Please finish editing row:"+
        (scenarioT.getEditingRow()+1) + " in table:" + kindOfData);
        business.Global.error = true;
    }

    for (int i = 0; i < stepStrT2V.size(); i++) {

      ((business.CStepStrT2) stepStrT2V.elementAt(i)).setPosition(i);
      ((business.CStepStrT2) stepStrT2V.elementAt(i)).setStep(
        ((String)tableModel.getValueAt(i, 0)));

      if (((String) tableModel.getValueAt(i, 1)).equals(new String("none"))) {
        ((business.CStepStrT2) stepStrT2V.elementAt(i)).setActor(null);
        ((business.CStepStrT2) stepStrT2V.elementAt(i)).setAgent(null);
        ((business.CStepStrT2) stepStrT2V.elementAt(i)).setSystemStep(false);

      } else if (((String) tableModel.getValueAt(i, 1)).equals(business.Global.project.getSystem())) {
        ((business.CStepStrT2) stepStrT2V.elementAt(i)).setActor(null);
        ((business.CStepStrT2) stepStrT2V.elementAt(i)).setAgent(null);
        ((business.CStepStrT2) stepStrT2V.elementAt(i)).setSystemStep(true);
      } else { // agent or actor
        ((business.CStepStrT2) stepStrT2V.elementAt(i)).setSystemStep(false);
        if (type.equals(business.Global.TYPE_USECASE)) {
          business.CActor actor = null;
          boolean found = false;
          for (int j=0; j<actorV.size(); j++) {
            if (((business.CActor) actorV.elementAt(j)).getType().equals((String) tableModel.getValueAt(i, 1))) {
              found = true;
              actor = (business.CActor) actorV.elementAt(j);
            }
          }
          ((business.CStepStrT2) stepStrT2V.elementAt(i)).setActor(actor);

        } else {
          business.CAgent agent = null;
          boolean found = false;
          for (int j=0; j<actorV.size(); j++) {
            if (((business.CAgent) actorV.elementAt(j)).getName().equals((String) tableModel.getValueAt(i, 1))) {
              found = true;
              agent = (business.CAgent) actorV.elementAt(j);
            }
          }
          ((business.CStepStrT2) stepStrT2V.elementAt(i)).setAgent(agent);
        }
      }

      ((business.CStepStrT2) stepStrT2V.elementAt(i)).setAction(
        ((String)tableModel.getValueAt(i, 2)));
    }

    return stepStrT2V;
  }

  /** is called if user wants to add, copy, move or delete scenario step */
  public void actionPerformed(ActionEvent e) {
    editingStopped();

//  tableModel
    if (scenarioT.isEditing()){
      JOptionPane.showMessageDialog(null,"Please finish editing row:"+
        (scenarioT.getEditingRow()+1) + " in table:" + kindOfData);
    }else{

      observer.sendMessage(business.CObserver.Read_User_Input);
      int kindOfStep = business.Global.Step_New;

      allStepV = new Vector();
      for (int i=0; mainStepV != null && i<mainStepV.size(); i++)
        ((business.CStep) mainStepV.elementAt(i)).insertStep(allStepV);
      for (int i=0; extensionStepV != null && i<extensionStepV.size(); i++)
        ((business.CStep) extensionStepV.elementAt(i)).insertStep(allStepV);
      for (int i=0; variationStepV != null && i<variationStepV.size(); i++)
        ((business.CStep) variationStepV.elementAt(i)).insertStep(allStepV);

      // copy step
      if (e.getActionCommand().equals(this.actionCopyStep)) {

        if (extensionStepV != null && variationStepV != null)
          kindOfStep = business.Global.Step_CopyMove;

        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();

        if (minIndex < 0) {
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }

        // step, which is to copy
        business.CStepStrT2 copyStep =
          (business.CStepStrT2) stepStrT2V.elementAt(minIndex);

        gui.CNewScStepD newScStepD = null;
        if (parent.getClass().getSuperclass().isInstance(new JFrame())) {
          newScStepD =
            new gui.CNewScStepD((Frame) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITH_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        } else {
          newScStepD =
            new gui.CNewScStepD((Dialog) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITH_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        }
        if (newScStepD != null) {
          business.CStepStrT2 newStep =
          (business.CStepStrT2) newScStepD.showDialog();
          if (newStep != null) {
            newStep.setAction(copyStep.getAction());
            if (type == business.Global.TYPE_USECASE) {
              if (copyStep.isSystemStep())
                newStep.setSystemStep(true);
              else if (copyStep.getActor() != null)
                newStep.setActor(copyStep.getActor());
            } else {
              if (copyStep.isSystemStep())
                newStep.setSystemStep(true);
              if (copyStep.getAgent() != null)
                newStep.setAgent(copyStep.getAgent());
            }
          }
        }

      // move step
      } else if (e.getActionCommand().equals(this.actionMoveStep)) {

        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();

        if (minIndex < 0) {
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }

        if (extensionStepV != null && variationStepV != null)
          kindOfStep = business.Global.Step_CopyMove;

        business.CStepStrT2 moveStep =
          (business.CStepStrT2) stepStrT2V.elementAt(minIndex);

        gui.CNewScStepD newScStepD = null;
        if (parent.getClass().getSuperclass().isInstance(new JFrame())) {
          newScStepD =
            new gui.CNewScStepD((Frame) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITH_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        } else {
          newScStepD =
            new gui.CNewScStepD((Dialog) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITH_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        }
        if (newScStepD != null) {
          business.CStepStrT2 newStep =
          (business.CStepStrT2) newScStepD.showDialog();


          if (newStep != null) {  // ok

            Vector newAllStepV = (Vector) allStepV.clone();
            newStep.insertStep(newAllStepV);

            // set action
            newStep.setAction(moveStep.getAction());
            // set agent of action
            if (type == business.Global.TYPE_USECASE) {
              if (moveStep.isSystemStep())
                newStep.setSystemStep(true);
              else if (moveStep.getActor() != null)
                newStep.setActor(moveStep.getActor());
            } else {
              if (moveStep.isSystemStep())
                newStep.setSystemStep(true);
              else if (moveStep.getAgent() != null)
                newStep.setAgent(moveStep.getAgent());
            }

            // move also all substeps of choosed step
            boolean finished = true;
            for (int i=allStepV.indexOf(moveStep)+1;
                 i<allStepV.size() && finished == true; i++) {
              if (((business.CStep) allStepV.elementAt(i)).getStep().startsWith(
                  moveStep.getStep())) {

                business.CStep step = (business.CStep) allStepV.elementAt(i);

                // change step, delete and insert again
                step.setStep(
                  newStep.getStep() + step.getStep().substring(
                                      moveStep.getStep().length()));

                stepStrT2V.remove(step);

                if (mainStepV.contains(step)) {
                  mainStepV.removeElement(step);
                  step.insertStep(mainStepV);
                } else if (extensionStepV != null && extensionStepV.contains(step)) {
                  extensionStepV.removeElement(step);
                  step.insertStep(extensionStepV);
                } else if (variationStepV != null && variationStepV.contains(step)) {
                  variationStepV.removeElement(step);
                  step.insertStep(variationStepV);
                }

                newAllStepV.removeElement(step);
                step.insertStep(newAllStepV);

              } else {
                finished = false;
              }
            }

            // correct all steps after new step
            if (!newStep.getStep().startsWith(moveStep.getStep())) {
              moveStep.removeFromStepAtLevel(
                newAllStepV, newAllStepV.indexOf(moveStep)+1,
                moveStep.getNumberOfLevels()-1);
            }

            // delete old step
            stepStrT2V.remove(moveStep);
            newAllStepV.remove(moveStep);

            allStepV = newAllStepV;
          }
        }

      // delete step
      } else if (e.getActionCommand().equals(this.actionDeleteStep)) {
        if(scenarioT.getSelectionModel().getMinSelectionIndex()<1){
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }

        int sure = JOptionPane.showConfirmDialog(
        (Window) parent,
        "Are you sure ? \nYou will delete all substeps.",
        "question",
        JOptionPane.YES_NO_OPTION);
        if (sure == JOptionPane.NO_OPTION) return;

        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int index = rowSM.getMinSelectionIndex();

        business.CStep step =
        (business.CStep) stepStrT2V.elementAt(index);

        // delete all substeps of choosed step
        boolean finished = true;
        for (int i=allStepV.indexOf(step)+1;
             i<allStepV.size() && finished == true;) {
          if (((business.CStep) allStepV.elementAt(i)).getStep().startsWith(
              step.getStep())) {
            stepStrT2V.removeElement((business.CStep) allStepV.elementAt(i));
            mainStepV.removeElement((business.CStep) allStepV.elementAt(i));
            if (extensionStepV != null)
              extensionStepV.removeElement((business.CStep) allStepV.elementAt(i));
            if (variationStepV != null)
              variationStepV.removeElement((business.CStep) allStepV.elementAt(i));
            allStepV.removeElementAt(i);
          } else {
            finished = false;
          }
        }

        // correct all steps after choosed step
        int numberOfLevels = step.getNumberOfLevels();
        step.removeFromStepAtLevel(
            allStepV, allStepV.indexOf(step) +1,
            numberOfLevels-1);

        // delete choosed step
        stepStrT2V.removeElement(step);
        allStepV.removeElement(step);

        // reload table (otherwise problem with JComboBox :-( )
        if (type == business.Global.TYPE_USECASE) {

            Vector newDataV = new Vector();
            for (int j=0; j<stepStrT2V.size(); j++) {
               // next row
               Vector rowV = new Vector();

               // step
               rowV.add(((business.CStepStrT2) stepStrT2V.elementAt(j)).getStep());

               // actor
               if (((business.CStepStrT2) stepStrT2V.elementAt(j)).getActor() == null) {
                 rowV.add(new String("none"));
               } else {
                 rowV.add(((business.CStepStrT2) stepStrT2V.elementAt(j)).getActor().getType());
               }

               // action
               rowV.add(((business.CStepStrT2) stepStrT2V.elementAt(j)).getAction());
               newDataV.add(rowV);
            }
            tableModel.setDataVector(newDataV, columnNamesUc);

        } else {

            Vector newDataV = new Vector();
            for (int j=0; j<stepStrT2V.size(); j++) {
              // next row
              Vector rowV = new Vector();

              // step
              rowV.add(((business.CStepStrT2) stepStrT2V.elementAt(j)).getStep());

              // agent
              if (((business.CStepStrT2) stepStrT2V.elementAt(j)).getAgent() == null) {
                rowV.add(new String("none"));
              } else {
                rowV.add(((business.CStepStrT2) stepStrT2V.elementAt(j)).getAgent().getName());
              }

              // action
              rowV.add(((business.CStepStrT2) stepStrT2V.elementAt(j)).getAction());
              newDataV.add(rowV);
            }
            tableModel.setDataVector(newDataV, columnNamesSc);
        }

          TableColumn typeColumn = scenarioT.getColumnModel().getColumn(1);
          actorCB.removeAllItems();
          if (actorV != null) {
            for (int j=0; j<actorV.size(); j++) {
              if (type == business.Global.TYPE_USECASE) {
                actorCB.addItem(((business.CActor) actorV.elementAt(j)).getType());
              } else {
                actorCB.addItem(((business.CAgent) actorV.elementAt(j)).getName());
              }
            }
          }
          actorCB.addItem(new String("none"));
          typeColumn.setCellEditor(new DefaultCellEditor(actorCB));

          scenarioT.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
          typeColumn = scenarioT.getColumnModel().getColumn(0);
          typeColumn.setPreferredWidth(30);
          typeColumn = scenarioT.getColumnModel().getColumn(1);
          typeColumn.setPreferredWidth(100);
          typeColumn = scenarioT.getColumnModel().getColumn(2);
          typeColumn.setPreferredWidth(370);

      //  new step
      } else if(e.getActionCommand().equals(this.actionNewStep)) {

        gui.CNewScStepD newScStepD = null;

        if (parent.getClass().getSuperclass().isInstance(new JFrame())) {
          newScStepD =
            new gui.CNewScStepD((Frame) parent, mainStepV, business.Global.STYLE_STRUCT_WITH_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        } else {
          newScStepD =
            new gui.CNewScStepD((Dialog) parent, mainStepV, business.Global.STYLE_STRUCT_WITH_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        }
        if (newScStepD != null)
          newScStepD.showDialog();
      //------------------------------------------------------------
      }else if(e.getActionCommand().equals(this.actionPhrasesStep)) {
        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        if (minIndex < 0) {
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }
        business.CStep step = (business.CStep) this.stepStrT2V.elementAt(minIndex);
        new gui.GSentence(null,step);
      }

      observer.sendMessage(business.CObserver.Reload_Screen);
    }//is not editing
  }//action performed

  /** is called if gui has to be reload
   *  @param AStepStrT2V new scenario steps
   *  @param AActorV new actors/agents
   */
  public void reload() {
    reload(this.stepStrT2V,this.actorV);
  }
  public void reload(Vector AStepStrT2V, Vector AActorV) {

    stepStrT2V = AStepStrT2V;
    if (stepStrT2V == null) stepStrT2V = new Vector();
    actorV = AActorV;

    TableColumn typeColumn = scenarioT.getColumnModel().getColumn(1);
    actorCB.removeAllItems();
    if (AActorV != null) {
      for (int i=0; i<AActorV.size(); i++) {
        if (type.equals(business.Global.TYPE_USECASE)) {
          actorCB.addItem(((business.CActor) AActorV.elementAt(i)).getType());
        } else {
          actorCB.addItem(((business.CAgent) AActorV.elementAt(i)).getName());
        }
      }
    }
    actorCB.addItem(new String("none"));
    actorCB.addItem(business.Global.project.getSystem());
    typeColumn.setCellEditor(new DefaultCellEditor(actorCB));

    for (int i=tableModel.getRowCount()-1; i>=0; i--) {
      //System.out.println("  removeRow: " + i);
      tableModel.removeRow(i);
    }

    for (int i=0; i<stepStrT2V.size(); i++) {

      Vector newRow = new Vector();
      newRow.add(((business.CStep) stepStrT2V.elementAt(i)).getStep());

      if (actorV != null && actorV.size()>0) {
         if (type.equals(business.Global.TYPE_USECASE)) {
           // actor
           if (((business.CStepStrT2) stepStrT2V.elementAt(i)).getActor() != null)
             newRow.add((((business.CStepStrT2) stepStrT2V.elementAt(i)).getActor()).getType());
           else if (((business.CStepStrT2) stepStrT2V.elementAt(i)).isSystemStep())
             newRow.add(business.Global.project.getSystem());
           else
             newRow.add(new String("none"));
         } else {
            // agent
           if (((business.CStepStrT2) stepStrT2V.elementAt(i)).getAgent() != null)
             newRow.add((((business.CStepStrT2) stepStrT2V.elementAt(i)).getAgent()).getName());
           else if (((business.CStepStrT2) stepStrT2V.elementAt(i)).isSystemStep())
             newRow.add(business.Global.project.getSystem());
           else
             newRow.add(new String("none"));
         }

      } else if (((business.CStepStrT2) stepStrT2V.elementAt(i)).isSystemStep()) {
        newRow.add(business.Global.project.getSystem());
      } else {
        newRow.add(new String("none"));
      }

      if (((business.CStep) stepStrT2V.elementAt(i)).getAction() != null) {
        newRow.add(((business.CStep) stepStrT2V.elementAt(i)).getAction());
      } else {
        newRow.add(new String(""));
      }

      tableModel.addRow(newRow);
    }
  }

  /** called if gui or data has to be updated
   *  @param AMessage type of message
   */
  public void receiveMessage(int AMessage) {
    if (AMessage == business.CObserver.Reload_Screen)
      this.reload(this.stepStrT2V, actorV);
    else
      this.getStepStrT2();
  }

  public void editingStopped(){
    //dosent work as expected
    //System.out.println("WARNING editingStopped()");
    //this.scenarioT.editingStopped(new ChangeEvent(this));

    DefaultCellEditor editor  =(DefaultCellEditor)scenarioT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();

  }
}
