package gui;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
/**
 *
 *  OLD              OLD                 OLD
 *
 *
 *
 * ********************************************************
 *
 *       D O       N O T         U S E
 *
 *        use:GStyle2P insted
 *
 *  * ********************************************************
 *
 *       D O       N O T         U S E
 *
 *        use:GStyle2P insted
 *
 * * ********************************************************
 *
 *       D O       N O T         U S E
 *
 *        use:GStyle2P insted
 *
 * ********************************************************
 *
 *
 *
 *
 * Description: gui for scenario steps of type business.CStepStrT1
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CStyle2P extends JPanel implements ActionListener, business.IListener {

  /** action steps of type business.CStepStr1 */
  private Vector stepStrT1V = null;

  /** which scenario data have to be displayed
   *  (business.Global.kindDataSuccessSc for success scenario,
   *   business.Global.kindDataExtension for extensions,
   *   business.Global.kindDataVariation for variations)
   */
  private String kindOfData = null;

  /** action steps for main success scenario of use case and scenario */
  private Vector mainStepV = null;
  /** action steps for extension of use case */
  private Vector extensionStepV = null;
  /** action steps for variation of use case */
  private Vector variationStepV = null;
  /** all action steps for use case and scenario (sorted) */
  private Vector allStepV = null;

  /** observer to inform about update */
  private business.IObserver observer = null;

  /** Tablemodel */
  private CTableModel tableModel = null;
  /** Table */
  private JTable scenarioT = null;
  /** column names for table */
  private final String[] columnNames = {"step", "action / state"};

  /** part of parent */
  private Object parent = null;

  /** actions */
  private final String actionCopyStep = new String("CopyStep");
  private final String actionMoveStep = new String("MoveStep");
  private final String actionNewStep = new String("NewStep");
  private final String actionDeleteStep = new String("DeleteString");
  private final String actionPhrasesStep = new String("Phrases");

  /** constructor
   *  @param AParent parent window
   *  @param AMainStepV vector of steps success scenario of type business.CStepStrT2
   *  @param AKindOfData which scenario data have to be displayed
   *  (business.Global.kindDataSuccessSc for success scenario,
   *   business.Global.kindDataExtension for extensions,
   *   business.Global.kindDataVariation for variations)
   *  @param AExtensionStepV vector of extension steps of success scenario
   *  of type business.CStepStrT2
   *  @param AVariationStepV vector of variation steps of success scenario
   *  of type business.CStepStrT2
   *  @param AObserver observer
   */
  public CStyle2P(Object AParent,
                  Vector AMainStepV,
                  String AKindOfData, // MainScenario, Extension, Variation
                  Vector AExtensionStepV,
                  Vector AVariationStepV,
                  business.IObserver AObserver) {

    parent = AParent;
    kindOfData = AKindOfData;
    extensionStepV = AExtensionStepV;
    variationStepV = AVariationStepV;
    mainStepV = AMainStepV;
    observer = AObserver;

    // set data to be displayed
    if (AKindOfData.equals(business.Global.kindDataSuccessSc)) {
      stepStrT1V = AMainStepV;
    } else if (AKindOfData.equals(business.Global.kindDataExtension)) {
      stepStrT1V = AExtensionStepV;
    } else {
      stepStrT1V = AVariationStepV;
    }
    if (stepStrT1V == null) stepStrT1V = new Vector();

    init();
  }

  /** initialize gui */
  private void init() {

    this.setLayout(new BorderLayout(5, 5));

    // scenario panel
    JPanel scenarioP = new JPanel();
    scenarioP.setLayout(new BorderLayout(5, 5));

    tableModel = new gui.CTableModel(columnNames, 0);
    tableModel.setEditableCol(0,false);
    for (int i=0; i<stepStrT1V.size(); i++) {
      Vector newRow = new Vector();
      newRow.add(((business.CStepStrT1) stepStrT1V.elementAt(i)).getStep());
      newRow.add(((business.CStepStrT1) stepStrT1V.elementAt(i)).getAction());
      tableModel.addRow(newRow);
    }
    scenarioT = new JTable(tableModel);
    scenarioT.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    TableColumn column = scenarioT.getColumnModel().getColumn(0);
    column.setPreferredWidth(80);
    column = scenarioT.getColumnModel().getColumn(1);
    column.setPreferredWidth(420);

    scenarioT.setPreferredScrollableViewportSize(new Dimension(500, 70));
    JScrollPane scenarioTSP = new JScrollPane(scenarioT);

    // button-panel
    JPanel scenarioBP = new JPanel();
    scenarioBP.setLayout(
      new BoxLayout(scenarioBP, BoxLayout.Y_AXIS));

    JButton scenarioNewB = new JButton ("New ...");
    scenarioNewB.setActionCommand(this.actionNewStep);
    scenarioNewB.addActionListener(this);

    JButton scenarioPhrasesB = new JButton ("Phrases ...");
    scenarioPhrasesB.setActionCommand(this.actionPhrasesStep);
    scenarioPhrasesB.addActionListener(this);

    JButton scenarioCopyB = new JButton ("Copy ...");
    scenarioCopyB.setActionCommand(this.actionCopyStep);
    scenarioCopyB.addActionListener(this);

    JButton scenarioMoveB = new JButton ("Move ...");
    scenarioMoveB.setActionCommand(this.actionMoveStep);
    scenarioMoveB.addActionListener(this);

    JButton scenarioDeleteB = new JButton ("Delete ...");
    scenarioDeleteB.setActionCommand(this.actionDeleteStep);
    scenarioDeleteB.addActionListener(this);

    scenarioBP.add(scenarioNewB);
    scenarioBP.add(scenarioCopyB);
    scenarioBP.add(scenarioMoveB);
    scenarioBP.add(scenarioDeleteB);
    scenarioBP.add(scenarioPhrasesB);

    add(scenarioTSP, BorderLayout.CENTER);
    add(scenarioBP, BorderLayout.EAST);
  }

  /** is called if user wants to add, copy, move or delete scenario step */
  public void actionPerformed(ActionEvent e) {
    editingStopped();

//  tableModel
    if (scenarioT.isEditing()){
      JOptionPane.showMessageDialog(null,"Please finish editing row:"+
        (scenarioT.getEditingRow()+1) + " in table:" + kindOfData);
    }else{
      observer.sendMessage(business.CObserver.Read_User_Input);
      int kindOfStep = business.Global.Step_New;
      allStepV = (Vector) mainStepV.clone();
      for (int i=0; extensionStepV != null && i<extensionStepV.size(); i++)
        ((business.CStep) extensionStepV.elementAt(i)).insertStep(allStepV);
      for (int i=0; variationStepV != null && i<variationStepV.size(); i++)
        ((business.CStep) variationStepV.elementAt(i)).insertStep(allStepV);

      // copy step
      if (e.getActionCommand().equals(this.actionCopyStep)) {
        if (extensionStepV != null && variationStepV != null)
          kindOfStep = business.Global.Step_CopyMove;

        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();

        if (minIndex < 0) {
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }

        // step, which is to copy
        business.CStepStrT1 copyStep =
          (business.CStepStrT1) stepStrT1V.elementAt(minIndex);

        gui.CNewScStepD newScStepD = null;
        if (parent.getClass().getSuperclass().isInstance(new JFrame())) {
          newScStepD =
            new gui.CNewScStepD((Frame) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITHOUT_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        } else {
          newScStepD =
            new gui.CNewScStepD((Dialog) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITHOUT_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        }
        if (newScStepD != null) {
          business.CStepStrT1 newStep =
          (business.CStepStrT1) newScStepD.showDialog();
          if (newStep != null) {
            newStep.setAction(copyStep.getAction());
          }
        }

      // move step
      } else if (e.getActionCommand().equals(this.actionMoveStep)) {

        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();

        if (minIndex < 0) {
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }

        if (extensionStepV != null && variationStepV != null)
          kindOfStep = business.Global.Step_CopyMove;

        business.CStepStrT1 moveStep =
          (business.CStepStrT1) stepStrT1V.elementAt(minIndex);

        // create dialog to create new step and insert step
        gui.CNewScStepD newScStepD = null;
        if (parent.getClass().getSuperclass().isInstance(new JFrame())) {
          newScStepD =
            new gui.CNewScStepD((Frame) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITHOUT_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        } else {
          newScStepD =
            new gui.CNewScStepD((Dialog) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITHOUT_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        }

        if (newScStepD != null) {

          business.CStepStrT1 newStep =
          (business.CStepStrT1) newScStepD.showDialog();

          if (newStep != null) {  // ok

            Vector newAllStepV = (Vector) allStepV.clone();
            newStep.insertStep(newAllStepV);

            // set action
            newStep.setAction(moveStep.getAction());

            // move also all substeps of choosed step
            boolean finished = true;
            for (int i=allStepV.indexOf(moveStep)+1;
                 i<allStepV.size() && finished == true; i++) {
              if (((business.CStep) allStepV.elementAt(i)).getStep().startsWith(
                  moveStep.getStep())) {

                business.CStep step = (business.CStep) allStepV.elementAt(i);

                // change step, delete and insert again
                step.setStep(
                  newStep.getStep() + step.getStep().substring(
                                      moveStep.getStep().length()));

                stepStrT1V.remove(step);

                if (mainStepV.contains(step)) {
                  mainStepV.removeElement(step);
                  step.insertStep(mainStepV);
                } else if (extensionStepV != null && extensionStepV.contains(step)) {
                  extensionStepV.removeElement(step);
                  step.insertStep(extensionStepV);
                } else if (variationStepV != null && variationStepV.contains(step)) {
                  variationStepV.removeElement(step);
                  step.insertStep(variationStepV);
                }

                newAllStepV.removeElement(step);
                step.insertStep(newAllStepV);

              } else {
                finished = false;
              }
            }

            // correct all steps after new step
            if (!newStep.getStep().startsWith(moveStep.getStep())) {
              moveStep.removeFromStepAtLevel(
                newAllStepV, newAllStepV.indexOf(moveStep)+1,
                moveStep.getNumberOfLevels()-1);
            }

            // delete old step
            stepStrT1V.remove(moveStep);
            newAllStepV.remove(moveStep);

            allStepV = newAllStepV;
          }
        }

      // delete step
      } else if (e.getActionCommand().equals(this.actionDeleteStep)) {
        if(scenarioT.getSelectionModel().getMinSelectionIndex()<0){
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }
        int sure = JOptionPane.showConfirmDialog(
        (Window) parent,
        "Are you sure ? \nYou will delete all substeps.",
        "question",
        JOptionPane.YES_NO_OPTION);
        if (sure == JOptionPane.NO_OPTION) return;

        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int index = rowSM.getMinSelectionIndex();
        business.CStep step = (business.CStep) stepStrT1V.elementAt(index);

        // delete all substeps of choosed step
        boolean finished = true;
        for (int i=allStepV.indexOf(step)+1;
             i<allStepV.size() && finished == true;) {
          if (((business.CStep) allStepV.elementAt(i)).getStep().startsWith(
              step.getStep())) {
            stepStrT1V.removeElement((business.CStep) allStepV.elementAt(i));
            mainStepV.removeElement((business.CStep) allStepV.elementAt(i));
            if (extensionStepV != null)
              extensionStepV.removeElement((business.CStep) allStepV.elementAt(i));
            if (variationStepV != null)
              variationStepV.removeElement((business.CStep) allStepV.elementAt(i));
            allStepV.removeElementAt(i);
          } else {
            finished = false;
          }
        }

        // correct all steps after choosed step
        int numberOfLevels = step.getNumberOfLevels();
        step.removeFromStepAtLevel(
            allStepV, allStepV.indexOf(step) +1,
            numberOfLevels-1);

        // delete choosed step
        stepStrT1V.removeElement(step);
        allStepV.removeElement(step);
      //------------------------------------------------------------
      // new step
      } else if(e.getActionCommand().equals(this.actionNewStep)) {

        gui.CNewScStepD newScStepD = null;
        if (parent.getClass().getSuperclass().isInstance(new JFrame())) {
          newScStepD =
            new gui.CNewScStepD((Frame) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITHOUT_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        } else {
          newScStepD =
            new gui.CNewScStepD((Dialog) parent, mainStepV,
                business.Global.STYLE_STRUCT_WITHOUT_ACTOR,
                kindOfData, extensionStepV, variationStepV, observer, kindOfStep);
        }
        if (newScStepD != null) newScStepD.showDialog();
      //------------------------------------------------------------
      }else if(e.getActionCommand().equals(this.actionPhrasesStep)) {
        ListSelectionModel rowSM = scenarioT.getSelectionModel();
        int minIndex = rowSM.getMinSelectionIndex();
        if (minIndex < 0) {
          contr.CError.showSelectRowInTable((Component) parent);
          return;
        }
        business.CStep step = (business.CStep) this.stepStrT1V.elementAt(minIndex);
        new gui.GSentence(null,step);
        //this.reload(); see line below
      }
      observer.sendMessage(business.CObserver.Reload_Screen);
    }//is not editing table
  }//action performed


  /**
   * reads scenario steps of type
   * <code> business.CStepStrT1 </code>
   * from table
   *
   * @return Vector of scenario steps
   */
  public Vector getStepStrT1() {
    editingStopped();
    if (scenarioT.isEditing()){
      JOptionPane.showMessageDialog(null,"Please finish editing row:"+
        (scenarioT.getEditingRow()+1) + " in table:" + kindOfData);
        business.Global.error = true;
    }

    for (int i = 0; i < stepStrT1V.size(); i++) {
      ((business.CStepStrT1) stepStrT1V.elementAt(i)).setPosition(i);
      ((business.CStepStrT1) stepStrT1V.elementAt(i)).setStep(
        ((String)tableModel.getValueAt(i, 0)));
      ((business.CStepStrT1) stepStrT1V.elementAt(i)).setAction(
        ((String)tableModel.getValueAt(i, 1)));
    }

    return stepStrT1V;
  }

  /**
   * update table of scenario steps
   *
   * @param AStepStrT1V Vector of scenario steps of type
   * <code> business.CStepStrT1 </code>
   * @return void
   */
  public void reload() {
    reload(this.stepStrT1V);
  }

  public void reload(Vector AStepStrT1V) {

    stepStrT1V = AStepStrT1V;
    // if (stepStrT1V == null) stepStrT1V = new Vector();

    // === delete all rows of table
    for (int i=tableModel.getRowCount()-1; i>=0; i--)
      tableModel.removeRow(i);

    // === create for each step new row
    for (int i=0; i<stepStrT1V.size(); i++) {

      Vector newRow = new Vector();
      newRow.add(((business.CStep) stepStrT1V.elementAt(i)).getStep());

      if (((business.CStep) stepStrT1V.elementAt(i)).getAction() != null) {
        newRow.add(((business.CStep) stepStrT1V.elementAt(i)).getAction());
      } else {
        newRow.add(new String(""));
      }

      tableModel.addRow(newRow);
    }
  }

  /**
   * receives messages for updating table of scenario steps
   *
   * @param AMessage type of message
   * @return void
   */
  public void receiveMessage(int AMessage) {

    // === update screen
    if (AMessage == business.CObserver.Reload_Screen)
      this.reload(this.stepStrT1V);

    // === read content of table
    else // business.CObserver.Read_User_Input
      this.getStepStrT1();
  }

  public void editingStopped(){
    //dosent work as expected
    //System.out.println("WARNING editingStopped()");
    //this.scenarioT.editingStopped(new ChangeEvent(this));

    DefaultCellEditor editor  =(DefaultCellEditor)scenarioT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();
  }
  public void moveItem(int i){
//    this.scenarioT.removeRowSelectionInterval(0,this.scenarioT.getRowCount()-1);
//    this.scenarioT.changeSelection(i,0,true,false);
    selectItem(i);
    this.actionPerformed( new ActionEvent(this,ActionEvent.ACTION_PERFORMED,this.actionMoveStep));

  }
  public void selectItem(int i){
    this.scenarioT.removeRowSelectionInterval(0,this.scenarioT.getRowCount()-1);
    this.scenarioT.changeSelection(i,0,true,false);
  }


}
