package gui;

import java.util.*;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;

/**
 *
 * Description: gui for unstructured scenario description
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
  public class CStyle1P extends JPanel {

    private String text = null;
    private JTextPane scenarioTP = null;

    /** constructor
     *  @param AText unstructured scenario description
     */
    public CStyle1P(String AText) {

      text = AText;
      if (text == null) text = new String("");

      scenarioTP = new JTextPane();

      JScrollPane scenarioTPSP = new JScrollPane(scenarioTP);
      scenarioTPSP.setPreferredSize(new Dimension(550, 300));

      add(scenarioTPSP);

      Style def =
      StyleContext.getDefaultStyleContext().getStyle(
        StyleContext.DEFAULT_STYLE);
      Style regular = scenarioTP.addStyle("regular", def);
      Document doc = scenarioTP.getDocument();
      try {
        doc.insertString(
         doc.getLength(), text, scenarioTP.getStyle("regular"));
      } catch (BadLocationException ble) {
        System.err.println("Couldn't insert initial text.");
      }
    }

    /** returns unstructured scenario description
     *  @return unstructured scenario description
     */
    public String getUnstructText() {
      return scenarioTP.getText();
    }
  }
