package gui;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * Description: TabbedPane for three styles of scenario descriptions
 * (unstructured text,
 *  steps of type business.CStepStrT1,
 *  steps of type business.CStepStrT2)
 *
 *  used by viewpointScenarioP (gui)
 * @author Kathrin Boettger modified by Oscar Aguilera
 *
 * @version 1.2
 */
public class CScenarioTP extends JTabbedPane{

  gui.CStyle1P style1P = null;
  gui.GStyle2P style2P = null;
  gui.CStyle3P style3P = null;

  /** constructor
   *  @param AParent parent window
   *  @param AUnstructText unstructured scenario description
   *  @param AStepStrT1 vector of scenario steps of type
   *  business.CStepStrT1
   *  @param AStepStrT2 vector of scenario steps of type
   *  business.CStepStrT2
   *  @param AActorV actors or agents
   */
  public CScenarioTP(Object AParent,
                     String AUnstructText,
                     Vector AStepStrT1,
                     Vector AStepStrT2,
                     Vector AActorV) {

    business.CObserver observerStrT1 = new business.CObserver();

    style2P = new GStyle2P(AParent, AStepStrT1,
    business.Global.kindDataSuccessSc, null, null, observerStrT1);
    observerStrT1.addListener(style2P);
    this.addTab("Style ***", style2P);

    style3P = new CStyle3P(AParent, AStepStrT2, AActorV, business.Global.TYPE_VP_SCENARIO, business.Global.kindDataSuccessSc, null, null, observerStrT1);
    observerStrT1.addListener(style3P);
    this.addTab("Style **", style3P);

    style1P = new CStyle1P(AUnstructText);
    this.addTab("Style *", style1P);

    this.setPreferredSize(new Dimension(550, 300));
  }

  /** returns unstructured scenario description
   *  @return unstructured scenario description
   */
  public String getUnstructText() {
    return style1P.getUnstructText();
  }

  /** returns scenario steps of type business.CStepStrT1
   *  @returns scenario steps of type business.CStepStrT1
   */
  public Vector getStepStrT1() {
    return style2P.getStepStrT1();
  }

  /** returns scenario steps of type business.CStepStrT2
   *  @returns scenario steps of type business.CStepStrT2
   */
  public Vector getStepStrT2() {
    return style3P.getStepStrT2();
  }

  /** returns chosen style = which tab is in the foreground
   *  @return chosen style = which tab is in the foreground
   */
  public int getStyle() {
    return this.getSelectedIndex();
  }

  /** called to reload scenario steps of type business.CStepStrT2 */
  public void reload(Vector AStepStrT2, Vector AActorV) {
    style3P.reload(AStepStrT2, AActorV);
  }

  public void reload() {
    style3P.reload();
    style2P.reload();
  }

}
