package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: creates a dialog to choose a shared shared from a combobox to
 * open this shared shared
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CScenarioOpenD extends JDialog {

  /** this dialog */
  private static CScenarioOpenD dialogD = null;
  /** chosen vp */
  private business.CViewpointUc viewpointUC = null;
  /** combobox to choose shared scenario */
  private JComboBox nameCB = null;

  private Vector scenarioV = null;

  /** constructor
   *  @param AParent parent frame
   *  @param vector of shared scenarios
   */
  public CScenarioOpenD(JFrame AParent, business.CViewpointUc AviewpointUC) {
    super(AParent, "Open Scenario", true); // not true
    viewpointUC = AviewpointUC;
    dialogD = this;
    init();
    this.pack();
    this.show();

  }

  /** initialize gui */
  private void init() {
    JPanel scenarioP = new JPanel();
    // scenario panel

    scenarioV =  persistence.CViewpointSc.getAllViewpointScOf(viewpointUC);

    JLabel nameL;
    if(scenarioV.size()!=0){
      nameL = new JLabel("Scenario Viewpoint:");
    }else{
       nameL = new JLabel("No Scenario Viewpoint Found");
    }
    scenarioP.add(nameL);


    nameCB = new JComboBox();
    if (scenarioV.size() > 0) {
      for (int i=0;  i< scenarioV.size();  i++) {
        business.CViewpointSc VPSC = (business.CViewpointSc) scenarioV.elementAt(i);
        nameCB.addItem(VPSC.getName());
      }
      nameCB.setSelectedIndex(0);
    }
    if(scenarioV.size()!=0)  scenarioP.add(nameCB);


    // button panel
    final JButton createB = new JButton("Create scenario");
    createB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String name = JOptionPane.showInputDialog(null,"Name:");
        if(name != null && name.length() >0){
          business.CViewpointSc vpsc = new business.CViewpointSc();
          vpsc.setName(name);
          vpsc.setViewpointUc(viewpointUC);
          vpsc.setViewpointAgent(viewpointUC.getViewpointAgent());
          business.Global.contrViewpoint.createViewpoint(vpsc);
          business.Global.contrViewpoint.openViewpoint(vpsc);
          business.Global.contrViewpoint.showViewpoint(vpsc);

          dispose();
        }
      }
    });




    final JButton openB = new JButton("Open scenario");
    openB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

      business.Global.contrViewpoint.openViewpoint((business.CViewpointSc) scenarioV.elementAt(nameCB.getSelectedIndex()));
      boolean found = false;
      for (int i=0; found == false && i<business.Global.viewpointV.size(); i++) {
        if (((business.CViewpoint) business.Global.viewpointV.elementAt(i)).getId() == ((business.CViewpointSc)scenarioV.elementAt(nameCB.getSelectedIndex())).getId() ){
          found = true;
          business.Global.contrRecocase.showViewpoint(i);
          //System.out.println("FOUND");
        }
      }
      dispose();

      }
    });

    JButton cancelB = new JButton("Cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        CScenarioOpenD.dialogD.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));

    if(scenarioV.size()!=0)  buttonP.add(openB);
    buttonP.add(createB);
    buttonP.add(cancelB);

    getContentPane().add(scenarioP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
    });



  }

  /** shows dialog */
  public void showDialog() {
    dialogD.setLocationRelativeTo(null);
    dialogD.setVisible(true);
  }
}
