package gui;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.event.TableModelEvent;
import javax.swing.event.*;


/**
 * Description: An object of this class is part of a frame to capture
 * data of a project.
 *
 * @author Kathrin Boettger and Oscar Aguilera
 *
 * @version 1.0
 */
public class CProjectP extends JPanel implements ActionListener,TableModelListener {

  //actors
  //private gui.CActorsF actorsF = null;

  /** current project */
  private business.CProject project = null;
  private Vector useCaseV = new Vector();
  private Vector actorsV  = new Vector();
  // gui
  private JTextField nameTF = null;
  private JTextField systemTF = null;
  private gui.CTableModel tableModel = null;
  private JTable actorsT = null;

  private gui.CTableModel tableModelUC = null;
  private JTable useCaseT = null;
  /** constructor
   *  @param AProject project to be displayed
   */
  public CProjectP(business.CProject AProject) {
    project = AProject;
    init();
  }

  /** initialize gui*/
  private void init() {

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    this.setLayout(gridbag);

    // ===================================================================
    // ===== label name
    // ===================================================================
    JLabel nameL = new JLabel("Name:*");
    c.gridx = 0;
    c.gridy = 0;
    c.insets = new Insets(10, 10, 10, 10);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(nameL, c);
    this.add(nameL);

    // ===================================================================
    // ===== textfield name
    // ===================================================================
    nameTF = new JTextField(30);
    if (project != null && project.getName() != null)
      nameTF.setText(project.getName());
    c.gridx = 1;
    c.gridy = 0;
    gridbag.setConstraints(nameTF, c);
    this.add(nameTF);


    // ===================================================================
    // ===== label system
    // ===================================================================
    JLabel systemL = new JLabel("System:*");
    c.gridx = 0;
    c.gridy = 1;
    c.insets = new Insets(10, 10, 10, 10);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(systemL, c);
    this.add(systemL);

    // ===================================================================
    // ===== textfield system
    // ===================================================================
    systemTF = new JTextField(30);
    if (project != null && project.getSystem() != null)
      systemTF.setText(project.getSystem());
    c.gridx = 1;
    c.gridy = 1;
    gridbag.setConstraints(systemTF, c);
    this.add(systemTF);

    // ===================================================================
    // ===== label actor
    // ===================================================================
    JLabel actorsL = new JLabel("Actors:");
    c.gridx = 0;
    c.gridy = 2;
    gridbag.setConstraints(actorsL, c);
    this.add(actorsL);

    // ===================================================================
    // ===== table actor
    // ===================================================================

    JComboBox actorCB = new JComboBox();
    JPanel actorsP = new JPanel();
    actorsP.setLayout(new BorderLayout(5, 5));
    Vector title =  new Vector();    title.add("Actor");
    Vector actors = new Vector();
    for(int i = 0; i < project.getActors().size() ; i++){
        Vector actor = new Vector();
        actor.add(project.getActors().elementAt(i));
        actors.add(actor);
    }
    tableModel = new gui.CTableModel(actors,title);
    tableModel.addTableModelListener(this);
    actorsT = new JTable(tableModel);
    Vector allActors = persistence.CActor.getAllActors();
    for (int i=0; i< allActors.size(); i++) {
      actorCB.addItem( allActors.elementAt(i));
    }
    TableColumn typeColumnActors = actorsT.getColumnModel().getColumn(0);
    typeColumnActors.setCellEditor(new DefaultCellEditor(actorCB));

    actorsT.setPreferredScrollableViewportSize(new Dimension(200, 50));
    JScrollPane actorsTSP = new JScrollPane(actorsT);

    c.gridx = 1;
    c.gridy = 2;

    JPanel actorsBP = new JPanel();
    actorsBP.setLayout(new BoxLayout(actorsBP, BoxLayout.Y_AXIS));

    JButton actorsAddB = new JButton ("Add");
    actorsAddB.setActionCommand("addActor");
    actorsAddB.addActionListener(this);
    actorsBP.add(actorsAddB);


    JButton actorsDeleteB = new JButton ("Remove");
    actorsDeleteB.setActionCommand("deleteActor");
    actorsDeleteB.addActionListener(this);
    actorsBP.add(actorsDeleteB);

    JButton actorsNewB = new JButton ("View / Create / Edit ");
    actorsNewB.setActionCommand("newActor");
    actorsNewB.addActionListener(this);
    actorsBP.add(actorsNewB);


    actorsP.add(actorsTSP, BorderLayout.CENTER);
    actorsP.add(actorsBP, BorderLayout.EAST);

    gridbag.setConstraints(actorsP, c);
    this.add(actorsP);

    // ===================================================================
    // =====  use cases
    // ===================================================================

    JLabel useCaseL = new JLabel("Use Cases:");
    c.gridx = 0;
    c.gridy = 3;
    gridbag.setConstraints(useCaseL, c);

    // ===================================================================
    // =====  use cases Table
    // ===================================================================
    this.add(useCaseL);
    final String[] columnNamesUC = {"Use Case"};
    JPanel useCaseP = new JPanel();
    useCaseP.setLayout(new BorderLayout(5, 5));
    tableModelUC = new gui.CTableModel(columnNamesUC, 0);
    tableModelUC.setEditable(false);
    useCaseT = new JTable(tableModelUC);

    useCaseV = persistence.CUsecase.getAllUsecasesOfProject(business.Global.project);
    if (useCaseV != null && useCaseV.size()>0) {
      for (int i=0; i<useCaseV.size(); i++) {
        Vector uc  = new Vector();
        uc.add(((business.CUsecase)useCaseV.elementAt(i)).getName()) ;
        tableModelUC.addRow(uc);
      }
    }
    useCaseT.setPreferredScrollableViewportSize(new Dimension(200, 70));
    JScrollPane useCaseTSP = new JScrollPane(useCaseT);

    c.gridx = 1;
    c.gridy = 3;

    JPanel useCaseBP = new JPanel();
    useCaseBP.setLayout(new BoxLayout(useCaseBP, BoxLayout.Y_AXIS));

    JButton useCaseNewB = new JButton ("New");
    useCaseNewB.setActionCommand("newUseCase");
    useCaseNewB.addActionListener(this);

    JButton useCaseDeleteB = new JButton ("Delete");
    useCaseDeleteB.setActionCommand("deleteUseCase");
    useCaseDeleteB.addActionListener(this);

    JButton useCaseEditB = new JButton ("Modify Actors/Agents");
    useCaseEditB.setActionCommand("editUseCase");
    useCaseEditB.addActionListener(this);

    JButton useCaseRefreshB = new JButton ("Refresh List");
    useCaseRefreshB.setActionCommand("refresh");
    useCaseRefreshB.addActionListener(this);


    useCaseBP.add(useCaseNewB);
    useCaseBP.add(useCaseDeleteB);
    useCaseBP.add(useCaseEditB);
    useCaseBP.add(useCaseRefreshB);
    useCaseP.add(useCaseTSP, BorderLayout.CENTER);
    useCaseP.add(useCaseBP, BorderLayout.EAST);
    gridbag.setConstraints(useCaseP, c);
    this.add(useCaseP);

  }


    // ===================================================================
    // ===== ACTION
    // ===================================================================

  /** is called if the user wants to add or delete actor */
  public void actionPerformed(ActionEvent e) {
    editingStopped();

    if(business.Global.user.isAnalyst()){
//======= actors
      if(e.getActionCommand().equals("newActor")) {
          new gui.CActorsF();
//        if(actorsF == null)actorsF =  new gui.CActorsF();
//        actorsF.show();
      }else if(e.getActionCommand().equals("addActor")) {

        if (business.Global.usecase != null ){
          JOptionPane.showMessageDialog(null,"For changes to take effects you must reopen the shared use case");
        }

        this.refresh();
        Vector allActors = persistence.CActor.getAllActors();
        if( allActors.size()>0){
          boolean notDone = true;
          Vector newRow = new Vector();
          // newRow.add(new String(""));
          if (this.actorsV.size()==0 ){
            //this.project.setActors(new Vector());
            newRow.add( allActors.elementAt(0));
            notDone = false;
          }else{
            for(  int i = 0; notDone && i < allActors.size();i++){
              boolean found = true;
              for(int j = 0; j <this.actorsV.size();j++){
                //System.out.println(i+":"+usecase.getProject().getActors().size());
                if(((business.CActor) allActors.elementAt(i)).getId() ==
                   ((business.CActor) this.actorsV.elementAt(j)).getId() )
                {
                  found =false;
                }
              }//for
              if(found){
                newRow.add( allActors.elementAt(i));
                notDone = false;
              }//if
            }//for
          }//if
          if(notDone){
            JOptionPane.showMessageDialog(null,"usecase contains already all actors");
          }else{
            //usecase.getActors().add(new business.CActor());
            this.tableModel.addRow(newRow);
          }
        }else{
         JOptionPane.showMessageDialog(null,"there are no actors");
        }
        //this.fixActors(); no need
      } else if (e.getActionCommand().equals("deleteActor")) {
         if (actorsT.getSelectedRow() >-1 ) tableModel.removeRow( actorsT.getSelectedRow());

//======= usecase
      } else if (e.getActionCommand().equals("newUseCase")) {
        business.Global.projectF.save();
        String name = JOptionPane.showInputDialog(this,"name of usecase:");
        if(name != null && name.length()>0){
          business.CUsecase uc = new business.CUsecase();
          uc.setName(name);
          uc.setProject(business.Global.project);
          persistence.CUsecase.insertUsecase(uc);
          new gui.CUseCaseProject(uc);
        }
        refresh();

      } else if (e.getActionCommand().equals("refresh")) {
        refresh();
      } else if (e.getActionCommand().equals("deleteUseCase")) {
        int selected =  useCaseT.getSelectedRow();
        if(selected >-1 && selected < useCaseV.size()){
          business.CUsecase UC = (business.CUsecase) useCaseV.elementAt(selected);
          boolean delete = true;
          gui.CUseCaseProject deleteUsecase = new gui.CUseCaseProject(delete,UC);
        }else{
          JOptionPane.showMessageDialog(null,"Please select a Use Case");
        }
        refresh();
      } else if (e.getActionCommand().equals("editUseCase")) {
        int selected =  useCaseT.getSelectedRow();
        if(selected >-1 && selected < useCaseV.size()){
          business.CUsecase UC = (business.CUsecase) useCaseV.elementAt(selected);
          if(!business.Global.contrUsecase.isOpen( UC) ){
            business.Global.projectF.save();
            new gui.CUseCaseProject(UC);
          }else{
             JOptionPane.showMessageDialog(null,"Can't Modyfy: this Usecase is Open");
          }
        }else{
          JOptionPane.showMessageDialog(null,"Please select a Use Case");
        }
        refresh();
      }
    }else{
      contr.CError.showNoRights(business.Global.recocase);
    }
  }

  /** reads data of project from gui
   *  @return project
   */
  public business.CProject getProject() {
    editingStopped();
    refresh();  //incase no actors where added EVER this will update actorsV

    Vector actorsInProject = persistence.CActor.actorsInUse(this.project);
    for(int i = 0;i<actorsInProject.size();i++){
      boolean notfound = true;
      for(int y = 0;y<actorsV.size();y++){
        long a = (((business.CActor) actorsInProject.elementAt(i)).getId());
        long b = (((business.CActor) actorsV.elementAt(y)).getId());
        if(a== b)notfound = false;
      }
      if( notfound ){
        actorsV.add(actorsInProject.elementAt(i));
        Vector row = new Vector();
        row.add(actorsInProject.elementAt(i));
        this.tableModel.addRow(row);//by duing this actorsV is also updated (it calls refresh() )
        JOptionPane.showMessageDialog(null,"this actor is in use :"+actorsInProject.elementAt(i).toString()+"\n This actor has been added to the project ");
      }
    }

    project.setActors(actorsV);

    if(nameTF.getText().equals("") || nameTF.getText() == null) {
      business.Global.error = true;
    }else{
      project.setName(nameTF.getText());
    }
    project.setSystem(systemTF.getText());

    return project;
  }

  public void editingStopped(){
    DefaultCellEditor editor  =(DefaultCellEditor)this.actorsT.getCellEditor();
    if (editor != null)   editor.stopCellEditing();
  }


  public void refresh(){
    actorsV.clear();
    Vector allActors = persistence.CActor.getAllActors();
    for(int i = 0; i < this.actorsT.getRowCount() ; i++){
      for(int y = 0; y < allActors.size() ; y++){
        long actorInTable = ((business.CActor )this.actorsT.getModel().getValueAt(i,0)).getId();
        long actorInDB = (((business.CActor )allActors.elementAt(y)).getId()) ;
        if(actorInTable == actorInDB){
          if (actorsV.contains(allActors.elementAt(y))){
            JOptionPane.showMessageDialog(null,(((business.CActor )allActors.elementAt(y)).getType())+" is in the table more than once");
          }else{
            actorsV.add(allActors.elementAt(y));
          }
        }
      }
    }
    //fix editor of actors to contain all new actors
    JComboBox actorCB = new JComboBox();
    for (int i=0; i< allActors.size(); i++) {
      actorCB.addItem( allActors.elementAt(i));
    }
    TableColumn typeColumnActors = this.actorsT.getColumnModel().getColumn(0);
    typeColumnActors.setCellEditor(new DefaultCellEditor(actorCB));

    //fix usecase table
    final String[] columnNamesUC = {"Use Case"};
    gui.CTableModel newTableModelUC = new gui.CTableModel(columnNamesUC, 0);
    useCaseV = persistence.CUsecase.getAllUsecasesOfProject(business.Global.project);
    if (useCaseV != null && useCaseV.size()>0) {
      for (int i=0; i<useCaseV.size(); i++) {
        Vector uc  = new Vector();
        uc.add(((business.CUsecase)useCaseV.elementAt(i)).getName()) ;
        newTableModelUC.addRow(uc);
      }
    }
    useCaseT.setModel( newTableModelUC);
    tableModelUC = newTableModelUC;
    tableModelUC.setEditable(false);
    useCaseT.setPreferredScrollableViewportSize(new Dimension(200, 70));
  }

  public void tableChanged(TableModelEvent e) {
    this.refresh();


  }

}
