package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: creates a dialog to choose a project from a combobox to
 * open this project
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CProjectOpenD extends JDialog {

  /** this dialog */
  private gui.CProjectOpenD dialogD = null;
  /** vector of projects */
  private Vector projectV = null;
  /** combobox to choose project */
  private JComboBox nameCB = null;

  /** constructor
   *  @param AParent parent frame
   *  @param vector of projects
   */
  public CProjectOpenD(JFrame AParent, Vector AProjectV) {

    super(AParent, "Open Project", true); // not true
    projectV = AProjectV;
    dialogD = this;

    business.Global.contrProject.setDialog(this);

    init();
    pack();
  }

  /** initialize gui */
  private void init() {

    // project panel
    JPanel projectP = new JPanel();
    projectP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));

    JLabel nameL = new JLabel("name:");
    projectP.add(nameL);

    nameCB = new JComboBox();
    for (int i=0; i<projectV.size(); i++) {
      nameCB.addItem(((business.CProject) projectV.elementAt(i)).getName());
    }
    projectP.add(nameCB);

    // button panel
    final JButton openB = new JButton("open project",business.Global.imageIconProject);
    openB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        business.Global.contrProject.openProject(
          (business.CProject) projectV.elementAt(nameCB.getSelectedIndex()));
      }
    });

    JButton cancelB = new JButton("cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dialogD.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));
    buttonP.add(openB);
    buttonP.add(cancelB);

    this.getContentPane().add(projectP, BorderLayout.CENTER);
    this.getContentPane().add(buttonP, BorderLayout.SOUTH);

    this.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
    });
  }

  /** show dialog */
  public void showDialog() {
    this.setLocationRelativeTo(null);
    this.setVisible(true);
  }
}
