package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: creates a dialog to create a project
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CProjectNewD extends JDialog {

  /** this dialog */
  private gui.CProjectNewD dialogD = null;

  public CProjectNewD(JFrame AParent) {

    super(AParent, "New Project", true); // not true
    dialogD = this;

    business.Global.contrProject.setDialog(this);

    init();
    pack();
  }


  JTextField  nameTF = null;

  private void init() {

    // project panel
    final JPanel projectP = new JPanel();

    JLabel nameL = new JLabel("name:*");
    projectP.add(nameL);

    nameTF = new JTextField(30);
    projectP.add(nameTF);

    // button panel
    final JButton newB = new JButton("Create Project",business.Global.imageIconProject);
    newB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if(nameTF.getText() ==  null || nameTF.getText().length()<1){
          JOptionPane.showMessageDialog(null,"Error in name");
        }else{
          business.Global.error = false;
          business.CProject newProject = new business.CProject(-1, nameTF.getText() , null, null);
          business.Global.contrProject.createProject(newProject);
          if(!business.Global.ProjectIsOpen){

            Vector projects = persistence.CProject.getAllProject();
            for(int i = 0; i < projects.size();i++){
              if(((business.CProject) projects.elementAt(i)).getId()== newProject.getId()){
                newProject = ((business.CProject) projects.elementAt(i));
                System.out.println(newProject.getId()+"*************");
              }
            }

            business.Global.contrProject.openProject(newProject);
            business.Global.contrRecocase.showProject();
          }
          dialogD.dispose();
        }
      }
    });


    JButton cancelB = new JButton("Cancel",business.Global.imageIconClose);
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dialogD.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 30));
    buttonP.add(newB);
    buttonP.add(cancelB);

    getContentPane().add(projectP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
    });
  }

  /** show dialog */
  public void showDialog() {
    dialogD.setLocationRelativeTo(null);
    dialogD.setVisible(true);
  }
}
