package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * Title:        recocase
 * Description:  An object of this class is created if user wants to open
 *               an existing project.
 * Copyright:    Copyright (c) 2000
 * Company:      Macquire uni
 * @author       Kathrin Boettger and Oscar Aguilera
 * @version 1.0
 */

public class CProjectF extends JFrame {

  /** this frame */
  private JFrame frameF = null;
  private gui.CProjectP projectP;

  /** project to be displayed */
  private business.CProject project = null;
  /** button to save project data */
  private JButton saveB = null;

  /** constructor
   *  @param AProject project to be displayed
   */
  public CProjectF(business.CProject AProject) {

    super("Project");
    project = AProject;
    frameF = this;

    business.Global.contrProject.setFrame(this);

    init();
    pack();
  }

  /** initialize gui */
  private void init() {
    // project panel
    projectP = new gui.CProjectP(project);
    // button panel
    saveB = new JButton("Save",business.Global.imageIconSave);
    saveB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        save();
      }
    });

    final JButton deleteB = new JButton("Delete",business.Global.imageIconDelete);
    deleteB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if(business.Global.user.isAnalyst()){

          int sure1 = JOptionPane.showConfirmDialog(
            frameF,
            "Are you sure you want to delete this Project?",
            "delete project",
            JOptionPane.YES_NO_OPTION);
          if (sure1 == JOptionPane.NO_OPTION) return;


          int sure2 = JOptionPane.showConfirmDialog(
            frameF,
            "Are you sure you want to DELETE this Project?   (This will also delete the related use cases and viewpoints)",
            "delete project",
            JOptionPane.YES_NO_OPTION,
            JOptionPane.ERROR_MESSAGE);
          if (sure2 == JOptionPane.NO_OPTION) return;



          business.Global.contrProject.deleteProject(projectP.getProject());
        }else{
          contr.CError.showNoRights(business.Global.recocase);
        }
      }
    });

    final JButton closeB = new JButton("Close Project",business.Global.imageIconClose);
    closeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	business.Global.contrProject.closeProject();
      }
    });

    JButton minimizeB = new JButton("Minimize",business.Global.imageIconMinimize);
    minimizeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        business.Global.contrProject.hideProject();
      }
    });

    JPanel buttonPR = new JPanel();
    buttonPR.setLayout(new FlowLayout(FlowLayout.RIGHT, 1, 1));
    JPanel buttonPL = new JPanel();
    buttonPL.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));

    buttonPL.add(saveB);
    buttonPL.add(deleteB);

    buttonPR.add(minimizeB);
    buttonPR.add(closeB);

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new BorderLayout());
    buttonP.add(buttonPL,BorderLayout.WEST);
    buttonP.add(buttonPR,BorderLayout.EAST);


    getContentPane().add(projectP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.NORTH);
  }

  /** called to save project */

  public void save(){
    if(business.Global.user.isAnalyst()){
      business.Global.error = false;
      business.CProject project = projectP.getProject();
      if(business.Global.error == false && project != null){
        business.Global.contrProject.saveProject(project);
      }else{
        JOptionPane.showMessageDialog(null,"Please make sure all the required fields are filled");
      }
    }else{
      contr.CError.showNoRights(business.Global.recocase);
    }
  }


}
