package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * Description: to create a new scenario step
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CNewScStepD extends JDialog implements ItemListener{

  private JRadioButton subRB;
  private JRadioButton afterRB;
  private JRadioButton beforeRB;
  private JRadioButton condAfterRB;
  private JRadioButton subStepRB;
  /** this dialog */
  private static CNewScStepD dialogD = null;
  /** new step */
  business.CStep newStep = null;
  /** kind of step */
  int kindOfStep;
  /** combobox to choose kind of step */
  private JComboBox kindOfStepCB = null;

  private int style;
  private String kindOfData = null;
  private Vector stepV = null;
  private Vector mainStepV = null;
  private Vector extensionStepV = null;
  private Vector variationStepV = null;
  private Vector allStepForCBV = null;
  private Vector allStepV = null;

  private java.util.Hashtable beforeHt = null;
  private java.util.Hashtable afterHt = null;
  private java.util.Hashtable subHt = null;
  private java.util.Hashtable resultOfHt = null;
  private java.util.Hashtable condAfterHt = null;

  private JComboBox typeCB = null;
  private JButton insertB = null;
  private JPanel stepP = null;

  private static final int NEW_STEP = 0;
  private static final int REPEAT_UNTIL = 1;
  private static final int REPEAT_WHILE = 2;
  private static final int AT_THE_SAME_TIME = 3;
  private static final int IN_ANY_TEMPORAL_ORDER = 4;
  private static final int IF = 5;
  private static final int OTHERWISE_IF = 6;
  private static final int OTHERWISE = 7;

  private int selectedType = NEW_STEP;

  // NEW_STEP, REPEAT_WHILE
  private boolean afterStep = true;
  private boolean beforeStep = false;
  private boolean subStep = false;

  //norm
  private JComboBox beforeCB = new JComboBox();
  private JComboBox afterCB = new JComboBox();
  private JComboBox subCB = new JComboBox();
  //cond
  private JComboBox resultOfCB = new JComboBox();
  private JComboBox condAfterCB = new JComboBox();

  // + REPEAT_WHILE
  private Vector afterV = null;
  private Vector beforeV = null;
  private Vector subV = null;

  // IF_STEP
  private boolean resultOf = true;
  private Vector resultOfV = new Vector();
  private boolean condAfter = false;



  private business.IObserver observer = null;

  /** constructor
   *  @param AParent parent dialog
   *  @param AMainStepV scenario steps of success scenario
   *  @param AStyle type of step
   *  (business.CStepStrT1 or business.CStepStrT2)
   *  @param AKindOfData where new step shall be inserted
   *  (business.Global.kindDataSuccessSc for success scenario,
   *   business.Global.kindDataExtension for extensions,
   *   business.Global.kindDataVariation for variations)
   *  @param AExtensionStepV scenario steps of extensions
   *  @param AVariationStepV scenario steps of variations
   *  @param AKindOfStep
   */
  public CNewScStepD(Dialog AParent,
                     Vector AMainStepV,
                     int AStyle,
                     String AKindOfData,
                     Vector AExtensionStepV,
                     Vector AVariationStepV,
                     business.IObserver AObserver,
                     int AKindOfStep) {

    super(AParent, "new action", true); // not true
    init(AMainStepV,
         AStyle,
         AKindOfData,
         AExtensionStepV,
         AVariationStepV,
         AObserver,
         AKindOfStep);

  }

  /** constructor
   *  @param AParent parent frame
   *  @param AMainStepV scenario steps of success scenario
   *  @param AStyle type of step
   *  (business.CStepStrT1 or business.CStepStrT2)
   *  @param AKindOfData where new step shall be inserted
   *  (business.Global.kindDataSuccessSc for success scenario,
   *   business.Global.kindDataExtension for extensions,
   *   business.Global.kindDataVariation for variations)
   *  @param AExtensionStepV scenario steps of extensions
   *  @param AVariationStepV scenario steps of variations
   *  @param AKindOfStep
   */
  public CNewScStepD(Frame AParent,
                     Vector AMainStepV,
                     int AStyle,
                     String AKindOfData,
                     Vector AExtensionStepV,
                     Vector AVariationStepV,
                     business.IObserver AObserver,
                     int AKindOfStep) {

    super(AParent, "new action", true); // not true
    init(AMainStepV,
         AStyle,
         AKindOfData,
         AExtensionStepV,
         AVariationStepV,
         AObserver,
         AKindOfStep);
  }

  /** initialize objects */
  private void init(Vector AMainStepV,
                    int AStyle, // StrT1 or StrT2
                    String AKindOfData, // MainScenario, Extension, Variation
                    Vector AExtensionStepV,
                    Vector AVariationStepV,
                    business.IObserver AObserver,
                    int AKindOfStep) {

    style = AStyle;
    kindOfData = AKindOfData;
    kindOfStep = AKindOfStep;
    extensionStepV = AExtensionStepV;
    variationStepV = AVariationStepV;
    mainStepV = AMainStepV;
    observer = AObserver;

    if (AKindOfData.equals(business.Global.kindDataSuccessSc)) {
      stepV = AMainStepV;
    } else if (AKindOfData.equals(business.Global.kindDataExtension)) {
      stepV = AExtensionStepV;
    } else { // business.Global.kindDataVariation
      stepV = AVariationStepV;
    }

    allStepV = new Vector();
    allStepV = (Vector) mainStepV.clone();
    for (int i=0; extensionStepV != null && i<extensionStepV.size(); i++)
      ((business.CStep) extensionStepV.elementAt(i)).insertStep(allStepV);
    for (int i=0; variationStepV != null && i<variationStepV.size(); i++)
      ((business.CStep) variationStepV.elementAt(i)).insertStep(allStepV);

    initGui();
  }

  /** initialize gui */
  private void initGui() {

    dialogD = this;

    JPanel actionSuccessScenarioNewP = new JPanel();

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    actionSuccessScenarioNewP.setLayout(gridbag);

    // ===================================
    // ===== label: type
    // ===================================
    JLabel typeL = new JLabel("type:");
    c.gridx = 0;
    c.gridy = 0;
    c.anchor = GridBagConstraints.NORTHWEST;
    c.insets = new Insets(10, 10, 10, 10);
    gridbag.setConstraints(typeL, c);
    actionSuccessScenarioNewP.add(typeL);

    // ===================================
    // ===== checkbox: type
    // ===================================

    typeCB = new JComboBox();
    typeCB.addItem("Action");
    typeCB.addItem("Repeat [number and] until [conditions]");
    typeCB.addItem("Repeat while [conditions]");
    typeCB.addItem("[actions] at the same time");
    typeCB.addItem("[actions] in any temporal order");
    typeCB.addItem("if [conditions] ");

    typeCB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

        JComboBox typeCB = (JComboBox) e.getSource();
        selectedType = typeCB.getSelectedIndex();
        reload();
      }
    });
    selectedType = NEW_STEP;
    c.gridx = 1;
    c.gridy = 0;
    gridbag.setConstraints(typeCB, c);
    actionSuccessScenarioNewP.add(typeCB);

    // ===================================
    // ===== panel: step
    // ===================================
    stepP = new JPanel();
    c.gridx = 0;
    c.gridy = 1;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(stepP, c);
    actionSuccessScenarioNewP.add(stepP);

    stepP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(""),
        BorderFactory.createEmptyBorder(5,5,5,5)
      )
    );

    // ======================================================
    // ===== kindOfStep
    // ======================================================
    JPanel kindOfStepP = new JPanel();
    kindOfStepP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 20));
    kindOfStepCB = new JComboBox();
    kindOfStepCB.addItem(new String("Success scenario"));
    kindOfStepCB.addItem(new String("Extension"));
    kindOfStepCB.addItem(new String("Variation"));
    kindOfStepCB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (kindOfStepCB.getSelectedIndex() == 0) {
          stepV = mainStepV;
        } else if (kindOfStepCB.getSelectedIndex() == 1) {
          stepV = extensionStepV;
        } else {
          stepV = variationStepV;
        }
      }
    });
    kindOfStepP.add(kindOfStepCB);
    kindOfStepP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder("copy / move to"),
        BorderFactory.createEmptyBorder(5,5,5,5)
      )
    );

    // button panel
    insertB = new JButton("ok");
    if (style == business.Global.STYLE_STRUCT_WITH_ACTOR)
      this.addInsertStepStrT2Listener();
    else
      this.addInsertStepStrT1Listener();

    JButton cancelB = new JButton("cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        gui.CNewScStepD.dialogD.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));
    buttonP.add(insertB);
    buttonP.add(cancelB);

    getContentPane().add(actionSuccessScenarioNewP, BorderLayout.NORTH);
    if (kindOfStep == business.Global.Step_CopyMove)
      getContentPane().add(kindOfStepP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
    });

    this.reload();
    this.pack();
  }

  /** reloads gui */
  private void reload() {

    stepP.removeAll();

    if (selectedType == NEW_STEP || // New Step
        selectedType == AT_THE_SAME_TIME || // at the same time
        selectedType == IN_ANY_TEMPORAL_ORDER || // in any temporal order
        selectedType == REPEAT_WHILE || // repeat while
        selectedType == REPEAT_UNTIL) // repeat until
    {
      allStepForCBV = allStepV;

      GridBagLayout gridbag = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();
      stepP.setLayout(gridbag);

      beforeRB = new JRadioButton("before step: ");
      beforeRB.addItemListener(this);
      c.gridx = 0;
      c.gridy = 0;
      c.anchor = GridBagConstraints.NORTHWEST;
      c.insets = new Insets(10, 10, 10, 10);
      gridbag.setConstraints(beforeRB, c);
      stepP.add(beforeRB);
      beforeRB.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          beforeStep = true;
          afterStep = false;
          subStep = false;
        }
      });

      beforeHt = new java.util.Hashtable();
      beforeCB = new JComboBox();

      for (int i=0; allStepForCBV != null && i<allStepForCBV.size(); i++) {
        beforeCB.addItem(((business.CStep) allStepForCBV.elementAt(i)).getStep());
        beforeHt.put(((business.CStep) allStepForCBV.elementAt(i)).getStep(),
                     (business.CStep) allStepForCBV.elementAt(i));
      }

      c.gridx = 1;
      c.gridy = 0;
      gridbag.setConstraints(beforeCB, c);
      if (beforeCB.getItemCount() == 0) {
        beforeRB.setEnabled(false);
      }
      stepP.add(beforeCB);

      JLabel orL = new JLabel("or");
      c.gridx = 0;
      c.gridy = 1;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.anchor = GridBagConstraints.CENTER;
      gridbag.setConstraints(orL, c);
      stepP.add(orL);

      afterRB = new JRadioButton("after step:");
      afterRB.addItemListener(this);
      c.gridx = 0;
      c.gridy = 2;
      c.anchor = GridBagConstraints.NORTHWEST;
      gridbag.setConstraints(afterRB, c);
      stepP.add(afterRB);
      afterRB.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          beforeStep = false;
          afterStep = true;
          subStep = false;
        }
      });

      afterCB = new JComboBox();
      afterHt = new java.util.Hashtable();
      for (int i=0; allStepForCBV != null && i<allStepForCBV.size(); i++) {
        afterCB.addItem(((business.CStep) allStepForCBV.elementAt(i)).getStep());
        afterHt.put(((business.CStep) allStepForCBV.elementAt(i)).getStep(),
                     (business.CStep) allStepForCBV.elementAt(i));
      }

      afterCB.setSelectedIndex(afterCB.getItemCount()-1);
      c.gridx = 1;
      c.gridy = 2;
      gridbag.setConstraints(afterCB, c);
      if (afterCB.getItemCount() == 0) {
        afterRB.setEnabled(false);
      }
      stepP.add(afterCB);

      orL = new JLabel("or");
      c.gridx = 0;
      c.gridy = 3;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.anchor = GridBagConstraints.CENTER;
      gridbag.setConstraints(orL, c);
      stepP.add(orL);

      subRB = new JRadioButton("supstep of: ");
      subRB.addItemListener(this);
      c.gridx = 0;
      c.gridy = 4;
      c.anchor = GridBagConstraints.NORTHWEST;
      gridbag.setConstraints(subRB, c);
      stepP.add(subRB);
      subRB.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          beforeStep = false;
          afterStep = false;
          subStep = true;
        }
      });

      subCB = new JComboBox();
      subHt = new java.util.Hashtable();
      for (int i=0; allStepForCBV != null && i<allStepForCBV.size(); i++) {
        subCB.addItem(((business.CStep) allStepForCBV.elementAt(i)).getStep());
        subHt.put(((business.CStep) allStepForCBV.elementAt(i)).getStep(),
                     (business.CStep) allStepForCBV.elementAt(i));
      }
      c.gridx = 1;
      c.gridy = 4;
      gridbag.setConstraints(subCB, c);
      stepP.add(subCB);
      if (subCB.getItemCount() == 0) {
        subRB.setEnabled(false);
      }

      ButtonGroup stepBG = new ButtonGroup();
      stepBG.add(beforeRB);
      stepBG.add(afterRB);
      stepBG.add(subRB);
      afterRB.setSelected(true);

    } else if (selectedType == IF) { // if
      GridBagLayout gridbag = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();
      stepP.setLayout(gridbag);

      condAfterRB = new JRadioButton("condition after step:");
      condAfterRB.addItemListener(this);
      condAfterRB.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          resultOf = false;
          condAfter = true;
        }
      });
      c.gridx = 0;
      c.gridy = 0;
      c.anchor = GridBagConstraints.NORTHWEST;
      gridbag.setConstraints(condAfterRB, c);
      stepP.add(condAfterRB);

      allStepForCBV = allStepV;

      condAfterCB = new JComboBox();
      condAfterHt = new java.util.Hashtable();
      for (int i=0; allStepForCBV != null && i<allStepForCBV.size(); i++) {
        condAfterCB.addItem(((business.CStep) allStepForCBV.elementAt(i)).getStep());
        condAfterHt.put(((business.CStep) allStepForCBV.elementAt(i)).getStep(),
                     (business.CStep) allStepForCBV.elementAt(i));
      }

      if (condAfterCB.getItemCount() == 0) {
        afterRB.setEnabled(false);
      }

      c.gridx = 1;
      c.gridy = 0;
      gridbag.setConstraints(condAfterCB, c);
      stepP.add(condAfterCB);

      JLabel orL = new JLabel("or");
      c.gridx = 0;
      c.gridy = 1;
      c.anchor = GridBagConstraints.CENTER;
      c.gridwidth = GridBagConstraints.REMAINDER;
      gridbag.setConstraints(orL, c);
      stepP.add(orL);

      subStepRB = new JRadioButton("result of step:");
      subStepRB.addItemListener(this);
      subStepRB.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          resultOf = true;
          condAfter = false;
        }
      });
      c.gridx = 0;
      c.gridy = 2;
      c.anchor = GridBagConstraints.NORTHWEST;
      c.insets = new Insets(10, 10, 10, 10);
      gridbag.setConstraints(subStepRB, c);
      stepP.add(subStepRB);

      allStepForCBV = new Vector();
      for (int i=0; mainStepV != null && i<mainStepV.size(); i++)
        if (((business.CStep) mainStepV.elementAt(i)).getStep().charAt(((business.CStep)
            mainStepV.elementAt(i)).getStep().length()-1) < 'a')
          ((business.CStep) mainStepV.elementAt(i)).insertStep(allStepForCBV);
      for (int i=0; extensionStepV != null && i<extensionStepV.size(); i++)
        if (((business.CStep) extensionStepV.elementAt(i)).getStep().charAt(((business.CStep)
            extensionStepV.elementAt(i)).getStep().length()-1) < 'a')
          ((business.CStep) extensionStepV.elementAt(i)).insertStep(allStepForCBV);
      for (int i=0; variationStepV != null && i<variationStepV.size(); i++)
        if (((business.CStep) variationStepV.elementAt(i)).getStep().charAt(((business.CStep)
            variationStepV.elementAt(i)).getStep().length()-1) < 'a')
          ((business.CStep) variationStepV.elementAt(i)).insertStep(allStepForCBV);

      resultOfCB = new JComboBox();
      resultOfHt = new java.util.Hashtable();

      for (int i=0; allStepForCBV != null && i<allStepForCBV.size(); i++) {
        resultOfCB.addItem(((business.CStep) allStepForCBV.elementAt(i)).getStep());
        resultOfHt.put(((business.CStep) allStepForCBV.elementAt(i)).getStep(),
                     (business.CStep) allStepForCBV.elementAt(i));
      }

      if (resultOfCB.getItemCount() == 0) {
        subStepRB.setEnabled(false);
      }
      c.gridx = 1;
      c.gridy = 2;
      gridbag.setConstraints(resultOfCB, c);
      stepP.add(resultOfCB);

      ButtonGroup stepBG = new ButtonGroup();
      stepBG.add(subStepRB);
      stepBG.add(condAfterRB);
      subStepRB.setSelected(true);

    } else {
    }
    this.pack();
  }

  /** shows dialog and returns new step
   *  @return new step
   */
  public business.CStep showDialog() {
    dialogD.setLocationRelativeTo(null);
    dialogD.setVisible(true);
    return newStep;
  }

  /** is called if step of type business.CStepStrT1 shall be created */
  public void addInsertStepStrT1Listener() {

    insertB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

        if (selectedType == NEW_STEP) { // New Step

          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT1(-1, 1, new String("1"), null, "");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);
          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewActionBefore(stepV,
                beforeCB.getSelectedIndex()));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                afterHt.get((String) afterCB.getSelectedItem())).getNewActionAfter(stepV,
                afterCB.getSelectedIndex()));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                subHt.get((String) subCB.getSelectedItem())).getNewSubStep(stepV,
                subCB.getSelectedIndex()));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);
            }
          }

        } else if (selectedType == IF) { //

          if (resultOfHt.isEmpty() && condAfterHt.isEmpty()) {
            newStep =
              new business.CStepStrT1(-1, 1, new String("1.a"), null,"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);
          } else {

            if (resultOf == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                resultOfHt.get((String) resultOfCB.getSelectedItem())).getIfAsResultOfStep(allStepV));
              int index = newStep.insertStep(allStepV);
              newStep.insertStep(stepV);

            } else if (condAfter == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                condAfterHt.get((String) condAfterCB.getSelectedItem())).getIfAsCondAfterStep(allStepV));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);
            }
          }
        } else if (selectedType == OTHERWISE_IF) { //
        } else if (selectedType == OTHERWISE) { //

        } else if (selectedType == REPEAT_UNTIL) {
          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT1(-1, 1, new String("1.a"),
              new String("Repeat [number] and until [conditions]"),"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);

          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewRepeatWhileBefore(stepV,
                beforeCB.getSelectedIndex()));
              newStep.setAction("Repeat [number] and until [conditions]");
              int index = newStep.insertBeforeStep(allStepV,
                (business.CStepStrT1) beforeHt.get((String) beforeCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                afterHt.get((String) afterCB.getSelectedItem())).getNewRepeatWhileAfter(stepV,
                afterCB.getSelectedIndex()));
              newStep.setAction("Repeat [number] and until [conditions]");
              int index = newStep.insertAfterStep(allStepV,
                (business.CStepStrT1) afterHt.get((String) afterCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                subHt.get((String) subCB.getSelectedItem())).getNewRepeatWhileSub(stepV,
                subCB.getSelectedIndex()));
              newStep.setAction("Repeat [number] and until [conditions]");
              int index = newStep.insertAfterStep(allStepV,
                (business.CStepStrT1) afterHt.get((String) afterCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);
            }
          }

        } else if (selectedType == REPEAT_WHILE) {
          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT1(-1, 1, new String("1.a"),
              new String("Repeat while [conditions]"),"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);

          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewRepeatWhileBefore(stepV,
                beforeCB.getSelectedIndex()));
              int index = newStep.insertBeforeStep(allStepV,
                (business.CStepStrT1) beforeHt.get((String) beforeCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                afterHt.get((String) afterCB.getSelectedItem())).getNewRepeatWhileAfter(stepV,
                afterCB.getSelectedIndex()));
              int index = newStep.insertAfterStep(allStepV,
                (business.CStepStrT1) afterHt.get((String) afterCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                subHt.get((String) subCB.getSelectedItem())).getNewRepeatWhileSub(stepV,
                subCB.getSelectedIndex()));
              int index = newStep.insertAfterStep(allStepV,
                (business.CStepStrT1) afterHt.get((String) afterCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            }
          }
        } else if (selectedType == AT_THE_SAME_TIME) {

          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT1(-1, 1, new String("1"),
              new String("[actions] at the same time"),"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);
          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewActionBefore(stepV,
                beforeCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] at the same time"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                afterHt.get((String) afterCB.getSelectedItem())).getNewActionAfter(stepV,
                afterCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] at the same time"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                subHt.get((String) subCB.getSelectedItem())).getNewSubStep(stepV,
                subCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] at the same time"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            }
          }

        } else if (selectedType == IN_ANY_TEMPORAL_ORDER) {

          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =   new business.CStepStrT1(-1, 1, new String("1"),
                        new String("[actions] in any temporal order"),"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);
          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewActionBefore(stepV,
                beforeCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] in any temporal order"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                afterHt.get((String) afterCB.getSelectedItem())).getNewActionAfter(stepV,
                afterCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] in any temporal order"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT1(
              ((business.CStepStrT1)
                subHt.get((String) subCB.getSelectedItem())).getNewSubStep(stepV,
                subCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] in any temporal order"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            }
          }
        }
        gui.CNewScStepD.dialogD.dispose();
      }
    });
  }

  /** is called if step of type business.CStepStrT2 shall be created */
  public void addInsertStepStrT2Listener() {

    insertB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

        if (selectedType == NEW_STEP) { // New Step

          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT2(-1, 1, "1", null, null, null, false,"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);
          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewActionBefore(stepV,
                beforeCB.getSelectedIndex()));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                afterHt.get((String) afterCB.getSelectedItem())).getNewActionAfter(stepV,
                afterCB.getSelectedIndex()));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                subHt.get((String) subCB.getSelectedItem())).getNewSubStep(stepV,
                subCB.getSelectedIndex()));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            }
          }

        } else if (selectedType == IF) { //

          if (resultOfHt.isEmpty() && condAfterHt.isEmpty()) {
            newStep =
              new business.CStepStrT2(-1, 1,"1.a", null, null, null, false,"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);
          } else {

            if (resultOf == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                resultOfHt.get((String) resultOfCB.getSelectedItem())).getIfAsResultOfStep(allStepV));
              int index = newStep.insertStep(allStepV);
              newStep.insertStep(stepV);

            } else if (condAfter == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                condAfterHt.get((String) condAfterCB.getSelectedItem())).getIfAsCondAfterStep(allStepV));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);
            }
          }
        } else if (selectedType == OTHERWISE_IF) {
        } else if (selectedType == OTHERWISE) {

        } else if (selectedType == REPEAT_UNTIL) {
          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT2(-1, 1, "1.a","Repeat [number] and until [conditions]", null, null, false,"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);

          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewRepeatWhileBefore(stepV,
                beforeCB.getSelectedIndex()));
              newStep.setAction("Repeat [number] and until [conditions]");
              int index = newStep.insertBeforeStep(allStepV,
                (business.CStepStrT2) beforeHt.get((String) beforeCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                afterHt.get((String) afterCB.getSelectedItem())).getNewRepeatWhileAfter(stepV,
                afterCB.getSelectedIndex()));
              newStep.setAction("Repeat [number] and until [conditions]");
              int index = newStep.insertAfterStep(allStepV,
                (business.CStepStrT2) afterHt.get((String) afterCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                subHt.get((String) subCB.getSelectedItem())).getNewRepeatWhileSub(stepV,
                subCB.getSelectedIndex()));
              newStep.setAction("Repeat [number] and until [conditions]");
              int index = newStep.insertAfterStep(allStepV,
                (business.CStepStrT2) afterHt.get((String) afterCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);
            }
          }

        } else if (selectedType == REPEAT_WHILE) {
          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT2(-1, 1, new String("1.a"),
              new String("Repeat while [conditions]"), null, null, false,"");
            stepV.add(newStep);

          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewRepeatWhileBefore(stepV,
                beforeCB.getSelectedIndex()));
              int index = newStep.insertBeforeStep(allStepV,
                (business.CStepStrT2) beforeHt.get((String) beforeCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                afterHt.get((String) afterCB.getSelectedItem())).getNewRepeatWhileAfter(stepV,
                afterCB.getSelectedIndex()));
              int index = newStep.insertAfterStep(allStepV,
                (business.CStepStrT2) afterHt.get((String) afterCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                subHt.get((String) subCB.getSelectedItem())).getNewRepeatWhileSub(stepV,
                subCB.getSelectedIndex()));
              int index = newStep.insertAfterStep(allStepV,
                (business.CStepStrT2) afterHt.get((String) afterCB.getSelectedItem()));
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-2);
              newStep.insertStep(stepV);

            }
          }
        } else if (selectedType == AT_THE_SAME_TIME) {

          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT2(-1, 1, new String("1"),
              new String("[actions] at the same time"), null, null, false,"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);
          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewActionBefore(stepV,
                beforeCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] at the same time"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                afterHt.get((String) afterCB.getSelectedItem())).getNewActionAfter(stepV,
                afterCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] at the same time"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                subHt.get((String) subCB.getSelectedItem())).getNewSubStep(stepV,
                subCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] at the same time"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            }
          }

        } else if (selectedType == IN_ANY_TEMPORAL_ORDER) {

          if (beforeHt.isEmpty() && afterHt.isEmpty() && subHt.isEmpty()) {
            newStep =
              new business.CStepStrT2(-1, 1, new String("1"),
              new String("[actions] in any temporal order"), null, null, false,"");
            newStep.insertStep(allStepV);
            newStep.insertStep(stepV);
          } else {

            if (beforeStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                beforeHt.get((String) beforeCB.getSelectedItem())).getNewActionBefore(stepV,
                beforeCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] in any temporal order"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else if (afterStep == true) {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                afterHt.get((String) afterCB.getSelectedItem())).getNewActionAfter(stepV,
                afterCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] in any temporal order"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            } else {
              newStep = new business.CStepStrT2(
              ((business.CStepStrT2)
                subHt.get((String) subCB.getSelectedItem())).getNewSubStep(stepV,
                subCB.getSelectedIndex()));
              newStep.setAction(new String("[actions] in any temporal order"));
              int index = newStep.insertStep(allStepV);
              newStep.addToStepAtLevel(allStepV, index+1, newStep.getNumberOfLevels()-1);
              newStep.insertStep(stepV);

            }
          }
        }
        gui.CNewScStepD.dialogD.dispose();
      }
    });
  }









    public void itemStateChanged(ItemEvent e){
    Object source = e.getItemSelectable();
      if (source == subRB) {
        System.out.println("1   fix me");
        this.afterCB.disable();
        this.beforeCB.disable();
        this.subCB.enable();//
        this.condAfterCB.disable();
        this.resultOfCB.disable();

      }
      if (source == afterRB) {
        System.out.println("2   fix me");
        this.afterCB.enable();//
        this.beforeCB.disable();
        this.subCB.disable();
        this.condAfterCB.disable();
        this.resultOfCB.disable();
      }
      if (source == beforeRB) {
        System.out.println("3   fix me");
        this.afterCB.disable();
        this.beforeCB.enable();//
        this.subCB.disable();
        this.condAfterCB.disable();
        this.resultOfCB.disable();
      }




      if (source == condAfterRB) {
        System.out.println("4   fix me");
        this.afterCB.disable();
        this.beforeCB.disable();
        this.subCB.disable();
        this.condAfterCB.enable();//
        this.resultOfCB.disable();
      }

      if (source == subStepRB) {
        System.out.println("5   fix me");
        this.afterCB.disable();
        this.beforeCB.disable();
        this.subCB.disable();
        this.condAfterCB.disable();
        this.resultOfCB.enable();//
      }
      this.repaint();

  }







}
