package gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: menubar of main frame
 *
 * @author Kathrin Boettger and Oscar Aguilera
 *
 * @version 1.0
 */
public class CMenuBar extends JMenuBar {

  /** controller for menubar */
  private contr.CMenuBar contrMB;

  // gui
  private JMenu toolM;

  private JMenuItem toolUsersMI;
  private JMenuItem quitMI;
  private JMenuItem loginMI;

  private JMenu projectM;

  private JMenuItem projectNewMI;
  private JMenuItem projectOpenMI;
  private JMenuItem projectSaveMI;
  private JMenuItem projectCloseMI;

  private JMenu useCaseM;

  private JMenuItem useCaseNewMI;
  private JMenuItem useCaseOpenMI;
  private JMenuItem useCaseImportMI;
  private JMenuItem useCaseSaveMI;
  private JMenuItem useCaseCloseMI;

  private JMenu scenarioM;

  private JMenuItem scenarioNewMI;
  private JMenuItem scenarioOpenMI;
  private JMenuItem scenarioSaveMI;
  private JMenuItem scenarioCloseMI;

  private JMenu viewpointM;

  private JMenuItem viewpointOpenMI;
  private JMenuItem viewpointSaveMI;
  private JMenuItem viewpointCloseMI;
  private JMenuItem groupViewpointSaveMI;
  private JMenuItem groupViewpointCloseMI;

  private JMenuItem viewpointNewUCMI;
  private JMenuItem viewpointImportUCMI;


  private JMenuItem quickLatticeUCMI;
  private JMenuItem quickLatticeScMI;

  private JMenuItem viewpointNewSMI;
//  private JMenuItem groupViewpointCreateScMI;
//  private JMenuItem groupViewpointScMI;
  private JMenuItem groupViewpointCreateMI;
  private JMenuItem groupViewpointMI;

  private JMenu fcaM;
  private JMenuItem fcaNewMI;
  private JMenuItem fcaOpenMI;
  private JMenuItem fcaOpenFLTMI;


  /** constructor */
  public CMenuBar() {

    business.Global.menuBar = this;
    init();
  }

  /** initialize menubar */
  public void init() {

    contrMB = new contr.CMenuBar();

    JMenuItem menuItem;

    // ===================================================================
    // ===== Tool
    // ===================================================================
    toolM = new JMenu("[Tool]");
    quitMI = new JMenuItem("Quit");
    toolM.add(quitMI);
    quitMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if(JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(null,"Dou you want to quit?","Quit",JOptionPane.OK_CANCEL_OPTION)){
          persistence.CDatabase.closeDatabase();
          if(language.LInterface.started) language.LInterface.endLinkGrammar();
          System.exit(0);
        }
      }
    });

    loginMI = new JMenuItem("Log Off");
    toolM.add(loginMI);
    loginMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int sure = JOptionPane.showConfirmDialog(
          null,
          "You are about to log off \n Do you want to continue? ",
          "Open Project",
          JOptionPane.YES_NO_OPTION);
        if (sure == JOptionPane.YES_OPTION) {
          if(contrMB.closeProject()){
            business.Global.contrRecocase.showLogin();
            business.Global.recocase.reload();
            business.Global.menuBar.reload();
          }
        }
      }
    });

    toolUsersMI = new JMenuItem("Users");
    toolM.add(toolUsersMI);
    toolUsersMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        //System.out.println("Fix me");
        new gui.CUser();
      }
    });


    // ===================================================================
    // ===== Project
    // ===================================================================
    projectM = new JMenu("[Project]");
    projectNewMI = new JMenuItem("New ...");
    projectNewMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.newProject();
      }
    });
    projectM.add(projectNewMI);

    projectOpenMI = new JMenuItem("Open ...");
    projectOpenMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.openProject();
      }
    });
    projectM.add(projectOpenMI);

    projectSaveMI = new JMenuItem("Save");
    if (business.Global.ProjectIsOpen) projectSaveMI.setEnabled(true);
    else projectSaveMI.setEnabled(false);
    projectSaveMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.saveProject();
      }
    });
    projectM.add(projectSaveMI);

    projectM.addSeparator();

    projectCloseMI = new JMenuItem("Close ...");
    projectCloseMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.closeProject();
      }
    });
    if (business.Global.ProjectIsOpen) projectCloseMI.setEnabled(true);
    else projectCloseMI.setEnabled(false);
    projectM.add(projectCloseMI);

    // ===================================================================
    // ===== Use Case
    // ===================================================================
    useCaseM = new JMenu("[Shared Use Case]");
    useCaseM.setEnabled(true);
    if (business.Global.ProjectIsOpen) useCaseM.setEnabled(true);
    else useCaseM.setEnabled(false);

//    useCaseNewMI = new JMenuItem("New ...");
//    useCaseNewMI.addActionListener(
//    new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        contrMB.newUsecase();
//      }
//    });
//    useCaseM.add(useCaseNewMI);

    useCaseOpenMI = new JMenuItem("Open...");
    useCaseOpenMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.openUsecase();
      }
    });
    useCaseM.add(useCaseOpenMI);

    useCaseImportMI = new JMenuItem("Import...");
    useCaseImportMI.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            new gui.CImport();
//            JOptionPane.showMessageDialog(business.Global.recocase,"This option has not been implemented yet.");
        }//action performed
      });
    useCaseM.add(useCaseImportMI);


    useCaseSaveMI = new JMenuItem("Save");
    if (business.Global.UseCaseIsOpen) useCaseSaveMI.setEnabled(true);
    else useCaseSaveMI.setEnabled(false);
    useCaseSaveMI.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          contrMB.saveUsecase();
      }
    });
    useCaseM.add(useCaseSaveMI);

    useCaseM.addSeparator();

    useCaseCloseMI = new JMenuItem("Close");
    useCaseCloseMI.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          contrMB.closeUseCase();
        }
      });
    if (business.Global.UseCaseIsOpen) useCaseCloseMI.setEnabled(true);
    else useCaseCloseMI.setEnabled(false);
    useCaseM.add(useCaseCloseMI);

    // ===================================================================
    // ===== Scenario
    // ===================================================================
       //see bottom for commented code

    // ===================================================================
    // ===== Viewpoint
    // ===================================================================
    viewpointM = new JMenu("[Viewpoints]");
    if (business.Global.ProjectIsOpen) viewpointM.setEnabled(true);
    else viewpointM.setEnabled(false);

    viewpointOpenMI = new JMenuItem("Open Viewpoint");
    viewpointOpenMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.openViewpoint();
      }
    });
    viewpointM.add(viewpointOpenMI);


    viewpointSaveMI = new JMenuItem("Save All");
    viewpointSaveMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.saveAllViewpoint();
      }
    });

    if (business.Global.ViewpointIsOpen)
      viewpointSaveMI.setEnabled(true);
    else viewpointSaveMI.setEnabled(false);

    viewpointM.add(viewpointSaveMI);



    viewpointCloseMI = new JMenuItem("Close All");
    viewpointCloseMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.closeAllViewpoint();
      }
    });
    if (business.Global.ViewpointIsOpen)
      viewpointCloseMI.setEnabled(true);
    else viewpointCloseMI.setEnabled(false);
    viewpointM.add(viewpointCloseMI);

//--
    viewpointM.addSeparator();
//--





    groupViewpointCreateMI = new JMenuItem("Create Group Viewpoint");

    if (business.Global.UseCaseIsOpen)
    groupViewpointCreateMI.setEnabled(true);
    else groupViewpointCreateMI.setEnabled(false);

    groupViewpointCreateMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.createGroupVP();
      }
    });
    viewpointM.add(groupViewpointCreateMI);


    groupViewpointMI = new JMenuItem("Open Group Viewpoint");

    if (business.Global.UseCaseIsOpen)
    groupViewpointMI.setEnabled(true);
    else groupViewpointMI.setEnabled(false);

    groupViewpointMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if(business.Global.usecase != null){
          contrMB.openGroupVP();
          //new gui.CGroupVP( null ,business.Global.TYPE_VP_USECASE) ;
                   //persistence.CViewpointUc.getGroups( business.Global.usecase.getId());
        }else{
          System.out.println("MUST OPEN    U S E C A S E   FIRST");
        }
      }
    });
    viewpointM.add(groupViewpointMI);


    groupViewpointSaveMI = new JMenuItem("Save All Groups");
    groupViewpointSaveMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.saveAllGroupViewpoint();
      }
    });
    viewpointM.add(groupViewpointSaveMI);


    groupViewpointCloseMI = new JMenuItem("Close All Groups");
    groupViewpointCloseMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        contrMB.closeAllGroupViewpoint();
      }
    });
    viewpointM.add(groupViewpointCloseMI);


    if(((Vector) business.Global.groupViewpointFV).size() >0){
      groupViewpointSaveMI.setEnabled(true);
      groupViewpointCloseMI.setEnabled(true);
    }else{
       groupViewpointSaveMI.setEnabled(false);
       groupViewpointCloseMI.setEnabled(false);
    }
//--
//viewpointM.addSeparator();
//--------




//    viewpointNewUCMI = new JMenuItem("New Use Case Viewpoint");
//    viewpointNewUCMI.addActionListener(
//      new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        contrMB.newViewpoint(business.Global.TYPE_VP_USECASE);
//      }
//    });
//    viewpointM.add(viewpointNewUCMI);

//    viewpointImportUCMI = new JMenuItem("Import Use Case Viewpoint");
//    viewpointImportUCMI.addActionListener(
//      new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        new gui.CImportVP();
//      }
//    });
//    //viewpointM.add(viewpointImportUCMI);

    //--------

    //--------

//    viewpointNewSMI = new JMenuItem("New Scenario Viewpoint");
//    viewpointNewSMI.addActionListener(
//      new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        contrMB.newViewpoint(business.Global.TYPE_VP_SCENARIO);
//      }
//    });
//    viewpointM.add(viewpointNewSMI);

//    groupViewpointCreateScMI = new JMenuItem("Create a Group Scenario Viewpoints");
//
//    if (business.Global.UseCaseIsOpen)
//    groupViewpointCreateScMI.setEnabled(true);
//    else groupViewpointCreateScMI.setEnabled(false);
//
//    groupViewpointCreateScMI.addActionListener(
//      new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//         contrMB.createGroupVPSC();
//      }
//    });
//    viewpointM.add(groupViewpointCreateScMI);
//
//
//    groupViewpointScMI = new JMenuItem("Open Group Scenario Viewpoints");
//
//    if (business.Global.UseCaseIsOpen)
//    groupViewpointScMI.setEnabled(true);
//    else groupViewpointScMI.setEnabled(false);
//
//    groupViewpointScMI.addActionListener(
//      new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        if(business.Global.usecase != null){
//          contrMB.openGroupVPSC();
//          //new gui.CGroupVP( null ,business.Global.TYPE_VP_SCENARIO) ;
//                //persistence.CViewpointUc.getGroups( business.Global.usecase.getId());
//        }else{
//          System.out.println("MUST OPEN    U S E C A S E   FIRST");
//        }
//      }
//    });
//    viewpointM.add(groupViewpointScMI);



    // ===================================================================
    // ===== FCA
    // ===================================================================

    fcaM = new JMenu("[Lattice]");
    if (business.Global.ProjectIsOpen) fcaM.setEnabled(true);
    else fcaM.setEnabled(false);

    fcaNewMI = new JMenuItem("TEST ...");
    fcaNewMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        //test
        for(int i = 0 ; i <business.Global.viewpointFV.size();i++){
          ((JFrame) business.Global.viewpointFV.elementAt(i)).hide();
        }
        //test
      }
    });
    //fcaM.add(fcaNewMI);



    fcaOpenMI = new JMenuItem("Open Lattice");
    fcaOpenMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        diagram.DDiagram diagram = new diagram.DDiagram();// toms.CDiagram(true);
        if(!diagram.open())diagram.onFileExit() ;
      }
    });
    fcaM.add(fcaOpenMI);




    quickLatticeUCMI = new JMenuItem("Quick Lattice UC");
    quickLatticeUCMI.addActionListener(
      new ActionListener() {
      public void actionPerformed(ActionEvent e) {
          contrMB.newFCA(business.Global.TYPE_VP_USECASE);
      }
    });
    fcaM.add(quickLatticeUCMI);


//    quickLatticeUCMI = new JMenuItem("Quick Lattice Sc");
//    quickLatticeUCMI.addActionListener(
//      new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//          contrMB.newFCA(business.Global.TYPE_VP_SCENARIO);
//      }
//    });
//    fcaM.add(quickLatticeUCMI);


//    fcaOpenFLTMI = new JMenuItem("Create using an exiting FLT file");
//    fcaOpenFLTMI.addActionListener(
//      new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        toms.CDiagram diagram = new  toms.CDiagram(true);
//        if(!diagram.onFileOpenFLT())diagram.onFileExit();
//
//
//      }
//    });
//    //fcaM.add(fcaOpenFLTMI);

  }

  /** reloads menubar */
  public void reload() {

    this.removeAll();

    this.add(toolM);
    this.add(projectM);
    if (business.Global.user != null && business.Global.user.isAnalyst()) {
      //System.out.println("ANALYST");
      this.add(useCaseM);
      //this.add(scenarioM);
    }
    this.add(viewpointM);
    if (business.Global.user != null && business.Global.user.isAnalyst()) {
      this.add(fcaM);
    }
    // ===================================================================
    // Tool
    // ===================================================================

    if (business.Global.user != null && business.Global.user.isAnalyst() ) toolUsersMI.setEnabled(true) ;
    else toolUsersMI.setEnabled(false);

    // ===================================================================
    // ===== Project
    // ===================================================================


    if (business.Global.user != null && business.Global.user.isAnalyst() ) projectNewMI.setEnabled(true) ;
    else projectNewMI.setEnabled(false);

    if (business.Global.ProjectIsOpen && business.Global.user.isAnalyst()) projectSaveMI.setEnabled(true) ;
    else projectSaveMI.setEnabled(false);

    if (business.Global.ProjectIsOpen) projectCloseMI.setEnabled(true);
    else projectCloseMI.setEnabled(false);

    if (business.Global.user != null && business.Global.user.isAnalyst()) {

      // ===================================================================
      // ===== Use Case
      // ===================================================================
      if (business.Global.ProjectIsOpen) useCaseM.setEnabled(true);
      else useCaseM.setEnabled(false);

      if (business.Global.UseCaseIsOpen) useCaseImportMI.setEnabled(true);
      else useCaseImportMI.setEnabled(false);

      if (business.Global.UseCaseIsOpen) useCaseSaveMI.setEnabled(true);
      else useCaseSaveMI.setEnabled(false);

      if (business.Global.UseCaseIsOpen) useCaseCloseMI.setEnabled(true);
      else useCaseCloseMI.setEnabled(false);

      // ===================================================================
      // ===== Scenario
      // ===================================================================
//      if (business.Global.UseCaseIsOpen) scenarioM.setEnabled(true);
//      else scenarioM.setEnabled(false);
//
//      if (business.Global.ScenarioIsOpen) scenarioSaveMI.setEnabled(true);
//      else scenarioSaveMI.setEnabled(false);
//
//      if (business.Global.ScenarioIsOpen) scenarioCloseMI.setEnabled(true);
//      else scenarioCloseMI.setEnabled(false);

    }

    // ===================================================================
    // ===== Viewpoint
    // ===================================================================
    if (business.Global.ProjectIsOpen) viewpointM.setEnabled(true);
    else viewpointM.setEnabled(false);

    if (business.Global.ViewpointIsOpen) viewpointSaveMI.setEnabled(true);
    else viewpointSaveMI.setEnabled(false);

    if (business.Global.ViewpointIsOpen) viewpointCloseMI.setEnabled(true);
    else viewpointCloseMI.setEnabled(false);



    if(((Vector) business.Global.groupViewpointFV).size() >0){
      groupViewpointSaveMI.setEnabled(true);
      groupViewpointCloseMI.setEnabled(true);
    }else{
       groupViewpointSaveMI.setEnabled(false);
       groupViewpointCloseMI.setEnabled(false);
    }

    if (business.Global.UseCaseIsOpen) groupViewpointMI.setEnabled(true);
    else groupViewpointMI.setEnabled(false);

    if (business.Global.UseCaseIsOpen) groupViewpointCreateMI.setEnabled(true);
    else groupViewpointCreateMI.setEnabled(false);
//
//    if (business.Global.UseCaseIsOpen) groupViewpointCreateScMI.setEnabled(true);
//    else groupViewpointCreateScMI.setEnabled(false);
//
//    if (business.Global.UseCaseIsOpen) groupViewpointScMI.setEnabled(true);
//    else groupViewpointScMI.setEnabled(false);




    // ===================================================================
    // ===== FCA
    // ===================================================================
    if (business.Global.user != null && business.Global.user.isAnalyst()) {
      if (business.Global.UseCaseIsOpen) fcaM.setEnabled(true);
      else fcaM.setEnabled(false);
    }
  }
}





    // ===================================================================
    // ===== Scenario
    // ===================================================================

//    scenarioM = new JMenu("[Shared Scenario]");
//    if (business.Global.UseCaseIsOpen) scenarioM.setEnabled(true);
//    else scenarioM.setEnabled(false);
//
//    scenarioNewMI = new JMenuItem("New ...");
//    scenarioNewMI.addActionListener(
//      new ActionListener() {
//        public void actionPerformed(ActionEvent e) {
//          contrMB.newScenario();
//        }
//      });
//    scenarioM.add(scenarioNewMI);
//
//    scenarioOpenMI = new JMenuItem("Open ...");
//    scenarioOpenMI.addActionListener(
//      new ActionListener() {
//        public void actionPerformed(ActionEvent e) {
//          contrMB.openScenario();
//        }
//      });
//    scenarioM.add(scenarioOpenMI);
//
//    scenarioM.addSeparator();
//
//    scenarioSaveMI = new JMenuItem("Save All");
//    if (business.Global.ScenarioIsOpen) scenarioSaveMI.setEnabled(true);
//    else scenarioSaveMI.setEnabled(false);
//    scenarioSaveMI.addActionListener(
//      new ActionListener() {
//        public void actionPerformed(ActionEvent e) {
//          contrMB.saveAllScenario();
//        }
//      });
//    scenarioM.add(scenarioSaveMI);
//
//    scenarioM.addSeparator();
//
//    scenarioCloseMI = new JMenuItem("Close All");
//    scenarioCloseMI.addActionListener(
//      new ActionListener() {
//        public void actionPerformed(ActionEvent e) {
//          contrMB.closeAllScenario();
//        }
//      });
//    if (business.Global.ScenarioIsOpen) scenarioCloseMI.setEnabled(true);
//    else scenarioCloseMI.setEnabled(false);
//    scenarioM.add(scenarioCloseMI);
//
