package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: creates a dialog to login into the system
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CLoginD extends JDialog {

  /** this dialog */
  private static gui.CLoginD dialogD = null;
  /** current user */
  private static business.CUser user = null;

  // gui
  private JTextField loginTF = null;
  private JPasswordField passwordTF = null;

  /** constructor
   *
   */
  public CLoginD(JFrame AParent) {

    super(AParent, "Login", true); // not true
    dialogD = this;

    init();
    this.setSize(450, 150);
  }

  /** initialize gui */
  private void init() {

    // login panel
    JPanel loginP = new JPanel();
    GridBagLayout loginPGBL = new GridBagLayout();
    GridBagConstraints loginPGBC = new GridBagConstraints();
    loginP.setLayout(loginPGBL);


    JLabel loginL = new JLabel("login:");
    loginPGBC.gridx = 0;
    loginPGBC.gridy = 0;
    loginPGBC.anchor = GridBagConstraints.NORTHWEST;
    loginPGBL.setConstraints(loginL, loginPGBC);
    loginP.add(loginL);

    loginTF = new JTextField(30);
    loginPGBC.gridx = 1;
    loginPGBC.gridy = 0;
    loginPGBL.setConstraints(loginTF, loginPGBC);
    loginP.add(loginTF);

    JLabel passwordL = new JLabel("password:  ");
    loginPGBC.gridx = 0;
    loginPGBC.gridy = 1;
    loginPGBL.setConstraints(passwordL, loginPGBC);
    loginP.add(passwordL);

    passwordTF = new JPasswordField(30);
    loginPGBC.gridx = 1;
    loginPGBC.gridy = 1;
    loginPGBL.setConstraints(passwordTF, loginPGBC);
    loginP.add(passwordTF);


    // button panel
    final JButton loginB = new JButton("login");
    loginB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (!loginTF.getText().equals(new String("")) &&  !(new String(passwordTF.getPassword())).equals(new String("")))
          user = new business.CUser(0, null, loginTF.getText(),
          new String(passwordTF.getPassword()), false, false,false);
        dialogD.dispose();
      }
    });

    JButton cancelB = new JButton("cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        user = null;
        gui.CLoginD.dialogD.dispose();
      }
    });

    JButton exitB = new JButton("exit");
    exitB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        user = null;
        gui.CLoginD.dialogD.dispose();
        System.exit(0);
      }
    });



    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));
    buttonP.add(loginB);
    buttonP.add(cancelB);
    buttonP.add(exitB);

    getContentPane().add(loginP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);



    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
    });
  }

  /** shows dialog and returns user who wants to login
   *  @return user who wants to login
   */
  public static business.CUser showDialog() {
    dialogD.setLocationRelativeTo(null);
    dialogD.setVisible(true);
    return user;
  }
}
