package gui;


import javax.swing.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;


/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author:      Oscar Aguilera
 * @version 1.0
 */



public class CImport extends JDialog implements ActionListener {

  /** this dialog */
  private CImport dialogD = null;
  /** current marked viewpoint */
  private business.CViewpoint viewpoint = null;


  private JCheckBox successPreCondCB = null;
  private JCheckBox successEndCondCB = null;
  private JCheckBox failedEndCondCB = null;
  private JCheckBox successScenarioCB = null;
  private JCheckBox extensionCB = null;
  private JCheckBox variationCB = null;

  /** constructor *
   * @param AParent parent frame of this dialog
   * @param AViewpoint vector of viewpoints
   */

  public CImport() {
    super( business.Global.recocase, "Import UC", true); // not true

    dialogD = this;

    Vector AViewpointV = persistence.CProject.getAllViewpointUCOfProject( business.Global.project);

    init(AViewpointV);
    pack();
    showDialog();
  }

  /** initializes the dialog
   *  @param vector of viewpoints
   */
  private void init(Vector AViewpointV) {

    Vector viewpointV = AViewpointV;

    // create the tree
    JPanel viewpointTree = new JPanel();
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("viewpoint");
    if (viewpointV != null) {
      long lastUsecaseId = -1;
      long lastScenarioId = -1;
      DefaultMutableTreeNode usecaseNode = null;
      DefaultMutableTreeNode scenarioNode = null;
      for (int i=0; i<viewpointV.size(); i++) {
        business.CViewpoint viewpoint =
          (business.CViewpoint) viewpointV.elementAt(i);

        if (viewpoint.getClass().isInstance(new business.CViewpointUc())) {
          business.CViewpointUc viewpointUc =
            (business.CViewpointUc) viewpoint;

          if (viewpointUc.getUsecase().getId() != lastUsecaseId) {
            usecaseNode = new DefaultMutableTreeNode("usecase: " +
              viewpointUc.getUsecase().getName());
            top.add(usecaseNode);
            lastUsecaseId = viewpointUc.getUsecase().getId();
          }
          usecaseNode.add(new DefaultMutableTreeNode(viewpointUc));

        }
      }
    }

    final JTree tree = new JTree(top);
    tree.getSelectionModel().setSelectionMode(
      TreeSelectionModel.SINGLE_TREE_SELECTION);

    // set viewpoint if user marks viewpoint
    tree.addTreeSelectionListener(new TreeSelectionListener() {
      public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
          tree.getLastSelectedPathComponent();
        if (node == null) return;
        Object nodeInfo = node.getUserObject();
        if (nodeInfo.getClass().isInstance(new business.CViewpointUc())) {
          business.CViewpointUc viewpointUc =
            (business.CViewpointUc) nodeInfo;
          viewpoint = viewpointUc;
        } else if (nodeInfo.getClass().isInstance(new business.CViewpointSc())) {
          business.CViewpointSc viewpointSc =
            (business.CViewpointSc) nodeInfo;
          viewpoint = viewpointSc;
        } else {
          // no leaf
        }
      }
    });
    JScrollPane treeView = new JScrollPane(tree);
    treeView.setPreferredSize(new Dimension(300, 300));
    viewpointTree.add(treeView);

      JPanel optionsP = new JPanel();
      GridBagLayout gridbag = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();
      c.anchor = GridBagConstraints.WEST;

      optionsP.setLayout(gridbag);
      optionsP.setBorder(
        BorderFactory.createCompoundBorder(
          BorderFactory.createTitledBorder("data to import"),
          BorderFactory.createEmptyBorder(10,5,5,5)
        )
      );


      // radiobutton success precondition
      successPreCondCB = new JCheckBox("precondition");
//      successPreCondCB.setActionCommand(business.Global.kindDataPreCond);
      c.gridx = 0;
      c.gridy = 0;
      gridbag.setConstraints(successPreCondCB, c);
      optionsP.add(successPreCondCB);

      // radiobutton success endcondition
      successEndCondCB = new JCheckBox("success endcondition");
//      successEndCondCB.setActionCommand(business.Global.kindDataSuccessEndCond);
      c.gridx = 0;
      c.gridy = 1;
      gridbag.setConstraints(successEndCondCB, c);
      optionsP.add(successEndCondCB);

      // radiobutton failed endcondition
      failedEndCondCB = new JCheckBox("failed endcondition");
//      failedEndCondCB.setActionCommand(business.Global.kindDataFailedEndCond);
      c.gridx = 0;
      c.gridy = 2;
      gridbag.setConstraints(failedEndCondCB, c);
      optionsP.add(failedEndCondCB);

      // radiobutton success scenario
      successScenarioCB = new JCheckBox("success scenario");
//      successScenarioCB.setActionCommand(business.Global.kindDataSuccessSc);
      successScenarioCB.setSelected(true);
      c.gridx = 0;
      c.gridy = 3;
      gridbag.setConstraints(successScenarioCB, c);
      optionsP.add(successScenarioCB);

      // radiobutton extension
      extensionCB = new JCheckBox("extensions");
//      extensionCB.setActionCommand(business.Global.kindDataExtension);
      c.gridx = 0;
      c.gridy = 4;
      gridbag.setConstraints(extensionCB, c);
      optionsP.add(extensionCB);

      // radiobutton variation
      variationCB = new JCheckBox("variations");
//      variationCB.setActionCommand(business.Global.kindDataVariation);
      c.gridx = 0;
      c.gridy = 5;
      gridbag.setConstraints(variationCB, c);
      optionsP.add(variationCB);

    // create button to open viewpoint
    final JButton openB = new JButton("Import viewpoint");
    openB.setActionCommand("import");
    openB.addActionListener(this);

    // close the dialog without doing anything
    JButton cancelB = new JButton("cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dialogD.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));
    buttonP.add(openB);
    buttonP.add(cancelB);

    getContentPane().add(viewpointTree, BorderLayout.NORTH);
    getContentPane().add(optionsP, BorderLayout.CENTER);
    getContentPane().add(buttonP, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       dialogD.dispose();
     }
    });
  }

  /** shows the dialog */
  public void showDialog() {
    dialogD.setLocationRelativeTo(null);
    dialogD.setVisible(true);
  }

  public void actionPerformed(ActionEvent event) {
    String command = event.getActionCommand();

    if (command.equals("import"))
    {



        //************************************************************
       // Are viewpoints already open ?
      if (viewpoint != null){
        boolean found = false;
        for (int i=0; found == false && i<business.Global.viewpointV.size(); i++) {
          if (((business.CViewpoint) business.Global.viewpointV.elementAt(i)).getId() ==
            viewpoint.getId()){
            int option = JOptionPane.showConfirmDialog(null,"This View Point is open and may not be updated \n\n Do you want to continue?" ,"Import",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
            if (option == JOptionPane.OK_OPTION){
            }
            else{
              viewpoint = null ;
            }
            found = true;//ERROR
          }
        }
      }
        //************************************************************


      if (viewpoint != null){

        business.CViewpointUc AViewpointUc =   (business.CViewpointUc) viewpoint;
        business.CUsecase AUsecase = business.Global.usecase;
        //****************************
        //if USECASE is CLOSED then send WARNING
        //****************************


        AUsecase.setActors(persistence.CActor.getAllActorOfUsecase(AUsecase.getId()));

        Vector VP = new Vector();
        Vector UC = new Vector();

        if(successPreCondCB.isSelected()){
          UC = persistence.CUsecase.getPrecond(AUsecase);
          VP = persistence.CViewpointUc.getPrecond(AViewpointUc);
          for (int i = 0; i<VP.size()  ; i++) UC.add(VP.elementAt(i));
          for (int i = 0; i<UC.size()  ; i++) ((business.CCondition)UC.elementAt(i)).setNumber(i);
          AUsecase.setPrecond(UC);
        }
        else AUsecase.setPrecond(persistence.CUsecase.getPrecond(AUsecase));

        if(successEndCondCB.isSelected())
        {
          UC = persistence.CUsecase.getSuccessEndcond(AUsecase);
          VP = persistence.CViewpointUc.getSuccessEndcond(AViewpointUc);
          for (int i = 0; i<VP.size()  ; i++) UC.add(VP.elementAt(i));
          for (int i = 0; i<UC.size()  ; i++) ((business.CCondition)UC.elementAt(i)).setNumber(i);
          AUsecase.setSuccessEndcond(UC);
        }
        else AUsecase.setSuccessEndcond(persistence.CUsecase.getSuccessEndcond(AUsecase));

        if(failedEndCondCB .isSelected())
        {
          UC = persistence.CUsecase.getFailedEndcond(AUsecase);
          VP = persistence.CViewpointUc.getFailedEndcond(AViewpointUc);
          for (int i = 0; i<VP.size()  ; i++) UC.add(VP.elementAt(i));
          for (int i = 0; i<UC.size()  ; i++) ((business.CCondition)UC.elementAt(i)).setNumber(i);
          AUsecase.setFailedEndcond(UC);
        }
        else AUsecase.setFailedEndcond(persistence.CUsecase.getFailedEndcond(AUsecase));

        if(successScenarioCB.isSelected())
        {
          UC = persistence.CUsecase.getSuccessScenarioT1(AUsecase);
          VP = persistence.CViewpointUc.getSuccessScenarioT1(AViewpointUc);
          for (int i = 0; i<VP.size()  ; i++) UC.add(VP.elementAt(i));
          for (int i = 0; i<UC.size()  ; i++) ((business.CStep)UC.elementAt(i)).setStep(i+"");
          for (int i = 0; i<UC.size()  ; i++) ((business.CStep)UC.elementAt(i)).setPosition(i);
          AUsecase.setSuccessScenarioT1(UC);
        }else AUsecase.setSuccessScenarioT1(persistence.CUsecase.getSuccessScenarioT1(AUsecase));

        if(extensionCB.isSelected())
        {
          UC = persistence.CUsecase.getExtensionT1(AUsecase);
          VP = persistence.CViewpointUc.getExtensionT1(AViewpointUc);
          for (int i = 0; i<VP.size()  ; i++) UC.add(VP.elementAt(i));
          for (int i = 0; i<UC.size()  ; i++) ((business.CStep)UC.elementAt(i)).setStep(i+"");
          for (int i = 0; i<UC.size()  ; i++) ((business.CStep)UC.elementAt(i)).setPosition(i);
          AUsecase.setExtensionT1(UC);
        }else AUsecase.setExtensionT1(persistence.CUsecase.getExtensionT1(AUsecase));

        if(variationCB.isSelected())
        {
          UC = persistence.CUsecase.getSubvariationT1(AUsecase);
          VP = persistence.CViewpointUc.getSubvariationT1(AViewpointUc);
          for (int i = 0; i<VP.size()  ; i++) UC.add(VP.elementAt(i));
          for (int i = 0; i<UC.size()  ; i++) ((business.CStep)UC.elementAt(i)).setStep(i+"");
          for (int i = 0; i<UC.size()  ; i++) ((business.CStep)UC.elementAt(i)).setPosition(i);
          AUsecase.setSubvariationT1(UC);
        }else AUsecase.setSubvariationT1(persistence.CUsecase.getSubvariationT1(AUsecase));

        //business.Global.contrUsecase.closeUsecase();

        business.Global.usecase = AUsecase;
        if(business.Global.usecaseF != null) business.Global.usecaseF.dispose();
        business.Global.usecaseF = null;
        //business.Global.setUsecaseIsOpen();
        business.Global.menuBar.reload();
        business.Global.recocase.reload();
        this.dispose();

      }//no viewpoint chosen
      else
      {
        JOptionPane.showMessageDialog(null,"choose viewpoint");
      }

    }//import
  }//action performed

}//class




//    AViewpointUc.getUsecase().setActors(persistence.CActor.getAllActorOfUsecase(
//    AViewpointUc.getUsecase().getId()));
//    AViewpointUc.setActors(persistence.CActor.getAllActorOfViewpointUc(AViewpointUc.getId()));
//    AViewpointUc.setPrecond(persistence.CViewpointUc.getPrecond(AViewpointUc));
//    AViewpointUc.setSuccessEndcond(persistence.CViewpointUc.getSuccessEndcond(AViewpointUc));
//    AViewpointUc.setFailedEndcond(persistence.CViewpointUc.getFailedEndcond(AViewpointUc));
//
//    AViewpointUc.setSuccessScenarioT1(persistence.CViewpointUc.getSuccessScenarioT1(AViewpointUc));
//    AViewpointUc.setExtensionT1(persistence.CViewpointUc.getExtensionT1(AViewpointUc));
//    AViewpointUc.setSubvariationT1(persistence.CViewpointUc.getSubvariationT1(AViewpointUc));
//
//    AViewpointUc.setSuccessScenarioT2(persistence.CViewpointUc.getSuccessScenarioT2(AViewpointUc));
//    AViewpointUc.setExtensionT2(persistence.CViewpointUc.getExtensionT2(AViewpointUc));
//    AViewpointUc.setSubvariationT2(persistence.CViewpointUc.getSubvariationT2(AViewpointUc));



//REOPEN USECASE

