
/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 *
 * @author:      Oscar Aguilera
 * @version 1.0
 */


package gui;

import java.io.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.JTextArea.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;


public class CGroupViewpoint extends JFrame implements FocusListener {

  /** kind of viewpoint */
  //private String kindVp = null;
  /** vector of viewpoints */
  private Vector viewpointV = new Vector();

  boolean usecase = false;

  /** this frame */
  private JFrame frameF = null;
  /** chosen viewpoints */
  private Vector chosenVpV = null;

  // gui
  private JTree vpTree = null;
  private JList chosenVpL = null;
  private DefaultListModel chosenVpLM = null;

  // gui to choose datas of viewpoints for FCA
  private JCheckBox successPreCondCB = null;
  private JCheckBox successEndCondCB = null;
  private JCheckBox failedEndCondCB = null;
  private JCheckBox successScenarioCB = null;
  private JCheckBox extensionCB = null;
  private JCheckBox variationCB = null;

  public String name = null;
  public String notes = null;

  /** constructor
   *  @param AVpV vector of viewpoints
   *  @param AKindOfViewpoint kind of viewpoint
   */

  private long GroupId;

  private JTextField GroupInfoVPText;
  private JTextField GroupNameVPText;

  private long UsecaseId;
  private Vector resolutions;
  private Vector resolutionsIds;


  private JPanel allVpTree;
  private JPanel vpP;




  /**
   *
   *
   *
   *
   */
  public CGroupViewpoint(String groupId) {
    super("Group Viewpoint");
    init(new Long(groupId).longValue() );
  }
  public CGroupViewpoint(String groupId,String GVPname) {
       super("Group Viewpoint");
       name = GVPname;
       notes = "";
       init(new Long(groupId).longValue());
  }


  public void init(long groupId){
    GroupId = groupId;
    UsecaseId = business.Global.usecase.getId();
//    kindVp = Type;
//    kindVp = business.Global.TYPE_VP_USECASE ; //AKindOfViewpoint;
    frameF = this;

    frameF.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        business.Global.contrViewpoint.closeGroupVP(frameF);
      }
    });
    chosenVpV = new Vector();
    init();
    pack();
    business.Global.contrViewpoint.addGroupVP(frameF);
    setVisible(true);
  }

  public long getGroupId(){
    return GroupId;

  }

  public void paint(Graphics g){
    super.paint(g);
    this.update();
  }


  /** initialize gui */
  private void init() {

    vpP = new JPanel();

    vpP.setLayout(new BorderLayout(10, 10));

    if (name == null){
      persistence.CDatabase.refresh(); //sleep and try again
      business.CGroupViewpoint GVP = persistence.CGroupVP.getGroup(GroupId);
      {
        name = GVP.getDescription();
        notes = GVP.getInfo();
        usecase = GVP.includeUC();
      }
    }

    JPanel GroupP = new JPanel();

    JLabel GroupL = new JLabel("Name:");
    GroupP.add(GroupL,BorderLayout.NORTH);


    GroupNameVPText = new JTextField(20);
    GroupNameVPText.setPreferredSize(new Dimension(200,20) );
    GroupNameVPText.setText(name );
    GroupP.add(GroupNameVPText,BorderLayout.NORTH);


    JLabel GroupinfoL = new JLabel("      Notes:");
    GroupP.add(GroupinfoL,BorderLayout.CENTER);

    GroupInfoVPText = new JTextField(45) ;
    GroupInfoVPText.setPreferredSize(new Dimension(400,20) );
    GroupInfoVPText.setText(notes);
    GroupP.add(GroupInfoVPText,BorderLayout.CENTER);


    vpP.add(GroupP,BorderLayout.NORTH);



    // viewpoint tree
    allVpTree = new JPanel();
    updateTree();
    vpP.add(allVpTree, BorderLayout.WEST);

    // Add, Remove
    JPanel vpButtonP = new JPanel();
    vpButtonP.setLayout(new BoxLayout(vpButtonP, BoxLayout.Y_AXIS));
    JButton addB = new JButton("add",business.Global.imageIconRight);


//88888888888888888888
    addB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
          vpTree.getLastSelectedPathComponent();
        if (node == null) return;
        Object nodeInfo = node.getUserObject();

        if (nodeInfo.getClass().isInstance(new business.CViewpointUc())) {
          business.CViewpointUc viewpointUc =  (business.CViewpointUc) nodeInfo;
          //System.out.println("UC vp: " + viewpointUc.getName());
          chosenVpLM.addElement( viewpointUc);
          chosenVpV.add(viewpointUc);

        } else if (nodeInfo.getClass().isInstance(new business.CViewpointSc())) {
          business.CViewpointSc viewpointSc =   (business.CViewpointSc) nodeInfo;
          chosenVpLM.addElement(viewpointSc);
          chosenVpV.add(viewpointSc);

        } else if (nodeInfo.getClass().isInstance(new business.CUsecase())){
          usecase =  true;
          //System.out.println("shared use case viewpoint: " + usecase.getName());
          chosenVpLM.addElement(business.Global.usecase);

        }
//else if (nodeInfo.getClass().isInstance(new business.CScenario())){
//          CANT DO IT unless the Data base is modified
//          business.CScenario scenario =
//            (business.CScenario) nodeInfo;
//          System.out.println("shared scenario viewpoint: " + scenario.getName());
//          chosenVpLM.addElement("shared scenario viewpoint: " + scenario.getName());
//          chosenVpV.add(scenario);
//        }
      }
    });


//88888888888888888888





    JButton removeB = new JButton("remove",business.Global.imageIconLeft);
    removeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int index = chosenVpL.getSelectedIndex();
        if (index < 0) return;

        if (chosenVpLM.getElementAt(index).getClass().isInstance(new business.CUsecase())){
          usecase = false;
          chosenVpLM.remove(index);
        }else{
          business.CViewpoint vp = ((business.CViewpoint) chosenVpLM.getElementAt(index));
          for(int i = 0; i< chosenVpV.size() ; i++){
            if(vp.getId()==  ((business.CViewpoint)chosenVpV.elementAt(i)).getId()){
              chosenVpV.remove(i);
              chosenVpLM.remove(index);
            }

          }
        }
      }
    });


    final JButton openB = new JButton("Open",business.Global.imageIconOpenGVP);
    openB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
//------------------------------

        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
        vpTree.getLastSelectedPathComponent();
        if (node == null) return;
          Object nodeInfo = node.getUserObject();
          if( nodeInfo.getClass().isInstance(new business.CUsecase() )){
            business.Global.contrRecocase.showUseCase();
          }else{
            business.CViewpoint viewpoint = (business.CViewpoint) nodeInfo;
              // is viewpoint already open ?
            boolean found = false;
            for (int i=0; found == false && i<business.Global.viewpointV.size(); i++) {
              if (((business.CViewpoint) business.Global.viewpointV.elementAt(i)).getId() == viewpoint.getId() )
              {
                found = true;
              }
            }
            if (found == false){
              business.Global.contrViewpoint.openViewpoint(viewpoint);
              //System.out.println("OPEN 1 ");
            }
            found = false;
            for (int i=0; found == false && i<business.Global.viewpointV.size(); i++) {
                if (((business.CViewpoint) business.Global.viewpointV.elementAt(i)).getId() == viewpoint.getId() ){
                   found = true;
                   business.Global.contrRecocase.showViewpoint(i);
                      //System.out.println("FOUND");
                }
            }
          }
//        if (nodeInfo.getClass().isInstance(new business.CViewpointUc())) {
//
//        } else if (nodeInfo.getClass().isInstance(new business.CUsecase())){
//          System.out.println("error");
//        } else if (nodeInfo.getClass().isInstance(new business.CScenario())){
//          System.out.println("error");
//        } else if (nodeInfo.getClass().isInstance(new business.CViewpointSc())) {
//
//        }
      }
    });


    JButton updateB = new JButton("    Refresh    ");
    updateB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        update();
      }
    });

    vpButtonP.add(addB);
    vpButtonP.add(removeB);
    vpButtonP.add(openB);
    vpButtonP.add(updateB);
    vpP.add(vpButtonP, BorderLayout.CENTER);

    // chosen viewpoints
    chosenVpLM = new DefaultListModel();
    chosenVpL = new JList(chosenVpLM);
    chosenVpL.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane chosenVpSP = new JScrollPane(chosenVpL);
    chosenVpSP.setPreferredSize(new Dimension(300, 300));
    vpP.add(chosenVpSP, BorderLayout.EAST);

    vpP.setBorder(
      BorderFactory.createCompoundBorder(
      BorderFactory.createTitledBorder("Group viewpoint"),
      BorderFactory.createEmptyBorder(10,5,5,5)
      )
    );


    Vector GroupVPIDs =   persistence.CGroupVP.getGroupVPIDs(GroupId);
    chosenVpLM.removeAllElements();
    Vector newChosenVpV = new Vector();
    if (viewpointV != null) {
      //System.out.println("----------");
      for (int i=0; i<viewpointV.size(); i++) {
        business.CViewpoint vp = (business.CViewpoint) viewpointV.elementAt(i) ;
        for (int x = 0 ; x< GroupVPIDs.size() ; x++){
          //System.out.println("ID:"+((Long)GroupVPIDs.elementAt(x)).longValue()+" vs ID:"+vp.getId());
          if(vp.getId() == ((Long)GroupVPIDs.elementAt(x)).longValue()){
            chosenVpLM.addElement(vp);
            newChosenVpV.addElement( vp );
          }
        }
      }
      chosenVpV  = newChosenVpV ;
    }



    // kind of datas for FCA
    //if (kindVp.equals(business.Global.TYPE_VP_USECASE)) {

      JPanel dataP = new JPanel();
      GridBagLayout gridbag = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();
      c.anchor = GridBagConstraints.WEST;

      dataP.setLayout(gridbag);
      dataP.setBorder(
        BorderFactory.createCompoundBorder(
          BorderFactory.createTitledBorder("Data of Use Case viewpoints"),
          BorderFactory.createEmptyBorder(10,5,5,5)
        )
      );


      // radiobutton success precondition
      successPreCondCB = new JCheckBox("precondition");
      successPreCondCB.setActionCommand(business.Global.kindDataPreCond);
      c.gridx = 0;
      c.gridy = 0;
      gridbag.setConstraints(successPreCondCB, c);
      dataP.add(successPreCondCB);

      // radiobutton success endcondition
      successEndCondCB = new JCheckBox("success endcondition");
      successEndCondCB.setActionCommand(business.Global.kindDataSuccessEndCond);
      c.gridx = 0;
      c.gridy = 1;
      gridbag.setConstraints(successEndCondCB, c);
      dataP.add(successEndCondCB);

      // radiobutton failed endcondition
      failedEndCondCB = new JCheckBox("failed endcondition");
      failedEndCondCB.setActionCommand(business.Global.kindDataFailedEndCond);
      c.gridx = 0;
      c.gridy = 2;
      gridbag.setConstraints(failedEndCondCB, c);
      dataP.add(failedEndCondCB);

      // radiobutton success scenario
      successScenarioCB = new JCheckBox("success Main Flow");
      successScenarioCB.setActionCommand(business.Global.kindDataSuccessSc);
      successScenarioCB.setSelected(true);
      c.gridx = 0;
      c.gridy = 3;
      gridbag.setConstraints(successScenarioCB, c);
      dataP.add(successScenarioCB);

      // radiobutton extension
      extensionCB = new JCheckBox("extensions");
      extensionCB.setActionCommand(business.Global.kindDataExtension);
      c.gridx = 0;
      c.gridy = 4;
      gridbag.setConstraints(extensionCB, c);
      dataP.add(extensionCB);

      // radiobutton variation
      variationCB = new JCheckBox("variations");
//      variationCB.setActionCommand(business.Global.kindDataVariation);
//      c.gridx = 0;
//      c.gridy = 5;
//      gridbag.setConstraints(variationCB, c);
//      dataP.add(variationCB);


      vpButtonP.add(dataP);

    //}


//  ****************************************************************************

    final JButton saveB = new JButton("Save Group",business.Global.imageIconSave);
    saveB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        save();
      }
    });


    final JButton deleteB = new JButton("Delete Group",business.Global.imageIconDelete);
    deleteB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int sure = JOptionPane.showConfirmDialog(
        frameF,
        "Are you sure ? ",
        "delete Group",
        JOptionPane.YES_NO_OPTION);
        if (sure == JOptionPane.YES_OPTION) {

          business.Global.contrViewpoint.closeGroupVP(frameF);
          persistence.CGroupVP.DeleteGroup(GroupId);
          //frameF.dispose();
        }
      }
    });


//    final JButton groupViewpointB = new JButton("Import Viewpoints to a new viewpoint");
//    groupViewpointB.addActionListener(new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//
//        String VPname ="";
//        if(chosenVpV.size()>0){
//          VPname = JOptionPane.showInputDialog(
//          frameF,
//          "Name ? ");
//          //System.out.println(VPname);
//        }
//        if(VPname != null && VPname != ""){
//          if (kindVp.equals(business.Global.TYPE_VP_USECASE))
//          {
//              VPname = VPname + "(Group:"+ name.getData()    +")" ;
//              business.CViewpointUc vp = new business.CViewpointUc();
//              vp.setName(VPname);
//              vp.setUsecase(business.Global.usecase);
//
//              business.Global.contrViewpoint.setFrame(frameF);
//              //  business.Global.contrViewpoint.openViewpoint(vp);
//              for (int index=0;index < chosenVpV.size() ; index++){
//                business.Global.contrViewpoint.ImportUCVP(
//                vp,
//                (business.CViewpointUc) chosenVpV.elementAt(index),
//                  successPreCondCB.isSelected(),
//                  successEndCondCB.isSelected(),
//                  failedEndCondCB.isSelected(),
//                  successScenarioCB.isSelected(),
//                  extensionCB.isSelected(),
//                  variationCB.isSelected());
//              }
//              vp.setTrigger("");
//              business.Global.contrViewpoint.createViewpoint(vp,1);
//              //business.Global.contrViewpoint.openViewpoint(vp); dont open (race condition saving and openig)
//
//          }else{//Scenario
//
//              VPname = VPname + "(Group:"+ name.getData()   +")" ;
//              business.CViewpointSc vp = new business.CViewpointSc();
//              vp.setName(VPname);
//              //vp.setUsecase(business.Global.usecase);
//              //vp.setScenario(((business.CViewpointSc) chosenVpV.elementAt(0)).getScenario());
//
//              business.Global.contrViewpoint.setFrame(frameF);
//              //  business.Global.contrViewpoint.openViewpoint(vp);
//              for (int index=0;index < chosenVpV.size() ; index++){
//                business.Global.contrViewpoint.ImportScVP(
//                vp,
//                (business.CViewpointSc) chosenVpV.elementAt(index));
//              }
//              business.Global.contrViewpoint.createViewpoint(vp,1);
//              //business.Global.contrViewpoint.openViewpoint(vp); dont open (race condition saving and openig)
//
//          }
//        }//name
//      }
//    });

//    final JButton openTableB = new JButton("Open Table");
//    openTableB.addActionListener(new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        //System.out.println("OPEN TABLE");
//        new toms.OpenResolutionTable(frameF,GroupId);
//      }
//    });



    final JButton tableB = new JButton("Create Table",business.Global.imageIconXT);
    tableB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        Vector VpVandUC = new Vector();
        for(int i = 0; i<chosenVpV.size() ; i++){
          VpVandUC.addElement(chosenVpV.elementAt(i));
        }
        if(usecase) VpVandUC.addElement(business.Global.usecase);

        business.Global.contrFCA.createResolutionTableUCSC(
            getName(),
            GroupId+"",
            VpVandUC,
            successPreCondCB.isSelected(),
            successEndCondCB.isSelected(),
            failedEndCondCB.isSelected(),
            successScenarioCB.isSelected(),
            extensionCB.isSelected(),
            variationCB.isSelected());
      }

    });

    final JButton latticeB = new JButton("Create Diagram",business.Global.imageIconDiagram);
    latticeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        Vector VpVandUC = new Vector();
        for(int i = 0; i<chosenVpV.size() ; i++){
          VpVandUC.addElement(chosenVpV.elementAt(i));
        }
        if(usecase) VpVandUC.addElement(business.Global.usecase);
        business.Global.contrFCA.createLatticeUCSC(
            GroupId+"",
            VpVandUC,
            successPreCondCB.isSelected(),
            successEndCondCB.isSelected(),
            failedEndCondCB.isSelected(),
            successScenarioCB.isSelected(),
            extensionCB.isSelected(),
            variationCB.isSelected());
            //frameF.dispose();
        }

    });

    JButton closeB = new JButton("Close",business.Global.imageIconClose);
    closeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int sure = JOptionPane.showConfirmDialog(
        frameF,
        "Do you want to save ? ",
        "Close",
        JOptionPane.YES_NO_CANCEL_OPTION);
        if (sure == JOptionPane.YES_OPTION) {
            save();
            business.Global.contrViewpoint.closeGroupVP(frameF);
        }
        if (sure == JOptionPane.NO_OPTION) {
            business.Global.contrViewpoint.closeGroupVP(frameF);
        }

      }
    });




    final JButton minimizeB = new JButton("Minimize",business.Global.imageIconMinimize);
    minimizeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        frameF.hide();
      }
    });


//    JPanel buttonP = new JPanel();
//    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));

    JPanel buttonPR = new JPanel();
    buttonPR.setLayout(new FlowLayout(FlowLayout.RIGHT, 1, 1));
    JPanel buttonPL = new JPanel();
    buttonPL.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));


    buttonPL.add(saveB);
    buttonPL.add(tableB);
//    buttonPL.add(groupViewpointB);
//    buttonPL.add(openTableB);
    buttonPL.add(latticeB);
    buttonPL.add(deleteB);


    buttonPR.add(minimizeB);
    buttonPR.add(closeB);


//    buttonP.add(crosstableB);
//    buttonP.add(deleteTableB);
//    DO WE NEED THIS ?????????????????????????????????????????????????????????
//    buttonP.add(crosstableOpenB);
//    buttonP.add(fltB);


    JPanel buttonP = new JPanel();
    buttonP.setLayout(new BorderLayout());
    buttonP.add(buttonPL,BorderLayout.WEST);
    buttonP.add(buttonPR,BorderLayout.EAST);





    getContentPane().add(vpP, BorderLayout.SOUTH);
    getContentPane().add(buttonP, BorderLayout.NORTH);

  }

  public void focusGained(FocusEvent e) {
    update();
	//System.out.println("Focus gained");

  }

  public void focusLost(FocusEvent e) {
	//System.out.println("Focus lost");
  }


/**
 * ---------------------------------------------
 *
 * ---------------------------------------------
 */



  public void update(){
    //viewpointV = this.getVPV(this.kindVp);
    updateTree();
    updateSelected();
  }

  public void updateSelected(){

    chosenVpLM.removeAllElements();
    Vector newChosenVpV = new Vector();

    if (usecase){
      chosenVpLM.addElement(business.Global.usecase);
    }
    if (viewpointV != null) {
      for (int i=0; i<viewpointV.size(); i++) {
        business.CViewpoint vp = (business.CViewpoint) viewpointV.elementAt(i) ;
        for(int x = 0 ; x<chosenVpV.size() ; x ++){
          if(vp.getId() == ((business.CViewpoint) chosenVpV.elementAt(x)).getId()){
            chosenVpLM.addElement(vp);
            newChosenVpV.addElement( vp );
          }
        }
      }
      chosenVpV  = newChosenVpV ;
    }
  }


  /**
   *
   *
   */


  public void updateTree(){

    DefaultMutableTreeNode usecaseNode = null;
    DefaultMutableTreeNode scenarioNode = null;
    DefaultMutableTreeNode top = new DefaultMutableTreeNode(business.Global.usecase);
    this.viewpointV.removeAllElements();

    Vector ucVpV = persistence.CViewpointUc.getAllViewpointUcOfUsecase((business.CUsecase) business.Global.usecase);
    for(int i = 0;i<ucVpV.size();i++){
      this.viewpointV.add(ucVpV.elementAt(i) );
      usecaseNode = new DefaultMutableTreeNode( ucVpV.elementAt(i));
      top.add(usecaseNode);

      Vector scVpV = persistence.CViewpointSc.getAllViewpointScOf((business.CViewpointUc) ucVpV.elementAt(i))  ;
      for(int y = 0;y<scVpV.size();y++){
        this.viewpointV.add(scVpV.elementAt(y) );
        scenarioNode = new DefaultMutableTreeNode(scVpV.elementAt(y));
        usecaseNode.add(scenarioNode);
      }
    }
//            usecaseNode.add(new DefaultMutableTreeNode( (business.CViewpointUc) ucVpV.elementAt(j)));



    vpTree = new JTree(top);

    vpTree.getSelectionModel().setSelectionMode(
      TreeSelectionModel.SINGLE_TREE_SELECTION);

    JScrollPane treeView = new JScrollPane(vpTree);

    allVpTree.removeAll();
    allVpTree.add(treeView);
    treeView.setPreferredSize(new Dimension(300, 300));

    int row = 0;
    while(row < vpTree.getRowCount()){
      vpTree.expandRow(row);
      row++;
    }
    allVpTree.setVisible(true);
    allVpTree.updateUI();
   // vpP.add(allVpTree, BorderLayout.WEST);


  }

  public void save(){
    if(GroupNameVPText.getText().length()>0){
        persistence.CGroupVP.updateGroup(GroupId, GroupNameVPText.getText() , GroupInfoVPText.getText(),UsecaseId + "", usecase );
        Vector ids = new Vector();
        for(int i = 0; i<chosenVpV.size() ; i++){
          ids.addElement( ((business.CViewpoint) chosenVpV.elementAt(i)).getId()+"");
        }
        persistence.CGroupVP.updateGroupVP(GroupId, ids );
    }else{
      JOptionPane.showMessageDialog(this,"Please enter a group name");
    }
  }

  public String getName(){
    return GroupNameVPText.getText();
  }

}





















