package gui;

import java.io.*;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * Description:
 * gui to choose viewpoints for FCA (quick lattice)
 * to create crosstable or
 * to create file in flt-format
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CFCAF extends JFrame {

  /** kind of viewpoint */
  private String kindVp = null;
  /** vector of viewpoints */
  private Vector viewpointV = null;
  /** this frame */
  private JFrame frameF = null;
  /** chosen viewpoints */
  private Vector chosenVpV = null;

  // gui
  private JTree vpTree = null;
  private JList chosenVpL = null;
  private DefaultListModel chosenVpLM = null;

  // gui to choose datas of viewpoints for FCA
  private JCheckBox successPreCondCB = null;
  private JCheckBox successEndCondCB = null;
  private JCheckBox failedEndCondCB = null;
  private JCheckBox successScenarioCB = null;
  private JCheckBox extensionCB = null;
  private JCheckBox variationCB = null;

  /** constructor
   *  @param AVpV vector of viewpoints
   *  @param AKindOfViewpoint kind of viewpoint
   */
  public CFCAF(Vector AVpV, String AKindOfViewpoint) {

    super("FCA");
    viewpointV = AVpV;
    kindVp = AKindOfViewpoint;
    frameF = this;
    chosenVpV = new Vector();

    init();
    pack();
    setVisible(true);
  }

  /** initialize gui */
  private void init() {

    JPanel vpP = new JPanel();
    vpP.setLayout(new BorderLayout(10, 10));

    // viewpoint tree
    JPanel allVpTree = new JPanel();
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("viewpoint");
    if (viewpointV != null) {
      DefaultMutableTreeNode usecaseNode = null;
      DefaultMutableTreeNode scenarioNode = null;

      for (int i=0; i<viewpointV.size(); i++) {

        business.CUsecase usecase =
          (business.CUsecase) ((Vector) viewpointV.elementAt(i)).elementAt(0);
        usecaseNode = new DefaultMutableTreeNode("usecase: " +
          usecase.getName());
        top.add(usecaseNode);

        if (kindVp.equals(business.Global.TYPE_VP_USECASE)) {
          // shared use case
//          usecaseNode.add(new DefaultMutableTreeNode(
//            (business.CUsecase) usecase));

          // viewpoint use cases
          Vector ucVpV = (Vector) ((Vector) viewpointV.elementAt(i)).elementAt(1);
          if (ucVpV != null) {
            for (int j=0; j<ucVpV.size(); j++) {
              usecaseNode.add(new DefaultMutableTreeNode(
                (business.CViewpointUc) ucVpV.elementAt(j)));
            }
          }
        }

        if (kindVp.equals(business.Global.TYPE_VP_SCENARIO)) {
//          // scenarios
//          Vector allScenarioV = (Vector) ((Vector) viewpointV.elementAt(i)).elementAt(1);
//          if (allScenarioV != null) {
//            for (int j=0; j<allScenarioV.size(); j++) {
//              scenarioNode = new DefaultMutableTreeNode("scenario: " +  ((business.CScenario) ((Vector)
//                allScenarioV.elementAt(j)).elementAt(0)).toString());
//              usecaseNode.add(scenarioNode);
//
//              // viewpoint scenarios
//              Vector scVpV = (Vector) ((Vector) allScenarioV.elementAt(j)).elementAt(1);
//              if (scVpV != null) {
//                for (int k=0; k<scVpV.size(); k++) {
//                  scenarioNode.add(new DefaultMutableTreeNode(
//                    (business.CViewpointSc) scVpV.elementAt(k)));
//                }
//              }
//            }
//          }
        }
      }
    }

    vpTree = new JTree(top);
    vpTree.getSelectionModel().setSelectionMode(
      TreeSelectionModel.SINGLE_TREE_SELECTION);
    JScrollPane treeView = new JScrollPane(vpTree);
    treeView.setPreferredSize(new Dimension(300, 300));
    allVpTree.add(treeView);
    vpP.add(allVpTree, BorderLayout.WEST);

    // Add, Remove
    JPanel vpButtonP = new JPanel();
    vpButtonP.setLayout(new BoxLayout(vpButtonP, BoxLayout.Y_AXIS));
    JButton addB = new JButton(" add ");
    addB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
          vpTree.getLastSelectedPathComponent();
        if (node == null) return;
        Object nodeInfo = node.getUserObject();

        if (nodeInfo.getClass().isInstance(new business.CViewpointUc())) {
          business.CViewpointUc viewpointUc =
            (business.CViewpointUc) nodeInfo;
          System.out.println("use case viewpoint: " + viewpointUc.getName());
          chosenVpLM.addElement("use case viewpoint: " +
             viewpointUc.getUsecase().getName() + " / " +
             viewpointUc.getName() + " [" + viewpointUc.getUser().getName() + "]");
          chosenVpV.add(viewpointUc);

        } else if (nodeInfo.getClass().isInstance(new business.CViewpointSc())) {
          business.CViewpointSc viewpointSc =
            (business.CViewpointSc) nodeInfo;
          System.out.println("scenario viewpoint: " + viewpointSc.getName());
          chosenVpLM.addElement("scenario viewpoint: " +
            //viewpointSc.getScenario().getUsecase().getName() + " / " +
            //viewpointSc.getScenario().getName() + " / " +
            viewpointSc.getName() + " [" + viewpointSc.getUser().getName() + "]");
          chosenVpV.add(viewpointSc);

        } else if (nodeInfo.getClass().isInstance(new business.CUsecase())){
//          business.CUsecase usecase =
//            (business.CUsecase) nodeInfo;
//          System.out.println("shared use case viewpoint: " + usecase.getName());
//          chosenVpLM.addElement("shared use case viewpoint: " + usecase.getName());
//          chosenVpV.add(usecase);

        }// else if (nodeInfo.getClass().isInstance(new business.CScenario())){
//          business.CScenario scenario =
//            (business.CScenario) nodeInfo;
//          System.out.println("shared scenario viewpoint: " + scenario.getName());
//          chosenVpLM.addElement("shared scenario viewpoint: " + scenario.getName());
//          chosenVpV.add(scenario);
//        }
      }
    });

    JButton removeB = new JButton(" remove ");
    removeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int index = chosenVpL.getSelectedIndex();
        if (index < 0) return;
        chosenVpV.remove(index);
        chosenVpLM.remove(index);
      }
    });
    vpButtonP.add(addB);
    vpButtonP.add(removeB);
    vpP.add(vpButtonP, BorderLayout.CENTER);

    // chosen viewpoints
    chosenVpLM = new DefaultListModel();
    chosenVpL = new JList(chosenVpLM);
    chosenVpL.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane chosenVpSP = new JScrollPane(chosenVpL);
    chosenVpSP.setPreferredSize(new Dimension(300, 300));
    vpP.add(chosenVpSP, BorderLayout.EAST);

    vpP.setBorder(
      BorderFactory.createCompoundBorder(
      BorderFactory.createTitledBorder("viewpoints"),
      BorderFactory.createEmptyBorder(10,5,5,5)
      )
    );

    // kind of datas for FCA
    if (kindVp.equals(business.Global.TYPE_VP_USECASE)) {

      JPanel dataP = new JPanel();
      GridBagLayout gridbag = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();
      c.anchor = GridBagConstraints.WEST;

      dataP.setLayout(gridbag);
      dataP.setBorder(
        BorderFactory.createCompoundBorder(
          BorderFactory.createTitledBorder("data of viewpoints"),
          BorderFactory.createEmptyBorder(10,5,5,5)
        )
      );


      // radiobutton success precondition
      successPreCondCB = new JCheckBox("precondition");
      successPreCondCB.setActionCommand(business.Global.kindDataPreCond);
      c.gridx = 0;
      c.gridy = 0;
      gridbag.setConstraints(successPreCondCB, c);
      dataP.add(successPreCondCB);

      // radiobutton success endcondition
      successEndCondCB = new JCheckBox("success end condition");
      successEndCondCB.setActionCommand(business.Global.kindDataSuccessEndCond);
      c.gridx = 0;
      c.gridy = 1;
      gridbag.setConstraints(successEndCondCB, c);
      dataP.add(successEndCondCB);

      // radiobutton failed endcondition
      failedEndCondCB = new JCheckBox("failed end condition");
      failedEndCondCB.setActionCommand(business.Global.kindDataFailedEndCond);
      c.gridx = 0;
      c.gridy = 2;
      gridbag.setConstraints(failedEndCondCB, c);
      dataP.add(failedEndCondCB);

      // radiobutton success scenario
      successScenarioCB = new JCheckBox("success Main Flow");
      successScenarioCB.setActionCommand(business.Global.kindDataSuccessSc);
      successScenarioCB.setSelected(true);
      c.gridx = 0;
      c.gridy = 3;
      gridbag.setConstraints(successScenarioCB, c);
      dataP.add(successScenarioCB);

      // radiobutton extension
      extensionCB = new JCheckBox("extensions");
      extensionCB.setActionCommand(business.Global.kindDataExtension);
      c.gridx = 0;
      c.gridy = 4;
      gridbag.setConstraints(extensionCB, c);
      dataP.add(extensionCB);

      // radiobutton variation
      variationCB = new JCheckBox("variations");
      variationCB.setActionCommand(business.Global.kindDataVariation);
      c.gridx = 0;
      c.gridy = 5;
      gridbag.setConstraints(variationCB, c);
      dataP.add(variationCB);

      getContentPane().add(dataP, BorderLayout.CENTER);

    }


    final JButton latticeB = new JButton("Create Lattice");
    latticeB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (kindVp.equals(business.Global.TYPE_VP_USECASE))

          business.Global.contrFCA.createLatticeUCSC(
            chosenVpV,
            successPreCondCB.isSelected(),
            successEndCondCB.isSelected(),
            failedEndCondCB.isSelected(),
            successScenarioCB.isSelected(),
            extensionCB.isSelected(),
            variationCB.isSelected());
        else
          business.Global.contrFCA.createLatticeUCSC(
            chosenVpV,
            successPreCondCB.isSelected(),
            successEndCondCB.isSelected(),
            failedEndCondCB.isSelected(),
            successScenarioCB.isSelected(),
            extensionCB.isSelected(),
            variationCB.isSelected());
          frameF.dispose();

      }
    });


    // button panel
//    final JButton crosstableB = new JButton("create crosstable");
//    crosstableB.addActionListener(new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        if (kindVp.equals(business.Global.TYPE_VP_USECASE))
//          business.Global.contrFCA.createCrosstableForUc(
//            chosenVpV,
//            successPreCondCB.isSelected(),
//            successEndCondCB.isSelected(),
//            failedEndCondCB.isSelected(),
//            successScenarioCB.isSelected(),
//            extensionCB.isSelected(),
//            variationCB.isSelected());
//        else
//          business.Global.contrFCA.createCrosstableForSc(chosenVpV);
//
//        frameF.dispose();
//
//      }
//    });


//    final JButton crosstableOpenB = new JButton("open file in flt-format");
//    crosstableOpenB.addActionListener(new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        gui.CCrosstable gui_crosstable = new gui.CCrosstable();
//        frameF.dispose();
//      }
//    });
//
//    final JButton fltB = new JButton("create file in flt-format");
//    fltB.addActionListener(new ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        if (kindVp.equals(business.Global.TYPE_VP_USECASE))
//          business.Global.contrFCA.createFltFileForUc(
//            chosenVpV,
//            successPreCondCB.isSelected(),
//            successEndCondCB.isSelected(),
//            failedEndCondCB.isSelected(),
//            successScenarioCB.isSelected(),
//            extensionCB.isSelected(),
//            variationCB.isSelected());
//
//        else
//          business.Global.contrFCA.createFltFileForSc(chosenVpV);
//        frameF.dispose();
//      }
//    });

    JButton cancelB = new JButton("cancel");
    cancelB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        frameF.dispose();
      }
    });

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));
    buttonP.add(latticeB);
//    buttonP.add(crosstableB);
//    buttonP.add(crosstableOpenB);
//    buttonP.add(fltB);
    buttonP.add(cancelB);

    getContentPane().add(vpP, BorderLayout.NORTH);
    getContentPane().add(buttonP, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
       System.exit(0);
     }
    });
  }


}
