package gui;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Description: creates panel to display and edits agents
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CAgentTableP extends JPanel implements ActionListener,  TableModelListener {

  /** parent panel */
  private CViewpointScenarioP listenerP = null;
  /** vector of current agents */
  private Vector agentV = null;
  /** vector of actors of shared use case which shared scenario is attached to */
  private Vector actorV = null;
  /** shared use case which shared scenario is attached to */
  private business.CUsecase usecase = null;

  /** parent */
  private JFrame frameF = null;

  public JTable actorsT = null;

  private gui.CTableModel tableModel = null;

  private JComboBox actorCB = null;
  final String[] columnNames = {"name", "actor type"};
  final Object[][] data = {};

  /** constructor
   *  @param AFrame parent frame
   */
  public CAgentTableP(JFrame AFrameF,
                      CViewpointScenarioP AListenerP,
                      business.CUsecase AUsecase,
                      Vector AAgentV) {

    listenerP = AListenerP;
    usecase = AUsecase;
    agentV = AAgentV;
    actorV = usecase.getActors();
    frameF = AFrameF;

    init();
  }

  /** initialize gui */
  private void init() {

    this.setLayout(new BorderLayout(5, 5));

    // agent table
    tableModel = new gui.CTableModel(data, columnNames);
    actorsT = new JTable(tableModel);

    TableColumn typeColumn = actorsT.getColumnModel().getColumn(1);
    actorCB = new JComboBox();

    if (actorV != null) {
      for (int i=0; i<actorV.size(); i++) {
        actorCB.addItem((business.CActor) actorV.elementAt(i));
      }
      typeColumn.setCellEditor(new DefaultCellEditor(actorCB));
    }

    TableCellRenderer headerRenderer = typeColumn.getHeaderRenderer();
    if (headerRenderer instanceof DefaultTableCellRenderer) {
       ((DefaultTableCellRenderer)headerRenderer).setToolTipText(
                     "Click to see the list of actor types");
    }

    // fill table
    if (agentV != null) {
      for (int i=0; i<agentV.size(); i++) {

        Vector newRow = new Vector();
        newRow.add((String) ((business.CAgent) agentV.elementAt(i)).getName());

        if (((business.CAgent) agentV.elementAt(i)).getActor() != null) {
          newRow.add(((business.CAgent) agentV.elementAt(i)).getActor());
        } else {
          newRow.add(new business.CActor());
        }
        tableModel.addRow(newRow);
      }
    }

    actorsT.setPreferredScrollableViewportSize(new Dimension(400, 70));
    actorsT.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    typeColumn = actorsT.getColumnModel().getColumn(0);
    typeColumn.setPreferredWidth(200);
    typeColumn = actorsT.getColumnModel().getColumn(1);
    typeColumn.setPreferredWidth(200);

    tableModel.addTableModelListener(this); // not earlier

    JScrollPane actorsTSP = new JScrollPane(actorsT);

    // button panel
    JButton actorsNewB = new JButton ("New");
    actorsNewB.addActionListener(this);

    JButton actorsDeleteB = new JButton ("Delete");
    actorsDeleteB.addActionListener(this);

    JPanel actorsBP = new JPanel();
    actorsBP.setLayout(new BoxLayout(actorsBP, BoxLayout.Y_AXIS));
    actorsBP.add(actorsNewB);
    actorsBP.add(actorsDeleteB);

    this.add(actorsTSP, BorderLayout.CENTER);
    this.add(actorsBP, BorderLayout.EAST);
  }

  /** is called if user wants to add or delete agent */
  public void actionPerformed(ActionEvent e) {
    tableModel.removeTableModelListener(this);

    if(e.getActionCommand().equals("New")) {

      Vector newRow = new Vector();
      newRow.add(new String(""));
      newRow.add(new business.CActor());
      tableModel.addRow(newRow);

      if (agentV == null) agentV = new Vector();
      agentV.add(new business.CAgent());

    } else if (e.getActionCommand().equals("Delete")) {

      ListSelectionModel rowSM = actorsT.getSelectionModel();
      int minIndex = rowSM.getMinSelectionIndex();
      int maxIndex = rowSM.getMaxSelectionIndex();

      for(int i=maxIndex; i>-1 && i>=minIndex; i--) {

        // check if possible to delete
        if (listenerP == null || listenerP.canDeleteAgent(i)) {
          agentV.removeElementAt(i);
          tableModel.removeRow(i);
           // !!!minIndex, because previous row is already deleted
        } else {
          JOptionPane.showMessageDialog(frameF, "can't delete agent. agent is in use.");
        }
      }

      if (listenerP != null) listenerP.changedAgents();
    }

    tableModel.addTableModelListener(this);
  }

  /** reads data from gui and return vector of agents */
  public Vector getAgents() {



    if (agentV == null) return null;

    for (int i=0; i<agentV.size(); i++) {

      String name = (String) tableModel.getValueAt(i, 0);
      if(name.equals("")||name == null){
        business.Global.error = true;
      }
      business.CActor type = ((business.CActor) tableModel.getValueAt(i, 1));
      if(type.getType() == null || type.getType().equals("")){
        business.Global.error = true;
      }

      ((business.CAgent) agentV.elementAt(i)).setName(name);
      ((business.CAgent) agentV.elementAt(i)).setActor(type);
    }

    return agentV;
  }

  /** reloads gui */
  public void reload(business.CUsecase AUsecase, Vector AAgentV) {

    usecase = AUsecase;
    agentV = AAgentV;
    actorV = usecase.getActors();

    // delete old content
    tableModel.removeTableModelListener(this);
    tableModel.setDataVector(data, columnNames);

    // init combobox of actors
    if (usecase == null && agentV == null) return;

    if (usecase.getActors() != null) {
      TableColumn typeColumn = actorsT.getColumnModel().getColumn(1);
      actorCB = new JComboBox();
      for (int i=0; i<usecase.getActors().size(); i++) {
        actorCB.addItem(
          (business.CActor) usecase.getActors().elementAt(i));
      }
      typeColumn.setCellEditor(new DefaultCellEditor(actorCB));
    }

    // fill table
    if (agentV != null) {
      for (int i=0; i<agentV.size(); i++) {

        Vector newRow = new Vector();
        newRow.add((String) ((business.CAgent) agentV.elementAt(i)).getName());

        if (((business.CAgent) agentV.elementAt(i)).getActor() != null) {
          newRow.add(((business.CAgent) agentV.elementAt(i)).getActor());
        } else {
          newRow.add(new business.CActor());
        }

        tableModel.addRow(newRow);
      }
    }

    tableModel.addTableModelListener(this);

    actorsT.setPreferredScrollableViewportSize(new Dimension(400, 70));
    actorsT.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    TableColumn typeColumn = actorsT.getColumnModel().getColumn(0);
    typeColumn.setPreferredWidth(200);
    typeColumn = actorsT.getColumnModel().getColumn(1);
    typeColumn.setPreferredWidth(200);
  }

  /** is called if user changed agent table */
  public void tableChanged(TableModelEvent e) {

    if (listenerP != null) listenerP.changedAgents();
  }
}
