package gui;

import java.io.*;
import javax.swing.*;
import javax.swing.text.*;
               import javax.swing.JTextArea.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 *
 * Description: An object of this class is created if user wants modify the actors of the project
 *
 */

public class CActorsF extends JDialog implements ListSelectionListener , ActionListener,WindowListener {

  /** this frame */
  private CActorP actorP = null;
  private Vector allActors = null;
  private JList actorsL = null;
  private JScrollPane actorsList = null;
  /** constructor
   *  @param AProject project to be displayed
   */
  public CActorsF() {
    super(business.Global.recocase ,"Actors",true);
    this.init();
    this.pack();
    this.show();
  }

  /** initialize gui */
  private void init() {
    this.addWindowListener(this);
//    business.Global.dialog = this;

//    business.Global.windowV.add(this);
//    business.Global.recocase.reload();


    // actor panel List
    JPanel actorsP = new JPanel(new BorderLayout(20, 20));
    allActors = persistence.CActor.getAllActors();
    actorsL = new JList(allActors);
    actorsList = new JScrollPane(actorsL);
    actorsList.setVerticalScrollBarPolicy(actorsList.VERTICAL_SCROLLBAR_ALWAYS);
    actorsList.setHorizontalScrollBarPolicy(actorsList.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    actorsL.setSelectionMode(actorsL.getSelectionModel().SINGLE_SELECTION );
    actorsL.addListSelectionListener(this);
    actorsP.add(actorsList, BorderLayout.WEST);

    // button panel for actors
    JPanel actorsBP = new JPanel();
    actorsBP.setLayout( new BoxLayout(actorsBP, BoxLayout.Y_AXIS));

    JButton editActorB = new JButton("Edit Actor");
    editActorB.setActionCommand("editActor");
    editActorB.addActionListener(this);
    actorsBP.add(editActorB);


    JButton newActorB = new JButton("New Actor");
    newActorB.setActionCommand("newActor");
    newActorB.addActionListener(this);
    actorsBP.add(newActorB);

    JButton deleteActorB = new JButton("Delete Actor");
    deleteActorB.setActionCommand("deleteActor");
    deleteActorB.addActionListener(this);
    actorsBP.add(deleteActorB);

    actorsP.add(actorsBP, BorderLayout.CENTER);
    getContentPane().add(actorsP, BorderLayout.WEST);
    actorP = new CActorP(this);
    getContentPane().add(actorP, BorderLayout.EAST);


    actorP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder("Actor Editor"),
        BorderFactory.createEmptyBorder(10,10,10,10)
      )
    );
    actorsP.setBorder(
      BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder("Actors"),
        BorderFactory.createEmptyBorder(10,10,10,10)
      )
    );


    // button panel
    JPanel buttonP = new JPanel();
    buttonP.setLayout(new FlowLayout(FlowLayout.CENTER, 20, 10));

    JButton closeB = new JButton("Close");
    closeB.setActionCommand("close");
    closeB.addActionListener(this);
    buttonP.add(closeB);
    getContentPane().add(buttonP, BorderLayout.SOUTH);



  }

  public void valueChanged(ListSelectionEvent e) {
    if( !this.actorP.isEditing() && this.actorsL.getMinSelectionIndex() > -1){
      this.actorP.setActor((business.CActor ) allActors.elementAt(this.actorsL.getSelectedIndex()));
    }
    //    System.out.println( e.getFirstIndex()+" "+ ((business.CActor ) allActors.elementAt(e.getFirstIndex())).getType());
    //    System.out.println( e.getLastIndex()+" "+ ((business.CActor ) allActors.elementAt(e.getLastIndex())).getType());
    //    System.out.println( e.getLastIndex()+" "+ ((business.CActor ) allActors.elementAt(this.actorsL.getMinSelectionIndex())).getType());
    //    System.out.println( e.getLastIndex()+" "+ ((business.CActor ) allActors.elementAt(this.actorsL.getMaxSelectionIndex())).getType());
  }

  public void actionPerformed(ActionEvent e) {
    if(business.Global.user.isAnalyst()){
      if(e.getActionCommand().equals("newActor")) {
        if( !this.actorP.isEditing()){
          business.CActor ac = new business.CActor();
          ac.setType("new");
          persistence.CActor.insertActor(ac);
          this.actorP.setActor(ac);
          this.actorP.edit(true);
        }
      }else if(e.getActionCommand().equals("deleteActor")) {
        if( !this.actorP.isEditing()){
          if(actorsL.getSelectedIndex() != -1){
            if(persistence.CActor.deleteActor((business.CActor ) allActors.elementAt(actorsL.getSelectedIndex()))){
              JOptionPane.showMessageDialog(this,"deleted");
            }else{
              JOptionPane.showMessageDialog(this,"Can not delete this actor");
            }
          }
        }
      }else if(e.getActionCommand().equals("editActor")) {
        if(actorsL.getSelectedIndex() != -1){
          this.actorP.edit(true);
        }
      }
    }//admin
    if(e.getActionCommand().equals("close")) {
      if(this.actorP.isEditing()){
        JOptionPane.showMessageDialog(this,"Please finish edititng actor");
      }else{
        this.dispose();
      }
    }
    this.refresh();
  }
  public void refresh(){
    // chosen viewpoints
    allActors = persistence.CActor.getAllActors();
    DefaultListModel actorsM = new DefaultListModel();
    for(int i = 0; i < allActors.size();i++){
      actorsM.addElement( allActors.elementAt(i) );
    }
    this.actorsL.setModel(actorsM);
  }

//  public void dispose(){
//    business.Global.windowV.remove(this);
//    business.Global.recocase.reload();
//    super.dispose();
//  }
//
//  public String toString(){
//    return "Actors";
//  }





  public void windowActivated(WindowEvent e)
  {
    this.show();
  }
  public void windowClosed(WindowEvent e){
  }
  public void windowClosing(WindowEvent e){
  }
  public void windowDeactivated(WindowEvent e){
    this.show();
  }
  public void windowDeiconified(WindowEvent e) {
  }
  public void windowIconified(WindowEvent e){
  }
  public void windowOpened(WindowEvent e){
  }






}
