package gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;


/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author:      Oscar Aguilera
 * @version 1.0
 */



/**
 * Description: An object of this class is part of a frame to capture
 * data of a project.
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */

public class CActorP extends JPanel implements ActionListener {


  private boolean editing = false;


  // gui
  private JTextField nameTF = null;
  private JTextField descriptionTF = null;
  private JButton actorsSaveB = null;
  private JButton actorsCancelB = null;


  private business.CActor actor = null;



  /** constructor
   *  @param AProject project to be displayed
   */
  private gui.CActorsF parentF;
  public CActorP(gui.CActorsF aparent) {
    init();
    parentF = aparent;
  }

  /** initialize gui*/
  private void init() {

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    this.setLayout(gridbag);

    // ===================================================================
    // ===== label name
    // ===================================================================
    JLabel nameL = new JLabel("Name:*");
    c.gridx = 0;
    c.gridy = 0;
    c.insets = new Insets(10, 10, 10, 10);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(nameL, c);
    this.add(nameL);

    // ===================================================================
    // ===== textfield name
    // ===================================================================
    nameTF = new JTextField(30);
    // nameTF.setText("");
    c.gridx = 1;
    c.gridy = 0;
    gridbag.setConstraints(nameTF, c);
    this.add(nameTF);


    // ===================================================================
    // ===== label system
    // ===================================================================
    JLabel descriptionL = new JLabel("Description:");
    c.gridx = 0;
    c.gridy = 1;
    c.insets = new Insets(10, 10, 10, 10);
    c.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(descriptionL, c);
    this.add(descriptionL);

    // ===================================================================
    // ===== textfield system
    // ===================================================================
    descriptionTF = new JTextField(30);
    c.gridx = 1;
    c.gridy = 1;
    gridbag.setConstraints(descriptionTF, c);
    this.add(descriptionTF);


    JPanel actorsBP = new JPanel();
    actorsBP.setLayout(new BoxLayout(actorsBP, BoxLayout.X_AXIS));

    actorsSaveB = new JButton ("Save");
    actorsSaveB.setActionCommand("saveActor");
    actorsSaveB.addActionListener(this);
    actorsBP.add(actorsSaveB);
    actorsCancelB = new JButton ("Cancel");
    actorsCancelB.setActionCommand("cancelActor");
    actorsCancelB.addActionListener(this);
    actorsBP.add(actorsCancelB);
    c.gridx = 1;
    c.gridy = 2;
    gridbag.setConstraints(actorsBP, c);
    this.add(actorsBP);

    actorsSaveB.setEnabled(false);
    actorsCancelB.setEnabled(false);
    nameTF.setEnabled(false);
    descriptionTF.setEnabled(false);

  }


    // ===================================================================
    // ===== ACTION
    // ===================================================================

  /** is called if the user wants to add or delete actor */
  public void actionPerformed(ActionEvent e) {
    if(business.Global.user.isAnalyst()){
      if(e.getActionCommand().equals("saveActor")) {
        actor.setType(this.nameTF.getText());
        actor.setDescription(this.descriptionTF.getText());
        persistence.CActor.updateActor(this.actor );
        this.edit(false);
        parentF.refresh();
      }else if(e.getActionCommand().equals("cancelActor")) {
        this.edit(false);
        setActor(actor);
      }
    }else{
      contr.CError.showNoRights(business.Global.recocase);
    }
    parentF.refresh();
  }
  public void setActor(business.CActor anActor){
    actor = anActor;
    nameTF.setText(anActor.getType());
    descriptionTF.setText(anActor.getDescription());
  }

  public void edit(boolean tf){
    actorsSaveB.setEnabled(tf);
    actorsCancelB.setEnabled(tf);
    nameTF.setEnabled(tf);
    descriptionTF.setEnabled(tf);
    editing = tf;
  }

  public boolean isEditing(){
     return this.editing;
  }

}
