package diagram;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class Dedge{
private DNode parent ;
private DNode child;

  public Dedge(DNode parentN ,DNode childN) {
      parent = parentN;
      child = childN;
      parent.addEdge(this);
      child.addEdge(this);
      if(parent.graph != child.graph){
        parent.graph.edges.add(this);
        child.graph.edges.add(this);
      }else{
        parent.graph.edges.add(this);
      }
  }
  public DNode getChild(){
    return child;
  }
  public DNode getParent(){
    return parent;
  }

  public void destroy() {
      parent.removeEdge(this);
      child.removeEdge(this);
      parent.graph.edges.remove(this);
  }

  public void draw(Graphics g){
        if(child.isConector() && parent.isConector()) {
          g.drawLine( parent.x+(parent.height/2) ,parent.y+(parent.height/2), child.x+(child.height/2),child.y+(child.height/2));
        }else  if(child.isConector()) {
          g.drawLine( parent.x+(parent.height/2),parent.y+(parent.height) , child.x+(child.height/2),child.y+(child.height/2));
        }else if(parent.isConector()) {
          g.drawLine( parent.x+(parent.height/2) ,parent.y+(parent.height/2),child.x+(child.height/2), child.y);
        }else{
          g.drawLine( parent.x+(parent.height/2),parent.y+(parent.height) , child.x+(child.height/2), child.y);
        }
  }

  public boolean isHidden(){
    if(parent.isHidden() || child.isHidden() ){
      return true;
    }else{
      return false;
    }
  }
  public boolean isVisible() {
    return !isHidden();
  }


}